/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ITypeParameter;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.MemberElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.TypeParameterElementInfo;

public abstract class SourceMethodElementInfo
extends MemberElementInfo
implements ISourceMethod {
    protected char[] selector;
    protected char[][] argumentNames;
    protected char[][] argumentTypeNames;
    protected char[][] exceptionTypes;
    protected ITypeParameter[] typeParameters = TypeParameter.NO_TYPE_PARAMETERS;

    public char[][] getArgumentNames() {
        return this.argumentNames;
    }

    public char[][] getArgumentTypeNames() {
        return this.argumentTypeNames;
    }

    public char[][] getExceptionTypeNames() {
        return this.exceptionTypes;
    }

    public abstract char[] getReturnTypeName();

    public char[] getSelector() {
        return this.selector;
    }

    protected String getSignature() {
        String[] paramSignatures = new String[this.argumentTypeNames.length];
        int i = 0;
        while (i < this.argumentTypeNames.length) {
            paramSignatures[i] = Signature.createTypeSignature(this.argumentTypeNames[i], false);
            ++i;
        }
        return Signature.createMethodSignature(paramSignatures, Signature.createTypeSignature(this.getReturnTypeName(), false));
    }

    public char[][][] getTypeParameterBounds() {
        int length = this.typeParameters.length;
        char[][][] typeParameterBounds = new char[length][][];
        int i = 0;
        while (i < length) {
            try {
                TypeParameterElementInfo info = (TypeParameterElementInfo)((JavaElement)((Object)this.typeParameters[i])).getElementInfo();
                typeParameterBounds[i] = info.bounds;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        return typeParameterBounds;
    }

    public char[][] getTypeParameterNames() {
        int length = this.typeParameters.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] typeParameterNames = new char[length][];
        int i = 0;
        while (i < length) {
            typeParameterNames[i] = this.typeParameters[i].getElementName().toCharArray();
            ++i;
        }
        return typeParameterNames;
    }

    public abstract boolean isConstructor();

    public abstract boolean isAnnotationMethod();

    protected void setArgumentNames(char[][] names) {
        this.argumentNames = names;
    }

    protected void setArgumentTypeNames(char[][] types) {
        this.argumentTypeNames = types;
    }

    protected void setExceptionTypeNames(char[][] types) {
        this.exceptionTypes = types;
    }

    protected abstract void setReturnType(char[] var1);
}

