/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference type, int sourceStart) {
        this.type = type;
        this.sourceStart = sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? Annotation.NoValuePairs : this.memberValuePairs;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        super.printExpression(indent, output);
        output.append('(');
        if (this.memberValuePairs != null) {
            int i = 0;
            int max = this.memberValuePairs.length;
            while (i < max) {
                if (i > 0) {
                    output.append(',');
                }
                this.memberValuePairs[i].print(indent, output);
                ++i;
            }
        }
        output.append(')');
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.memberValuePairs != null) {
            int memberValuePairsLength = this.memberValuePairs.length;
            int i = 0;
            while (i < memberValuePairsLength) {
                this.memberValuePairs[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        if (visitor.visit(this, scope) && this.memberValuePairs != null) {
            int memberValuePairsLength = this.memberValuePairs.length;
            int i = 0;
            while (i < memberValuePairsLength) {
                this.memberValuePairs[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

