/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.SearchableEnvironmentRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.SourceType;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.aspectj.org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class SearchableEnvironment
implements INameEnvironment,
IJavaSearchConstants {
    public NameLookup nameLookup;
    protected org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit unitToSkip;
    protected ICompilationUnit[] workingCopies;
    protected JavaProject project;
    protected IJavaSearchScope searchScope;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironment(JavaProject project, ICompilationUnit[] workingCopies) throws JavaModelException {
        this.project = project;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = project.newNameLookup(workingCopies);
        this.searchScope = this.checkAccessRestrictions ? BasicSearchEngine.createJavaSearchScope(new IJavaElement[]{project}) : BasicSearchEngine.createJavaSearchScope(this.nameLookup.packageFragmentRoots);
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner) throws JavaModelException {
        this(project, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true));
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName) {
        IType type;
        if (packageName == null) {
            packageName = "";
        }
        if ((type = this.nameLookup.findType(typeName, packageName, false, 30)) != null) {
            AccessRuleSet accessRuleSet;
            PackageFragmentRoot root;
            ClasspathEntry entry;
            boolean isBinary = type instanceof BinaryType;
            AccessRestriction accessRestriction = null;
            if (this.checkAccessRestrictions && (isBinary || !type.getJavaProject().equals(this.project)) && (entry = (ClasspathEntry)this.nameLookup.rootToResolvedEntries.get(root = (PackageFragmentRoot)type.getAncestor(3))) != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
                char[][] packageChars = CharOperation.splitOn('.', packageName.toCharArray());
                char[] classFileChars = type.getElementName().toCharArray();
                accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, classFileChars, '/'));
            }
            if (isBinary) {
                try {
                    return new NameEnvironmentAnswer((IBinaryType)((BinaryType)type).getElementInfo(), accessRestriction);
                }
                catch (JavaModelException npe) {
                    return null;
                }
            }
            try {
                SourceTypeElementInfo sourceType;
                ISourceType topLevelType = sourceType = (SourceTypeElementInfo)((SourceType)type).getElementInfo();
                while (topLevelType.getEnclosingType() != null) {
                    topLevelType = topLevelType.getEnclosingType();
                }
                IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                ISourceType[] sourceTypes = new ISourceType[types.length];
                sourceTypes[0] = sourceType;
                int length = types.length;
                int i = 0;
                int index = 1;
                while (i < length) {
                    ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                    if (!otherType.equals(topLevelType) && index < length) {
                        sourceTypes[index++] = otherType;
                    }
                    ++i;
                }
                return new NameEnvironmentAnswer(sourceTypes, accessRestriction);
            }
            catch (JavaModelException npe) {
                return null;
            }
        }
        return null;
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor));
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        if (compoundTypeName == null) {
            return null;
        }
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(new String(compoundTypeName[lengthM1]), CharOperation.toString(packageName));
    }

    public NameEnvironmentAnswer findType(char[] name, char[][] packageName) {
        if (name == null) {
            return null;
        }
        return this.find(new String(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName));
    }

    public void findTypes(char[] prefix, final boolean findMembers, final ISearchRequestor storage) {
        try {
            char[] simpleName;
            char[] qualification;
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaElement)) {
                    this.findTypes(new String(prefix), storage, 30);
                    return;
                }
                excludePath = ((IJavaElement)((Object)this.unitToSkip)).getPath().toString();
            } else {
                excludePath = null;
            }
            int lastDotIndex = CharOperation.lastIndexOf('.', prefix);
            if (lastDotIndex < 0) {
                qualification = null;
                simpleName = CharOperation.toLowerCase(prefix);
            } else {
                qualification = CharOperation.subarray(prefix, 0, lastDotIndex);
                simpleName = CharOperation.toLowerCase(CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length));
            }
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String name, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        return;
                    }
                    storage.acceptType(packageName, simpleTypeName, enclosingTypeNames, modifiers, access);
                }
            };
            try {
                new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, simpleName, 1, 0, this.searchScope, typeRequestor, 2, progressMonitor);
            }
            catch (OperationCanceledException e) {
                this.findTypes(new String(prefix), storage, 30);
            }
        }
        catch (JavaModelException e) {
            this.findTypes(new String(prefix), storage, 30);
        }
    }

    private void findTypes(String prefix, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.project, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                int i = 0;
                int length = fragments.length;
                while (i < length) {
                    if (fragments[i] != null) {
                        this.nameLookup.seekTypes(className, fragments[i], true, type, requestor);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isPackage(char[][] parentPackageName, char[] subPackageName) {
        if (subPackageName == null || CharOperation.contains('.', subPackageName)) {
            return false;
        }
        if (parentPackageName == null || parentPackageName.length == 0) {
            return this.isTopLevelPackage(subPackageName);
        }
        int i = 0;
        int length = parentPackageName.length;
        while (i < length) {
            if (parentPackageName[i] == null || CharOperation.contains('.', parentPackageName[i])) {
                return false;
            }
            ++i;
        }
        String packageName = new String(CharOperation.concatWith(parentPackageName, subPackageName, '.'));
        return this.nameLookup.findPackageFragments(packageName, false) != null;
    }

    public boolean isTopLevelPackage(char[] packageName) {
        return packageName != null && !CharOperation.contains('.', packageName) && this.nameLookup.findPackageFragments(new String(packageName), false) != null;
    }

    protected String toStringChar(char[] name) {
        return "[" + new String(name) + "]";
    }

    protected String toStringCharChar(char[][] names) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            result.append(this.toStringChar(names[i]));
            ++i;
        }
        return result.toString();
    }

    public void cleanup() {
    }
}

