/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.vfs;

import java.io.InputStream;
import java.io.IOException;

/**
 * Accessor for implementations of VFS.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public interface VFileAccessor
{
    /**
     * Get size of resource in bytes.
     *
     * @param resource the resource designator
     * @return the size of resource in bytes
     */
    long getSize( VFile file, Object resource );

    /**
     * Get InputStream for resource.
     *
     * @param resource the resource designator
     * @return the input stream
     * @exception IOException if an error occurs
     */
    InputStream getInputStream( VFile file, Object resource )
        throws IOException;
}
