/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceLoader {
    private static final String s_babelJar = "babel-0.8.8.jar";
    private static final Map s_jarFiles;

    public InputStream getResourceStream(String resource, String jarFile) throws IOException {
        InputStream in = null;
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = this.searchClassPath(resource, jarFile);
        }
        return in;
    }

    public InputStream getResourceStream(String resource) throws IOException {
        return this.getResourceStream(resource, s_babelJar);
    }

    private InputStream searchClassPath(String name, String jarFileName) throws IOException {
        JarEntry entry;
        InputStream is;
        JarFile jarFile = (JarFile)s_jarFiles.get(jarFileName);
        if (jarFile == null) {
            String classpath = System.getProperty("java.class.path", "");
            StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File f;
                String path = tok.nextToken();
                if (!path.endsWith(jarFileName) || !(f = new File(path)).isFile()) continue;
                try {
                    JarFile jar = new JarFile(f);
                    if (jar == null) continue;
                    jarFile = jar;
                    break;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                s_jarFiles.put(jarFileName, jarFile);
            }
        }
        if (jarFile != null && (is = jarFile.getInputStream(entry = jarFile.getJarEntry(name))) != null) {
            return is;
        }
        throw new IOException("Cannot get a ClassLoader to load " + name);
    }

    static {
        s_babelJar = s_babelJar;
        s_jarFiles = Collections.synchronizedMap(new HashMap());
    }
}

