/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Comparator;

public class LevelComparator
implements Comparator {
    private SymbolTable d_table;
    private Class d_baseException;

    public LevelComparator(SymbolTable table) {
        this.d_table = table;
        this.d_baseException = (Class)this.d_table.lookupSymbol(BabelConfiguration.getBaseException());
    }

    private final int getClassLevel(Class ex) {
        int result = 0;
        while (ex != null && ex != this.d_baseException) {
            ++result;
            ex = ex.getParentClass();
        }
        return result;
    }

    public final int compare(Object o1, Object o2) {
        if (o1 instanceof SymbolID && o2 instanceof SymbolID) {
            Symbol sym1 = this.d_table.lookupSymbol((SymbolID)o1);
            Symbol sym2 = this.d_table.lookupSymbol((SymbolID)o2);
            if (sym1 instanceof Class && sym2 instanceof Class) {
                int l2;
                int l1 = this.getClassLevel((Class)sym1);
                return l1 < (l2 = this.getClassLevel((Class)sym2)) ? 1 : (l1 > l2 ? -1 : 0);
            }
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        return false;
    }
}

