/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.writers.ChangeWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForMakefiles;
import gov.llnl.babel.symbols.SymbolID;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MakefileGenerator
implements FileListener,
BuildGenerator {
    private Set d_excludedGroups = new TreeSet();
    private Map d_dir2group = new HashMap();

    public void newFile(SymbolID id, int type, String role, String dir, String name) {
        TreeSet<String> files;
        TreeMap<String, TreeSet<String>> role2file = (TreeMap<String, TreeSet<String>>)this.d_dir2group.get(dir);
        if (null == role2file) {
            role2file = new TreeMap<String, TreeSet<String>>();
            this.d_dir2group.put(dir, role2file);
        }
        if (null == (files = (TreeSet<String>)role2file.get(role))) {
            files = new TreeSet<String>();
            role2file.put(role, files);
        }
        files.add(name);
    }

    public void excludeGroup(String groupname) {
        if (groupname == null || groupname.equals("")) {
            return;
        }
        this.d_excludedGroups.add(groupname);
    }

    public void readmitExcludedGroup(String groupname) {
        if (groupname == null || groupname.equals("")) {
            return;
        }
        if (this.d_excludedGroups.contains(groupname)) {
            this.d_excludedGroups.remove(groupname);
        }
    }

    public void createAll() throws IOException {
        String errmsg = "";
        String makefilename = BabelConfiguration.getMakefileName();
        Iterator dir = this.d_dir2group.keySet().iterator();
        while (dir.hasNext()) {
            String dirname = (String)dir.next();
            try {
                this.createMakefileInDirectory(makefilename, dirname);
            }
            catch (IOException ex) {
                errmsg = errmsg + "\nCreating file \"" + dirname + makefilename + "\"\n" + ex.getMessage();
            }
        }
        if (!errmsg.equals("")) {
            throw new IOException(errmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMakefileInDirectory(String makefilename, String dirname) throws IOException {
        Map role2files;
        if (makefilename == null || makefilename.equals("")) {
            makefilename = this.defaultFilename();
        }
        if (dirname == null) {
            dirname = "";
        }
        if (!(dirname.equals("") || dirname.equals(File.separator) || dirname.endsWith(File.separator))) {
            dirname = dirname + File.separator;
        }
        if ((role2files = (Map)this.d_dir2group.get(dirname)) == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(ChangeWriter.createWriter(makefilename, dirname));
            this.writeMakefile(writer, role2files);
            Object var6_5 = null;
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (writer != null) {
                writer.close();
            }
            throw throwable;
        }
    }

    protected void writeMakefile(PrintWriter pw, Map role2files) {
        LanguageWriterForMakefiles writer = new LanguageWriterForMakefiles(pw);
        Iterator g = role2files.entrySet().iterator();
        while (g.hasNext()) {
            Map.Entry entry = g.next();
            String groupname = (String)entry.getKey();
            if (this.d_excludedGroups.contains(groupname)) continue;
            Set files = (Set)entry.getValue();
            writer.print(groupname + " =");
            Iterator f = files.iterator();
            while (f.hasNext()) {
                String s = (String)f.next();
                writer.print(" " + s);
            }
            writer.println();
        }
    }

    protected String defaultFilename() {
        return BabelConfiguration.getMakefileName();
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("c");
        result.add("c++");
        result.add("cxx");
        result.add("f77");
        result.add("f90");
        result.add("java");
        result.add("ior");
        return result;
    }
}

