/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.ImplHeader;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.Iterator;
import java.util.List;

public class SkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{"SIDL_general_order", "SIDL_column_major_order", "SIDL_row_major_order"};

    public static void generateCode(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        writer.writeBanner(cls, C.getSkelFile(cls.getSymbolID()), false, "Server-side glue code for " + id.getFullName());
        writer.generateInclude(IOR.getHeaderFile(cls.getSymbolID()), false);
        writer.generateInclude(C.getHeaderFile(cls.getSymbolID()), false);
        writer.printlnUnformatted("#include <stddef.h>");
        writer.println();
        if (cls.getParentClass() == null) {
            SkelSource.writeIORCall(cls, C.getPrivateDestructor(id), IOR.getBuiltinMethod(1, id), writer);
        }
        ImplHeader.writeBuiltinDecls(writer, cls);
        ImplHeader.writeMethodDecls(writer, cls, true);
        ImplHeader.writeMethodDecls(writer, cls, false);
        SkelSource.writeSkelMethods(cls, writer);
        SkelSource.writeInitializeEPV(cls, writer);
        if (cls.hasStaticMethod(true)) {
            SkelSource.writeInitializeSEPV(cls, writer);
        }
        SkelSource.writeGetDataPointer(cls, writer);
        SkelSource.writeSetDataPointer(cls, writer);
    }

    private static void writeSkelMethods(Class cls, LanguageWriter writer) throws CodeGenerationException {
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.hasArrayOrderSpec()) continue;
            SkelSource.writeSkelMethod(cls.getSymbolID(), m, writer);
        }
    }

    private static String getArgValue(Argument arg) {
        return arg.getMode() == 0 ? arg.getFormalName() : "*" + arg.getFormalName();
    }

    private static void writeSkelMethod(SymbolID id, Method m, LanguageWriter writer) throws CodeGenerationException {
        Type argType;
        Argument arg;
        List extArgs = Utilities.extendArgs(id, m);
        Iterator args = extArgs.iterator();
        Type methodReturn = m.getReturnType();
        String method_name = C.getMethodSkelName(id, m);
        writer.println("static " + C.getReturnString(methodReturn));
        writer.println(method_name + "(");
        if (args.hasNext()) {
            writer.increaseTabLevel();
            while (args.hasNext()) {
                arg = (Argument)args.next();
                writer.print(C.getArgumentWithFormal(arg));
                if (!args.hasNext()) continue;
                writer.println(",");
            }
            writer.println(")");
            writer.decreaseTabLevel();
        } else {
            writer.println("void)");
        }
        writer.println("{");
        writer.increaseTabLevel();
        if (methodReturn.getType() != 0) {
            writer.println(C.getReturnString(methodReturn) + " _return;");
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println(C.getReturnString(methodReturn) + " _return_proxy;");
            }
        }
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (!arg.hasArrayOrderSpec()) continue;
            argType = arg.getType();
            writer.print(C.getReturnString(argType) + " " + arg.getFormalName() + "_proxy");
            if (arg.getMode() != 2) {
                writer.println(" = " + C.getEnsureArray(argType.getArrayType()) + "(" + SkelSource.getArgValue(arg) + ", " + argType.getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
                continue;
            }
            writer.println(" = NULL;");
        }
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (!arg.hasArrayOrderSpec() || arg.getMode() != 1) continue;
            writer.println(C.getDelRefArray(arg.getType().getArrayType()) + "(" + SkelSource.getArgValue(arg) + ");");
        }
        if (methodReturn.getType() != 0) {
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println("_return_proxy =");
            } else {
                writer.println("_return =");
            }
            writer.increaseTabLevel();
        }
        writer.println(C.getMethodImplName(id, m.getLongMethodName()) + "(");
        writer.increaseTabLevel();
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (arg.hasArrayOrderSpec()) {
                if (0 != arg.getMode()) {
                    writer.print("&");
                }
                writer.print(arg.getFormalName() + "_proxy");
            } else {
                writer.print(arg.getFormalName());
            }
            if (!args.hasNext()) continue;
            writer.println(",");
        }
        writer.println(");");
        writer.decreaseTabLevel();
        if (methodReturn.getType() != 0) {
            writer.decreaseTabLevel();
        }
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (!arg.hasArrayOrderSpec()) continue;
            argType = arg.getType();
            if (arg.getMode() != 0) {
                writer.println(SkelSource.getArgValue(arg) + " = " + C.getEnsureArray(argType.getArrayType()) + "(" + arg.getFormalName() + "_proxy, " + arg.getType().getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
            }
            writer.println(C.getDelRefArray(argType.getArrayType()) + "(" + arg.getFormalName() + "_proxy);");
        }
        if (methodReturn.getType() != 0) {
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println("_return = " + C.getEnsureArray(methodReturn.getArrayType()) + "(_return_proxy, " + methodReturn.getArrayDimension() + ", " + s_ensureOrderConstant[methodReturn.getArrayOrder()] + ");");
                writer.println(C.getDelRefArray(methodReturn.getArrayType()) + "(_return_proxy);");
            }
            writer.println("return _return;");
        }
        writer.decreaseTabLevel();
        writer.println("}");
        writer.println();
    }

    private static void writeGetDataPointer(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println(C.getDataName(id) + "*");
        writer.println(C.getDataGetName(id) + "(" + C.getObjectName(id) + " self)");
        writer.println("{");
        writer.increaseTabLevel();
        writer.println("return (" + C.getDataName(id) + "*)" + "(self ? self->d_data : NULL);");
        writer.decreaseTabLevel();
        writer.println("}");
        writer.println();
    }

    private static void writeSetDataPointer(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println("void " + C.getDataSetName(id) + "(");
        writer.increaseTabLevel();
        writer.println(C.getObjectName(id) + " self,");
        writer.println(C.getDataName(id) + "* data)");
        writer.decreaseTabLevel();
        writer.println("{");
        writer.increaseTabLevel();
        writer.println("if (self) {");
        writer.increaseTabLevel();
        writer.println("self->d_data = data;");
        writer.decreaseTabLevel();
        writer.println("}");
        writer.decreaseTabLevel();
        writer.println("}");
    }

    private static void writeInitializeEPV(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println("void");
        writer.println(C.getSetEPVName(id) + "(" + IOR.getEPVName(id) + " *epv)");
        writer.println("{");
        writer.increaseTabLevel();
        SkelSource.initializeMethodPointer(writer, IOR.getBuiltinMethod(2, id), id);
        SkelSource.initializeMethodPointer(writer, IOR.getBuiltinMethod(3, id), id);
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            SkelSource.initializeMethodPointer(writer, m, id);
        }
        writer.decreaseTabLevel();
        writer.println("}");
        writer.println();
    }

    private static void initializeMethodPointer(LanguageWriter writer, Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                writer.print("epv->");
                writer.print(IOR.getVectorEntry(methodName));
                writer.print(" = ");
                writer.print(C.getMethodSkelName(id, m));
                writer.println(";");
                break;
            }
            case 1: {
                writer.print("epv->");
                writer.print(IOR.getVectorEntry(methodName));
                writer.println(" = NULL;");
                break;
            }
        }
    }

    private static void writeInitializeSEPV(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println("void");
        writer.println(C.getSetSEPVName(id) + "(" + IOR.getSEPVName(id) + " *sepv)");
        writer.println("{");
        writer.increaseTabLevel();
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            writer.print("sepv->");
            writer.print(IOR.getVectorEntry(m.getLongMethodName()));
            writer.print(" = ");
            writer.print(C.getMethodSkelName(id, m));
            writer.println(";");
        }
        writer.decreaseTabLevel();
        writer.println("}");
        writer.println();
    }

    private static void writeIORCall(Class cls, String funcName, Method iorMethod, LanguageWriter writer) throws CodeGenerationException {
        Argument a;
        SymbolID id = cls.getSymbolID();
        List extArgs = Utilities.extendArgs(id, iorMethod);
        Iterator args = extArgs.iterator();
        writer.println("void");
        writer.print(funcName);
        writer.print("(");
        while (args.hasNext()) {
            a = (Argument)args.next();
            writer.print(IOR.getArgumentWithFormal(a));
            if (!args.hasNext()) continue;
            writer.print(", ");
        }
        writer.println(") {");
        writer.increaseTabLevel();
        writer.println("if (self) {");
        writer.increaseTabLevel();
        writer.writeCommentLine("call the IOR method");
        writer.print("self->d_epv->");
        writer.print(IOR.getVectorEntry(iorMethod.getLongMethodName()));
        writer.print("(");
        args = extArgs.iterator();
        while (args.hasNext()) {
            a = (Argument)args.next();
            writer.print(a.getFormalName());
            if (!args.hasNext()) continue;
            writer.print(", ");
        }
        writer.println(");");
        writer.decreaseTabLevel();
        writer.println("}");
        writer.decreaseTabLevel();
        writer.println("}");
        writer.println();
    }
}

