/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class StubHeader {
    private static final String SIDL_EXCEPTION = BabelConfiguration.getBaseException();
    private LanguageWriterForC d_writer;
    private boolean d_comment_all;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        StubHeader header = new StubHeader(writer);
        header.generateCode(symbol);
    }

    public StubHeader(LanguageWriterForC writer) {
        this.d_writer = writer;
        this.d_comment_all = !BabelConfiguration.getInstance().getCommentLocalOnly();
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        block7: {
            block6: {
                if (symbol == null) break block6;
                this.generatePrologue(symbol);
                switch (symbol.getSymbolType()) {
                    case 12: {
                        this.generateExtendable((Extendable)symbol);
                        break block7;
                    }
                    case 11: {
                        this.generateEnumeration((Enumeration)symbol);
                        break block7;
                    }
                    case 13: {
                        this.generateExtendable((Extendable)symbol);
                        break block7;
                    }
                    case 14: {
                        this.generatePackage((Package)symbol);
                        break block7;
                    }
                    default: {
                        throw new CodeGenerationException("Unsupported symbol type.");
                    }
                }
            }
            throw new CodeGenerationException("Unexpected null Symbol.");
        }
    }

    private void generatePrologue(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        String header = C.getHeaderFile(id);
        this.d_writer.writeBanner(sym, header, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
    }

    private void generateEpilogue(boolean closeExtern) {
        if (closeExtern) {
            this.d_writer.closeCxxExtern();
        }
        this.d_writer.closeHeaderGuard();
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        ArrayMethods ar = new ArrayMethods(id, true);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), true);
        this.d_writer.println();
        this.d_writer.openCxxExtern();
        ar.generateHeader(this.d_writer);
        this.generateEpilogue(true);
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        this.d_writer.writeComment(ext, true);
        this.d_writer.println(IOR.getObjectName(id) + ";");
        this.d_writer.println(IOR.getArrayName(id) + ";");
        this.d_writer.print("typedef " + IOR.getObjectName(id) + "* ");
        this.d_writer.println(C.getObjectName(id) + ";");
        this.d_writer.println();
        this.generateIncludes(ext);
        this.d_writer.openCxxExtern();
        this.generateMethodPrototypes(ext);
        ArrayMethods ar = new ArrayMethods(id, false);
        ar.generateHeader(this.d_writer);
        this.generateEpilogue(true);
    }

    private void generatePackage(Package p) {
        SymbolID id = p.getSymbolID();
        ArrayList entries = Utilities.sort(p.getSymbols().keySet());
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String include = C.getHeaderFile((SymbolID)i.next());
            this.d_writer.generateInclude(include, true);
        }
        this.d_writer.println();
        this.generateEpilogue(false);
    }

    private void generateIncludes(Extendable ext) throws CodeGenerationException {
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            includes.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(SIDL_EXCEPTION);
            includes.add(symbol.getSymbolID());
        }
        this.d_writer.writeComment("Includes for all header dependencies.", false);
        this.d_writer.generateInclude("SIDL_header.h", true);
        includes.remove(ext.getSymbolID());
        if (!includes.isEmpty()) {
            ArrayList entries = Utilities.sort(includes);
            Iterator i2 = entries.iterator();
            while (i2.hasNext()) {
                String header = C.getHeaderFile((SymbolID)i2.next());
                this.d_writer.generateInclude(header, true);
            }
            this.d_writer.println();
        }
    }

    private void generateMethodPrototypes(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Constructor function for the class.", true);
            this.d_writer.println(C.getSymbolName(id));
            this.d_writer.println(C.getFullMethodName(id, "_create") + "(void);");
            this.d_writer.println();
        }
        Collection methods = ext.getMethods(true);
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateMethodSignature(id, method, this.d_comment_all || ext.isLocal(method));
            this.d_writer.println();
        }
        this.d_writer.writeComment("Cast method for interface and class type conversions.", true);
        this.d_writer.println(C.getSymbolName(id));
        this.d_writer.println(C.getFullMethodName(id, "_cast") + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* obj);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
        this.d_writer.writeComment("String cast method for interface and class type conversions.", true);
        this.d_writer.println("void*");
        this.d_writer.println(C.getFullMethodName(id, "_cast2") + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* obj,");
        this.d_writer.println("const char* type);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
    }

    private void generateMethodSignature(SymbolID id, Method method, boolean docComment) throws CodeGenerationException {
        if (docComment) {
            this.d_writer.writeComment(method, true);
        }
        this.d_writer.println(C.getReturnString(method.getReturnType()));
        this.d_writer.print(C.getFullMethodName(id, method));
        this.d_writer.println("(");
        this.d_writer.increaseTabLevel();
        this.generateArgumentList(id, method);
        this.d_writer.println(");");
        this.d_writer.decreaseTabLevel();
    }

    private void generateArgumentList(SymbolID id, Method method) throws CodeGenerationException {
        Iterator a = Utilities.extendArgs(id, method).iterator();
        if (a.hasNext()) {
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.d_writer.print(C.getArgumentWithFormal(arg));
                if (!a.hasNext()) continue;
                this.d_writer.println(",");
            }
        } else {
            this.d_writer.print("void");
        }
    }
}

