/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Iterator;

public class CxxSkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{"SIDL::general_order", "SIDL::column_major_order", "SIDL::row_major_order"};
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;

    public CxxSkelSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 2, 2);
        try {
            this.d_writer = Cxx.createSource(this.d_ext, 2, "SKELSRCS");
            SymbolID id = this.d_ext.getSymbolID();
            this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), true);
            this.d_writer.generateInclude(IOR.getHeaderFile(id), true);
            if (this.d_ext.hasExceptionThrowingMethod(true)) {
                this.d_writer.generateInclude(Cxx.generateFilename("SIDL.BaseException", 3, 1), true);
            }
            this.d_writer.generateInclude("SIDL_String.h", false);
            this.d_writer.printlnUnformatted("#include <stddef.h>");
            this.d_writer.println();
            Cxx.beginExternCRegion(this.d_writer);
            this.writeSkelFunctions();
            this.writeConstructor();
            this.writeDestructor();
            this.writeInitializeEPV();
            if (this.d_ext.hasStaticMethod(true)) {
                this.writeInitializeSEPV();
            }
            Cxx.endExternCRegion(this.d_writer);
            Object var4_3 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeInitializeEPV() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("initialize builtin methods");
        this.initializeMethodPointer(IOR.getBuiltinMethod(2, id), id);
        this.initializeMethodPointer(IOR.getBuiltinMethod(3, id), id);
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.initializeMethodPointer(m, id);
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeInitializeSEPV() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetSEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getSEPVName(id));
        this.d_writer.println(" *sepv) {");
        this.d_writer.increaseTabLevel();
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            this.d_writer.print("sepv->");
            this.d_writer.print(IOR.getVectorEntry(m.getLongMethodName()));
            this.d_writer.print(" = ");
            this.d_writer.print(Cxx.getMethodSkelName(id, m.getLongMethodName()));
            this.d_writer.println(";");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void initializeMethodPointer(Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.print(" = ");
                this.d_writer.print(Cxx.getMethodSkelName(id, methodName));
                this.d_writer.println(";");
                break;
            }
            case 1: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.println(" = NULL;");
                break;
            }
        }
    }

    private void writeConstructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.print("void ");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_ctor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.increaseTabLevel();
        this.d_writer.print("self->d_data = ");
        this.d_writer.print(Cxx.reinterpretCast("void*", "new " + Cxx.getSymbolName(id, "impl") + "(self)"));
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeDestructor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.print("void ");
        this.d_writer.print(Cxx.getMethodSkelName(id, "_dtor"));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println("* self ) { ");
        this.d_writer.increaseTabLevel();
        this.d_writer.print("delete ( ");
        this.d_writer.print(Cxx.reinterpretCast(Cxx.getSymbolName(id, "impl") + "*", "self->d_data"));
        this.d_writer.println(" );");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeGetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println("*");
        this.d_writer.print(C.getDataGetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return self ? self->d_data : NULL;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSetDataPointer() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(C.getDataSetName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getObjectName(id));
        this.d_writer.println(" *self,");
        this.d_writer.increaseTabLevel();
        this.d_writer.print(C.getDataName(id));
        this.d_writer.println(" *data) {");
        this.d_writer.println("if (self) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("self->d_data = data;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    public void writeSkelFunctions() throws CodeGenerationException {
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.writeImplDispatch(m);
        }
    }

    private void writeImplDispatch(Method m) throws CodeGenerationException {
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        boolean throwsExceptions = m.getThrows().size() > 0;
        StringBuffer func_decl = new StringBuffer(nargs * 32);
        StringBuffer pre_impl = new StringBuffer(nargs * 128);
        StringBuffer impl_call = new StringBuffer(nargs * 32);
        StringBuffer impl_suffix = new StringBuffer(16);
        StringBuffer post_impl = new StringBuffer(nargs * 128);
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        if (shortMethodName.equals(className)) {
            System.out.println("WARNING: gov.llnl.babel.backend.Cxx.CxxSkelSource: SIDL / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::f_" + shortMethodName + "()");
            shortMethodName = "f_" + shortMethodName;
        }
        if (m.isStatic()) {
            func_decl.append("static ");
        }
        Type return_type = m.getReturnType();
        func_decl.append(IOR.getReturnString(return_type));
        func_decl.append("\n");
        if (return_type.getType() != 0) {
            pre_impl.append(IOR.getReturnString(return_type));
            if (return_type.getDetailedType() == 11) {
                pre_impl.append(" _result;\n");
            } else if (return_type.getDetailedType() == 5 || return_type.getDetailedType() == 3) {
                pre_impl.append(" _result = {0,0};\n");
            } else {
                pre_impl.append(" _result = 0;\n");
            }
        }
        switch (return_type.getDetailedType()) {
            case 0: {
                break;
            }
            case 9: {
                impl_call.append("_result = ");
                break;
            }
            case 1: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = ( _local_result ? TRUE : FALSE );\n");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                impl_call.append("_result = ");
                break;
            }
            case 11: {
                pre_impl.append(Cxx.getEnumName(return_type.getSymbolID()) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = (" + IOR.getEnumName(return_type.getSymbolID()) + ")_local_result;\n");
                break;
            }
            case 5: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result.real = _local_result.real();\n");
                post_impl.append("_result.imaginary = _local_result.imag();\n");
                break;
            }
            case 3: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result.real = _local_result.real();\n");
                post_impl.append("_result.imaginary = _local_result.imag();\n");
                break;
            }
            case 10: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("_result = SIDL_String_strdup( _local_result.c_str() );\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
            }
            case 12: 
            case 13: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("if ( _local_result._not_nil() ) {\n");
                post_impl.append("  _local_result.addRef();\n");
                post_impl.append("}\n");
                post_impl.append("_result = _local_result._get_ior();\n");
                break;
            }
            case 16: {
                pre_impl.append(Cxx.getReturnString(return_type) + " _local_result;\n");
                impl_call.append("_local_result = ");
                post_impl.append("if ( _local_result._not_nil() ) {\n");
                post_impl.append("  _local_result.ensure(" + return_type.getArrayDimension() + ", " + s_ensureOrderConstant[return_type.getArrayOrder()] + ");\n");
                post_impl.append("  _local_result.addRef();\n");
                post_impl.append("}\n");
                post_impl.append("_result = _local_result._get_ior();\n");
                break;
            }
        }
        func_decl.append(Cxx.getMethodSkelName(this.d_ext.getSymbolID(), longMethodName));
        func_decl.append("( ");
        if (m.isStatic()) {
            impl_call.append(Cxx.getMethodImplName(this.d_ext.getSymbolID(), shortMethodName));
            impl_call.append("( ");
        } else {
            func_decl.append(IOR.getObjectName(this.d_ext.getSymbolID()) + "* self");
            if (nargs > 0) {
                func_decl.append(", ");
            }
            pre_impl.append(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl"));
            pre_impl.append(" *_this = ");
            pre_impl.append(Cxx.reinterpretCast(Cxx.getSymbolName(this.d_ext.getSymbolID(), "impl") + "*", "self->d_data"));
            pre_impl.append(";\n");
            impl_call.append("_this->" + shortMethodName + "( ");
        }
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = "/* " + Cxx.argModeToString(arg) + " */ ";
            int modeInt = arg.getMode();
            func_decl.append(mode);
            func_decl.append(IOR.getArgumentString(arg) + " " + argName);
            if (it.hasNext()) {
                func_decl.append(",");
            }
            impl_call.append(mode);
            block13 : switch (typeInt) {
                case 9: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append(argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("*" + argName);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append("bool _local_" + argName + " = (" + argName + "==TRUE);\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append("bool _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = (_local_" + argName + " ? TRUE : FALSE);\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append("bool _local_" + argName + " = (*" + argName + "==TRUE);\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = (_local_" + argName + " ? TRUE : FALSE);\n");
                        }
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append(argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("*" + argName);
                        }
                    }
                    break;
                }
                case 11: {
                    switch (modeInt) {
                        case 0: {
                            impl_call.append("(" + Cxx.getEnumName(type.getSymbolID()) + "&)" + argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            impl_call.append("(" + Cxx.getEnumName(type.getSymbolID()) + "&)*" + argName);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + ".real, " + argName + ".imaginary );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + "->real, " + argName + "->imaginary );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                        }
                    }
                    break;
                }
                case 3: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + ".real, " + argName + ".imaginary );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + " ( " + argName + "->real, " + argName + "->imaginary );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append(argName + "->real = _local_" + argName + ".real();\n" + argName + "->imaginary = _local_" + argName + ".imag();\n");
                        }
                    }
                    break;
                }
                case 10: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "= ( " + argName + " ? " + argName + ": \"\" );\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("*" + argName + " = SIDL_String_strdup( _local_" + argName + ".c_str() );\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "= ( *" + argName + " ? *" + argName + ": \"\" );\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( *" + argName + "== 0) {\n");
                            post_impl.append("  *" + argName + " = SIDL_String_strdup( _local_" + argName + ".c_str() );\n");
                            post_impl.append("} else if ( strlen( *" + argName + " ) >= _local_" + argName + ".length() ) {\n");
                            post_impl.append("  _local_" + argName + ".copy( *" + argName + ", ::std::string::npos );\n");
                            post_impl.append("  (*" + argName + ")[ _local_" + argName + ".length()] = 0;\n");
                            post_impl.append("} else { \n");
                            post_impl.append("  SIDL_String_free( *" + argName + ");\n");
                            post_impl.append("  *" + argName + " = SIDL_String_strdup( _local_" + argName + ".c_str() );\n");
                            post_impl.append("}");
                        }
                    }
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
                }
                case 12: 
                case 13: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(" + argName + ");\n");
                            impl_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                            break;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "((*" + argName + "));\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("if (*" + argName + ") (*((*" + argName + ")->d_epv->f_deleteRef))(*" + argName + ");\n");
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                        }
                    }
                    break;
                }
                case 16: {
                    switch (modeInt) {
                        case 0: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(" + argName + ");\n");
                            pre_impl.append("if (" + argName + ") { ");
                            pre_impl.append("_local_" + argName + ".addRef();");
                            pre_impl.append("_local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            pre_impl.append(" }\n");
                            impl_call.append("_local_" + argName);
                            break block13;
                        }
                        case 2: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + ";\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            post_impl.append("  _local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                            break block13;
                        }
                        case 1: {
                            pre_impl.append(Cxx.getReturnString(type) + " _local_" + argName + "(*" + argName + ");\n");
                            pre_impl.append("*" + argName + " = 0;\n");
                            pre_impl.append("_local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            impl_call.append("_local_" + argName);
                            post_impl.append("if ( _local_" + argName + "._not_nil() ) {\n");
                            post_impl.append("  _local_" + argName + ".ensure(" + type.getArrayDimension() + ", " + s_ensureOrderConstant[type.getArrayOrder()] + ");\n");
                            post_impl.append("_local_" + argName + ".addRef();\n");
                            post_impl.append("}\n");
                            post_impl.append("*" + argName + " = _local_" + argName + "._get_ior();\n");
                        }
                    }
                }
            }
            if (!it.hasNext()) continue;
            impl_call.append(", ");
        }
        if (throwsExceptions) {
            if (nargs > 0 || !m.isStatic()) {
                func_decl.append(", ");
            }
            pre_impl.append("*_exception = 0;//init just to be safe\n");
            func_decl.append("SIDL_BaseException__object ** _exception");
        }
        func_decl.append(" )\n");
        impl_call.append(" )" + impl_suffix.toString() + ";\n");
        this.d_writer.println(func_decl.toString().trim());
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("pack args to dispatch to impl");
        this.d_writer.println(pre_impl.toString().trim());
        this.d_writer.writeCommentLine("dispatch to impl");
        if (throwsExceptions) {
            this.d_writer.println("try { ");
            this.d_writer.increaseTabLevel();
        }
        this.d_writer.println(impl_call.toString().trim());
        if (throwsExceptions) {
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("} catch ( ::SIDL::StubBase& _sb ) { ");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("::SIDL::BaseException _ex(_sb);");
            this.d_writer.println("_ex.addRef();");
            this.d_writer.println("*_exception = _ex._get_ior();");
            if (return_type.getType() != 0) {
                this.d_writer.println("return _result;");
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        }
        this.d_writer.writeCommentLine("unpack results and cleanup");
        this.d_writer.println(post_impl.toString().trim());
        if (return_type.getType() != 0) {
            this.d_writer.println("return _result;");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

