/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.StubDoc;
import gov.llnl.babel.backend.mangler.FortranMangler;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.backend.mangler.NonMangler;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;

public class AbbrevHeader {
    public static final int MAXNAME = 31;
    public static final int MAXUNMANGLED = 21;
    private static final String[] s_arrayMethods;
    private static final String[] s_skelMethods;
    private LanguageWriter d_lw;

    public AbbrevHeader(LanguageWriter writer) {
        this.d_lw = writer;
    }

    private void writeLine(String longName, String shortName) {
        this.d_lw.disableLineBreak();
        this.d_lw.print("#define ");
        this.d_lw.print(longName);
        this.d_lw.print(" ");
        this.d_lw.println(shortName);
        this.d_lw.enableLineBreak();
    }

    private void writeEntry(String longName, String shortName) {
        String monocase = longName.toLowerCase();
        this.writeLine(longName, shortName);
        if (!monocase.equals(longName)) {
            this.writeLine(monocase, shortName.toLowerCase());
        }
        if (!(monocase = longName.toUpperCase()).equals(longName)) {
            this.writeLine(monocase, shortName.toUpperCase());
        }
    }

    public void generateMethods(String symName, NameMangler non, NameMangler fort, String[] methodNames) throws UnsupportedEncodingException {
        String suffix = Fortran.getMethodSuffix();
        int i = 0;
        while (i < methodNames.length) {
            String longName = non.shortArrayName(symName, methodNames[i], suffix);
            if (longName.length() > 31) {
                String shortName = fort.shortArrayName(symName, methodNames[i], suffix);
                this.writeEntry(longName, shortName);
            }
            ++i;
        }
    }

    public void generateClassMethods(String symName, NameMangler non, NameMangler fort, String[] methodNames) throws UnsupportedEncodingException {
        String suffix = Fortran.getMethodSuffix();
        int i = 0;
        while (i < methodNames.length) {
            String longName = non.shortName(symName, methodNames[i], suffix);
            if (longName.length() > 31) {
                String shortName = fort.shortName(symName, methodNames[i], suffix);
                this.writeEntry(longName, shortName);
            }
            ++i;
        }
    }

    public void generateNamedMethod(String symName, String methName, NameMangler non, NameMangler fort) throws UnsupportedEncodingException {
        String longName = non.shortName(symName, methName, Fortran.getMethodSuffix());
        if (longName.length() > 31) {
            String shortName = fort.shortName(symName, methName, Fortran.getMethodSuffix());
            this.writeEntry(longName, shortName);
        }
    }

    private void processMethod(String symName, Method m, NameMangler non, NameMangler fort) throws UnsupportedEncodingException {
        this.generateNamedMethod(symName, m.getLongMethodName(), non, fort);
    }

    private void generateType(String symName, NameMangler non, NameMangler fort, String suffix) throws UnsupportedEncodingException {
        String longName = non.shortName(symName, suffix);
        if (longName.length() > 31) {
            String shortName = fort.shortName(symName, suffix);
            this.writeEntry(longName, shortName);
        }
    }

    private void generateExtendable(Extendable ext, NameMangler non, NameMangler fort) throws UnsupportedEncodingException {
        String symName = ext.getFullName();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            this.processMethod(symName, (Method)i.next(), non, fort);
        }
        this.processMethod(symName, StubDoc.createCast(ext.getSymbolID()), non, fort);
        this.processMethod(symName, StubDoc.createCastTwo(ext.getSymbolID()), non, fort);
        if (!ext.isAbstract()) {
            if ("f90".equals(BabelConfiguration.getInstance().getTargetLanguage())) {
                this.generateNamedMethod(symName, "new", non, fort);
            } else {
                this.generateNamedMethod(symName, "_create", non, fort);
            }
        }
        if ("f90".equals(BabelConfiguration.getInstance().getTargetLanguage())) {
            BabelConfiguration.getInstance();
            int maxArray = BabelConfiguration.getMaximumArray();
            if (!ext.isInterface()) {
                this.generateType(symName, non, fort, "_impl");
                this.generateType(symName, non, fort, "_private");
                this.generateType(symName, non, fort, "_wrap");
            }
            this.generateType(symName, non, fort, "");
            int d = 1;
            while (d <= maxArray) {
                this.generateType(symName, non, fort, "_" + Integer.toString(d) + "d");
                ++d;
            }
            this.generateType(symName, non, fort, "_array");
            this.generateType(symName, non, fort, "_t");
            this.generateType(symName, non, fort, "_type");
        }
    }

    public void generateCode(Symbol sym) throws CodeGenerationException {
        try {
            String symName = sym.getFullName();
            NonMangler non = new NonMangler();
            FortranMangler fort = new FortranMangler(31, 21);
            if (sym instanceof Extendable) {
                this.generateExtendable((Extendable)sym, non, fort);
                this.generateClassMethods(symName, non, fort, s_skelMethods);
            }
            this.generateMethods(symName, non, fort, s_arrayMethods);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CodeGenerationException("NoSuchAlgorithmException: " + nsae.getMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException("UnsupportedEncodingException: " + uee.getMessage());
        }
    }

    public static void generateCode(Symbol sym, LanguageWriter writer) throws CodeGenerationException {
        AbbrevHeader source = new AbbrevHeader(writer);
        source.generateCode(sym);
    }

    static {
        MAXNAME = 31;
        MAXUNMANGLED = 21;
        s_arrayMethods = new String[]{"access", "addRef", "borrow", "copy", "create1d", "create2dCol", "create2dRow", "createCol", "createRow", "deleteRef", "dimen", "ensure", "get", "get1", "get2", "get3", "get4", "get5", "get6", "get7", "isColumnOrder", "isRowOrder", "lower", "set", "set1", "set2", "set3", "set4", "set5", "set6", "set7", "slice", "smartCopy", "stride", "upper"};
        s_skelMethods = new String[]{"_get_data", "_set_data"};
    }
}

