/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.UnsupportedEncodingException;

public class Fortran
implements CodeConstants {
    private static final String[] s_f77_types = new String[]{"void", "logical", "character", "double complex", "double precision", "complex", "real", "integer*4", "integer*8", "integer*8", "character*(*)", "integer*4", "integer*8", "integer*8", "void", "integer*8", "integer*8"};
    private static final String[] s_f90_types = new String[]{"void", "logical", "character (len=1)", "complex (selected_real_kind(15, 307))", "real (selected_real_kind(15, 307))", "complex (selected_real_kind(6, 37))", "real (selected_real_kind(6, 37))", "integer (selected_int_kind(9))", "integer (selected_int_kind(18))", "integer (selected_int_kind(18))", "character (len=*)", "integer (selected_int_kind(9))"};
    private static final String[] s_cTypeMatchingFortran = new String[]{"void", "SIDL_F77_Bool", "char", "struct SIDL_dcomplex", "double", "struct SIDL_fcomplex", "float", "int32_t", "int64_t", "int64_t", "char *", "int32_t", "int64_t", "int64_t", "void", "int64_t", "int64_t"};
    private static final int s_Fortran_Bool = 1;
    private static final String s_F90_Bool = "SIDL_F90_Bool";
    private static final String s_F90_Array = "struct SIDL_fortran_array";
    private static final boolean s_isF90;

    private Fortran() {
    }

    public static String getSymbolName(SymbolID id) {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (s_babel_config.makePackageSubdirs() && s_babel_config.excludeExternal()) {
            return id.getShortName().replace('.', '_');
        }
        return id.getFullName().replace('.', '_');
    }

    public static String getStubFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_fStub.c";
    }

    public static String getStubNameFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_fAbbrev.h";
    }

    public static String getStubDocFile(SymbolID id) {
        return Fortran.getSymbolName(id) + ".fif";
    }

    public static String getModuleFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "." + "F90";
    }

    public static String getTypeFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_type." + "F90";
    }

    public static String getTypeModule(SymbolID id) {
        return Fortran.getSymbolName(id) + "_type";
    }

    public static String getArrayModule(SymbolID id) {
        return Fortran.getSymbolName(id) + "_array";
    }

    public static String getArrayFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_array." + "F90";
    }

    public static String getTypeName(SymbolID id) {
        return Fortran.getSymbolName(id) + "_t";
    }

    public static String getArrayName(SymbolID id, int dim) {
        return Fortran.getSymbolName(id) + "_" + dim + "d";
    }

    public static String getModule(SymbolID id) {
        return Fortran.getSymbolName(id);
    }

    public static boolean hasDirectAccess(Type t) {
        if (t.getDetailedType() == 16) {
            switch (t.getArrayType().getDetailedType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getEnumStubFile(SymbolID id) {
        return Fortran.getSymbolName(id) + ".inc";
    }

    public static String getEnsureArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return "SIDL_interface__array_ensure((struct SIDL_interface__array *)";
            }
            case 11: {
                return "SIDL_int__array_ensure((struct SIDL_int__array *)";
            }
        }
        return "SIDL_" + arrayType.getTypeString() + "__array_ensure(";
    }

    public static String getDelRefArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return "SIDL_interface__array_deleteRef((struct SIDL_interface__array *)";
            }
            case 11: {
                return "SIDL_int__array_deleteRef((struct SIDL_int__array *)";
            }
        }
        return "SIDL_" + arrayType.getTypeString() + "__array_deleteRef((struct SIDL_" + arrayType.getTypeString() + "__array *)";
    }

    public static String getEnumStubImpl(SymbolID id) {
        return Fortran.getSymbolName(id) + "_fStub.c";
    }

    public static String getSkelFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_fSkel.c";
    }

    public static String getImplExtension() {
        if (s_isF90) {
            return "F90";
        }
        return "f";
    }

    public static String getImplFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_Impl." + Fortran.getImplExtension();
    }

    public static String getImplModuleFile(SymbolID id) {
        return Fortran.getSymbolName(id) + "_Mod." + Fortran.getImplExtension();
    }

    public static String getMethodStubName(SymbolID id, Method method) {
        return Fortran.getSymbolName(id) + "_" + method.getLongMethodName() + Fortran.getMethodSuffix();
    }

    public static int getFortranVersion() {
        int fversion = s_isF90 ? 90 : 77;
        return fversion;
    }

    public static String getMethodSuffix() {
        if (s_isF90) {
            return "_m";
        }
        return "_f";
    }

    public static String getImplMethodSuffix() {
        if (s_isF90) {
            return "_mi";
        }
        return "_fi";
    }

    public static String getFortranSymbol() {
        return "SIDLFortran" + Fortran.getFortranVersion() + "Symbol";
    }

    public static String getArrayDestructor(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_deleteRef" + Fortran.getMethodSuffix();
    }

    public static String getArrayConstructor(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_createRow" + Fortran.getMethodSuffix();
    }

    public static String getArraySet(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_set" + Fortran.getMethodSuffix();
    }

    public static String getArraySet(SymbolID id, int numArgs) {
        return Fortran.getSymbolName(id) + "__array_set" + Integer.toString(numArgs) + Fortran.getMethodSuffix();
    }

    public static String getArrayGet(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_get" + Fortran.getMethodSuffix();
    }

    public static String getArrayGet(SymbolID id, int numArgs) {
        return Fortran.getSymbolName(id) + "__array_get" + Integer.toString(numArgs) + Fortran.getMethodSuffix();
    }

    public static String getArrayDimen(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_dimen" + Fortran.getMethodSuffix();
    }

    public static String getArrayLower(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_lower" + Fortran.getMethodSuffix();
    }

    public static String getArrayUpper(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_upper" + Fortran.getMethodSuffix();
    }

    public static String getMethodImplName(SymbolID id, Method method, NameMangler mang) throws CodeGenerationException {
        try {
            return mang.shortName(id.getFullName(), method.getLongMethodName(), Fortran.getImplMethodSuffix());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException(uee.getMessage());
        }
    }

    public static String getMethodSkelName(SymbolID id, Method method) {
        return "skel_" + method.getLongMethodName();
    }

    public static String getFortranTypeInC(Type type) throws CodeGenerationException {
        int t = type.getDetailedType();
        if (t >= 0 && t < s_cTypeMatchingFortran.length) {
            if (s_isF90) {
                if (t == 1) {
                    return s_F90_Bool;
                }
                if (t == 16) {
                    return s_F90_Array;
                }
            }
            return s_cTypeMatchingFortran[t];
        }
        throw new CodeGenerationException("Unknown supported " + t);
    }

    public static String getFortranPrefix() {
        return "SIDL_F" + Fortran.getFortranVersion();
    }

    public static boolean isFortran90() {
        return s_isF90;
    }

    public static String arrayIOR() {
        return s_isF90 ? ".d_ior" : "";
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        int t = type.getDetailedType();
        if (s_isF90) {
            if (t >= 0 && t < s_f90_types.length) {
                return s_f90_types[t];
            }
            switch (t) {
                case 12: 
                case 13: {
                    return "type(" + Fortran.getTypeName(type.getSymbolID()) + ")";
                }
                case 16: {
                    Type arrayType = type.getArrayType();
                    if (arrayType.getDetailedType() <= 10) {
                        return "type(" + Fortran.getArrayName(new SymbolID("SIDL." + arrayType.getTypeString(), new Version()), type.getArrayDimension()) + ")";
                    }
                    return "type(" + Fortran.getArrayName(arrayType.getSymbolID(), type.getArrayDimension()) + ")";
                }
            }
            throw new CodeGenerationException("Unknown supported " + t);
        }
        if (t >= 0 && t < s_f77_types.length) {
            return s_f77_types[t];
        }
        throw new CodeGenerationException("Unknown supported " + t);
    }

    static {
        s_Fortran_Bool = 1;
        s_F90_Bool = s_F90_Bool;
        s_F90_Array = s_F90_Array;
        s_isF90 = BabelConfiguration.getInstance().getTargetLanguage().equals("f90");
    }
}

