/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.StubDoc;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ModuleSource {
    private static final int s_CASTS_PER_LINE = 7;
    private static final boolean d_isF90;
    private LanguageWriterForFortran d_lw;
    private static final String[] s_intent_spec;

    public ModuleSource(LanguageWriterForFortran writer) {
        this.d_lw = writer;
    }

    private void printArgs(List args) {
        this.d_lw.print("(");
        Iterator i = args.iterator();
        while (i.hasNext()) {
            this.d_lw.print(((Argument)i.next()).getFormalName());
            if (!i.hasNext()) continue;
            this.d_lw.print(", ");
        }
        this.d_lw.println(")");
    }

    private void extendAndGenerate(Method m, SymbolID id) throws CodeGenerationException {
        List extendedArgs = StubSource.extendArgs(id, m);
        String methodName = m.getLongMethodName() + "_s";
        String stubName = Fortran.getMethodStubName(id, m);
        this.d_lw.print("recursive subroutine " + methodName);
        this.printArgs(extendedArgs);
        this.d_lw.increaseTabLevel();
        this.d_lw.println("implicit none");
        Iterator i = extendedArgs.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            this.d_lw.writeCommentLine(a.getArgumentString());
            this.d_lw.println(Fortran.getReturnString(a.getType()) + " " + s_intent_spec[a.getMode()] + " :: " + a.getFormalName());
        }
        this.d_lw.println();
        this.d_lw.println("external " + stubName);
        this.d_lw.print("call " + stubName);
        this.printArgs(extendedArgs);
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
        this.d_lw.println("end subroutine " + methodName);
    }

    private Method create(SymbolID id) {
        Method m = new Method();
        m.setMethodName("new");
        m.setDefinitionModifier(3);
        String[] s = new String[]{"Create an instance of class " + id.getFullName()};
        m.setComment(new Comment(s));
        m.setReturnType(new Type(id));
        return m;
    }

    public static Set extendedReferences(Extendable ext) throws CodeGenerationException {
        Set s = StubSource.extendedReferences(ext);
        s.add(ext.getSymbolID());
        Iterator i = ext.getParents(true).iterator();
        while (i.hasNext()) {
            s.add(((Symbol)i.next()).getSymbolID());
        }
        return s;
    }

    private Collection extendMethods(Extendable ext) {
        Collection allMethods = ext.getMethods(true);
        SymbolID id = ext.getSymbolID();
        ArrayList<Method> extendedMethods = new ArrayList<Method>(allMethods.size() + 1);
        if (!ext.isAbstract()) {
            extendedMethods.add(this.create(id));
        }
        extendedMethods.addAll(allMethods);
        return extendedMethods;
    }

    private void writeIncludes(Extendable ext) throws CodeGenerationException {
        Set s = ModuleSource.extendedReferences(ext);
        s.add(ext.getSymbolID());
        Iterator i = s.iterator();
        this.d_lw.disableLineBreak();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(id) + "\"");
        }
        this.d_lw.enableLineBreak();
    }

    private void includeType(SymbolID id) {
        this.d_lw.println("use " + Fortran.getTypeModule(id));
    }

    private static void checkType(Type t, Set result) {
        Type arrayType;
        int detailedType;
        if (t.getDetailedType() == 16 && (detailedType = (arrayType = t.getArrayType()).getDetailedType()) > 0 && detailedType <= 10) {
            result.add(new SymbolID("SIDL." + arrayType.getTypeString(), new Version()));
        }
    }

    private static Set basicArrayReferences(Extendable ext) {
        HashSet result = new HashSet();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            ModuleSource.checkType(m.getReturnType(), result);
            Iterator j = m.getArgumentList().iterator();
            while (j.hasNext()) {
                ModuleSource.checkType(((Argument)j.next()).getType(), result);
            }
        }
        return result;
    }

    private void includeTypes(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        SymbolTable table = SymbolTable.getInstance();
        Set s = ModuleSource.extendedReferences(ext);
        s.add(id);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            SymbolID current = (SymbolID)i.next();
            Symbol sym = table.lookupSymbol(current);
            if (!(sym instanceof Extendable)) continue;
            this.includeType(current);
        }
        s = ModuleSource.basicArrayReferences(ext);
        i = s.iterator();
        while (i.hasNext()) {
            SymbolID basic_array = (SymbolID)i.next();
            this.d_lw.println("use " + Fortran.getArrayModule(basic_array));
        }
    }

    private void generateCast(SymbolID oldType, SymbolID newType, int num) {
        String castMethod = Fortran.getMethodStubName(newType, StubDoc.createCast(newType));
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("Static function to cast from " + oldType.getFullName());
        this.d_lw.println("to " + newType.getFullName() + ".");
        this.d_lw.endBlockComment(false);
        this.d_lw.println("subroutine cast_" + num + "(oldType, newType)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("implicit none");
        this.d_lw.println("type(" + Fortran.getTypeName(oldType) + "), intent(in) :: oldType");
        this.d_lw.println("type(" + Fortran.getTypeName(newType) + "), intent(out) :: newType");
        this.d_lw.println("external " + castMethod);
        this.d_lw.println();
        this.d_lw.println("call " + castMethod + "(oldType, newType)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine cast_" + num);
        this.d_lw.println();
    }

    private void generateCastMethods(Extendable ext, Collection parents) {
        Object[] parentArray = parents.toArray();
        SymbolID id = ext.getSymbolID();
        int num = 0;
        Arrays.sort(parentArray);
        int i = 0;
        while (i < parentArray.length) {
            SymbolID parentID = ((Extendable)parentArray[i]).getSymbolID();
            this.generateCast(id, parentID, num++);
            this.generateCast(parentID, id, num++);
            ++i;
        }
    }

    private void writeCastList(int numCasts) {
        this.d_lw.print("cast_0");
        int i = 1;
        while (i < numCasts) {
            if (numCasts % 7 == 0 && i < numCasts - 1) {
                this.d_lw.println(", &");
                if (numCasts == 7) {
                    this.d_lw.increaseTabLevel();
                }
            } else {
                this.d_lw.print(", ");
            }
            this.d_lw.print("cast_" + i);
            ++i;
        }
    }

    private void writeCastInterface(int numCasts) {
        if (numCasts > 0) {
            this.d_lw.print("private :: ");
            this.writeCastList(numCasts);
            this.d_lw.println();
            if (numCasts > 7) {
                this.d_lw.decreaseTabLevel();
            }
            this.d_lw.println("interface cast");
            this.d_lw.increaseTabLevel();
            this.d_lw.print("module procedure ");
            this.writeCastList(numCasts);
            this.d_lw.println();
            if (numCasts > 7) {
                this.d_lw.decreaseTabLevel();
            }
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end interface");
        }
    }

    private void generateNullSubroutines(Extendable ext) {
        this.d_lw.println("logical function is_null_s(ext)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("type(" + Fortran.getTypeName(ext.getSymbolID()) + "), intent(in) :: ext");
        this.d_lw.println("is_null_s = (ext%d_ior .eq. 0)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function is_null_s");
        this.d_lw.println();
        this.d_lw.println("logical function not_null_s(ext)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("type(" + Fortran.getTypeName(ext.getSymbolID()) + "), intent(in) :: ext");
        this.d_lw.println("not_null_s = (ext%d_ior .ne. 0)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function not_null_s");
        this.d_lw.println();
        this.d_lw.println("subroutine set_null_s(ext)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("type(" + Fortran.getTypeName(ext.getSymbolID()) + "), intent(out) :: ext");
        this.d_lw.println("ext%d_ior = 0");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine set_null_s");
        this.d_lw.println();
    }

    private void writeMethodInterface(String methodName) {
        this.d_lw.println("private :: " + methodName + "_s");
        this.d_lw.println("interface " + methodName);
        this.d_lw.increaseTabLevel();
        this.d_lw.println("module procedure " + methodName + "_s");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end interface");
        this.d_lw.println();
    }

    private void writeMethodInterfaces(Collection methods) {
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.writeMethodInterface(m.getLongMethodName());
        }
    }

    public void generateCode(Extendable ext) throws CodeGenerationException {
        Collection methods = this.extendMethods(ext);
        Collection parents = ext.getParents(true);
        SymbolID id = ext.getSymbolID();
        String name = Fortran.getModule(id);
        this.d_lw.writeBanner(ext, Fortran.getModuleFile(id), false, "Client-side module for " + id.getFullName());
        this.d_lw.println();
        this.d_lw.writeComment(ext, false);
        this.d_lw.println();
        this.writeIncludes(ext);
        this.d_lw.println();
        this.d_lw.println("module " + name);
        this.d_lw.println();
        this.d_lw.increaseTabLevel();
        this.includeTypes(ext);
        this.writeCastInterface(parents.size() * 2);
        this.writeMethodInterfaces(methods);
        this.writeMethodInterface("not_null");
        this.writeMethodInterface("is_null");
        this.writeMethodInterface("set_null");
        this.d_lw.println();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("contains");
        this.d_lw.println();
        this.d_lw.increaseTabLevel();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            this.d_lw.println();
            this.d_lw.println();
            this.extendAndGenerate((Method)i.next(), id);
        }
        this.d_lw.println();
        this.generateCastMethods(ext, parents);
        this.generateNullSubroutines(ext);
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
        this.d_lw.println("end module " + name);
    }

    public void generateCode(Enumeration enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        String name = Fortran.getModule(id);
        this.d_lw.writeBanner(enm, Fortran.getModuleFile(id), false, "Client-side module for " + id.getFullName());
        this.d_lw.println();
        this.d_lw.println("module " + name);
        this.d_lw.writeComment(enm, false);
        this.d_lw.increaseTabLevel();
        this.d_lw.println();
        Iterator i = enm.getEnumerators().iterator();
        while (i.hasNext()) {
            String sym = (String)i.next();
            Comment cmt = enm.getEnumeratorComment(sym);
            this.d_lw.writeComment(cmt, true);
            this.d_lw.print(Fortran.getReturnString(new Type(id)));
            this.d_lw.print(", parameter :: ");
            this.d_lw.print(sym);
            this.d_lw.println(" = " + enm.getEnumeratorValue(sym));
            if (cmt == null) continue;
            this.d_lw.println();
        }
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end module " + name);
    }

    public static void generateCode(Symbol sym, LanguageWriterForFortran writer) throws CodeGenerationException {
        if (d_isF90) {
            if (sym instanceof Extendable) {
                ModuleSource modFile = new ModuleSource(writer);
                modFile.generateCode((Extendable)sym);
            } else if (sym instanceof Enumeration) {
                ModuleSource modFile = new ModuleSource(writer);
                modFile.generateCode((Enumeration)sym);
            }
        } else {
            throw new CodeGenerationException("Generation of module files only supported for FORTRAN 90");
        }
    }

    static {
        s_CASTS_PER_LINE = 7;
        d_isF90 = "f90".equals(BabelConfiguration.getInstance().getTargetLanguage());
        s_intent_spec = new String[]{", intent(in)", ", intent(inout)", ", intent(out)"};
    }
}

