/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClientJava {
    private static final int INTERFACE = 0;
    private static final int WRAPPER = 1;
    private static final int CLASS = 2;
    private LanguageWriterForJava d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForJava writer) throws CodeGenerationException {
        ClientJava source = new ClientJava(writer);
        source.generateCode(symbol);
    }

    public ClientJava(LanguageWriterForJava writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol == null) {
            throw new CodeGenerationException("Unexpected null symbol object");
        }
        switch (symbol.getSymbolType()) {
            case 12: {
                this.generateExtendable((Extendable)symbol);
                break;
            }
            case 11: {
                this.generateEnumeration((Enumeration)symbol);
                break;
            }
            case 13: {
                this.generateExtendable((Extendable)symbol);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new CodeGenerationException("Unsupported symbol type");
            }
        }
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        String file = Java.getClientJavaFile(id);
        this.d_writer.writeBanner(enm, file, false, "Client-side glue code for " + id.getFullName());
        this.writeJavaPackage(id);
        this.d_writer.writeComment(enm, true);
        this.d_writer.println("public interface " + Java.getJavaSymbolName(id) + " {");
        this.d_writer.increaseTabLevel();
        int maxlength = Utilities.getWidth(enm.getEnumerators());
        Iterator e = enm.getIterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Comment cmt = enm.getEnumeratorComment(name);
            this.d_writer.writeComment(cmt, true);
            this.d_writer.print("public final static int ");
            this.d_writer.printAligned(name, maxlength);
            this.d_writer.print(" = ");
            this.d_writer.print(String.valueOf(enm.getEnumeratorValue(name)));
            this.d_writer.println(";");
            if (cmt == null) continue;
            this.d_writer.println();
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String file = Java.getClientJavaFile(id);
        this.d_writer.writeBanner(ext, file, false, "Client-side glue code for " + id.getFullName());
        this.writeJavaPackage(id);
        this.d_writer.writeComment(ext, true);
        if (ext.isInterface()) {
            this.d_writer.println("public interface " + Java.getJavaSymbolName(id) + " extends");
            this.d_writer.increaseTabLevel();
            this.d_writer.print(Java.getJavaBaseInterface());
            Collection parents = ext.getParentInterfaces(false);
            if (parents == null || parents.isEmpty()) {
                this.d_writer.println();
            } else {
                this.d_writer.println(",");
                Iterator p = parents.iterator();
                while (p.hasNext()) {
                    Interface i = (Interface)p.next();
                    this.d_writer.print(Java.getFullJavaSymbolName(i.getSymbolID()));
                    if (p.hasNext()) {
                        this.d_writer.print(",");
                    }
                    this.d_writer.println();
                }
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            List local_methods = (List)ext.getMethods(false);
            Iterator m = local_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method, 0);
                this.d_writer.println();
            }
            this.d_writer.writeComment("Inner wrapper class that implements interface methods.", true);
            this.d_writer.println("public class " + Java.getInterfaceWrapper());
            this.d_writer.increaseTabLevel();
            this.d_writer.println("extends " + Java.getJavaBaseClass());
            this.d_writer.println("implements " + Java.getFullJavaSymbolName(id));
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.writeRegisterFunction(id);
            this.d_writer.writeComment("Class constructor for the wrapper class.", true);
            this.d_writer.println("public " + Java.getInterfaceWrapper() + "(long ior) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("super(ior);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
            List all_methods = (List)ext.getMethods(true);
            Iterator m2 = all_methods.iterator();
            while (m2.hasNext()) {
                Method method = (Method)m2.next();
                this.generateMethod(method, 1);
                if (!m2.hasNext()) continue;
                this.d_writer.println();
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
            this.writeHolderClass(id);
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        } else {
            Class cls = (Class)ext;
            this.d_writer.print("public ");
            if (ext.isAbstract()) {
                this.d_writer.print("abstract ");
            }
            this.d_writer.println("class " + Java.getJavaSymbolName(id) + " extends");
            this.d_writer.increaseTabLevel();
            Class c = cls.getParentClass();
            if (c == null) {
                this.d_writer.println(Java.getJavaBaseClass() + " implements");
            } else {
                this.d_writer.println(Java.getFullJavaSymbolName(c.getSymbolID()) + " implements");
            }
            Collection parents = ext.getParentInterfaces(true);
            Iterator p = parents.iterator();
            while (p.hasNext()) {
                Interface i = (Interface)p.next();
                this.d_writer.print(Java.getFullJavaSymbolName(i.getSymbolID()));
                if (p.hasNext()) {
                    this.d_writer.print(",");
                }
                this.d_writer.println();
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.writeRegisterFunction(id);
            if (!cls.isAbstract()) {
                this.d_writer.writeComment("Default constructor for the class.", true);
                this.d_writer.println("public " + Java.getJavaSymbolName(id) + "() {");
                this.d_writer.increaseTabLevel();
                this.d_writer.println("super(_create_ior());");
                this.d_writer.decreaseTabLevel();
                this.d_writer.println("}");
                this.d_writer.println();
                this.d_writer.writeComment("Private method to create IOR reference.", true);
                this.d_writer.println("private static native long _create_ior();");
                this.d_writer.println();
            }
            this.d_writer.writeComment("Public constructor for an existing IOR.", true);
            this.d_writer.println("public " + Java.getJavaSymbolName(id) + "(long ior) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("super(ior);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
            List local_methods = (List)ext.getMethods(false);
            Iterator m = local_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method, 2);
                this.d_writer.println();
            }
            this.writeHolderClass(id);
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        }
    }

    private void writeJavaPackage(SymbolID id) {
        String pkg = SymbolUtilities.getParentPackage(id.getFullName());
        this.d_writer.println("package " + pkg + ";");
        this.d_writer.println();
    }

    private void writeRegisterFunction(SymbolID id) {
        this.d_writer.writeComment("Register the JNI native routines.", false);
        this.d_writer.println("static {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(Java.getJavaBaseClass() + "._registerNatives(\"" + id.getFullName() + "\");");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeHolderClass(SymbolID id) {
        String holder = Java.getHolderName();
        String holdee = Java.getFullJavaSymbolName(id);
        this.d_writer.writeComment("Holder class for inout and out arguments.", true);
        this.d_writer.println("public class " + holder + " {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("private " + holdee + " d_obj;");
        this.d_writer.println();
        this.d_writer.writeComment("Create a holder with a null holdee object.", true);
        this.d_writer.println("public " + holder + "() {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("d_obj = null;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Create a holder with the specified object.", true);
        this.d_writer.println("public " + holder + "(" + holdee + " obj) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("d_obj = obj;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Set the value of the holdee object.", true);
        this.d_writer.println("public void set(" + holdee + " obj) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("d_obj = obj;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Get the value of the holdee object.", true);
        this.d_writer.println("public " + holdee + " get() {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return d_obj;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateMethod(Method method, int mode) {
        this.d_writer.writeComment(method, true);
        this.d_writer.print("public ");
        if (mode != 1 && method.isAbstract()) {
            this.d_writer.print("abstract ");
        } else if (method.isFinal()) {
            this.d_writer.print("final ");
        } else if (method.isStatic()) {
            this.d_writer.print("static ");
        }
        if (mode == 1 || !method.isAbstract()) {
            this.d_writer.print("native ");
        }
        this.d_writer.print(Java.getJavaReturnType(method.getReturnType()) + " " + method.getShortMethodName() + "(");
        ArrayList args = method.getArgumentList();
        Set thrws = method.getThrows();
        if (args.isEmpty() && thrws.isEmpty()) {
            this.d_writer.println(");");
        } else {
            if (!args.isEmpty()) {
                this.d_writer.println();
                this.d_writer.increaseTabLevel();
                Iterator a = args.iterator();
                while (a.hasNext()) {
                    Argument arg = (Argument)a.next();
                    this.d_writer.print(Java.getJavaFormalArgument(arg));
                    if (!a.hasNext()) continue;
                    this.d_writer.println(",");
                }
            }
            if (thrws.isEmpty()) {
                this.d_writer.println(");");
            } else {
                this.d_writer.println(") throws");
                if (args.isEmpty()) {
                    this.d_writer.increaseTabLevel();
                }
                Iterator t = thrws.iterator();
                while (t.hasNext()) {
                    SymbolID tid = (SymbolID)t.next();
                    this.d_writer.print(Java.getFullJavaSymbolName(tid));
                    this.d_writer.println(t.hasNext() ? "," : ";");
                }
            }
            this.d_writer.decreaseTabLevel();
        }
    }

    static {
        INTERFACE = 0;
        WRAPPER = 1;
        CLASS = 2;
    }
}

