/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.HashMap;
import java.util.Iterator;

public class Java {
    private static final HashMap s_java_val = new HashMap();
    private static final HashMap s_java_ref = new HashMap();
    private static final HashMap s_java_arr = new HashMap();
    private static final HashMap s_java_sig = new HashMap();
    private static final HashMap s_jni_arg = new HashMap();
    private static final HashMap s_init_ior = new HashMap();
    private static final HashMap s_init_jni = new HashMap();
    private static final HashMap s_init_java = new HashMap();
    private static final HashMap s_in = new HashMap();
    private static final HashMap s_inout = new HashMap();
    private static final HashMap s_post = new HashMap();
    private static final HashMap s_return = new HashMap();
    private static final Integer s_void = new Integer(0);
    private static final Integer s_boolean = new Integer(1);
    private static final Integer s_char = new Integer(2);
    private static final Integer s_dcomplex = new Integer(3);
    private static final Integer s_double = new Integer(4);
    private static final Integer s_fcomplex = new Integer(5);
    private static final Integer s_float = new Integer(6);
    private static final Integer s_int = new Integer(7);
    private static final Integer s_long = new Integer(8);
    private static final Integer s_opaque = new Integer(9);
    private static final Integer s_string = new Integer(10);
    private static final Integer s_enum = new Integer(11);
    private static final Integer s_class = new Integer(12);
    private static final Integer s_interface = new Integer(13);
    private static final Integer s_array = new Integer(16);

    public static String getClientJavaFile(SymbolID id) {
        return id.getShortName() + ".java";
    }

    public static String getClientJNIFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_jniStub.c";
    }

    public static String getJavaImplSourceFile(SymbolID id) {
        return id.getShortName() + "_Impl.java";
    }

    public static String getServerJNIFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_jniSkel.c";
    }

    public static String getJavaSymbolName(SymbolID id) {
        return id.getShortName();
    }

    public static String getFullJavaSymbolName(SymbolID id) {
        return id.getFullName();
    }

    public static String getRegisterFunction(SymbolID id) {
        return id.getFullName().replace('.', '_') + "__register";
    }

    public static String getJavaBaseClass() {
        return "gov.llnl.sidl.BaseClass";
    }

    public static String getJavaBaseInterface() {
        return "gov.llnl.sidl.BaseInterface";
    }

    public static String getInterfaceWrapper() {
        return "Wrapper";
    }

    public static String getHolderName() {
        return "Holder";
    }

    private static String getJavaArrayType(int dim, Type type) {
        String val = (String)s_java_arr.get(new Integer(type.getDetailedType()));
        if (val == null) {
            val = "java.lang.Object";
        }
        return val.replace('#', Character.forDigit(dim, 10));
    }

    private static String getJavaInternalReturnType(Type type) {
        int t = type.getDetailedType();
        String val = (String)s_java_val.get(new Integer(t));
        if (val == null) {
            if (t == 12 || t == 13) {
                val = Java.getFullJavaSymbolName(type.getSymbolID());
            } else if (t == 16) {
                val = Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType());
            }
        }
        return val;
    }

    public static String getJavaReturnType(Type type) {
        return Java.getJavaInternalReturnType(type).replace('$', '.');
    }

    private static String getDescriptor(String type) {
        String jni = (String)s_java_sig.get(type);
        if (jni == null) {
            jni = "L" + type.replace('.', '/') + ";";
        }
        return jni;
    }

    private static String getJavaInternalArgument(Argument arg) {
        String val = null;
        Type type = arg.getType();
        int t = type.getDetailedType();
        int m = arg.getMode();
        Integer T = new Integer(t);
        val = (String)(m == 0 ? s_java_val.get(T) : s_java_ref.get(T));
        if (val == null) {
            if (t == 12 || t == 13) {
                val = Java.getFullJavaSymbolName(arg.getType().getSymbolID());
                if (m != 0) {
                    val = val + "$" + Java.getHolderName();
                }
            } else if (t == 16) {
                val = Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType());
            }
        }
        return val;
    }

    public static String getJavaArgument(Argument arg) {
        return Java.getJavaInternalArgument(arg).replace('$', '.');
    }

    public static String getJavaFormalArgument(Argument arg) {
        return Java.getJavaArgument(arg) + " " + arg.getFormalName();
    }

    public static String getJavaSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        Iterator a = method.getArgumentList().iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            buffer.append(Java.getDescriptor(Java.getJavaInternalArgument(arg)));
        }
        buffer.append(")");
        Type type = method.getReturnType();
        buffer.append(Java.getDescriptor(Java.getJavaInternalReturnType(type)));
        return buffer.toString();
    }

    public static String getDefaultReturnValue(Method method) {
        if (method.getReturnType().getType() >= 9 || method.getReturnType().getType() == 5 || method.getReturnType().getType() == 3) {
            return "null";
        }
        if (method.getReturnType().getType() > 2 && method.getReturnType().getType() < 9) {
            return "0";
        }
        if (method.getReturnType().getType() == 2) {
            return "'\\0'";
        }
        if (method.getReturnType().getType() == 1) {
            return "false";
        }
        return "";
    }

    public static String getDefaultJNIReturnValue(Method method) {
        if (method.getReturnType().getType() >= 9) {
            return "NULL";
        }
        if (method.getReturnType().getType() == 5 || method.getReturnType().getType() == 3) {
            return "";
        }
        if (method.getReturnType().getType() > 2 && method.getReturnType().getType() < 9) {
            return "0";
        }
        if (method.getReturnType().getType() == 2) {
            return "'\\0'";
        }
        if (method.getReturnType().getType() == 1) {
            return "0";
        }
        return "";
    }

    public static String getJNIFunction(Method method) {
        return "jni_" + method.getLongMethodName();
    }

    public static String getJNINativeType(String type) {
        String jni = (String)s_jni_arg.get(type);
        if (jni == null) {
            jni = "jobject";
        }
        return jni;
    }

    public static String getJNIReturnType(Type type) {
        return Java.getJNINativeType(Java.getJavaReturnType(type));
    }

    public static void declareIORVariable(LanguageWriterForC writer, Type type, String variable) throws CodeGenerationException {
        writer.println(Java.substitute((String)s_init_ior.get(new Integer(type.getDetailedType())), IOR.getReturnString(type), variable));
    }

    public static void declareIORVariable(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        Type type = arg.getType();
        writer.println(Java.substitute((String)s_init_ior.get(new Integer(type.getDetailedType())), IOR.getReturnString(type), prefix + arg.getFormalName()));
    }

    public static void declareJavaVariable(LanguageWriterForC writer, Type type, String variable) {
        String rtype = Java.getJNIReturnType(type);
        writer.println(Java.substitute((String)s_init_jni.get(rtype), rtype, variable));
    }

    public static void declareJavaVariable(LanguageWriterForJava writer, Type type, String variable) {
        String rtype = type.getTypeString();
        writer.println(Java.substitute((String)s_init_java.get(rtype), rtype, variable));
    }

    public static String getJNIFormalArgument(Argument arg) {
        return Java.getJNINativeType(Java.getJavaArgument(arg)) + " _arg_" + arg.getFormalName();
    }

    public static void preprocessJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        String convert = null;
        Type type = arg.getType();
        Integer detail = new Integer(type.getDetailedType());
        if (arg.getMode() == 0) {
            convert = (String)s_in.get(detail);
        } else if (arg.getMode() == 1) {
            convert = (String)s_inout.get(detail);
        }
        if (convert != null) {
            writer.println(Java.substitute(convert, prefix + arg.getFormalName(), "_arg_" + arg.getFormalName(), IOR.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : null));
        }
    }

    public static void postprocessJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        Type type;
        String convert;
        if (arg.getMode() != 0 && (convert = (String)s_post.get(new Integer((type = arg.getType()).getDetailedType()))) != null) {
            writer.println(Java.substitute(convert, prefix + arg.getFormalName(), "_arg_" + arg.getFormalName(), IOR.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : null));
        }
        if (arg.getType().getType() == 10) {
            writer.println("SIDL_String_free(" + prefix + arg.getFormalName() + ");");
        }
    }

    public static void postprocessJNIReturn(LanguageWriterForC writer, Type type, String ior_result, String java_result) {
        int t = type.getDetailedType();
        writer.println(Java.substitute((String)s_return.get(new Integer(t)), java_result, ior_result, Java.getJNIReturnType(type), Java.getJavaInternalReturnType(type)));
        if (t == 10) {
            writer.println("SIDL_String_free(" + ior_result + ");");
        }
    }

    private static String substitute(String s, String s0, String s1) {
        return Java.substitute(s, new String[]{s0, s1});
    }

    private static String substitute(String s, String s0, String s1, String s2, String s3) {
        return Java.substitute(s, new String[]{s0, s1, s2, s3});
    }

    private static String substitute(String s, String[] args) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length() - 1) {
            if (sb.charAt(i) == '#') {
                try {
                    int n = Integer.parseInt(String.valueOf(sb.charAt(i + 1))) - 1;
                    if (n >= 0 && n < args.length) {
                        sb.replace(i, i + 2, args[n]);
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        s_java_val.put(s_void, "void");
        s_java_val.put(s_boolean, "boolean");
        s_java_val.put(s_char, "char");
        s_java_val.put(s_dcomplex, "SIDL.DoubleComplex");
        s_java_val.put(s_double, "double");
        s_java_val.put(s_fcomplex, "SIDL.FloatComplex");
        s_java_val.put(s_float, "float");
        s_java_val.put(s_int, "int");
        s_java_val.put(s_long, "long");
        s_java_val.put(s_opaque, "long");
        s_java_val.put(s_string, "java.lang.String");
        s_java_val.put(s_enum, "int");
        s_java_ref.put(s_boolean, "SIDL.Boolean$Holder");
        s_java_ref.put(s_char, "SIDL.Character$Holder");
        s_java_ref.put(s_dcomplex, "SIDL.DoubleComplex$Holder");
        s_java_ref.put(s_double, "SIDL.Double$Holder");
        s_java_ref.put(s_fcomplex, "SIDL.FloatComplex$Holder");
        s_java_ref.put(s_float, "SIDL.Float$Holder");
        s_java_ref.put(s_int, "SIDL.Integer$Holder");
        s_java_ref.put(s_long, "SIDL.Long$Holder");
        s_java_ref.put(s_opaque, "SIDL.Opaque$Holder");
        s_java_ref.put(s_string, "SIDL.String$Holder");
        s_java_ref.put(s_enum, "SIDL.Integer$Holder");
        s_java_arr.put(s_boolean, "SIDL.Boolean$Array#");
        s_java_arr.put(s_char, "SIDL.Character$Array#");
        s_java_arr.put(s_dcomplex, "SIDL.DoubleComplex$Array#");
        s_java_arr.put(s_double, "SIDL.Double$Array#");
        s_java_arr.put(s_fcomplex, "SIDL.FloatComplex$Array#");
        s_java_arr.put(s_float, "SIDL.Float$Array#");
        s_java_arr.put(s_int, "SIDL.Integer$Array#");
        s_java_arr.put(s_long, "SIDL.Long$Array#");
        s_java_arr.put(s_opaque, "SIDL.Opaque$Array#");
        s_java_arr.put(s_string, "SIDL.String$Array#");
        s_java_sig.put("boolean", "Z");
        s_java_sig.put("char", "C");
        s_java_sig.put("int", "I");
        s_java_sig.put("long", "J");
        s_java_sig.put("float", "F");
        s_java_sig.put("double", "D");
        s_java_sig.put("void", "V");
        s_jni_arg.put("void", "void");
        s_jni_arg.put("boolean", "jboolean");
        s_jni_arg.put("char", "jchar");
        s_jni_arg.put("double", "jdouble");
        s_jni_arg.put("float", "jfloat");
        s_jni_arg.put("int", "jint");
        s_jni_arg.put("long", "jlong");
        s_jni_arg.put("java.lang.String", "jstring");
        s_init_ior.put(s_boolean, "#1 #2 = FALSE;");
        s_init_ior.put(s_char, "#1 #2 = (#1) 0;");
        s_init_ior.put(s_dcomplex, "#1 #2 = { 0.0, 0.0 };");
        s_init_ior.put(s_double, "#1 #2 = 0.0;");
        s_init_ior.put(s_fcomplex, "#1 #2 = { 0.0, 0.0 };");
        s_init_ior.put(s_float, "#1 #2 = 0.0;");
        s_init_ior.put(s_int, "#1 #2 = 0;");
        s_init_ior.put(s_long, "#1 #2 = 0;");
        s_init_ior.put(s_opaque, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_string, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_enum, "#1 #2 = (#1) 0;");
        s_init_ior.put(s_class, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_interface, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_array, "#1 #2 = (#1) NULL;");
        s_init_jni.put("jboolean", "#1 #2 = JNI_FALSE;");
        s_init_jni.put("jchar", "#1 #2 = 0;");
        s_init_jni.put("jdouble", "#1 #2 = 0.0;");
        s_init_jni.put("jfloat", "#1 #2 = 0.0;");
        s_init_jni.put("jint", "#1 #2 = 0;");
        s_init_jni.put("jlong", "#1 #2 = 0;");
        s_init_jni.put("jobject", "#1 #2 = (#1) NULL;");
        s_init_jni.put("jstring", "#1 #2 = (#1) NULL;");
        s_init_java.put("boolean", "#1 #2 = false");
        s_init_java.put("char", "#1 #2 = 0");
        s_init_java.put("double", "#1 #2 = 0.0;");
        s_init_java.put("float", "#1 #2 = 0.0;");
        s_init_java.put("int", "#1 #2 = 0;");
        s_init_java.put("long", "#1 #2 = 0;");
        s_init_java.put("object", "#1 #2 = (#1) NULL;");
        s_init_java.put("string", "#1 #2 = (#1) NULL;");
        s_in.put(s_boolean, "#1 = (#3) #2;");
        s_in.put(s_char, "#1 = (#3) #2;");
        s_in.put(s_dcomplex, "#1 = SIDL_Java_J2I_dcomplex(env, #2);");
        s_in.put(s_double, "#1 = (#3) #2;");
        s_in.put(s_fcomplex, "#1 = SIDL_Java_J2I_fcomplex(env, #2);");
        s_in.put(s_float, "#1 = (#3) #2;");
        s_in.put(s_int, "#1 = (#3) #2;");
        s_in.put(s_long, "#1 = (#3) #2;");
        s_in.put(s_opaque, "#1 = (#3) JLONG_TO_POINTER(#2);");
        s_in.put(s_string, "#1 = SIDL_Java_J2I_string(env, #2);");
        s_in.put(s_enum, "#1 = (#3) #2;");
        s_in.put(s_class, "#1 = (#3) SIDL_Java_J2I_cls(env, #2);");
        s_in.put(s_interface, "#1 = (#3) SIDL_Java_J2I_ifc(env, #2, \"#4\");");
        s_in.put(s_array, "#1 = (#3) SIDL_Java_J2I_borrow_array(env, #2);");
        s_inout.put(s_boolean, "#1 = SIDL_Java_J2I_boolean_holder(env, #2);");
        s_inout.put(s_char, "#1 = SIDL_Java_J2I_character_holder(env, #2);");
        s_inout.put(s_dcomplex, "#1 = SIDL_Java_J2I_dcomplex_holder(env, #2);");
        s_inout.put(s_double, "#1 = SIDL_Java_J2I_double_holder(env, #2);");
        s_inout.put(s_fcomplex, "#1 = SIDL_Java_J2I_fcomplex_holder(env, #2);");
        s_inout.put(s_float, "#1 = SIDL_Java_J2I_float_holder(env, #2);");
        s_inout.put(s_int, "#1 = SIDL_Java_J2I_int_holder(env, #2);");
        s_inout.put(s_long, "#1 = SIDL_Java_J2I_long_holder(env, #2);");
        s_inout.put(s_opaque, "#1 = SIDL_Java_J2I_opaque_holder(env, #2);");
        s_inout.put(s_string, "#1 = SIDL_Java_J2I_string_holder(env, #2);");
        s_inout.put(s_enum, "#1 = (#3) SIDL_Java_J2I_int_holder(env, #2);");
        s_inout.put(s_class, "#1 = (#3) SIDL_Java_J2I_cls_holder(env, #2, \"#4\");");
        s_inout.put(s_interface, "#1 = (#3) SIDL_Java_J2I_ifc_holder(env, #2, \"#4\");");
        s_inout.put(s_array, "#1 = (#3) SIDL_Java_J2I_take_array(env, #2);");
        s_post.put(s_boolean, "SIDL_Java_I2J_boolean_holder(env, #2, #1);");
        s_post.put(s_char, "SIDL_Java_I2J_character_holder(env, #2, #1);");
        s_post.put(s_dcomplex, "SIDL_Java_I2J_dcomplex_holder(env, #2, &#1);");
        s_post.put(s_double, "SIDL_Java_I2J_double_holder(env, #2, #1);");
        s_post.put(s_fcomplex, "SIDL_Java_I2J_fcomplex_holder(env, #2, &#1);");
        s_post.put(s_float, "SIDL_Java_I2J_float_holder(env, #2, #1);");
        s_post.put(s_int, "SIDL_Java_I2J_int_holder(env, #2, #1);");
        s_post.put(s_long, "SIDL_Java_I2J_long_holder(env, #2, #1);");
        s_post.put(s_opaque, "SIDL_Java_I2J_opaque_holder(env, #2, #1);");
        s_post.put(s_string, "SIDL_Java_I2J_string_holder(env, #2, #1);");
        s_post.put(s_enum, "SIDL_Java_I2J_int_holder(env, #2, (int) #1);");
        s_post.put(s_class, "SIDL_Java_I2J_cls_holder(env, #2, #1, \"#4\");");
        s_post.put(s_interface, "SIDL_Java_I2J_ifc_holder(env, #2, #1, \"#4\");");
        s_post.put(s_array, "SIDL_Java_I2J_set_array(env, #2, #1);");
        s_return.put(s_boolean, "#1 = (#3) #2;");
        s_return.put(s_char, "#1 = (#3) #2;");
        s_return.put(s_dcomplex, "#1 = SIDL_Java_I2J_dcomplex(env, &#2);");
        s_return.put(s_double, "#1 = (#3) #2;");
        s_return.put(s_fcomplex, "#1 = SIDL_Java_I2J_fcomplex(env, &#2);");
        s_return.put(s_float, "#1 = (#3) #2;");
        s_return.put(s_int, "#1 = (#3) #2;");
        s_return.put(s_long, "#1 = (#3) #2;");
        s_return.put(s_opaque, "#1 = (#3) POINTER_TO_JLONG(#2);");
        s_return.put(s_string, "#1 = SIDL_Java_I2J_string(env, #2);");
        s_return.put(s_enum, "#1 = (#3) #2;");
        s_return.put(s_class, "#1 = SIDL_Java_I2J_cls(env, #2, \"#4\");");
        s_return.put(s_interface, "#1 = SIDL_Java_I2J_ifc(env, #2, \"#4\");");
        s_return.put(s_array, "#1 = SIDL_Java_I2J_new_array(env, #2, \"#4\");");
    }
}

