/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.python.PythonClientCSource;
import gov.llnl.babel.backend.python.PythonClientHeader;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForPython;
import gov.llnl.babel.backend.writers.PrettyWriter;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenPythonClient
implements CodeGenerator {
    /*
     * WARNING - void declaration
     */
    private void checkExtraParents(Set symbols, Set extraParents, SymbolTable table, String fullname) {
        int index;
        while ((index = fullname.lastIndexOf(46)) >= 0) {
            void var6_6;
            if (extraParents.contains(fullname = fullname.substring(0, (int)var6_6))) {
                return;
            }
            Symbol sym = table.lookupSymbol(fullname);
            if (sym != null && symbols.contains(sym.getSymbolID())) {
                return;
            }
            extraParents.add(fullname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        HashSet extraParents = new HashSet();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            this.checkExtraParents(symbols, extraParents, table, id.getFullName());
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: 
                case 13: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                case 11: {
                    this.generateEnumeration((Enumeration)symbol);
                    break;
                }
                case 14: {
                    this.generatePackage((Package)symbol);
                }
            }
        }
        Version v = new Version();
        PrettyWriter out = null;
        try {
            Iterator s2 = extraParents.iterator();
            while (s2.hasNext()) {
                SymbolID id = new SymbolID((String)s2.next(), v);
                Package pkg = new Package(id, null);
                out = Python.createPyWriter(pkg, "__init__.py", "Fabricated package initialization");
                out.close();
            }
            Object var11_10 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - void declaration
     */
    private String packageTop(SymbolID id) {
        int nextIndex;
        String fullName = id.getFullName();
        int curIndex = 0;
        StringBuffer buf = new StringBuffer(15);
        while ((nextIndex = fullName.indexOf(46, curIndex)) >= 0) {
            void var4_5;
            if (buf.length() > 0) {
                buf.append("/..");
            } else {
                buf.append("..");
            }
            curIndex = var4_5 + true;
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generatePackage(Package packge) throws CodeGenerationException {
        LanguageWriterForPython out = null;
        try {
            out = Python.createPyWriter(packge, "__init__.py", "package initialization code");
            out.println("all = [");
            Iterator i = packge.getSymbolReferences().iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                out.print("   \"");
                out.print(id.getShortName());
                out.print("\"");
                if (i.hasNext()) {
                    out.println(",");
                }
                Symbol symbol = Utilities.lookupSymbol(id);
            }
            out.println(" ]");
            Object var7_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateEnumeration(Enumeration enumeration) throws CodeGenerationException {
        PrettyWriter out = null;
        try {
            out = Python.createPyWriter(enumeration, enumeration.getSymbolID().getShortName() + ".py", "define enumeration constants");
            Iterator i = enumeration.getIterator();
            while (i.hasNext()) {
                String enumerator = (String)i.next();
                Comment cmt = enumeration.getEnumeratorComment(enumerator);
                ((LanguageWriter)out).writeComment(cmt, true);
                int value = enumeration.getEnumeratorValue(enumerator);
                out.print(enumerator);
                out.print(" = ");
                out.println(Integer.toString(value));
                if (cmt == null) continue;
                out.println();
            }
            Object var8_7 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private void generateExtendable(Extendable extendable) throws CodeGenerationException {
        PythonClientHeader header = new PythonClientHeader(extendable);
        PythonClientCSource source = new PythonClientCSource(extendable);
        header.generateCode();
        source.generateCode();
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("python");
        return result;
    }
}

