/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LineCountingFilterWriter;
import gov.llnl.babel.backend.writers.LineRedirector;
import java.io.File;
import java.io.PrintWriter;

public class LanguageWriterForC
extends LanguageWriter
implements CodeConstants,
LineRedirector {
    protected LineCountingFilterWriter d_lcfw = null;

    public LanguageWriterForC(PrintWriter writer) {
        super(writer);
        this.d_lcfw = null;
        this.setFirstTabStop(0);
        this.setTabSpacing(2);
        this.enableLineBreak(80, null, null);
        this.defineBlockComment(null, " * ");
    }

    public LanguageWriterForC(PrintWriter writer, LineCountingFilterWriter lcfw) {
        super(writer);
        this.d_lcfw = lcfw;
        this.setFirstTabStop(0);
        this.setTabSpacing(2);
        this.enableLineBreak(80, null, null);
        this.defineBlockComment(null, " * ");
    }

    public void redirectBegin(String path, int line) {
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        this.printlnUnformatted("#line " + line + " \"" + path + "\"");
    }

    public void redirectEnd(String path, int line) {
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        this.printlnUnformatted("#line " + line + " \"" + path + "\"");
    }

    public int getLineCount() {
        if (this.d_lcfw == null) {
            return -1;
        }
        return this.d_lcfw.getLineCount();
    }

    public void beginBlockComment(boolean is_doc) {
        if (is_doc) {
            this.println("/**");
        } else {
            this.println("/*");
        }
        this.enableBlockComment();
    }

    public void endBlockComment(boolean is_doc) {
        this.disableBlockComment();
        this.println(" */");
        if (!is_doc) {
            this.println();
        }
    }

    public void writeCommentLine(String comment) {
        if (comment != null) {
            this.println("/* " + comment + " " + "*/");
        }
    }

    public void generateInclude(String file, boolean guards) {
        if (guards) {
            this.printUnformatted("#ifndef ");
            this.printlnUnformatted(this.getIncludeGuard(file));
        }
        this.printUnformatted("#include \"");
        this.printUnformatted(file);
        this.printlnUnformatted("\"");
        if (guards) {
            this.printlnUnformatted("#endif");
        }
    }

    public void openHeaderGuard(String file) {
        String guard = this.getIncludeGuard(file);
        this.println("#ifndef " + guard);
        this.println("#define " + guard);
        this.println();
    }

    public void closeHeaderGuard() {
        this.println("#endif");
    }

    public void openCxxExtern() {
        this.println("#ifdef __cplusplus");
        this.println("extern \"C\" {");
        this.println("#endif");
        this.println();
    }

    public void closeCxxExtern() {
        this.println("#ifdef __cplusplus");
        this.println("}");
        this.println("#endif");
    }

    public String getIncludeGuard(String file) {
        int index = file.length();
        String suffix = "";
        if (file.endsWith(".h")) {
            index -= 2;
            suffix = "_h";
        }
        return "included_" + file.substring(0, index) + suffix;
    }

    public static String toSafeString(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(ch);
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\f': {
                    buf.append("\\f");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001a') {
                        String oct = Integer.toOctalString(ch);
                        int leadingZeros = 3 - oct.length();
                        buf.append('\\');
                        while (leadingZeros-- > 0) {
                            buf.append('0');
                        }
                        buf.append(oct);
                        break;
                    }
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public final String safeCommentString(String str) {
        return LanguageWriterForC.toSafeComment(str);
    }

    public static String toSafeComment(String str) {
        int len = str.length();
        int startComment = str.indexOf("/*");
        int endComment = str.indexOf("*/");
        int safeChars = Math.min(startComment = startComment < 0 ? len : startComment, endComment = endComment < 0 ? len : endComment);
        if (safeChars < len) {
            char[] orig = str.toCharArray();
            StringBuffer buf = new StringBuffer(len + 1);
            buf.append(orig, 0, safeChars);
            int i = safeChars;
            while (i < len - 1) {
                buf.append(orig[i]);
                if (orig[i] == '*' && orig[i + 1] == '/' || orig[i] == '/' && orig[i + 1] == '*') {
                    buf.append(' ');
                }
                ++i;
            }
            str = buf.toString();
        }
        return str;
    }
}

