/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.writers.LanguageWriter;
import java.io.PrintWriter;

public class LanguageWriterForPython
extends LanguageWriter
implements CodeConstants {
    public LanguageWriterForPython(PrintWriter writer) {
        super(writer);
        this.setFirstTabStop(0);
        this.setTabSpacing(2);
        this.enableLineBreak(78, null, "\\");
        this.defineBlockComment(null, "# ");
    }

    public void beginBlockComment(boolean is_doc) {
        this.println("#");
        this.enableBlockComment();
    }

    public void endBlockComment(boolean is_doc) {
        this.disableBlockComment();
        this.println("#");
        this.println();
    }

    public void writeCommentLine(String comment) {
        if (comment != null) {
            this.println("# " + comment);
        }
    }

    public static String toPythonString(String str) {
        int len = str.length();
        int firstBslash = str.indexOf(92);
        int firstQuote = str.indexOf(34);
        int safeChars = Math.min(firstBslash = firstBslash < 0 ? len : firstBslash, firstQuote = firstQuote < 0 ? len : firstQuote);
        if (safeChars < len) {
            char[] orig = str.toCharArray();
            StringBuffer buf = new StringBuffer(len + 1);
            buf.append(orig, 0, safeChars);
            int i = safeChars;
            while (i < len) {
                switch (orig[i]) {
                    case '\\': {
                        buf.append("\\\\");
                        break;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        break;
                    }
                    default: {
                        buf.append(orig[i]);
                    }
                }
                ++i;
            }
            str = buf.toString();
        }
        return str;
    }
}

