/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.parsers.sidl.GrammarException;
import gov.llnl.babel.parsers.sidl.ParseException;
import gov.llnl.babel.parsers.sidl.ParserConstants;
import gov.llnl.babel.parsers.sidl.ParserTokenManager;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.parsers.sidl.SimpleCharStream;
import gov.llnl.babel.parsers.sidl.SymbolException;
import gov.llnl.babel.parsers.sidl.Token;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class Parser
implements ParserConstants {
    private Stack d_arg_stack;
    private HashSet d_forward_refs;
    private Stack d_grammar;
    private ArrayList d_imports;
    private HashMap d_metadata;
    private HashMap d_reserved_words;
    private ArrayList d_scope;
    private String d_source_url;
    private HashSet d_unused_imports;
    private HashSet d_unused_versions;
    private HashMap d_versions;
    private ArrayList d_warnings;
    private LinkedList d_parent_stack;
    private static final String SCOPE = ".";
    private static final String EOL = "\n";
    private static final int MAX_ARRAY_DIM = 4;
    private static final String SIDL_CLASS;
    private static final String SIDL_INTERFACE;
    private static final String SIDL_THROWS;
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[47];
    private final int[] jj_la1_0 = new int[]{0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0xB000000, 0, 0xB000000, 0x1000000, 0x10000000, 0, 0, 0, 0, 0x5000000, 0, 0, 0, 0, 0, 0x10000000, 0x4000000, 0, 0x1000000, 0x1000000, 0x4000000, 0x4000000, 0, 0, -1006632960, 0, 0, 0, 0, 0x4000000, -1073741824, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{256, 0, 129, 0x6000000, 0x6000000, 2048, 1, 0x6000000, 2048, 137, 0, 137, 0, 0, 0, 4, 0, 2, 33550849, 0, 0, 0, 0, 0, 0, 0x1FFF000, 0, 513, 513, 0, 0x1FFF000, 0x1000000, 0, 64, 48, 48, 0, 1024, 0, 64, 33546240, 0, 0, 0, 0x4000000, 0, 0};
    private final int[] jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 1, 0, 1, 0, 0, 32, 1, 32, 2, 1, 0, 0, 32, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 384, 1, 384, 384, 1, 64};
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setSourceURL(String url) {
        this.d_source_url = url;
    }

    public void addMetadata(String key, String value) {
        if (this.d_metadata == null) {
            this.d_metadata = new HashMap();
        }
        this.d_metadata.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] beginParse() throws SIDLException {
        this.d_arg_stack = new Stack();
        this.d_forward_refs = new HashSet();
        this.d_grammar = new Stack();
        this.d_imports = new ArrayList();
        this.d_reserved_words = new HashMap();
        this.d_scope = new ArrayList();
        this.d_unused_imports = new HashSet();
        this.d_unused_versions = new HashSet();
        this.d_versions = new HashMap();
        this.d_warnings = new ArrayList();
        this.d_parent_stack = new LinkedList();
        this.generateReservedWords();
        if (this.d_metadata == null) {
            this.d_metadata = new HashMap();
        }
        if (this.d_source_url == null) {
            this.d_source_url = "file:unknown.sidl";
        }
        String[] warnings = null;
        try {
            try {
                this.Specification();
                warnings = this.generateWarnings();
            }
            catch (ParseException ex) {
                this.generateGrammarException(ex);
                Object var4_3 = null;
                this.d_arg_stack = null;
                this.d_forward_refs = null;
                this.d_grammar = null;
                this.d_imports = null;
                this.d_metadata = null;
                this.d_reserved_words = null;
                this.d_scope = null;
                this.d_unused_imports = null;
                this.d_unused_versions = null;
                this.d_versions = null;
                this.d_warnings = null;
                this.d_parent_stack = null;
            }
            Object var4_2 = null;
            this.d_arg_stack = null;
            this.d_forward_refs = null;
            this.d_grammar = null;
            this.d_imports = null;
            this.d_metadata = null;
            this.d_reserved_words = null;
            this.d_scope = null;
            this.d_unused_imports = null;
            this.d_unused_versions = null;
            this.d_versions = null;
            this.d_warnings = null;
            this.d_parent_stack = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.d_arg_stack = null;
            this.d_forward_refs = null;
            this.d_grammar = null;
            this.d_imports = null;
            this.d_metadata = null;
            this.d_reserved_words = null;
            this.d_scope = null;
            this.d_unused_imports = null;
            this.d_unused_versions = null;
            this.d_versions = null;
            this.d_warnings = null;
            this.d_parent_stack = null;
            throw throwable;
        }
        return warnings;
    }

    private void generateGrammarException(ParseException ex) throws GrammarException {
        Integer state = (Integer)this.d_grammar.peek();
        throw new GrammarException(ex, state);
    }

    private void generateSymbolException(String message) throws SymbolException {
        Integer state = (Integer)this.d_grammar.peek();
        throw new SymbolException(this.token, (int)state, message);
    }

    private void generateReservedWords() {
        this.d_reserved_words.put("abstract", "Java");
        this.d_reserved_words.put("and", "C++ and Python");
        this.d_reserved_words.put("and_eq", "C++");
        this.d_reserved_words.put("asm", "C and C++");
        this.d_reserved_words.put("assert", "Java and Python");
        this.d_reserved_words.put("auto", "C and C++");
        this.d_reserved_words.put("bitand", "C++");
        this.d_reserved_words.put("bitor", "C++");
        this.d_reserved_words.put("bool", "C++");
        this.d_reserved_words.put("boolean", "Java");
        this.d_reserved_words.put("break", "C, C++, Java, and Python");
        this.d_reserved_words.put("case", "C, C++, and Java");
        this.d_reserved_words.put("catch", "C++ and Java");
        this.d_reserved_words.put("char", "C, C++, and Java");
        this.d_reserved_words.put("class", "C++ and Java");
        this.d_reserved_words.put("compl", "C++");
        this.d_reserved_words.put("const", "C, C++, and Java");
        this.d_reserved_words.put("const_cast", "C++");
        this.d_reserved_words.put("continue", "C, C++, Java, and Python");
        this.d_reserved_words.put("def", "Python");
        this.d_reserved_words.put("default", "C, C++, and Java");
        this.d_reserved_words.put("del", "Python");
        this.d_reserved_words.put("delete", "C++");
        this.d_reserved_words.put("do", "C, C++, and Java");
        this.d_reserved_words.put("double", "C, C++, and Java");
        this.d_reserved_words.put("dynamic_cast", "C++");
        this.d_reserved_words.put("elif", "Python");
        this.d_reserved_words.put("else", "C, C++, Java, and Python");
        this.d_reserved_words.put("enum", "C and C++");
        this.d_reserved_words.put("except", "Python");
        this.d_reserved_words.put("exec", "Python");
        this.d_reserved_words.put("explicit", "C++");
        this.d_reserved_words.put("export", "C++");
        this.d_reserved_words.put("extends", "Java");
        this.d_reserved_words.put("extern", "C and C++");
        this.d_reserved_words.put("false", "C++ and Java");
        this.d_reserved_words.put("final", "Java");
        this.d_reserved_words.put("finally", "Java and Python");
        this.d_reserved_words.put("float", "C, C++, and Java");
        this.d_reserved_words.put("for", "C, C++, Java, and Python");
        this.d_reserved_words.put("friend", "C++");
        this.d_reserved_words.put("from", "Python");
        this.d_reserved_words.put("global", "Python");
        this.d_reserved_words.put("goto", "C, C++, and Java");
        this.d_reserved_words.put("if", "C, C++, Java, and Python");
        this.d_reserved_words.put("implements", "Java");
        this.d_reserved_words.put("import", "Java");
        this.d_reserved_words.put("inline", "C++");
        this.d_reserved_words.put("instanceof", "Java");
        this.d_reserved_words.put("int", "C, C++, and Java");
        this.d_reserved_words.put("interface", "Java");
        this.d_reserved_words.put("is", "Python");
        this.d_reserved_words.put("lambda", "Python");
        this.d_reserved_words.put("long", "C, C++, and Java");
        this.d_reserved_words.put("mutable", "C++");
        this.d_reserved_words.put("namespace", "C++");
        this.d_reserved_words.put("native", "Java");
        this.d_reserved_words.put("new", "C++ and Java");
        this.d_reserved_words.put("not", "C++ and Python");
        this.d_reserved_words.put("not_eq", "C++");
        this.d_reserved_words.put("null", "Java");
        this.d_reserved_words.put("operator", "C++");
        this.d_reserved_words.put("or", "C++ and Python");
        this.d_reserved_words.put("or_eq", "C++");
        this.d_reserved_words.put("package", "Java");
        this.d_reserved_words.put("pass", "Python");
        this.d_reserved_words.put("print", "Python");
        this.d_reserved_words.put("private", "C++ and Java");
        this.d_reserved_words.put("protected", "C++ and Java");
        this.d_reserved_words.put("public", "C++ and Java");
        this.d_reserved_words.put("raise", "Python");
        this.d_reserved_words.put("register", "C and C++");
        this.d_reserved_words.put("reinterpret_cast", "C++");
        this.d_reserved_words.put("return", "C, C++, Java, and Python");
        this.d_reserved_words.put("short", "C, C++, and Java");
        this.d_reserved_words.put("signed", "C and C++");
        this.d_reserved_words.put("sizeof", "C and C++");
        this.d_reserved_words.put("static", "C, C++, and Java");
        this.d_reserved_words.put("static_cast", "C++");
        this.d_reserved_words.put("strictfp", "Java");
        this.d_reserved_words.put("struct", "C and C++");
        this.d_reserved_words.put("super", "Java");
        this.d_reserved_words.put("switch", "C, C++, and Java");
        this.d_reserved_words.put("synchronized", "Java");
        this.d_reserved_words.put("template", "C++");
        this.d_reserved_words.put("this", "C++ and Java");
        this.d_reserved_words.put("throw", "C++ and Java");
        this.d_reserved_words.put("throws", "Java");
        this.d_reserved_words.put("transient", "Java");
        this.d_reserved_words.put("true", "C++ and Java");
        this.d_reserved_words.put("try", "C++, Java, and Python");
        this.d_reserved_words.put("typedef", "C and C++");
        this.d_reserved_words.put("typeid", "C++");
        this.d_reserved_words.put("typename", "C++");
        this.d_reserved_words.put("union", "C and C++");
        this.d_reserved_words.put("unsigned", "C and C++");
        this.d_reserved_words.put("using", "C++");
        this.d_reserved_words.put("virtual", "C++");
        this.d_reserved_words.put("void", "C, C++, and Java");
        this.d_reserved_words.put("volatile", "C, C++, and Java");
        this.d_reserved_words.put("wchar_t", "C++");
        this.d_reserved_words.put("while", "C, C++, Java, and Python");
        this.d_reserved_words.put("xor", "C++");
        this.d_reserved_words.put("xor_eq", "C++");
    }

    private void verifyReservedWords(String id) throws SymbolException {
        String lang = (String)this.d_reserved_words.get(id);
        if (lang != null) {
            this.generateSymbolException("Illegal identifier \"" + id + "\" is a reserved word in " + lang);
        }
    }

    private void checkMethodNameLength(String shortname, String extension, Token tok) {
        int extLen = extension != null ? extension.length() : 0;
        if (shortname.length() + (extension != null ? extension.length() : 0) > 31) {
            this.generateWarning("Method \"" + shortname + (extension != null ? "[" + extension + "]" : "") + "\" at line(s) " + tok.beginLine + ":" + tok.endLine + " is longer than 31 characters. This will require name mangling in FORTRAN 90/95 and potentially C.");
        }
    }

    private void setMetadataValues(Symbol sym) {
        sym.addMetadata("babel-version", "0.8.8");
        sym.addMetadata("source-url", this.d_source_url);
        sym.addMetadata("source-line", String.valueOf(this.token.beginLine));
        Iterator i = this.d_metadata.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            sym.addMetadata((String)e.getKey(), (String)e.getValue());
        }
    }

    private void generateWarning(String warning) {
        this.d_warnings.add(warning);
    }

    private String[] generateWarnings() {
        String[] warnings = null;
        int n = this.d_warnings.size();
        if (n > 0) {
            warnings = new String[n];
            int i = 0;
            while (i < n) {
                warnings[i] = (String)this.d_warnings.get(i);
                ++i;
            }
        }
        return warnings;
    }

    private void pushGrammarProduction(int production) {
        this.d_grammar.push(new Integer(production));
    }

    private void popGrammarProduction() {
        this.d_grammar.pop();
    }

    private void enterScope(String scope) {
        this.d_scope.add(scope);
    }

    private static Package toPackage(Symbol sym, SymbolID newID) throws SymbolRedefinitionException {
        Package p = null;
        if (sym != null) {
            if (sym instanceof Package) {
                p = (Package)sym;
            } else {
                throw new SymbolRedefinitionException(newID, sym.getSymbolID());
            }
        }
        return p;
    }

    private void leaveScope() {
        this.d_scope.remove(this.d_scope.size() - 1);
    }

    private String getScope() {
        int s = this.d_scope.size();
        return s == 0 ? "" : (String)this.d_scope.get(s - 1);
    }

    private String getScope(String name) {
        int s = this.d_scope.size();
        return s == 0 ? name : (String)this.d_scope.get(s - 1) + SCOPE + name;
    }

    private Comment generateComment(Token t) {
        String[] comment_lines = null;
        Token special = t.specialToken;
        if (special != null) {
            int lines = 0;
            while (special.kind != 10) {
                ++lines;
                special = special.specialToken;
            }
            if (lines > 0) {
                comment_lines = new String[lines];
                special = t.specialToken;
                while (special.kind != 10) {
                    comment_lines[--lines] = special.image;
                    special = special.specialToken;
                }
            }
        }
        return new Comment(comment_lines);
    }

    private void addForwardReference(String fqn) {
        this.d_forward_refs.add(fqn);
    }

    private void removeForwardReference(String fqn) {
        this.d_forward_refs.remove(fqn);
    }

    private void verifyForwardReferences() throws SymbolException {
        Iterator i = this.d_forward_refs.iterator();
        while (i.hasNext()) {
            this.generateSymbolException("Symbol name \"" + (String)i.next() + "\" not found or defined within package");
        }
    }

    private void verifyNotForwardReference(String fqn) throws SymbolException {
        if (this.d_forward_refs.contains(fqn)) {
            this.generateSymbolException("Forward reference \"" + fqn + "\" cannot be used as a package or enumerated type");
        }
    }

    private Version lookupVersion(String fqn) {
        SymbolTable table = SymbolTable.getInstance();
        Version version = null;
        while (fqn != null && version == null) {
            version = (Version)this.d_versions.get(fqn);
            if (version == null) {
                Symbol sym = table.lookupSymbol(fqn);
                if (sym != null) {
                    version = sym.getSymbolID().getVersion();
                    continue;
                }
                fqn = SymbolUtilities.getParentPackage(fqn);
                continue;
            }
            this.d_unused_versions.remove(fqn);
        }
        return version;
    }

    private void verifyVersionNotDefined(String name) throws SymbolException {
        if (this.d_versions.keySet().contains(name)) {
            this.generateSymbolException("Redefinition of version for package \"" + name + "\"");
        }
    }

    private void addPackageVersion(String name, Version version) {
        this.d_versions.put(name, version);
        this.d_unused_versions.add(name);
    }

    private void generateVersionWarnings() {
        Iterator i = this.d_unused_versions.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.generateWarning("Package \"" + name + "-v" + ((Version)this.d_versions.get(name)).getVersionString() + "\" was not used to resolve any symbols");
        }
    }

    private void verifyImportNotDefined(String fqn) throws SymbolException {
        if (this.d_imports.contains(fqn)) {
            this.generateSymbolException("Redefinition of import for package \"" + fqn + "\"");
        }
    }

    private void addToImportPath(String fqn) {
        this.d_imports.add(fqn);
        this.d_unused_imports.add(fqn);
    }

    private void usedImportToResolveSymbol(String fqn) {
        this.d_unused_imports.remove(fqn);
    }

    private void generateImportWarnings() {
        Iterator i = this.d_unused_imports.iterator();
        while (i.hasNext()) {
            this.generateWarning("Import statement for package \"" + (String)i.next() + "\" not used to resolve any symbols");
        }
    }

    private Symbol tryResolveFQN(String fqn) throws SymbolException {
        Symbol sym = null;
        Version version = this.lookupVersion(fqn);
        if (version == null) {
            sym = SymbolTable.getInstance().resolveSymbol(fqn);
        } else {
            try {
                SymbolID id = new SymbolID(fqn, version);
                sym = SymbolTable.getInstance().resolveSymbol(id);
            }
            catch (SymbolRedefinitionException ex) {
                this.generateSymbolException(ex.getMessage());
            }
        }
        if (sym != null) {
            try {
                Set refs = sym.getSymbolReferences();
                SymbolTable.getInstance().generateDependencies(refs);
            }
            catch (SymbolRedefinitionException ex) {
                this.generateSymbolException(ex.getMessage());
            }
            catch (SymbolNotFoundException ex) {
                // empty catch block
            }
        }
        return sym;
    }

    private Symbol resolveFQN(String fqn) throws SymbolException {
        Symbol sym = this.tryResolveFQN(fqn);
        if (sym == null) {
            Version v = this.lookupVersion(fqn);
            String s = v == null ? fqn : fqn + "-v" + v.getVersionString();
            this.generateSymbolException("Symbol \"" + s + "\" not found");
        }
        return sym;
    }

    private Symbol tryResolveSymbol(String name) throws SymbolException {
        Symbol sym = this.tryResolveFQN(name);
        int s = this.d_scope.size() - 1;
        while (s >= 0 && sym == null) {
            sym = this.tryResolveFQN((String)this.d_scope.get(s) + SCOPE + name);
            --s;
        }
        int n = this.d_imports.size();
        int s2 = 0;
        while (s2 < n && sym == null) {
            String prefix = (String)this.d_imports.get(s2);
            sym = this.tryResolveFQN(prefix + SCOPE + name);
            if (sym != null) {
                this.usedImportToResolveSymbol(prefix);
            }
            ++s2;
        }
        return sym;
    }

    private Symbol resolveSymbol(String name) throws SymbolException {
        Symbol sym = this.tryResolveSymbol(name);
        if (sym == null) {
            this.generateSymbolException("Symbol \"" + name + "\" not found");
        }
        return sym;
    }

    private void verifyImportIsPackage(String fqn) throws SymbolException {
        Symbol sym = this.resolveFQN(fqn);
        if (sym.getSymbolType() != 14) {
            this.generateSymbolException("Symbol \"" + sym.getSymbolID().getSymbolName() + "\" is not a package");
        }
    }

    private void verifySymbolCanBeDefined(SymbolID id) throws SymbolException {
        Version version = id.getVersion();
        if (version == null || version.isUnspecified()) {
            this.generateSymbolException("No version specified for the definition of symbol \"" + id.getSymbolName() + "\".\nClasses & interfaces cannot be defined in an unversioned package.");
        }
        try {
            Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
            if (sym != null) {
                this.generateSymbolException("Redefinition of symbol \"" + sym.getSymbolID().getSymbolName() + "\"");
            }
        }
        catch (SymbolRedefinitionException sre) {
            this.generateSymbolException(sre.getMessage());
        }
    }

    private void addSymbolToParentPackage(Package parent, SymbolID id, int type) throws SymbolException {
        if (parent != null) {
            if (parent.getSymbolType() != 14) {
                this.generateSymbolException("Symbol \"" + parent.getSymbolID().getSymbolName() + "\" is not a package");
            }
            if (parent.getFinal()) {
                this.generateSymbolException("Cannot modify final package \"" + parent.getSymbolID().getSymbolName() + "\"");
            }
            parent.addSymbol(id, type);
            SymbolTable.getInstance().markSymbolAsModified(parent.getSymbolID());
        }
    }

    private void verifyCopyModifierValid(Type type) throws SymbolException {
        if (type.getType() != 15) {
            this.generateSymbolException("Modifier \"copy\" is only valid for interfaces and classes");
        } else {
            SymbolID id = type.getSymbolID();
            Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
            if (symbol != null && symbol.getSymbolType() == 11) {
                this.generateSymbolException("Modifier \"copy\" is not allowed for enumerated types");
            }
        }
    }

    private void verifyOnewayValid(Method m) throws SymbolException {
        if (m.getReturnType() != null) {
            this.generateSymbolException("Modifier \"oneway\" invalid for methods that return values");
        }
        ArrayList args = m.getArgumentList();
        int i = 0;
        while (i < args.size()) {
            Argument arg = (Argument)args.get(i);
            if (arg.getMode() != 0) {
                this.generateSymbolException("Modifier \"oneway\" invalid for methods with inout and out arguments");
            }
            ++i;
        }
    }

    private void verifyAndAddThrows(Method m, String identifier) throws SymbolException {
        Class throwable;
        Class symbolcls;
        if (m.getCommunicationModifier() == 2) {
            this.generateSymbolException("Modifier \"oneway\" invalid for methods with a throws clause");
        }
        Symbol symbol = this.resolveSymbol(identifier);
        if (m.getThrows().contains(symbol.getSymbolID())) {
            this.generateSymbolException("Class \"" + symbol.getFullName() + "\" already listed in throws clause");
        }
        if (symbol.getSymbolType() != 12) {
            this.generateSymbolException("Symbol \"" + symbol.getFullName() + "\" must be a class to be in a throws clause");
        }
        if (!SIDL_THROWS.equals(symbol.getFullName()) && !(symbolcls = (Class)symbol).hasParentClass((throwable = (Class)this.resolveFQN(SIDL_THROWS)).getSymbolID(), true)) {
            this.generateSymbolException("Class \"" + symbol.getFullName() + "\" does not extend \"" + SIDL_THROWS + "\"");
        }
        m.addThrows(symbol.getSymbolID());
    }

    private void verifyMethodRedefinition(Extendable ext, Method m) throws SymbolException {
        Collection methods;
        Method method = ext.lookupMethodByLongName(m.getLongMethodName(), false);
        if (method != null) {
            if (method.sameSignature(m)) {
                this.generateSymbolException("Method \"" + m.getSignature() + "\" has already been defined locally in \"" + ext.getFullName() + "\" with same signature");
            } else {
                this.generateSymbolException("Method \"" + m.getSignature() + "\" conflicts with existing method \"" + method.getSignature() + "\" already defined locally in \"" + ext.getFullName() + "\"");
            }
        }
        if ((methods = ext.lookupMethodByShortName(m.getShortMethodName(), false)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                method = (Method)i.next();
                if (!method.sameBaseSignature(m)) continue;
                this.generateSymbolException("Method \"" + m.getSignature() + "\" has already been defined locally in \"" + ext.getFullName() + "\" with the same short name and argument list");
            }
        }
    }

    private void verifyMethodSignature(Extendable ext, Method m, String definer) throws SymbolException {
        Method existing;
        if (ext.getSymbolID().getShortName().equals(m.getLongMethodName())) {
            this.generateSymbolException("Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot have same (long) name as \"" + ext.getFullName() + "\"");
        }
        if (ext.getSymbolID().getShortName().equals(m.getShortMethodName())) {
            this.generateSymbolException("Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot have same (short) name as \"" + ext.getFullName() + "\"");
        }
        if ((existing = ext.lookupMethodByLongName(m.getLongMethodName(), true)) != null && !m.sameSignature(existing)) {
            this.generateSymbolException("Signature conflict between method \"" + m.getSignature() + "\" from \"" + definer + "\" and existing ancestor method \"" + existing.getSignature() + "\"");
        }
    }

    private void verifyMethodStatic(Extendable ext, Method m, String definer) throws SymbolException {
        Collection methods;
        Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
        if (existing != null) {
            if (m.isStatic()) {
                this.generateSymbolException("Static method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing ancestor method with same long " + "name");
            }
            if (existing.isStatic()) {
                this.generateSymbolException("Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing static ancestor method with same " + "long name");
            }
        }
        if ((methods = ext.lookupMethodByShortName(m.getShortMethodName(), true)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                existing = (Method)i.next();
                if (!existing.sameBaseSignature(m)) continue;
                if (m.isStatic()) {
                    this.generateSymbolException("Static method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing ancestor method with same " + "short name and argument list");
                }
                if (!existing.isStatic()) continue;
                this.generateSymbolException("Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing static ancestor method with" + " the same short name and argument list");
            }
        }
    }

    private void verifyMethodOverride(Class cls, Method m) throws SymbolException {
        Collection methods;
        Method existing = cls.lookupMethodByLongName(m.getLongMethodName(), true);
        if (existing != null) {
            if (existing.isFinal()) {
                this.generateSymbolException("Method \"" + m.getSignature() + "\" cannot redefine existing final ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\" with the same long method name");
            }
            if (!existing.isAbstract() && m.isAbstract()) {
                this.generateSymbolException("Abstract method \"" + m.getSignature() + "\" cannot redefine existing non-abstract ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\"");
            }
        }
        if ((methods = cls.lookupMethodByShortName(m.getShortMethodName(), true)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                existing = (Method)i.next();
                if (!existing.sameBaseSignature(m)) continue;
                if (existing.isFinal()) {
                    this.generateSymbolException("Method \"" + m.getSignature() + "\" cannot redefine existing final ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\" with the same short name and arguments");
                }
                if (existing.isAbstract() || !m.isAbstract()) continue;
                this.generateSymbolException("Abstract method \"" + m.getSignature() + "\" cannot redefine existing non-abstract ancestor " + "method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\"");
            }
        }
    }

    private void verifyClassInheritance(Class cls, Class test) throws SymbolException {
        if (cls == test) {
            this.generateSymbolException("Class \"" + cls.getFullName() + "\" cannot extend itself");
        }
        String test_name = test.getFullName();
        Iterator methods = test.getMethods(true).iterator();
        while (methods.hasNext()) {
            this.verifyMethodSignature(cls, (Method)methods.next(), test_name);
        }
    }

    private void verifyInterfaceInheritance(Extendable old, Interface test) throws SymbolException {
        if (old == test) {
            this.generateSymbolException("Interface \"" + old.getFullName() + "\" cannot inherit from itself");
        }
        Iterator methods = test.getMethods(true).iterator();
        while (methods.hasNext()) {
            Method method = (Method)methods.next();
            String name = test.getFullName();
            this.verifyMethodSignature(old, method, name);
            this.verifyMethodStatic(old, method, name);
        }
    }

    private void verifyAbstract(Class cls, boolean ab) throws SymbolException {
        if (ab && !cls.isAbstract()) {
            this.generateSymbolException("Class \"" + cls.getFullName() + "\" declared abstract but contains no abstract methods");
        }
        if (!ab && cls.isAbstract()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Class \"");
            msg.append(cls.getFullName());
            msg.append("\" not declared abstract but has abstract method(s):");
            msg.append(EOL);
            Iterator m = cls.getAbstractMethods().iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                msg.append("   ");
                msg.append(method.getSignature());
                msg.append(EOL);
            }
            this.generateSymbolException(msg.toString());
        }
    }

    public final void Specification() throws ParseException, SymbolException {
        this.pushGrammarProduction(1);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block12;
                }
            }
            this.Require();
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block13;
                }
            }
            this.Import();
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block14;
                }
            }
            this.Package();
        }
        this.jj_consume_token(0);
        try {
            SymbolTable.getInstance().resolveAllReferences();
        }
        catch (SymbolNotFoundException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.verifyForwardReferences();
        this.generateVersionWarnings();
        this.generateImportWarnings();
        this.popGrammarProduction();
    }

    public final void Require() throws ParseException, SymbolException {
        this.pushGrammarProduction(2);
        this.jj_consume_token(40);
        this.ScopedIdentifier();
        String name = (String)this.d_arg_stack.pop();
        this.verifyVersionNotDefined(name);
        this.jj_consume_token(43);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            Version version = new Version(this.token.image);
            this.addPackageVersion(name, version);
        }
        catch (NumberFormatException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.jj_consume_token(69);
        this.popGrammarProduction();
    }

    public final void Import() throws ParseException, SymbolException {
        Version version = null;
        this.pushGrammarProduction(3);
        this.jj_consume_token(29);
        this.ScopedIdentifier();
        String fqn = (String)this.d_arg_stack.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    version = new Version(this.token.image);
                }
                catch (NumberFormatException nfe) {
                    this.generateSymbolException(nfe.getMessage());
                }
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        if (version != null) {
            this.addPackageVersion(fqn, version);
        }
        this.verifyImportNotDefined(fqn);
        this.verifyImportIsPackage(fqn);
        this.addToImportPath(fqn);
        this.jj_consume_token(69);
        this.popGrammarProduction();
    }

    public final void Package() throws ParseException, SymbolException {
        boolean declared_final = false;
        Package parent = this.d_parent_stack.isEmpty() ? null : (Package)this.d_parent_stack.getFirst();
        Version version = parent != null ? parent.getSymbolID().getVersion() : new Version();
        Package p = null;
        this.pushGrammarProduction(4);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                declared_final = true;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(39);
        Comment comment = this.generateComment(this.token);
        this.ScopedIdentifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    version = new Version(this.token.image);
                }
                catch (NumberFormatException nfe) {
                    this.generateSymbolException("Bad version number \"" + this.token.image + "\" for package " + fqn);
                }
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        try {
            this.verifyNotForwardReference(fqn);
            SymbolTable table = SymbolTable.getInstance();
            SymbolID id = null;
            id = new SymbolID(fqn, version);
            Symbol sym = table.resolveSymbol(id);
            p = Parser.toPackage(sym, id);
            if (p == null) {
                p = new Package(id, comment);
                p.setFinal(false);
                this.setMetadataValues(p);
                table.putSymbol(p);
                this.addSymbolToParentPackage(parent, id, 14);
            } else if (p.getFinal()) {
                this.generateSymbolException("Attempt to reopen final package " + id.getFullName() + " version " + id.getVersion().getVersionString());
            } else {
                p.setComment(Comment.combineComments(p.getComment(), comment));
            }
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.enterScope(fqn);
        this.d_parent_stack.addFirst(p);
        this.jj_consume_token(67);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 25: 
                case 27: 
                case 32: 
                case 35: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block20;
                }
            }
            this.Definition();
        }
        this.jj_consume_token(62);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.d_parent_stack.removeFirst();
        this.leaveScope();
        if (p != null) {
            p.setFinal(declared_final);
        }
    }

    public final void Definition() throws ParseException, SymbolException {
        this.pushGrammarProduction(5);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: {
                this.Class();
                break;
            }
            case 27: {
                this.Enum();
                break;
            }
            case 35: {
                this.Interface();
                break;
            }
            case 32: 
            case 39: {
                this.Package();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.popGrammarProduction();
    }

    public final void Class() throws ParseException, SymbolException {
        this.pushGrammarProduction(6);
        Comment comment = null;
        HashSet implall = new HashSet();
        boolean declared_abstract = false;
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                declared_abstract = true;
                comment = this.generateComment(this.token);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
        if (comment == null) {
            comment = this.generateComment(this.token);
        }
        this.Identifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.removeForwardReference(fqn);
        Class cls = new Class(id, comment);
        this.setMetadataValues(cls);
        try {
            SymbolTable.getInstance().putSymbol(cls);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.ScopedIdentifier();
                String identifier = (String)this.d_arg_stack.pop();
                Symbol symbol = this.resolveSymbol(identifier);
                if (symbol.getSymbolType() != 12) {
                    this.generateSymbolException("Symbol \"" + symbol.getSymbolID().getSymbolName() + "\" must be an class");
                }
                this.verifyClassInheritance(cls, (Class)symbol);
                cls.setParentClass((Class)symbol);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (cls.getParentClass() == null && !fqn.equals(SIDL_CLASS)) {
            Class base = (Class)this.resolveFQN(SIDL_CLASS);
            this.verifyClassInheritance(cls, base);
            cls.setParentClass(base);
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                this.AddInterface(cls, implall);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(64);
                    this.AddInterface(cls, implall);
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                this.AddInterface(cls, null);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(64);
                    this.AddInterface(cls, null);
                }
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.jj_consume_token(67);
        block28: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 26: 
                case 32: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block28;
                }
            }
            this.ClassMethod(cls);
        }
        this.jj_consume_token(62);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        Iterator i = implall.iterator();
        while (i.hasNext()) {
            Interface ifc = (Interface)i.next();
            String name = ifc.getFullName();
            Iterator m = ifc.getMethods(true).iterator();
            while (m.hasNext()) {
                Method exist;
                Method method = (Method)m.next();
                Method defined = cls.lookupMethodByLongName(method.getLongMethodName(), false);
                if (defined != null || !(exist = cls.lookupMethodByLongName(method.getLongMethodName(), true)).isAbstract()) continue;
                Method clone = method.cloneMethod();
                clone.setDefinitionModifier(0);
                cls.addMethod(clone);
            }
        }
        this.verifyAbstract(cls, declared_abstract);
        this.popGrammarProduction();
    }

    public final void Enum() throws ParseException, SymbolException {
        this.pushGrammarProduction(7);
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        this.jj_consume_token(27);
        Comment comment = this.generateComment(this.token);
        this.Identifier();
        if (comment == null) {
            // empty if block
        }
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.verifyNotForwardReference(fqn);
        Enumeration e = new Enumeration(id, comment);
        this.setMetadataValues(e);
        try {
            SymbolTable.getInstance().putSymbol(e);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 11);
        this.jj_consume_token(67);
        this.Enumerator(e);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(64);
            this.Enumerator(e);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(62);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void Enumerator(Enumeration e) throws ParseException, SymbolException {
        this.pushGrammarProduction(8);
        Comment comment = null;
        this.Identifier();
        comment = this.generateComment(this.token);
        String name = (String)this.d_arg_stack.pop();
        if (e.hasEnumerator(name)) {
            this.generateSymbolException("Redefinition of enumerator \"" + name + "\"");
        }
        int value = 0;
        boolean user_defined = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(58);
                user_defined = true;
                try {
                    value = Integer.parseInt(this.token.image);
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Invalid integer \"" + this.token.image + "\"");
                }
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        if (!user_defined) {
            e.addEnumerator(name, comment);
        } else {
            e.addEnumerator(name, value, comment);
        }
        this.popGrammarProduction();
    }

    public final void Interface() throws ParseException, SymbolException {
        this.pushGrammarProduction(9);
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        this.jj_consume_token(35);
        Comment comment = this.generateComment(this.token);
        this.Identifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.removeForwardReference(fqn);
        Interface ifc = new Interface(id, comment);
        this.setMetadataValues(ifc);
        try {
            SymbolTable.getInstance().putSymbol(ifc);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException(ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 13);
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.AddInterface(ifc, null);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block1;
                        }
                    }
                    this.jj_consume_token(64);
                    this.AddInterface(ifc, null);
                }
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (ifc.getParentInterfaces(false).isEmpty() && !fqn.equals(SIDL_INTERFACE)) {
            Interface base = (Interface)this.resolveFQN(SIDL_INTERFACE);
            this.verifyInterfaceInheritance(ifc, base);
            ifc.addParentInterface(base);
        }
        this.jj_consume_token(67);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block15;
                }
            }
            this.InterfaceMethod(ifc);
        }
        this.jj_consume_token(62);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void AddInterface(Extendable ext, Set set) throws ParseException, SymbolException {
        this.ScopedIdentifier();
        String identifier = (String)this.d_arg_stack.pop();
        Symbol symbol = this.resolveSymbol(identifier);
        if (symbol.getSymbolType() != 13) {
            this.generateSymbolException("Symbol \"" + symbol.getSymbolID().getSymbolName() + "\" must be an interface");
        }
        this.verifyInterfaceInheritance(ext, (Interface)symbol);
        ext.addParentInterface((Interface)symbol);
        if (set != null) {
            set.add(symbol);
        }
    }

    public final void ClassMethod(Class cls) throws ParseException, SymbolException {
        this.pushGrammarProduction(10);
        Method method = new Method();
        Comment comment = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 32: 
            case 41: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        method.setDefinitionModifier(1);
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        method.setDefinitionModifier(2);
                        break;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        method.setDefinitionModifier(3);
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                comment = this.generateComment(this.token);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        if (comment == null) {
            comment = this.generateComment(this.getToken(1));
        }
        method.setComment(comment);
        this.Method(method);
        String name = cls.getFullName();
        this.verifyMethodRedefinition(cls, method);
        this.verifyMethodSignature(cls, method, name);
        this.verifyMethodStatic(cls, method, name);
        this.verifyMethodOverride(cls, method);
        cls.addMethod(method);
        this.popGrammarProduction();
    }

    public final void InterfaceMethod(Interface ifc) throws ParseException, SymbolException {
        Method method = new Method();
        method.setComment(this.generateComment(this.getToken(1)));
        this.Method(method);
        method.setDefinitionModifier(1);
        String name = ifc.getFullName();
        this.verifyMethodRedefinition(ifc, method);
        this.verifyMethodSignature(ifc, method, name);
        ifc.addMethod(method);
    }

    public final void Method(Method m) throws ParseException, SymbolException {
        this.pushGrammarProduction(11);
        boolean copy = false;
        String short_name = null;
        String extension = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                m.setReturnType(new Type(0));
                m.setReturnCopy(false);
                break;
            }
            case 26: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        copy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                    }
                }
                this.Type();
                Type t = (Type)this.d_arg_stack.pop();
                if (copy) {
                    this.verifyCopyModifierValid(t);
                }
                m.setReturnType(t);
                m.setReturnCopy(copy);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.Identifier();
        short_name = (String)this.d_arg_stack.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                this.verifyReservedWords(this.token.image);
                extension = this.token.image;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        this.checkMethodNameLength(short_name, extension, this.token);
        if (extension != null) {
            m.setMethodName(short_name, extension);
        } else {
            m.setMethodName(short_name);
        }
        this.jj_consume_token(68);
        block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: 
            case 30: 
            case 31: 
            case 38: {
                this.Argument();
                m.addArgument((Argument)this.d_arg_stack.pop());
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(64);
                    this.Argument();
                    m.addArgument((Argument)this.d_arg_stack.pop());
                }
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.jj_consume_token(63);
        block16 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 37: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        m.setCommunicationModifier(1);
                        break block16;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        this.verifyOnewayValid(m);
                        m.setCommunicationModifier(2);
                        break block16;
                    }
                }
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        block23 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                this.ScopedIdentifier();
                this.verifyAndAddThrows(m, (String)this.d_arg_stack.pop());
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                            break block23;
                        }
                    }
                    this.jj_consume_token(64);
                    this.ScopedIdentifier();
                    this.verifyAndAddThrows(m, (String)this.d_arg_stack.pop());
                }
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        this.jj_consume_token(69);
        this.popGrammarProduction();
    }

    public final void Argument() throws ParseException, SymbolException {
        this.pushGrammarProduction(12);
        boolean copy = false;
        int mode = 0;
        String name = null;
        Type type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                copy = true;
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                mode = 0;
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                mode = 2;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                mode = 1;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.Type();
        type = (Type)this.d_arg_stack.pop();
        this.Identifier();
        name = (String)this.d_arg_stack.pop();
        if (copy) {
            this.verifyCopyModifierValid(type);
        }
        Argument arg = new Argument(copy, mode, type, name);
        this.d_arg_stack.push(arg);
        this.popGrammarProduction();
    }

    public final void Type() throws ParseException, SymbolException {
        Type type;
        this.pushGrammarProduction(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                type = new Type(1);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                type = new Type(2);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                type = new Type(3);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                type = new Type(4);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                type = new Type(5);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                type = new Type(6);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                type = new Type(7);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                type = new Type(8);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                type = new Type(9);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                type = new Type(10);
                break;
            }
            case 45: {
                this.Array();
                type = (Type)this.d_arg_stack.pop();
                break;
            }
            case 56: {
                this.SymbolType();
                type = new Type((SymbolID)this.d_arg_stack.pop());
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.d_arg_stack.push(type);
        this.popGrammarProduction();
    }

    public final void Array() throws ParseException, SymbolException {
        this.pushGrammarProduction(14);
        int dim = 1;
        int order = 0;
        this.jj_consume_token(45);
        this.jj_consume_token(66);
        this.Type();
        if (((Type)this.d_arg_stack.peek()).isArray()) {
            this.generateSymbolException("Nested arrays are not supported");
        }
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        try {
                            dim = Integer.parseInt(this.token.image);
                        }
                        catch (NumberFormatException e) {
                            this.generateSymbolException("Illegal array dimension \"" + this.token.image + "\"");
                        }
                        if (dim < 1 || dim > 4) {
                            this.generateSymbolException("Illegal array dimension \"" + this.token.image + "\"");
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 64: {
                                this.jj_consume_token(64);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 71: {
                                        this.jj_consume_token(71);
                                        order = 1;
                                        break block1;
                                    }
                                    case 72: {
                                        this.jj_consume_token(72);
                                        order = 2;
                                        break block1;
                                    }
                                }
                                this.jj_la1[41] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[42] = this.jj_gen;
                        break block1;
                    }
                    case 71: 
                    case 72: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                order = 1;
                                break block1;
                            }
                            case 72: {
                                this.jj_consume_token(72);
                                order = 2;
                                break block1;
                            }
                        }
                        this.jj_la1[43] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(61);
        Type type = (Type)this.d_arg_stack.pop();
        this.d_arg_stack.push(new Type(type, dim, order));
        this.popGrammarProduction();
    }

    public final void SymbolType() throws ParseException, SymbolException {
        this.ScopedIdentifier();
        String identifier = (String)this.d_arg_stack.pop();
        Symbol symbol = this.tryResolveSymbol(identifier);
        if (symbol != null) {
            if (symbol.getSymbolType() == 14) {
                this.generateSymbolException("Cannot use package \"" + symbol.getSymbolID().getSymbolName() + "\" as a SIDL type");
            }
            this.d_arg_stack.push(symbol.getSymbolID());
        } else {
            String fqn = this.getScope(identifier);
            this.addForwardReference(fqn);
            this.d_arg_stack.push(new SymbolID(fqn, this.lookupVersion(fqn)));
        }
    }

    public final void ScopedIdentifier() throws ParseException, SymbolException {
        this.pushGrammarProduction(15);
        StringBuffer buffer = new StringBuffer();
        this.Identifier();
        buffer.append((String)this.d_arg_stack.pop());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(70);
            this.Identifier();
            buffer.append(SCOPE);
            buffer.append((String)this.d_arg_stack.pop());
        }
        this.d_arg_stack.push(buffer.toString());
        this.popGrammarProduction();
    }

    public final void Identifier() throws ParseException, SymbolException {
        this.jj_consume_token(56);
        this.verifyReservedWords(this.token.image);
        this.d_arg_stack.push(this.token.image);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public Parser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public Parser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public Parser(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 47) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            java.util.Enumeration enm = this.jj_expentries.elements();
            while (enm.hasMoreElements()) {
                int[] oldentry = (int[])enm.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[74];
        int i = 0;
        while (i < 74) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 47) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((this.jj_la1_1[i2] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((this.jj_la1_2[i2] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 74) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, ParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SCOPE = SCOPE;
        EOL = EOL;
        MAX_ARRAY_DIM = 4;
        SIDL_CLASS = BabelConfiguration.getBaseClass();
        SIDL_INTERFACE = BabelConfiguration.getBaseInterface();
        SIDL_THROWS = BabelConfiguration.getBaseException();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

