/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.ResourceLoader;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDManager
implements EntityResolver {
    public static final String SYMBOL_PUBLIC_ID = "-//CCA//SIDL Symbol DTD v1.1//EN";
    public static final String HTML_PUBLIC_ID = "-//CCA//SIDL HTML DTD v1.0//EN";
    public static final String COMMENT_PUBLIC_ID = "-//CCA//SIDL Comment DTD v1.0//EN";
    public static final String COMMENT_FILE = "comment.dtd";
    private static final String s_resource_id = "gov/llnl/babel/dtds/";
    private static DTDManager s_instance;
    ResourceLoader rl = new ResourceLoader();

    public static DTDManager getInstance() {
        if (s_instance == null) {
            s_instance = new DTDManager();
        }
        return s_instance;
    }

    public static void setInstance(DTDManager instance) {
        s_instance = instance;
    }

    public InputSource resolveEntity(String public_id, String system_id) throws IOException {
        InputSource is = null;
        String jarEntry = null;
        String simpleName = null;
        if (SYMBOL_PUBLIC_ID.equals(public_id)) {
            simpleName = "SIDL.dtd";
            jarEntry = s_resource_id + simpleName;
        } else if (HTML_PUBLIC_ID.equals(public_id)) {
            simpleName = "html-lite.dtd";
            jarEntry = s_resource_id + simpleName;
        } else if (COMMENT_PUBLIC_ID.equals(public_id)) {
            simpleName = COMMENT_FILE;
            jarEntry = s_resource_id + simpleName;
        }
        if (jarEntry != null) {
            is = new InputSource(this.rl.getResourceStream(jarEntry));
        }
        return is;
    }

    static {
        SYMBOL_PUBLIC_ID = SYMBOL_PUBLIC_ID;
        HTML_PUBLIC_ID = HTML_PUBLIC_ID;
        COMMENT_PUBLIC_ID = COMMENT_PUBLIC_ID;
        COMMENT_FILE = COMMENT_FILE;
        s_resource_id = s_resource_id;
        s_instance = null;
    }
}

