/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.repository;

import gov.llnl.babel.parsers.xml.ParseSymbolException;
import gov.llnl.babel.parsers.xml.ParseSymbolXML;
import gov.llnl.babel.parsers.xml.SymbolToDOM;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.InputSource;

public class FileRepository
implements Repository {
    private File d_repository;

    public FileRepository(String repository) throws RepositoryException {
        this.d_repository = new File(repository);
        if (!this.d_repository.isDirectory()) {
            throw new RepositoryException("File \"" + repository + "\" is not a repository directory");
        }
    }

    public Symbol lookupSymbol(SymbolID id) {
        Symbol symbol = null;
        Set matching = this.findMatchingSymbols(id.getFullName());
        if (matching.contains(id)) {
            Iterator i = matching.iterator();
            while (i.hasNext()) {
                SymbolID s = (SymbolID)i.next();
                if (!id.equals(s)) continue;
                symbol = this.parseSymbolXML(s);
                break;
            }
        }
        return symbol;
    }

    public Symbol lookupSymbol(String fqn) {
        Symbol symbol = null;
        Set matching = this.findMatchingSymbols(fqn);
        while (symbol == null && !matching.isEmpty()) {
            SymbolID id = this.getMostRecentVersion(matching);
            symbol = this.parseSymbolXML(id);
            if (symbol != null) continue;
            matching.remove(id);
        }
        return symbol;
    }

    public Set getAllSymbols() {
        return this.findMatchingSymbols(null);
    }

    public void writeSymbols(Set symbol_names) throws RepositoryException {
        Iterator i = symbol_names.iterator();
        while (i.hasNext()) {
            this.writeSymbol((SymbolID)i.next());
        }
    }

    private void writeSymbol(SymbolID id) throws RepositoryException {
        Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
        if (symbol == null) {
            throw new RepositoryException("Symbol \"" + id.getSymbolName() + "\" not found in symbol table");
        }
        File file = new File(this.d_repository, id.getSymbolName() + ".xml");
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new FileWriter(file));
                writer.println(SymbolToDOM.convertToString(symbol));
            }
            catch (IOException ex) {
                throw new RepositoryException(ex.getMessage());
            }
            Object var7_5 = null;
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (writer != null) {
                writer.close();
            }
            throw throwable;
        }
    }

    private Set findMatchingSymbols(String prefix) {
        HashSet<SymbolID> symbols = new HashSet<SymbolID>();
        String[] files = this.d_repository.list();
        if (files != null) {
            int f = 0;
            while (f < files.length) {
                String s = files[f];
                int dash = s.indexOf("-v");
                if (dash > 0 && s.endsWith(".xml")) {
                    String name = s.substring(0, dash);
                    String vers = s.substring(dash + 2, s.length() - 4);
                    if (prefix == null || prefix.equals(name)) {
                        try {
                            symbols.add(new SymbolID(name, new Version(vers)));
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                ++f;
            }
        }
        return symbols;
    }

    private SymbolID getMostRecentVersion(Set symbols) {
        SymbolID s = null;
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SymbolID t = (SymbolID)i.next();
            if (s != null && !t.getVersion().isGreaterThan(s.getVersion())) continue;
            s = t;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Symbol parseSymbolXML(SymbolID id) {
        Symbol symbol = null;
        FileReader reader = null;
        File file = new File(this.d_repository, id.getSymbolName() + ".xml");
        reader = new FileReader(file);
        try {
            symbol = ParseSymbolXML.convert(new InputSource(reader));
        }
        catch (ParseSymbolException ex) {
        }
        Object var7_7 = null;
        if (reader == null) return symbol;
        try {
            reader.close();
            return symbol;
        }
        catch (IOException ex2) {}
        return symbol;
        {
            catch (IOException ex) {
                Object var7_8 = null;
                if (reader == null) return symbol;
                try {
                    reader.close();
                    return symbol;
                }
                catch (IOException ex2) {}
                return symbol;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

