//
// File:        LevelComparator.java
// Package:     gov.llnl.babel.backend
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.2 $
// Date:        $Date: 2002/08/20 16:55:30 $
// Description: Compare SymbolID's based on distance from BaseException
// 
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Comparator;

public class LevelComparator implements Comparator {

  private SymbolTable d_table;
  private Class       d_baseException;

  public LevelComparator(SymbolTable table) {
    d_table = table;
    d_baseException = (Class)
      d_table.lookupSymbol(BabelConfiguration.getBaseException());
  }

  private final int getClassLevel(Class ex) {
    int result = 0;
    while (ex != null && (ex != d_baseException)) {
      ++result;
      ex = ex.getParentClass();
    }
    return result;
  }

  /**
   * Compare two <code>SymbolID</code>s to see which type is more refined.
   * An object is considered lesser if there are more types in the type
   * hierarchy between it and the base exception type than the
   * object is is being compared with.
   *
   * @param o1  this should be a <code>SymbolID</code> object.
   * @param o2  this should be a <code>SymbolID</code> object.
   * @return -1 if <code>o1</code> has more types in the type hierarchy
   *         between it and the base exception type than <code>o2</code>.
   *         1  if <code>o1</code> has fewer types in the type hierarchy
   *         between it and the base exception type than <code>o2</code>.
   *         Otherwise, 0 is returned.
   */
  public final int compare(Object o1, Object o2) {
    if ((o1 instanceof SymbolID) && (o2 instanceof SymbolID)) {
      Symbol sym1 = d_table.lookupSymbol((SymbolID)o1);
      Symbol sym2 = d_table.lookupSymbol((SymbolID)o2);
      if ((sym1 instanceof gov.llnl.babel.symbols.Class) &&
          (sym2 instanceof gov.llnl.babel.symbols.Class)) {
        int   l1 = getClassLevel((Class)sym1);
        int   l2 = getClassLevel((Class)sym2);
        return (l1 < l2) ? 1 : ((l1 > l2) ? -1 : 0);
      }
    }
    return 0;
  }

  /**
   * The following equals method does not make sense for a sort
   * comparator.  It always returns <code>false</code>.
   *
   * @param obj   ignored
   * @return <code>false</code>
   */
  public final boolean equals(Object obj) {
    return false;
  }
}
