//
// File:        DualGenerator.java
// Package:     gov.llnl.babel.backend.python
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.4 $
// Date:        $Date: 2003/03/17 23:43:26 $
// Description: Generate setup.py and babel.make for Python binding
// 
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.MakefileGenerator;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.TreeSet;
import java.util.Set;

public class DualGenerator implements BuildGenerator, FileListener {
  private SetupGenerator    m_setup    = new SetupGenerator();
  private MakefileGenerator m_makefile = new MakefileGenerator();

  /**
   * Generate babel.make and setup.py for all the symbols.
   *
   * @exception java.io.IOException this is a exception that contains
   * all the I/O exceptions that occurred during file generation.
   */
  public void createAll()
    throws IOException
  {
    m_setup.createAll();
    m_makefile.createAll();
  }

  /**
   * This method is called by the {@link gov.llnl.babel.backend.FileManager}
   * for each new file it creates.  Delegate this method to 
   * {@link gov.llnl.babel.backend.MakefileGenerator} and
   * {@link gov.llnl.babel.backend.python.SetupGenerator}.
   * 
   *
   * @param id     the file is related to this symbol ID.
   * @param type   the symbol ID is this type (one of the constants from
   *               {@link gov.llnl.babel.symbols.Type}.
   * @param role   this describes the role the file plays. For example,
   *               the file could be a <code>STUBSRCS</code> file or a
   *               <code>IMPLSRCS</code> file. The role strings used
   *               are determined by the backend.
   * @param dir    the path (relative or absolute) of the directory where
   *               the file will be created.
   * @param name   the name of the file not including any directory
   *               information. The complete name of the file should
   *               be <code>dir + name</code>.
   */
  public void newFile(SymbolID id,
                      int      type,
                      String   role,
                      String   dir,
                      String   name)
  {
    m_makefile.newFile(id, type, role, dir, name);
    m_setup.newFile(id, type, role, dir, name);
  }

  public Set getLanguages()
  {
    return m_setup.getLanguages();
  }
}
