/* Generated By:JavaCC: Do not edit this line. Parser.java */
// Copyright (c) 2000-2002, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.parsers.sidl.Grammar;
import gov.llnl.babel.parsers.sidl.GrammarException;
import gov.llnl.babel.parsers.sidl.ParseException;
import gov.llnl.babel.parsers.sidl.ParserConstants;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.parsers.sidl.SymbolException;
import gov.llnl.babel.parsers.sidl.Token;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/**
 * The <code>Parser</code> class is automatically generated by the
 * <code>JavaCC</code> compiler.  The primary public method in the
 * parser is <code>beginParse</code>, which parses the SIDL code in
 * the input stream set in the parser constructor.  The other public
 * methods are <code>setSourceURL</code>, which sets the name associated
 * with the input stream, and <code>setMetadata</code>, which stores
 * metadata to be associated with symbols created from this input
 * file.
 */
public class Parser implements ParserConstants {
   private Stack      d_arg_stack;
   private HashSet    d_forward_refs;
   private Stack      d_grammar;
   private ArrayList  d_imports;
   private HashMap    d_metadata;
   private HashMap    d_reserved_words;
   private ArrayList  d_scope;
   private String     d_source_url;
   private HashSet    d_unused_imports;
   private HashSet    d_unused_versions;
   private HashMap    d_versions;
   private ArrayList  d_warnings;
   private LinkedList d_parent_stack;

   private final static String SCOPE = ".";

   private final static String EOL = "\n";

   private final static int MAX_ARRAY_DIM = 4;

   private final static String SIDL_CLASS     =
        BabelConfiguration.getBaseClass();
   private final static String SIDL_INTERFACE =
        BabelConfiguration.getBaseInterface();
   private final static String SIDL_THROWS    =
        BabelConfiguration.getBaseException();

   /**
    * Set the source URL name.  If the source URL is not set, then
    * it is "file:unknown.sidl".
    */
   public void setSourceURL(String url) {
      d_source_url = url;
   }

   /**
    * Add metadata to be associated with symbols generated during the
    * parse of this input stream.  By default, the parser creates metadata
    * associated with the source file (keyword "source-url"), compiler
    * version (keyword "babel-version"), and source line number of the
    * symbol definition (keyword "source-line").
    */
   public void addMetadata(String key, String value) {
      if (d_metadata == null) {
         d_metadata = new HashMap();
      }
      d_metadata.put(key, value);
   }

   /**
    * Begin parsing and analysis of the SIDL grammar.  All of the exceptions
    * generated during the parse are subclasses of <code>SIDLException</code>.
    * The symbols generated during the parse are returned in the symbol table.
    * Any warnings generated during the parse are returned through the string
    * array return argument (or null if there were no warnings).
    */
   public String[] beginParse() throws SIDLException {
      d_arg_stack       = new Stack();
      d_forward_refs    = new HashSet();
      d_grammar         = new Stack();
      d_imports         = new ArrayList();
      d_reserved_words  = new HashMap();
      d_scope           = new ArrayList();
      d_unused_imports  = new HashSet();
      d_unused_versions = new HashSet();
      d_versions        = new HashMap();
      d_warnings        = new ArrayList();
      d_parent_stack    = new LinkedList();

      generateReservedWords();

      if (d_metadata == null) {
         d_metadata = new HashMap();
      }
      if (d_source_url == null) {
         d_source_url = "file:unknown.sidl";
      }

      String[] warnings = null;
      try {
         Specification();
         warnings = generateWarnings();
      } catch (ParseException ex) {
         generateGrammarException(ex);
      } finally {
         d_arg_stack       = null;
         d_forward_refs    = null;
         d_grammar         = null;
         d_imports         = null;
         d_metadata        = null;
         d_reserved_words  = null;
         d_scope           = null;
         d_unused_imports  = null;
         d_unused_versions = null;
         d_versions        = null;
         d_warnings        = null;
         d_parent_stack    = null;
      }

      return warnings;
   }

   /**
    * Generate a <code>GrammarException</code> from the information in
    * the <code>ParseException</code> class.
    */
   private void generateGrammarException(ParseException ex)
         throws GrammarException
   {
      Integer state = (Integer) d_grammar.peek();
      throw new GrammarException(ex, state.intValue());
   }

   /**
    * Generate a <code>SymbolException</code> from the information in
    * the message and the current parsing token.
    */
   private void generateSymbolException(String message)
         throws SymbolException
   {
      Integer state = (Integer) d_grammar.peek();
      throw new SymbolException(token, state.intValue(), message);
   }

   /**
    * Generate the list of reserved words that are not allowed as identifiers
    * in the SIDL input file.
    */
   private void generateReservedWords() {
      d_reserved_words.put("abstract",         "Java");
      d_reserved_words.put("and",              "C++ and Python");
      d_reserved_words.put("and_eq",           "C++");
      d_reserved_words.put("asm",              "C and C++");
      d_reserved_words.put("assert",           "Java and Python");
      d_reserved_words.put("auto",             "C and C++");
      d_reserved_words.put("bitand",           "C++");
      d_reserved_words.put("bitor",            "C++");
      d_reserved_words.put("bool",             "C++");
      d_reserved_words.put("boolean",          "Java");
      d_reserved_words.put("break",            "C, C++, Java, and Python");
      d_reserved_words.put("case",             "C, C++, and Java");
      d_reserved_words.put("catch",            "C++ and Java");
      d_reserved_words.put("char",             "C, C++, and Java");
      d_reserved_words.put("class",            "C++ and Java");
      d_reserved_words.put("compl",            "C++");
      d_reserved_words.put("const",            "C, C++, and Java");
      d_reserved_words.put("const_cast",       "C++");
      d_reserved_words.put("continue",         "C, C++, Java, and Python");
      d_reserved_words.put("def",              "Python");
      d_reserved_words.put("default",          "C, C++, and Java");
      d_reserved_words.put("del",              "Python");
      d_reserved_words.put("delete",           "C++");
      d_reserved_words.put("do",               "C, C++, and Java");
      d_reserved_words.put("double",           "C, C++, and Java");
      d_reserved_words.put("dynamic_cast",     "C++");
      d_reserved_words.put("elif",             "Python");
      d_reserved_words.put("else",             "C, C++, Java, and Python");
      d_reserved_words.put("enum",             "C and C++");
      d_reserved_words.put("except",           "Python");
      d_reserved_words.put("exec",             "Python");
      d_reserved_words.put("explicit",         "C++");
      d_reserved_words.put("export",           "C++");
      d_reserved_words.put("extends",          "Java");
      d_reserved_words.put("extern",           "C and C++");
      d_reserved_words.put("false",            "C++ and Java");
      d_reserved_words.put("final",            "Java");
      d_reserved_words.put("finally",          "Java and Python");
      d_reserved_words.put("float",            "C, C++, and Java");
      d_reserved_words.put("for",              "C, C++, Java, and Python");
      d_reserved_words.put("friend",           "C++");
      d_reserved_words.put("from",             "Python");
      d_reserved_words.put("global",           "Python");
      d_reserved_words.put("goto",             "C, C++, and Java");
      d_reserved_words.put("if",               "C, C++, Java, and Python");
      d_reserved_words.put("implements",       "Java");
      d_reserved_words.put("import",           "Java");
      d_reserved_words.put("inline",           "C++");
      d_reserved_words.put("instanceof",       "Java");
      d_reserved_words.put("int",              "C, C++, and Java");
      d_reserved_words.put("interface",        "Java");
      d_reserved_words.put("is",               "Python");
      d_reserved_words.put("lambda",           "Python");
      d_reserved_words.put("long",             "C, C++, and Java");
      d_reserved_words.put("mutable",          "C++");
      d_reserved_words.put("namespace",        "C++");
      d_reserved_words.put("native",           "Java");
      d_reserved_words.put("new",              "C++ and Java");
      d_reserved_words.put("not",              "C++ and Python");
      d_reserved_words.put("not_eq",           "C++");
      d_reserved_words.put("null",             "Java");
      d_reserved_words.put("operator",         "C++");
      d_reserved_words.put("or",               "C++ and Python");
      d_reserved_words.put("or_eq",            "C++");
      d_reserved_words.put("package",          "Java");
      d_reserved_words.put("pass",             "Python");
      d_reserved_words.put("print",            "Python");
      d_reserved_words.put("private",          "C++ and Java");
      d_reserved_words.put("protected",        "C++ and Java");
      d_reserved_words.put("public",           "C++ and Java");
      d_reserved_words.put("raise",            "Python");
      d_reserved_words.put("register",         "C and C++");
      d_reserved_words.put("reinterpret_cast", "C++");
      d_reserved_words.put("return",           "C, C++, Java, and Python");
      d_reserved_words.put("short",            "C, C++, and Java");
      d_reserved_words.put("signed",           "C and C++");
      d_reserved_words.put("sizeof",           "C and C++");
      d_reserved_words.put("static",           "C, C++, and Java");
      d_reserved_words.put("static_cast",      "C++");
      d_reserved_words.put("strictfp",         "Java");
      d_reserved_words.put("struct",           "C and C++");
      d_reserved_words.put("super",            "Java");
      d_reserved_words.put("switch",           "C, C++, and Java");
      d_reserved_words.put("synchronized",     "Java");
      d_reserved_words.put("template",         "C++");
      d_reserved_words.put("this",             "C++ and Java");
      d_reserved_words.put("throw",            "C++ and Java");
      d_reserved_words.put("throws",           "Java");
      d_reserved_words.put("transient",        "Java");
      d_reserved_words.put("true",             "C++ and Java");
      d_reserved_words.put("try",              "C++, Java, and Python");
      d_reserved_words.put("typedef",          "C and C++");
      d_reserved_words.put("typeid",           "C++");
      d_reserved_words.put("typename",         "C++");
      d_reserved_words.put("union",            "C and C++");
      d_reserved_words.put("unsigned",         "C and C++");
      d_reserved_words.put("using",            "C++");
      d_reserved_words.put("virtual",          "C++");
      d_reserved_words.put("void",             "C, C++, and Java");
      d_reserved_words.put("volatile",         "C, C++, and Java");
      d_reserved_words.put("wchar_t",          "C++");
      d_reserved_words.put("while",            "C, C++, Java, and Python");
      d_reserved_words.put("xor",              "C++");
      d_reserved_words.put("xor_eq",           "C++");
   }

   /**
    * Verify that the specified identifier is not on the list of reserved
    * words.  If it is, then generate a symbol exception.
    */
   private void verifyReservedWords(String id) throws SymbolException {
      String lang = (String) d_reserved_words.get(id);
      if (lang != null) {
         generateSymbolException(
            "Illegal identifier \""+id+"\" is a reserved word in "+lang);
      }
   }

   /**
    * Generate a warning message if a method name (short or extended)
    * exceeds thirty one characters in length.
    */
   private void checkMethodNameLength(String shortname, String extension,
                                      Token tok)
   {
     final int extLen = ((extension != null) ? extension.length() : 0);
     if ((shortname.length() + ((extension != null) ? extension.length() : 0))
         > 31) {
       generateWarning("Method \"" + shortname +
                       ((extension != null) ? ("[" + extension + "]")
                                            : "") +
                       "\" at line(s) " + tok.beginLine + ":" +
                       tok.endLine + " is longer than 31 characters. This will require name mangling in FORTRAN 90/95 and potentially C.");

     }
   }

   /**
    * Set the metadata associated with this new symbol.
    */
   private void setMetadataValues(Symbol sym) {
      sym.addMetadata("babel-version", gov.llnl.babel.Version.VERSION);
      sym.addMetadata("source-url",    d_source_url);
      sym.addMetadata("source-line",   String.valueOf(token.beginLine));

      for (Iterator i = d_metadata.entrySet().iterator(); i.hasNext(); ) {
         Map.Entry e = (Map.Entry) i.next();
         sym.addMetadata((String) e.getKey(), (String) e.getValue());
      }
   }

   /**
    * Add the specified warning string to the array of parser warnings.
    */
   private void generateWarning(String warning) {
      d_warnings.add(warning);
   }

   /**
    * Return a string array of the warnings generated during the parse.
    */
   private String[] generateWarnings() {
      String[] warnings = null;

      int n = d_warnings.size();
      if (n > 0) {
         warnings = new String[n];
         for (int i = 0; i < n; i++) {
            warnings[i] = (String) d_warnings.get(i);
         }
      }

      return warnings;
   }

   /**
    * Push the specified grammar production on top of the current production
    * stack.  The stack must be popped when the parser leaves the production.
    */
   private void pushGrammarProduction(int production) {
      d_grammar.push(new Integer(production));
   }

   /**
    * Pop the grammar production.  This method must be called when leaving
    * a grammar production scope to match the appropriate push call.
    */
   private void popGrammarProduction() {
      d_grammar.pop();
   }

   /**
    * Enter the specified naming scope, which will be used to resolve
    * symbol names.
    */
   private void enterScope(String scope) {
      d_scope.add(scope);
   }

  /**
   * If the argument is a Package, return it; otherwise, throw a
   * SymbolRedefinitionException because there is a package with the same name
   * as something else.
   */
  private static Package toPackage(Symbol   sym,
                                   SymbolID newID)
    throws SymbolRedefinitionException
  {
    Package p = null;
    if (sym != null) {
      if (sym instanceof Package) {
        p = (Package)sym;
      }
      else {
        throw new SymbolRedefinitionException(newID, sym.getSymbolID());
      }
    }
    return p;
  }

   /**
    * Leave the outer-most naming scope by removing the top of the scope
    * stack.
    */
   private void leaveScope() {
      d_scope.remove(d_scope.size()-1);
   }

   /**
    * Return the current scope as a string.  If no scope has been defined,
    * then return an empty string.
    */
   private String getScope() {
      int s = d_scope.size();
      return (s == 0 ? "" : (String) d_scope.get(s-1));
   }

   /**
    * Return the argument symbol name prepended with the current scope.
    */
   private String getScope(String name) {
      int s = d_scope.size();
      return (s == 0 ? name : ((String) d_scope.get(s-1)) + SCOPE + name);
   }

   /**
    * Generate a comment object for a documentation comment.  If a special
    * token is present in the input stream, then read special tokens until
    * a "start of comment" special token is found.
    */
   private Comment generateComment(Token t) {
      String[] comment_lines = null;

      Token special = t.specialToken;
      if (special != null) {

         /*
          * Count the number of comment lines by iterating through tokens.
          */
         int lines = 0;
         while (special.kind != ParserConstants.T_COMMENT) {
            lines++;
            special = special.specialToken;
         }

         /*
          * Allocate the string array and read comments in reverse order.
          */
         if (lines > 0) {
            comment_lines = new String[lines];
            special = t.specialToken;
            while (special.kind != ParserConstants.T_COMMENT) {
               comment_lines[--lines] = special.image;
               special = special.specialToken;
            }
         }
      }

      return new Comment(comment_lines);
   }

   /**
    * Add a fully qualified symbol name to the list of forward references.
    */
   private void addForwardReference(String fqn) {
      d_forward_refs.add(fqn);
   }

   /**
    * Remove a fully qualified symbol name from the list of forward
    * references.
    */
   private void removeForwardReference(String fqn) {
      d_forward_refs.remove(fqn);
   }

   /**
    * Verify that there are no remaining forward references and that all
    * have been defined.  If any forward references remain, then throw a
    * <code>SymbolException</code>.
    */
   private void verifyForwardReferences() throws SymbolException {
      for (Iterator i = d_forward_refs.iterator(); i.hasNext(); ) {
         generateSymbolException("Symbol name \""
            + (String) i.next()
            + "\" not found or defined within package");
      }
   }

   /**
    * Verify that the specified fully qualified symbol name is not a
    * forward reference.  Package names and enumerated types are not
    * allowed as a forward references.  If the specified symbol is a
    * forward reference, then throw a <code>SymbolException</code>.
    */
   private void verifyNotForwardReference(String fqn) throws SymbolException {
      if (d_forward_refs.contains(fqn)) {
         generateSymbolException("Forward reference \""
            + fqn
            + "\" cannot be used as a package or enumerated type");
      }
   }

   /**
    * Lookup the version for the specified fully qualified name.  If no
    * version exists, then return a null.
    */
   private Version lookupVersion(String fqn) {
     SymbolTable table = SymbolTable.getInstance();
     Version version = null;
     while ((fqn != null) && (version == null)) {
       version = (Version)d_versions.get(fqn);
       if (version == null) {
         Symbol sym = table.lookupSymbol(fqn);
         if (sym != null) {
           version = sym.getSymbolID().getVersion();
         }
         else {
           fqn = SymbolUtilities.getParentPackage(fqn);
         }
       }
       else {
         d_unused_versions.remove(fqn);
       }
     }
     return version;
   }

   /**
    * Generate a symbol exception if a version default has already been
    * specified for the package.
    */
   private void verifyVersionNotDefined(String name) throws SymbolException {
      if (d_versions.keySet().contains(name)) {
         generateSymbolException(
            "Redefinition of version for package \"" + name + "\"");
      }
   }

   /**
    * Add a new (package name, version) entry into the version hash table.
    * Also add a copy to the unused version hash set.
    */
   private void addPackageVersion(String name, Version version) {
      d_versions.put(name, version);
      d_unused_versions.add(name);
   }

   /**
    * Generate version warnings for every version entry not used to resolve
    * a symbol during the parse.
    */
   private void generateVersionWarnings() {
      for (Iterator i = d_unused_versions.iterator(); i.hasNext(); ) {
         String name = (String) i.next();
         generateWarning("Package \""
            + name
            + "-v"
            + ((Version)d_versions.get(name)).getVersionString()
            + "\" was not used to resolve any symbols");
      }
   }

   /**
    * Generate a symbol exception if a particular package has already been
    * included in an import statement.
    */
   private void verifyImportNotDefined(String fqn) throws SymbolException {
      if (d_imports.contains(fqn)) {
         generateSymbolException(
            "Redefinition of import for package \"" + fqn + "\"");
      }
   }

   /**
    * Add a new package at the end of the package search list.  Also add a
    * copy to the unused import hash set.  Package import statements not used
    * to resolve a symbol will generate warnings at the end of the parse.
    */
   private void addToImportPath(String fqn) {
      d_imports.add(fqn);
      d_unused_imports.add(fqn);
   }

   /**
    * Mark the specified import as being used to resolve a symbol.  Unused
    * import packages will generate warnings at the end of the parse.
    */
   private void usedImportToResolveSymbol(String fqn) {
      d_unused_imports.remove(fqn);
   }

   /**
    * Generate import warnings for every import package not used to resolve
    * a symbol during the parse.
    */
   private void generateImportWarnings() {
      for (Iterator i = d_unused_imports.iterator(); i.hasNext(); ) {
         generateWarning("Import statement for package \""
            + (String) i.next()
            + "\" not used to resolve any symbols");
      }
   }

   /**
    * Try to resolve a symbol in the symbol table by fully qualified name.
    * If the symbol cannot be found, then return null; otherwise, return
    * the symbol.  If the symbol is a duplicate of an existing symbol in
    * the table with a different version, then return a symbol exception.
    * When we load this symbol into the symbol table, then load all of its
    * dependencies.
    */
   private Symbol tryResolveFQN(String fqn) throws SymbolException {
      Symbol sym = null;

      Version version = lookupVersion(fqn);
      if (version == null) {
         sym = SymbolTable.getInstance().resolveSymbol(fqn);
      } else {
         try {
            SymbolID id = new SymbolID(fqn, version);
            sym = SymbolTable.getInstance().resolveSymbol(id);
         } catch (SymbolRedefinitionException ex) {
            generateSymbolException(ex.getMessage());
         }
      }

      if (sym != null) {
         try {
            Set refs = sym.getSymbolReferences();
            SymbolTable.getInstance().generateDependencies(refs);
         } catch (SymbolRedefinitionException ex) {
            generateSymbolException(ex.getMessage());
         } catch (SymbolNotFoundException ex) {
            // ignore - forward references not resolved yet...
         }
      }

      return sym;
   }

   /**
    * Resolve a symbol in the symbol table by fully qualified name.  If the
    * symbol does not exist or is a duplicate of another symbol with another
    * version, then throw a <code>SymbolException</code>.
    */
   private Symbol resolveFQN(String fqn) throws SymbolException {
      Symbol sym = tryResolveFQN(fqn);
      if (sym == null) {
         Version v = lookupVersion(fqn);
         String  s = (v == null ? fqn : fqn + "-v" + v.getVersionString());
         generateSymbolException("Symbol \"" + s + "\" not found");
      }
      return(sym);
   }
   /**
    * Try to resolve a symbol in the symbol table by searching through
    * the scopes and default import paths.  If ths symbol is not found,
    * then return null.  If a symbol exists in the symbol table with the
    * same name but different version, then throw a symbol exception.
    */
   private Symbol tryResolveSymbol(String name) throws SymbolException {
      Symbol sym = tryResolveFQN(name);

      for (int s = d_scope.size()-1; (s >= 0) && (sym == null); s--) {
         sym = tryResolveFQN(((String) d_scope.get(s)) + SCOPE + name);
      }

      int n = d_imports.size();
      for (int s = 0; (s < n) && (sym == null); s++) {
         String prefix = (String) d_imports.get(s);
         sym = tryResolveFQN(prefix + SCOPE + name);
         if (sym != null) {
            usedImportToResolveSymbol(prefix);
         }
      }

      return sym;
   }

   /**
    * Resolve a symbol in the symbol table by searching through the scopes
    * and default import paths.  If the symbol is not found, then throw a
    * <code>SymbolException</code>.  Otherwise, return the symbol object.
    */
   private Symbol resolveSymbol(String name) throws SymbolException {
      Symbol sym = tryResolveSymbol(name);
      if (sym == null) {
         generateSymbolException("Symbol \"" + name + "\" not found");
      }
      return sym;
   }

   /**
    * Verify that the specified symbol exists and is a package.  If not,
    * then throw a <code>SymbolException</code>.
    */
   private void verifyImportIsPackage(String fqn) throws SymbolException {
      Symbol sym = resolveFQN(fqn);
      if (sym.getSymbolType() != Symbol.PACKAGE) {
         generateSymbolException("Symbol \""
            + sym.getSymbolID().getSymbolName()
            + "\" is not a package");
      }
   }

   /**
    * Verify that the specified fully qualified symbol has a version
    * associated with it and has not been already defined.  These checks
    * are required before defining any new symbol.  If the version for
    * this symbol has not been defined or if the symbol has already been
    * defined, a <code>SymbolException</code> is thrown.
    */
   private void verifySymbolCanBeDefined(SymbolID id) throws SymbolException {
      Version version = id.getVersion();
      if ((version == null) || version.isUnspecified()) {
         generateSymbolException(
            "No version specified for the definition of symbol \""+
            id.getSymbolName() + "\".\nClasses & interfaces cannot be defined in an unversioned package.");
      }

      try {
        Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
        if (sym != null) {
          generateSymbolException("Redefinition of symbol \""
              + sym.getSymbolID().getSymbolName()
              + "\"");
        }
      }
      catch (SymbolRedefinitionException sre) {
        generateSymbolException(sre.getMessage());
      }
   }

   /**
    * Add a symbol to its parent package.  This will involve creating the
    * parent package, looking up its name, and then adding the child to the
    * package.  If the symbol is a root-level package (that is, does not
    * contain a SCOPE "."), then do nothing.  Throw an exception if the
    * package is marked as read-only (e.g., was brought in from a repository
    * and may not be changed).  Mark the parent package as modified.
    */
   private void addSymbolToParentPackage(Package parent, SymbolID id, int type)
         throws SymbolException
   {
      if (parent != null) {
         if (parent.getSymbolType() != Symbol.PACKAGE) {
            generateSymbolException("Symbol \""
               + parent.getSymbolID().getSymbolName()
               + "\" is not a package");
         }
         if (parent.getFinal()) {
            generateSymbolException("Cannot modify final package \""
               + parent.getSymbolID().getSymbolName()
               + "\"");
         }
         parent.addSymbol(id, type);
         SymbolTable.getInstance().markSymbolAsModified(parent.getSymbolID());
      }
   }

   /*
    * Verify that the copy modifier is set properly for an argument.  The
    * copy modifier is only valid for a symbol type that is an interface or
    * a class.  If the symbol is a forward reference, then we know that it
    * must be an interface or a class.  We know that if the type is a symbol,
    * then it must be in the symbol table or exist as a forward reference.
    */
   private void verifyCopyModifierValid(Type type) throws SymbolException {
      if (type.getType() != Type.SYMBOL) {
         generateSymbolException(
            "Modifier \"copy\" is only valid for interfaces and classes");
      } else {
         SymbolID id = type.getSymbolID();
         Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
         if ((symbol != null) && (symbol.getSymbolType() == Symbol.ENUM)) {
            generateSymbolException(
               "Modifier \"copy\" is not allowed for enumerated types");
         }
      }
   }

   /**
    * Verify that the oneway modifier is valid for this method.  The oneway
    * modifier may not be used on any method that has an inout or out argument
    * or returns a value.  If any of these conditions are violated, then an
    * exception is thrown.
    */
   private void verifyOnewayValid(Method m) throws SymbolException {
      if (m.getReturnType() != null) {
         generateSymbolException(
            "Modifier \"oneway\" invalid for methods that return values");
      }
      ArrayList args = m.getArgumentList();
      for (int i = 0; i < args.size(); i++) {
         Argument arg = (Argument) args.get(i);
         if (arg.getMode() != Argument.IN) {
            generateSymbolException(
               "Modifier \"oneway\" invalid for methods " +
               "with inout and out arguments");
         }
      }
   }

   /**
    * Verify that the specified scoped identifer is valid in a throws
    * clause and that it does not already exist in the throws list.
    * If the identifier is valid, then add it to the throws supported
    * by the method.  A throws clause is invalid with a oneway modifier.
    * Any classes in the throws clause must extend the base SIDL throwable
    * class (unless, of course, it is the base SIDL throwable class).
    */
   private void verifyAndAddThrows(Method m, String identifier)
         throws SymbolException
   {
      if (m.getCommunicationModifier() == Method.ONEWAY) {
         generateSymbolException(
            "Modifier \"oneway\" invalid for methods with a throws clause");
      }

      Symbol symbol = resolveSymbol(identifier);
      if (m.getThrows().contains(symbol.getSymbolID())) {
         generateSymbolException("Class \""
            + symbol.getFullName()
            + "\" already listed in throws clause");
      }

      if (symbol.getSymbolType() != Symbol.CLASS) {
         generateSymbolException("Symbol \""
            + symbol.getFullName()
            + "\" must be a class to be in a throws clause");
      }

      if (!SIDL_THROWS.equals(symbol.getFullName())) {
         Class symbolcls = (Class) symbol;
         Class throwable = (Class) resolveFQN(SIDL_THROWS);
         if (!symbolcls.hasParentClass(throwable.getSymbolID(), true)) {
            generateSymbolException("Class \""
               + symbol.getFullName()
               + "\" does not extend \""
               + SIDL_THROWS
               + "\"");
         }
      }

      m.addThrows(symbol.getSymbolID());
   }

   /**
    * Verify that the method does not already exist in the specified
    * extendable object (interface or class) with the same long name
    * or the same short name and base signature.  If one does exist, a 
    * method redefinition exception.
    */
   private void verifyMethodRedefinition(Extendable ext, Method m)
         throws SymbolException
   {
      /*
       * First check local method based on the long name since methods 
       * must be uniquely identified by their long names (due to languages
       * that do not support method overloading).
       */
      Method method = ext.lookupMethodByLongName(m.getLongMethodName(), false);
      if (method != null) {
         if (method.sameSignature(m)) {
            generateSymbolException("Method \""
               + m.getSignature()
               + "\" has already been defined locally in \""
               + ext.getFullName()
               + "\" with same signature");
         } else {
            generateSymbolException("Method \""
               + m.getSignature()
               + "\" conflicts with existing method \""
               + method.getSignature()
               + "\" already defined locally in \""
               + ext.getFullName()
               + "\"");
         }
      }

      /*
       * Now check to ensure no existing local methods with the same
       * short name and same base signature.
       */
      Collection methods = ext.lookupMethodByShortName(m.getShortMethodName(),
                                                       false);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            method = (Method) i.next();
            if (method.sameBaseSignature(m)) {
               generateSymbolException("Method \""
                  + m.getSignature()
                  + "\" has already been defined locally in \""
                  + ext.getFullName()
                  + "\" with the same short name and argument list");
            }
         }
      }
   }

   /**
    * Verify that the new method may be added to the specified class.
    * Check that the method name is not the same as the class name and
    * that it does not conflict with the signature of any existing method.
    */
   private void verifyMethodSignature(Extendable ext, Method m, String definer)
         throws SymbolException
   {
      /*
       * Verify that the symbol name is not the same as the method
       * name (which would be a problem for C++ and Java since it
       * would be interpreted as a constructor).  We're going to 
       * disallow the same short _and_ long name at this time although,
       * technically, the above languages would only be concerned with
       * the short name.
       */
      if (ext.getSymbolID().getShortName().equals(m.getLongMethodName())) {
         generateSymbolException("Method \""
            + m.getSignature()
            + "\" from \""
            + definer
            + "\" cannot have same (long) name as \""
            + ext.getFullName()
            + "\"");
      }
      if (ext.getSymbolID().getShortName().equals(m.getShortMethodName())) {
         generateSymbolException("Method \""
            + m.getSignature()
            + "\" from \""
            + definer
            + "\" cannot have same (short) name as \""
            + ext.getFullName()
            + "\"");
      }

      /*
       * Check whether there is a signature conflict with any existing
       * methods in the parent class.
       */
      Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
      if ((existing != null) && (!m.sameSignature(existing))) {
         generateSymbolException("Signature conflict between method \""
            + m.getSignature()
            + "\" from \""
            + definer
            + "\" and existing ancestor method \""
            + existing.getSignature()
            + "\"");
      }
   }

   /**
    * Verify that there is not a conflict due to static methods.  Neither
    * the new method nor any matching existing methods may be static, since
    * static methods cannot be re-defined.
    */
   private void verifyMethodStatic(Extendable ext, Method m, String definer)
         throws SymbolException
   {
      /*
       * First check to ensure no issues with static methods for 
       * existing/parent methods with the same long name.
       */
      Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
      if (existing != null) {
         if (m.isStatic()) {
            generateSymbolException("Static method \""
               + m.getSignature()
               + "\" from \""
               + definer
               + "\" cannot redefine existing ancestor method with same long "
               + "name");
         }
         if (existing.isStatic()) {
            generateSymbolException("Method \""
               + m.getSignature()
               + "\" from \""
               + definer
               + "\" cannot redefine existing static ancestor method with same "
               + "long name");
         }
      }

      /*
       * Now check to ensure no issues with static methods for existing/parent 
       * methods with the same short name and same base signature.
       */
      Collection methods = ext.lookupMethodByShortName(m.getShortMethodName(),
                                                       true);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            existing = (Method) i.next();
            if (existing.sameBaseSignature(m)) {
               if (m.isStatic()) {
                  generateSymbolException("Static method \""
                     + m.getSignature()
                     + "\" from \""
                     + definer
                     + "\" cannot redefine existing ancestor method with same "
                     + "short name and argument list");
               }
               if (existing.isStatic()) {
                  generateSymbolException("Method \""
                     + m.getSignature()
                     + "\" from \""
                     + definer
                     + "\" cannot redefine existing static ancestor method with"
                     + " the same short name and argument list");
               }
            }
         }
      }
   }

   /**
    * Verify that the method may be added to the specified class.  There
    * is a conflict if a matching method currently exists and (a) the
    * existing method is final or (b) the new method is abstract but the
    * existing method is not abstract.
    */
   private void verifyMethodOverride(Class cls, Method m)
         throws SymbolException
   {
      /*
       * First check to make sure no conflicts with existing/parent method 
       * with same long name.
       */
      Method existing = cls.lookupMethodByLongName(m.getLongMethodName(), true);
      if (existing != null) {
         /*
          * If the existing method is final, then we cannot redefine it.
          */
         if (existing.isFinal()) {
            generateSymbolException("Method \""
               + m.getSignature()
               + "\" cannot redefine existing final ancestor method \""
               + existing.getSignature()
               + "\" already defined in \""
               + cls.getFullName()
               + "\" with the same long method name");
         }

         /*
          * If the existing method is not abstract, then the new method
          * cannot be abstract.
          */
         if (!existing.isAbstract() && m.isAbstract()) {
            generateSymbolException("Abstract method \""
               + m.getSignature()
               + "\" cannot redefine existing non-abstract ancestor method \""
               + existing.getSignature()
               + "\" already defined in \""
               + cls.getFullName()
               + "\"");
         }
      }

      /*
       * Now check to make sure no conflicts with existing/parent method 
       * with same short name and same base signature.
       */
      Collection methods = cls.lookupMethodByShortName(m.getShortMethodName(),
                                                       true);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            existing = (Method) i.next();
            if (existing.sameBaseSignature(m)) {
               /*
                * If the existing method is final, then we cannot redefine it.
                */
               if (existing.isFinal()) {
                  generateSymbolException("Method \""
                     + m.getSignature()
                     + "\" cannot redefine existing final ancestor method \""
                     + existing.getSignature()
                     + "\" already defined in \""
                     + cls.getFullName()
                     + "\" with the same short name and arguments");
               }

               /*
                * If the existing method is not abstract, then the new method
                * cannot be abstract.
                */
               if (!existing.isAbstract() && m.isAbstract()) {
                  generateSymbolException("Abstract method \""
                     + m.getSignature()
                     + "\" cannot redefine existing non-abstract ancestor "
                     + "method \""
                     + existing.getSignature()
                     + "\" already defined in \""
                     + cls.getFullName()
                     + "\"");
               }
            }
         }
      }
   }

   /**
    * Verify that the methods in the extending test class are compatible
    * with those in the existing class.  Since the existing class should
    * have no methods in it, we only need to do the basic signature test.
    */
   private void verifyClassInheritance(Class cls, Class test)
         throws SymbolException
   {
      /*
       * Verify that the two classes are different (OK to check that
       * the two object references point to the same object)
       */
      if (cls == test) {
         generateSymbolException("Class \""
            + cls.getFullName()
            + "\" cannot extend itself");
      }

      /*
       * Verify that each of the methods in the extending class do not have
       * the same name as the exiting interface.  Note that there should be
       * no methods in the class since class extension is done as the first
       * item in the construction of a class.
       */
      String test_name = test.getFullName();
      Iterator methods = test.getMethods(true).iterator();
      while (methods.hasNext()) {
         verifyMethodSignature(cls, (Method) methods.next(), test_name);
      }
   }

   /**
    * Verify that the methods in the new interface are compatible with
    * those in the existing extendable (class or interface).  If there
    * are any conflicts, then throw a symbol exception.  An interface
    * cannot inherit from itself.
    */
   private void verifyInterfaceInheritance(Extendable old, Interface test)
         throws SymbolException
   {
      /*
       * Verify that the two interfaces are different (OK to check that
       * the two objects are the same)
       */
      if (old == ((Extendable) test)) {
         generateSymbolException("Interface \""
            + old.getFullName()
            + "\" cannot inherit from itself");
      }

      /*
       * Verify that each of the methods in the new interface (1) does not
       * have the same name as the existing interface, (2) does not conflict
       * with existing methods in signature, and (3) does not conflict with
       * an existing static method.
       */
      Iterator methods = test.getMethods(true).iterator();
      while (methods.hasNext()) {
         Method method = (Method) methods.next();
         String name = test.getFullName();
         verifyMethodSignature(old, method, name);
         verifyMethodStatic(old, method, name);
      }
   }

   /**
    * Verify that the abstract qualifier on the class matches whether the
    * class has any abstract methods.
    */
   private void verifyAbstract(Class cls, boolean ab) throws SymbolException {
      if (ab && !cls.isAbstract()) {
         generateSymbolException("Class \""
            + cls.getFullName()
            + "\" declared abstract but contains no abstract methods");
      }
      if (!ab && cls.isAbstract()) {
         StringBuffer msg = new StringBuffer();
         msg.append("Class \"");
         msg.append(cls.getFullName());
         msg.append("\" not declared abstract but has abstract method(s):");
         msg.append(EOL);
         Iterator m = cls.getAbstractMethods().iterator();
         while (m.hasNext()) {
            Method method = (Method) m.next();
            msg.append("   ");
            msg.append(method.getSignature());
            msg.append(EOL);
         }
         generateSymbolException(msg.toString());
      }
   }

/**
 * A SIDL Specification contains zero or more require productions followed
 * by zero or more import productions followed by zero or more package
 * productions followed by the end-of-file.  Before leaving the specification
 * scope, resolve all references in the symbol table.
 */
  final public void Specification() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.SPECIFICATION);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_REQUIRE:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Require();
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IMPORT:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      Import();
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_FINAL:
      case T_PACKAGE:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      Package();
    }
    jj_consume_token(0);
      try {
         SymbolTable.getInstance().resolveAllReferences();
      } catch (SymbolNotFoundException ex) {
         generateSymbolException(ex.getMessage());
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(ex.getMessage());
      }
      verifyForwardReferences();
      generateVersionWarnings();
      generateImportWarnings();
      popGrammarProduction();
  }

/**
 * A SIDL Require production begins with a "require" token and is followed
 * by a scoped identifer, a "version" token, and a version number.  The 
 * scoped identifier must be not defined.  The version number is specified 
 * in the general form "V1.V2...Vn" where Vi is a non-negative integer.  
 */
  final public void Require() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.REQUIRE);
    jj_consume_token(T_REQUIRE);
    ScopedIdentifier();
      String name = (String) d_arg_stack.pop();
      verifyVersionNotDefined(name);
    jj_consume_token(T_VERSION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_INTEGER:
      jj_consume_token(T_INTEGER);
      break;
    case T_VERSION_STRING:
      jj_consume_token(T_VERSION_STRING);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      try {
         Version version = new Version(token.image);
         addPackageVersion(name, version);
      } catch (NumberFormatException ex) {
         generateSymbolException(ex.getMessage());
      }
    jj_consume_token(T_SEMICOLON);
      popGrammarProduction();
  }

/**
 * A SIDL Import production begins with an "import" token and is followed
 * by a scoped identifier which is optionally followed by a "version" token
 * and a version number.  The scoped identifier must be defined and it must 
 * be a package.  The version number is specified in the general form 
 * "V1.V2...Vn" where Vi is a non-negative integer.  A particular package 
 * may only be included in one import statement.  The import package name 
 * is added to the default search path.  At the end of the parse, any import 
 * statements that were not used to resolve a symbol name are output as 
 * warnings.
 */
  final public void Import() throws ParseException, SymbolException {
   Version version = null;
   pushGrammarProduction(Grammar.IMPORT);
    jj_consume_token(T_IMPORT);
    ScopedIdentifier();
      String fqn = (String) d_arg_stack.pop();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VERSION:
      jj_consume_token(T_VERSION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_INTEGER:
        jj_consume_token(T_INTEGER);
        break;
      case T_VERSION_STRING:
        jj_consume_token(T_VERSION_STRING);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      try {
        version = new Version(token.image);
      }
      catch (NumberFormatException nfe) {
        generateSymbolException(nfe.getMessage());
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
      if (version != null) {
        addPackageVersion(fqn, version);
      }
      verifyImportNotDefined(fqn);
      verifyImportIsPackage(fqn);
      addToImportPath(fqn);
    jj_consume_token(T_SEMICOLON);
      popGrammarProduction();
  }

/**
 * The SIDL package specification begins with a "package" token followed by
 * a scoped identifier.  The new package namespace begins with an open curly
 * brace, a set of zero or more definitions, and a close curly brace.  The
 * closing curly brace may be followed by an optional semicolon.  The package
 * identifier must have a version defined for it, and it must not have been
 * previously defined as a symbol or used as a forward reference.  The parent
 * of the package must itself be a package and must have been defined.  The
 * symbols within the curly braces will be defined within the package scope.
 */
  final public void Package() throws ParseException, SymbolException {
   boolean declared_final = false;
   Package parent = d_parent_stack.isEmpty()
        ? null : (Package)d_parent_stack.getFirst();
   Version version = (parent != null)
        ? parent.getSymbolID().getVersion() : new Version();
   Package p = null;
   pushGrammarProduction(Grammar.PACKAGE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_FINAL:
      jj_consume_token(T_FINAL);
   declared_final = true;
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(T_PACKAGE);
   Comment comment = generateComment(token);
    ScopedIdentifier();
   String fqn = getScope((String) d_arg_stack.pop());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VERSION:
      jj_consume_token(T_VERSION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_INTEGER:
        jj_consume_token(T_INTEGER);
        break;
      case T_VERSION_STRING:
        jj_consume_token(T_VERSION_STRING);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
   try {
     version = new Version(token.image);
   }
   catch (NumberFormatException nfe) {
     generateSymbolException("Bad version number \"" + token.image +
                             "\" for package " + fqn);
   }
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    try {
       verifyNotForwardReference(fqn); // packages cannot be forward references
       SymbolTable table = SymbolTable.getInstance();
       SymbolID id = null;
       id = new SymbolID(fqn, version);
       Symbol sym = table.resolveSymbol(id);
       p = toPackage(sym, id);
       if (p == null) {
         p = new Package(id, comment);
         p.setFinal(false); // it's not final until the curly brace closes
         setMetadataValues(p);
         table.putSymbol(p);
         addSymbolToParentPackage(parent, id, Symbol.PACKAGE);
      }
       else {
         if (p.getFinal()) { // attempt to add to non-reentrant package
           generateSymbolException("Attempt to reopen final package " +
                                   id.getFullName() + " version " +
                                   id.getVersion().getVersionString());
       }
       else {
           p.setComment(Comment.combineComments(p.getComment(), comment));
         }
       }
     }
     catch (SymbolRedefinitionException ex) {
       generateSymbolException(ex.getMessage());
     }

     enterScope(fqn);
     d_parent_stack.addFirst(p);
    jj_consume_token(T_OPEN_CURLY);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
      case T_CLASS:
      case T_ENUM:
      case T_FINAL:
      case T_INTERFACE:
      case T_PACKAGE:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      Definition();
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
     d_parent_stack.removeFirst();
     leaveScope();
     if (p != null) {
       p.setFinal(declared_final);
     }
  }

/**
 * A SIDL Definition production consists of a class, interface, enumerated
 * type, or package.
 */
  final public void Definition() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.DEFINITION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
    case T_CLASS:
      Class();
      break;
    case T_ENUM:
      Enum();
      break;
    case T_INTERFACE:
      Interface();
      break;
    case T_FINAL:
    case T_PACKAGE:
      Package();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      popGrammarProduction();
  }

/**
 * A SIDL class specification begins with an optional abstract keyword
 * followed by the class token followed by an identifier.  The abstract
 * keyword is required if and only if there are abstract methods in the
 * class.  The class keyword is followed by an identifer.  The identifier
 * string may not have been previously defined, although it may have been
 * used as a forward reference.  The identifier string may be preceeded
 * by a documentation comment.  A class may optionally extend another class;
 * if no class is specified, then the class will automatically extend the
 * SIDL base class (unless it is itself the SIDL base class).  Then parse
 * the implements-all and implements clauses.  The interfaces parsed during
 * implements-all are saved in a set and then all those methods are defined
 * at the end of the class definition.  The methods block begins with an
 * open curly-brace followed by zero or more methods followed by a close
 * curly-brace and optional semicolon.
 */
  final public void Class() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.CLASS);
   Comment comment = null;
   HashSet implall = new HashSet();
   boolean declared_abstract = false;
   Package parent = (Package)d_parent_stack.getFirst();
   Version parentVersion = parent.getSymbolID().getVersion();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
      jj_consume_token(T_ABSTRACT);
      declared_abstract = true;
      comment = generateComment(token);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(T_CLASS);
      if (comment == null) {
         comment = generateComment(token);
      }
    Identifier();
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);
      verifySymbolCanBeDefined(id);
      removeForwardReference(fqn);

      Class cls = new Class(id, comment);
      setMetadataValues(cls);

      try {
         SymbolTable.getInstance().putSymbol(cls);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.CLASS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EXTENDS:
      jj_consume_token(T_EXTENDS);
      ScopedIdentifier();
      String identifier = (String) d_arg_stack.pop();
      Symbol symbol = resolveSymbol(identifier);

      if (symbol.getSymbolType() != Symbol.CLASS) {
         generateSymbolException("Symbol \""
            + symbol.getSymbolID().getSymbolName()
            + "\" must be an class");
      }

      verifyClassInheritance(cls, (Class) symbol);
      cls.setParentClass((Class) symbol);
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
      if (cls.getParentClass() == null) {
         if (!fqn.equals(SIDL_CLASS)) {
            Class base = (Class) resolveFQN(SIDL_CLASS);
            verifyClassInheritance(cls, base);
            cls.setParentClass(base);
         }
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IMPLEMENTS_ALL:
      jj_consume_token(T_IMPLEMENTS_ALL);
      AddInterface(cls, implall);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[14] = jj_gen;
          break label_5;
        }
        jj_consume_token(T_COMMA);
        AddInterface(cls, implall);
      }
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IMPLEMENTS:
      jj_consume_token(T_IMPLEMENTS);
      AddInterface(cls, null);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_6;
        }
        jj_consume_token(T_COMMA);
        AddInterface(cls, null);
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(T_OPEN_CURLY);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
      case T_COPY:
      case T_FINAL:
      case T_STATIC:
      case T_VOID:
      case T_ARRAY:
      case T_BOOLEAN:
      case T_CHAR:
      case T_DCOMPLEX:
      case T_DOUBLE:
      case T_FCOMPLEX:
      case T_FLOAT:
      case T_INT:
      case T_LONG:
      case T_OPAQUE:
      case T_STRING:
      case T_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_7;
      }
      ClassMethod(cls);
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
      for (Iterator i = implall.iterator(); i.hasNext(); ) {
         Interface ifc = (Interface) i.next();
         String name = ifc.getFullName();
         for (Iterator m = ifc.getMethods(true).iterator(); m.hasNext(); ) {
            Method method = (Method) m.next();
            Method defined = cls.lookupMethodByLongName(
                                 method.getLongMethodName(), false);
            if (defined == null) {
               Method exist = cls.lookupMethodByLongName(
                                  method.getLongMethodName(), true);
               if (exist.isAbstract()) {
                  Method clone = method.cloneMethod();
                  clone.setDefinitionModifier(Method.NORMAL);
                  cls.addMethod(clone);
               }
            }
         }
      }

      /*
       * Check that the class abstract qualifier matches whether there are
       * any abstract methods in the class.
       */
      verifyAbstract(cls, declared_abstract);
      popGrammarProduction();
  }

/**
 * The SIDL enumeration specification begins with an "enum" token followed by
 * an identifier.  The enumerator list begins with an open curly brace, a set
 * of one or more definitions, and a close curly brace.  The closing curly
 * brace may be followed by an optional semicolon.  The enumeration symbol
 * identifier must have a version defined for it, and it must not have been
 * previously defined as a symbol.  Forward references are not allowed for
 * enumerated types.  This routine creates the enumerated class and then
 * grabs the list of enumeration symbols and their optional values.
 */
  final public void Enum() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ENUM);
   Package parent = (Package)d_parent_stack.getFirst();
   Version parentVersion = parent.getSymbolID().getVersion();
    jj_consume_token(T_ENUM);
      Comment comment = generateComment(token);
    Identifier();
      if (comment == null) {
      }
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);
      verifySymbolCanBeDefined(id);
      verifyNotForwardReference(fqn);

      Enumeration e = new Enumeration(id, comment);
      setMetadataValues(e);

      try {
         SymbolTable.getInstance().putSymbol(e);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.ENUM);
    jj_consume_token(T_OPEN_CURLY);
    Enumerator(e);
    label_8:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_8;
      }
      jj_consume_token(T_COMMA);
      Enumerator(e);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COMMA:
      jj_consume_token(T_COMMA);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
      popGrammarProduction();
  }

/**
 * The SIDL enumerator specification consists of an identifier followed
 * by an optional assignment statement beginning with an equals and followed
 * by an integer value.  This routine adds the new enumeration symbol to
 * the list and then returns.
 */
  final public void Enumerator(Enumeration e) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ENUMERATOR);
   Comment comment = null;
    Identifier();
      comment = generateComment(token);
      String name = (String) d_arg_stack.pop();
      if (e.hasEnumerator(name)) {
         generateSymbolException("Redefinition of enumerator \""+name+"\"");
      }
      int value = 0;
      boolean user_defined = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EQUALS:
      jj_consume_token(T_EQUALS);
      jj_consume_token(T_INTEGER);
      user_defined = true;
      try {
         value = Integer.parseInt(token.image);
      } catch (NumberFormatException ex) {
         generateSymbolException("Invalid integer \""+token.image+"\"");
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
      if (!user_defined) {
         e.addEnumerator(name, comment);
      } else {
         e.addEnumerator(name, value, comment);
      }
      popGrammarProduction();
  }

/**
 * A SIDL interface specification begins with the interface token followed
 * by an identifier.  An interface may have an extends block consisting of
 * a comma-separated sequence of interfaces.  The methods block begins with
 * an open curly-brace followed by zero or more methods followed by a close
 * curly-brace and optional semicolon.  Interfaces may be preceeded by a
 * documentation comment.  The identifier string may not have been previously
 * defined, although it may have been used as a forward reference.  If the
 * interface does not extend another interface, then it must extend the base
 * SIDL interface (unless, of course, this is the definition for the base
 * SIDL interface).
 */
  final public void Interface() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.INTERFACE);
   Package parent = (Package)d_parent_stack.getFirst();
   Version parentVersion = parent.getSymbolID().getVersion();
    jj_consume_token(T_INTERFACE);
      Comment comment = generateComment(token);
    Identifier();
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);

      verifySymbolCanBeDefined(id);
      removeForwardReference(fqn);

      Interface ifc = new Interface(id, comment);
      setMetadataValues(ifc);

      try {
         SymbolTable.getInstance().putSymbol(ifc);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.INTERFACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EXTENDS:
      jj_consume_token(T_EXTENDS);
      AddInterface(ifc, null);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_9;
        }
        jj_consume_token(T_COMMA);
        AddInterface(ifc, null);
      }
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
      if (ifc.getParentInterfaces(false).isEmpty()) {
         if (!fqn.equals(SIDL_INTERFACE)) {
            Interface base = (Interface) resolveFQN(SIDL_INTERFACE);
            verifyInterfaceInheritance(ifc, base);
            ifc.addParentInterface(base);
         }
      }
    jj_consume_token(T_OPEN_CURLY);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COPY:
      case T_VOID:
      case T_ARRAY:
      case T_BOOLEAN:
      case T_CHAR:
      case T_DCOMPLEX:
      case T_DOUBLE:
      case T_FCOMPLEX:
      case T_FLOAT:
      case T_INT:
      case T_LONG:
      case T_OPAQUE:
      case T_STRING:
      case T_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_10;
      }
      InterfaceMethod(ifc);
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
      popGrammarProduction();
  }

/**
 * This production parses the next scoped identifier and validates that
 * the name exists and is an interface symbol.  Then each of its methods
 * are checked for validity with the existing methods.  If everything
 * checks out, then the new interface is added to the existing object.
 */
  final public void AddInterface(Extendable ext, Set set) throws ParseException, SymbolException {
    ScopedIdentifier();
      String identifier = (String) d_arg_stack.pop();
      Symbol symbol = resolveSymbol(identifier);

      if (symbol.getSymbolType() != Symbol.INTERFACE) {
         generateSymbolException("Symbol \""
            + symbol.getSymbolID().getSymbolName()
            + "\" must be an interface");
      }

      verifyInterfaceInheritance(ext, (Interface) symbol);
      ext.addParentInterface((Interface) symbol);

      if (set != null) {
         set.add(symbol);
      }
  }

/**
 * This production parses the SIDL method description for a class method.
 * A class method may start with abstract, final, or static.  An error is
 * thrown if the method has already been defined in the class object or if
 * the method name is the same as the class name.  An error is also thrown
 * if a method has been defined in a parent class and (1) the signatures
 * do not match, (2) either of the methods is static, (3) the existing method
 * is final, or (4) the new method is abstract but the existing method was
 * not abstract.
 */
  final public void ClassMethod(Class cls) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.CLASS_METHOD);
   Method method = new Method();
   Comment comment = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
    case T_FINAL:
    case T_STATIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
        jj_consume_token(T_ABSTRACT);
      method.setDefinitionModifier(Method.ABSTRACT);
        break;
      case T_FINAL:
        jj_consume_token(T_FINAL);
      method.setDefinitionModifier(Method.FINAL);
        break;
      case T_STATIC:
        jj_consume_token(T_STATIC);
      method.setDefinitionModifier(Method.STATIC);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      comment = generateComment(token);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
      if (comment == null) {
         comment = generateComment(getToken(1));
      }
      method.setComment(comment);
    Method(method);
      String name = cls.getFullName();
      verifyMethodRedefinition(cls, method);
      verifyMethodSignature(cls, method, name);
      verifyMethodStatic(cls, method, name);
      verifyMethodOverride(cls, method);
      cls.addMethod(method);
      popGrammarProduction();
  }

/**
 * This method parses a SIDL method and then checks whether it can be
 * added to the interface object.  An error is thrown if the method has
 * already been added to the interface object or if the method name is
 * the same as the interface name.  An error is also thrown if a previous
 * method was defined with the same name but a different signature.
 */
  final public void InterfaceMethod(Interface ifc) throws ParseException, SymbolException {
   Method method = new Method();
   method.setComment(generateComment(getToken(1)));
    Method(method);
      method.setDefinitionModifier(Method.ABSTRACT);
      String name = ifc.getFullName();
      verifyMethodRedefinition(ifc, method);
      verifyMethodSignature(ifc, method, name);
      ifc.addMethod(method);
  }

/**
 * The SIDL method production has a return type, a method identifier,
 * an optional argument list, an optional communication modifier, and
 * an optional throws clause.  The return type may be void (no return
 * type) or any valid SIDL type.  The method is built piece by piece.
 */
  final public void Method(Method m) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.METHOD);
   boolean copy = false;
   String short_name = null;
   String extension = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VOID:
      jj_consume_token(T_VOID);
      m.setReturnType(new Type(Type.VOID));
      m.setReturnCopy(false);
      break;
    case T_COPY:
    case T_ARRAY:
    case T_BOOLEAN:
    case T_CHAR:
    case T_DCOMPLEX:
    case T_DOUBLE:
    case T_FCOMPLEX:
    case T_FLOAT:
    case T_INT:
    case T_LONG:
    case T_OPAQUE:
    case T_STRING:
    case T_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COPY:
        jj_consume_token(T_COPY);
      copy = true;
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      Type();
      Type t = (Type) d_arg_stack.pop();
      if (copy) {
         verifyCopyModifierValid(t);
      }
      m.setReturnType(t);
      m.setReturnCopy(copy);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    Identifier();
      short_name = (String) d_arg_stack.pop();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IDENTIFIER:
      jj_consume_token(T_IDENTIFIER);
      verifyReservedWords(token.image);
      extension = (String) token.image;
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
      checkMethodNameLength(short_name, extension, token);
      if (extension != null) {
         m.setMethodName(short_name, extension);
      } else {
         m.setMethodName(short_name);
      }
    jj_consume_token(T_OPEN_PAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COPY:
    case T_IN:
    case T_INOUT:
    case T_OUT:
      Argument();
      m.addArgument((Argument) d_arg_stack.pop());
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_11;
        }
        jj_consume_token(T_COMMA);
        Argument();
      m.addArgument((Argument) d_arg_stack.pop());
      }
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_PAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LOCAL:
    case T_ONEWAY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_LOCAL:
        jj_consume_token(T_LOCAL);
      m.setCommunicationModifier(Method.LOCAL);
        break;
      case T_ONEWAY:
        jj_consume_token(T_ONEWAY);
      verifyOnewayValid(m);
      m.setCommunicationModifier(Method.ONEWAY);
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_THROWS:
      jj_consume_token(T_THROWS);
      ScopedIdentifier();
      verifyAndAddThrows(m, (String) d_arg_stack.pop());
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_12;
        }
        jj_consume_token(T_COMMA);
        ScopedIdentifier();
      verifyAndAddThrows(m, (String) d_arg_stack.pop());
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(T_SEMICOLON);
      popGrammarProduction();
  }

/**
 * Parse a SIDL argument.  Arguments begin with an optional copy modifier
 * followed by in, out, or inout followed by a type and a formal argument.
 * The argument is returned on the top of the argument stack.  This routine
 * also checks that the copy modifier is used only for symbol objects.  For
 * all other types, copy is redundant.
 */
  final public void Argument() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ARGUMENT);
   boolean copy = false;
   int     mode = Argument.IN;
   String  name = null;
   Type    type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COPY:
      jj_consume_token(T_COPY);
      copy = true;
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IN:
      jj_consume_token(T_IN);
      mode = Argument.IN;
      break;
    case T_OUT:
      jj_consume_token(T_OUT);
      mode = Argument.OUT;
      break;
    case T_INOUT:
      jj_consume_token(T_INOUT);
      mode = Argument.INOUT;
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    Type();
      type = (Type) d_arg_stack.pop();
    Identifier();
      name = (String) d_arg_stack.pop();
      if (copy) {
         verifyCopyModifierValid(type);
      }
      Argument arg = new Argument(copy, mode, type, name);
      d_arg_stack.push(arg);
      popGrammarProduction();
  }

/**
 * A SIDL type consists of one of the standard built-in types (boolean,
 * char, dcomplex, double, fcomplex, float, int, long, opaque, and string),
 * a user-defined type (interface, class, or enum), or an array.  This
 * production parses the type and pushes the resulting type object on
 * the top of the argument stack.
 */
  final public void Type() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.TYPE);
   Type type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_BOOLEAN:
      jj_consume_token(T_BOOLEAN);
      type = new Type(Type.BOOLEAN);
      break;
    case T_CHAR:
      jj_consume_token(T_CHAR);
      type = new Type(Type.CHAR);
      break;
    case T_DCOMPLEX:
      jj_consume_token(T_DCOMPLEX);
      type = new Type(Type.DCOMPLEX);
      break;
    case T_DOUBLE:
      jj_consume_token(T_DOUBLE);
      type = new Type(Type.DOUBLE);
      break;
    case T_FCOMPLEX:
      jj_consume_token(T_FCOMPLEX);
      type = new Type(Type.FCOMPLEX);
      break;
    case T_FLOAT:
      jj_consume_token(T_FLOAT);
      type = new Type(Type.FLOAT);
      break;
    case T_INT:
      jj_consume_token(T_INT);
      type = new Type(Type.INT);
      break;
    case T_LONG:
      jj_consume_token(T_LONG);
      type = new Type(Type.LONG);
      break;
    case T_OPAQUE:
      jj_consume_token(T_OPAQUE);
      type = new Type(Type.OPAQUE);
      break;
    case T_STRING:
      jj_consume_token(T_STRING);
      type = new Type(Type.STRING);
      break;
    case T_ARRAY:
      Array();
      type = (Type) d_arg_stack.pop();
      break;
    case T_IDENTIFIER:
      SymbolType();
      type = new Type((SymbolID) d_arg_stack.pop());
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      d_arg_stack.push(type);
      popGrammarProduction();
  }

/**
 * Parse an array construct and push the resulting type and ordering on top of 
 * the stack.  Only dimensions one through MAX_ARRAY_DIM (inclusive) are 
 * supported.
 */
  final public void Array() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ARRAY);
   int dim   = 1;
   int order = Type.UNSPECIFIED;
    jj_consume_token(T_ARRAY);
    jj_consume_token(T_OPEN_ANGLE);
    Type();
      if (((Type) d_arg_stack.peek()).isArray()) {
         generateSymbolException("Nested arrays are not supported");
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COMMA:
      jj_consume_token(T_COMMA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_INTEGER:
        jj_consume_token(T_INTEGER);
      try {
         dim = Integer.parseInt(token.image);
      } catch (NumberFormatException e) {
         generateSymbolException(
            "Illegal array dimension \"" + token.image + "\"");
      }
      if ((dim < 1) || (dim > MAX_ARRAY_DIM)) {
         generateSymbolException(
            "Illegal array dimension \"" + token.image + "\"");
      }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          jj_consume_token(T_COMMA);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case T_COLUMN_MAJOR:
            jj_consume_token(T_COLUMN_MAJOR);
      order = Type.COLUMN_MAJOR;
            break;
          case T_ROW_MAJOR:
            jj_consume_token(T_ROW_MAJOR);
      order = Type.ROW_MAJOR;
            break;
          default:
            jj_la1[41] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[42] = jj_gen;
          ;
        }
        break;
      case T_COLUMN_MAJOR:
      case T_ROW_MAJOR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COLUMN_MAJOR:
          jj_consume_token(T_COLUMN_MAJOR);
      order = Type.COLUMN_MAJOR;
          break;
        case T_ROW_MAJOR:
          jj_consume_token(T_ROW_MAJOR);
      order = Type.ROW_MAJOR;
          break;
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_ANGLE);
      Type type = (Type) d_arg_stack.pop();
      d_arg_stack.push(new Type(type, dim, order));
      popGrammarProduction();
  }

/**
 * This production parses a scoped identifier and verifies that it is
 * either a forward reference or a symbol that may be used as a type
 * (either an enum, an interface, or a class).
 */
  final public void SymbolType() throws ParseException, SymbolException {
    ScopedIdentifier();
      String identifier = (String) d_arg_stack.pop();
      Symbol symbol = tryResolveSymbol(identifier);

      if (symbol != null) {
         if (symbol.getSymbolType() == Symbol.PACKAGE) {
            generateSymbolException("Cannot use package \""
               + symbol.getSymbolID().getSymbolName()
               + "\" as a SIDL type");
         }
         d_arg_stack.push(symbol.getSymbolID());
      } else {
         String fqn = getScope(identifier);
         addForwardReference(fqn);
         d_arg_stack.push(new SymbolID(fqn, lookupVersion(fqn)));
      }
  }

/**
 * All SIDL scoped names are of the general form "ID ( . ID )*".  Each
 * identifier ID is a string of letters, numbers, and underscores that
 * must begin with a letter.  The scope resolution operator "." separates
 * the identifiers in a name.
 */
  final public void ScopedIdentifier() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.SCOPED_IDENTIFIER);
   StringBuffer buffer = new StringBuffer();
    Identifier();
      buffer.append((String) d_arg_stack.pop());
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_SCOPE:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_13;
      }
      jj_consume_token(T_SCOPE);
      Identifier();
      buffer.append(SCOPE);
      buffer.append((String) d_arg_stack.pop());
    }
      d_arg_stack.push(buffer.toString());
      popGrammarProduction();
  }

/**
 * A SIDL identifier must start with a letter and may be followed by any
 * number of letters, numbers, or underscores.  It may not be a reserved
 * word in any of the SIDL implementation languages (e.g., C or C++).
 */
  final public void Identifier() throws ParseException, SymbolException {
    jj_consume_token(T_IDENTIFIER);
      verifyReservedWords(token.image);
      d_arg_stack.push(token.image);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(T_COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(T_IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[47];
  final private int[] jj_la1_0 = {0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb000000,0x0,0xb000000,0x1000000,0x10000000,0x0,0x0,0x0,0x0,0x5000000,0x0,0x0,0x0,0x0,0x0,0x10000000,0x4000000,0x0,0x1000000,0x1000000,0x4000000,0x4000000,0x0,0x0,0xc4000000,0x0,0x0,0x0,0x0,0x4000000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_1 = {0x100,0x0,0x81,0x6000000,0x6000000,0x800,0x1,0x6000000,0x800,0x89,0x0,0x89,0x0,0x0,0x0,0x4,0x0,0x2,0x1fff201,0x0,0x0,0x0,0x0,0x0,0x0,0x1fff000,0x0,0x201,0x201,0x0,0x1fff000,0x1000000,0x0,0x40,0x30,0x30,0x0,0x400,0x0,0x40,0x1ffe000,0x0,0x0,0x0,0x4000000,0x0,0x0,};
  final private int[] jj_la1_2 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x20,0x1,0x20,0x2,0x1,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x180,0x1,0x180,0x180,0x1,0x40,};
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enm = jj_expentries.elements(); enm.hasMoreElements();) {
        int[] oldentry = (int[])(enm.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[74];
    for (int i = 0; i < 74; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 47; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 74; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
