#! /bin/sh
## File:        runAll.sh
## Package:     Babel hello examples
## Copyright:   (c) 2000-2001 The Regents of the University of California
## Release:     $Name: release-0-8-8 $
## Revision:    $Revision: 1.5 $
## Modified:    $Date: 2003/04/25 06:01:38 $
## Description: script to run C dynamically loading hello implementations
##

BC="/bin/sh ../../../bin/babel-config"

echo "Hello from C..."
SIDL_DLL_PATH="../libC/libImpl.la" ; export SIDL_DLL_PATH
./runAll

if $BC --with-c++; then
echo "Hello from C++..."
SIDL_DLL_PATH="../libCxx/libImpl.la" ; export SIDL_DLL_PATH
./runAll
else
echo "C++ support not enabled"
fi 

if $BC --with-f77; then
echo "Hello from Fortran77..."
SIDL_DLL_PATH="../libF77/libImpl.la" ; export SIDL_DLL_PATH
./runAll
else
echo "f77 support not enabled"
fi
