c
c     File:       argstest.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Release:    $Name: release-0-8-8 $
c     Revision:   @(#) $Revision: 1.7 $
c     Date:       $Date: 2002/09/30 23:01:00 $
c     Description:Exercise the FORTRAN interface
c
c
      subroutine starttest(number)
      implicit none
      integer number
      write (6, 100) number
 100  format ('PART ', I4)
      end

      subroutine reporttest(test, number, pass, fail, xfail,
     $     python)
      implicit none
      integer number, pass, fail, xfail
      logical test, python
      if (test) then
         write (6, 100) number, 'PASS'
         pass = pass + 1
      else
         if (python) then
            write (6, 100) number, 'XFAIL'
            xfail = xfail + 1
         else
            write (6, 100) number, 'FAIL'
            fail = fail + 1
         endif
      endif
 100  format ('RESULT', 1x, i2, 1x, A5)
      number = number + 1
      end

      subroutine testbool(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical out, inout, retval
      
      inout = .true.
      call Args_Cbool__create_f(obj)
      call starttest(test)
      call Args_Cbool_returnback_f(obj, retval)
      call reporttest(retval, test, pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cbool_passin_f(obj, .true., retval)
      call reporttest(retval, test, pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cbool_passout_f(obj, out, retval)
      call reporttest(retval .and. out, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cbool_passinout_f(obj, inout, retval)
      call reporttest(retval .and. .not. inout, test, pass,
     $     fail, xfail, .false.)
      call starttest(test)
      call Args_Cbool_passeverywhere_f(obj, .true.,
     $     out, inout, retval)
      call reporttest(retval .and. out .and. inout, test,
     $     pass, fail, xfail, .false.)
      call Args_Cbool_deleteRef_f(obj)
      end

      subroutine testint(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval
      integer*4 iretval, out, inout
      
      inout = 3
      call Args_Cint__create_f(obj)
      call starttest(test)
      call Args_Cint_returnback_f(obj, iretval)
      call reporttest(iretval .eq. 3, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cint_passin_f(obj, 3, bretval)
      call reporttest(bretval, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cint_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cint_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cint_passeverywhere_f(obj, 3,
     $     out, inout, iretval)
      call reporttest((iretval .eq. 3) .and.
     $     (out .eq. 3) .and.
     $     (inout .eq. 3), test, pass, fail, xfail, .false.)
      call Args_Cint_deleteRef_f(obj)
      end

      subroutine testchar(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval
      character cretval, out, inout
      
      inout = 'A'
      call Args_Cchar__create_f(obj)
      call starttest(test)
      call Args_Cchar_returnback_f(obj, cretval)
      call reporttest(cretval .eq. '3', test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cchar_passin_f(obj, '3', bretval)
      call reporttest(bretval, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cchar_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. '3'), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cchar_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. 'a'), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cchar_passeverywhere_f(obj, '3',
     $     out, inout, cretval)
      call reporttest((cretval .eq. '3') .and.
     $     (out .eq. '3') .and.
     $     (inout .eq. 'A'), test, pass, fail, xfail, .false.)
      call Args_Cchar_deleteRef_f(obj)
      end

      subroutine testlong(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval
      integer*8 out, inout, iretval, inval
      
      inout = 3
      call Args_Clong__create_f(obj)
      call starttest(test)
      call Args_Clong_returnback_f(obj, iretval)
      call reporttest(iretval .eq. 3, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      inval = 3
      call Args_Clong_passin_f(obj, inval, bretval)
      call reporttest(bretval, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Clong_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Clong_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      inval = 3
      call Args_Clong_passeverywhere_f(obj, inval,
     $     out, inout, iretval)
      call reporttest((iretval .eq. 3) .and.
     $     (out .eq. 3) .and.
     $     (inout .eq. 3), test, pass, fail, xfail, .false.)
      call Args_Clong_deleteRef_f(obj)
      end

      subroutine testfloat(test, pass, fail, xfail, python)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval, python
      real out, inout, fretval
      
      inout = 3.1
      call Args_Cfloat__create_f(obj)
      call starttest(test)
      call Args_Cfloat_returnback_f(obj, fretval)
      call reporttest(fretval .eq. 3.1, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cfloat_passin_f(obj, 3.1, bretval)
      call reporttest(bretval, test, pass, fail, xfail, python)
      call starttest(test)
      call Args_Cfloat_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3.1), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cfloat_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3.1), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cfloat_passeverywhere_f(obj, 3.1,
     $     out, inout, fretval)
      call reporttest((fretval .eq. 3.1) .and.
     $     (out .eq. 3.1) .and.
     $     (inout .eq. 3.1), test, pass, fail,
     $     xfail, python)
      call Args_Cfloat_deleteRef_f(obj)
      end

      subroutine testdouble(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval
      double precision out, inout, dretval
      
      inout = 3.14d0
      call Args_Cdouble__create_f(obj)
      call starttest(test)
      call Args_Cdouble_returnback_f(obj, dretval)
      call reporttest(dretval .eq. 3.14d0, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cdouble_passin_f(obj, 3.14d0, bretval)
      call reporttest(bretval, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cdouble_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3.14d0), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cdouble_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3.14d0), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cdouble_passeverywhere_f(obj, 3.14d0,
     $     out, inout, dretval)
      call reporttest((dretval .eq. 3.14d0) .and.
     $     (out .eq. 3.14d0) .and.
     $     (inout .eq. 3.14d0), test, pass, fail,
     $     xfail, .false.)
      call Args_Cdouble_deleteRef_f(obj)
      end

      subroutine testfcomplex(test, pass, fail, xfail, python)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval, python
      complex in, out, inout, cretval
      
      in = (3.1,3.1)
      inout = (3.1, 3.1)
      call Args_Cfcomplex__create_f(obj)
      call starttest(test)
      call Args_Cfcomplex_returnback_f(obj, cretval)
      call reporttest(cretval .eq. (3.1,3.1), test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cfcomplex_passin_f(obj, in, bretval)
      call reporttest(bretval, test, pass, fail, xfail, python)
      call starttest(test)
      call Args_Cfcomplex_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. (3.1,3.1)), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cfcomplex_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. (3.1,-3.1)), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cfcomplex_passeverywhere_f(obj, in,
     $     out, inout, cretval)
      call reporttest((cretval .eq. (3.1,3.1)) .and.
     $     (out .eq. (3.1,3.1)) .and.
     $     (inout .eq. (3.1,3.1)), test, pass, fail,
     $     xfail, python)
      call Args_Cfcomplex_deleteRef_f(obj)
      end

      subroutine testdcomplex(test, pass, fail, xfail)
      implicit none
      integer*8 obj
      integer test, pass, fail, xfail
      logical bretval
      double complex in, out, inout, cretval
      
      in = (3.14d0,3.14d0)
      inout = (3.14d0, 3.14d0)
      call Args_Cdcomplex__create_f(obj)
      call starttest(test)
      call Args_Cdcomplex_returnback_f(obj, cretval)
      call reporttest(cretval .eq. (3.14d0,3.14d0), test,
     $     pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cdcomplex_passin_f(obj, in, bretval)
      call reporttest(bretval, test, pass, fail,
     $     xfail, .false.)
      call starttest(test)
      call Args_Cdcomplex_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. (3.14d0,3.14d0)),
     $     test, pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cdcomplex_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. (3.14d0,-3.14d0)),
     $     test, pass, fail, xfail, .false.)
      call starttest(test)
      call Args_Cdcomplex_passeverywhere_f(obj, in,
     $     out, inout, cretval)
      call reporttest((cretval .eq. (3.14d0,3.14d0)) .and.
     $     (out .eq. (3.14d0,3.14d0)) .and.
     $     (inout .eq. (3.14d0,3.14d0)), test, pass, fail,
     $     xfail, .false.)
      call Args_Cdcomplex_deleteRef_f(obj)
      end


      program argstest
      integer test, pass, fail, xfail
      character*80 language
      language = ' '
      if (IArgc() .eq. 1) then
         callGetArg(1, language)
      endif
      test = 1
      pass = 0
      xfail = 0
      fail = 0
      write(6,120) 40
      write(6,110) 'Boolean tests'
      call testbool(test, pass, fail, xfail)
      write(6,110) 'Character tests'
      call testchar(test, pass, fail, xfail)
      write(6,110) 'Integer tests'
      call testint(test, pass, fail, xfail)
      write(6,110) 'Long tests'
      call testlong(test, pass, fail, xfail)
      write(6,110) 'Float tests'
      call testfloat(test, pass, fail, xfail,
     $     language .eq. 'Python')
      write(6,110) 'Double tests'
      call testdouble(test, pass, fail, xfail)
      write(6,110) 'Fcomplex tests'
      call testfcomplex(test, pass, fail, xfail,
     $     language .eq. 'Python')
      write(6,110) 'Dcomplex tests'
      call testDcomplex(test, pass, fail, xfail)
      if (fail .eq. 0) then
         if (pass .eq. 40) then
            write(6, 100) 'PASS'
         else
            write(6, 100) 'XFAIL'
         endif
      else
         write(6, 100) 'FAIL'
      endif
 100  format ('TEST_RESULT', 1x, a5)
 110  format ('COMMENT:', 1x, a20)
 120  format ('NPARTS', 1x, i4)
      end
