/*
 * File:          ArrayTest_ArrayOps_Impl.c
 * Symbol:        ArrayTest.ArrayOps-v1.2
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for ArrayTest.ArrayOps
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "ArrayTest.ArrayOps" (version 1.2)
 */

#include "ArrayTest_ArrayOps_Impl.h"

/* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._includes) */
#include "ArrayTest_ArrayOps_IOR.h"
#include "ArrayTest_ArrayOps.h"
#include "SIDLArray.h"
#include <string.h>
#include <stdlib.h>

static int32_t intFunc(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0;i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static int
next(const int dimen, int32_t ind[],
     const int32_t lower[], const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static struct SIDL_int__array *
makeIntTestMatrix(int dimen)
{
  struct SIDL_int__array *result = NULL;
  static const int32_t lower[] = {0, 0, 0, 0};
  static const int32_t upper[] = {3, 3, 2, 2};
  int32_t ind[] = {0, 0, 0, 0};
  int32_t value;
  result  = SIDL_int__array_createCol(dimen, lower, upper);
  do {
    value = intFunc(dimen, ind);
    switch(rand() % 3) {
    case 0:
      if (dimen == 3) {
        SIDLArrayElem3(result, ind[0], ind[1], ind[2]) = value;
      }
      else {
        SIDLArrayElem4(result, ind[0], ind[1], ind[2], ind[3]) = value;
      }
      break;
    case 1:
      SIDL_int__array_set(result, ind, value);
      break;
    case 2:
      if (dimen == 3) {
        SIDL_int__array_set3(result, ind[0], ind[1], ind[2], value);
      }
      else {
        SIDL_int__array_set4(result, ind[0], ind[1], ind[2], ind[3], value);
      }
      break;
    }
  } while (next(dimen, ind, lower, upper));
  return result;
}

double powTwo(int64_t i) {
  double result = 1;
  if (i >= 0) {
    while (i--) {
      result *= 2;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5;
    }
  }
  return result;
}

float fpowTwo(int64_t i) {
  register float result = 0.0F;
  static volatile float forcestore;                               
 
  result = 1.0F;
  if (i >= 0) {
    while (i--) {
      result *= 2.0F;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5F;
    }
  }
  forcestore = result;
  return forcestore;
}

static int isPrime(const int64_t num) {
  register int64_t i;
  for(i = 3; i*i <= num; ++i) {
    if (!(num % i)) return 0;
  }
  return 1;
}

int64_t
nextPrime(int64_t prev) {
  if (prev <= 1L) {
    return 2L;
  }
  else if (prev == 2L) {
    return 3L;
  }
  else {
    do {
      prev += 2;
    } while (!isPrime(prev));
    return prev;
  }
}

static const char s_TestText[] = "\
I'd rather write programs to write programs than write programs.";

static const char *s_TestWords[] = {
  "I'd",
  "rather",
  "write",
  "programs",
  "to",
  "write",
  "programs",
  "than",
  "write",
  "programs.",
  NULL
};

const char *nextChar(const char *str) {
  if (!*(++str)) {
    str = s_TestText;
  }
  return str;
}

const char * const* nextWord(const char *const*word) {
  if (!*(++word)){
    word = s_TestWords;
  }
  return word;
}

static int
nextElem(const int32_t dimen,
         int32_t ind[],
         const int32_t lower[],
         const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static int32_t
arrayValue(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0; i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static int
hasElements(const int dimen, const int32_t lower[], const int32_t upper[])
{
  int i;
  for (i = 0; i < dimen; ++i){
    if (lower[i] > upper[i]) return 0;
  }
  return 1;
}

/* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps__ctor"

void
impl_ArrayTest_ArrayOps__ctor(
  ArrayTest_ArrayOps self)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps__dtor"

void
impl_ArrayTest_ArrayOps__dtor(
  ArrayTest_ArrayOps self)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor) */
}

/*
 * Return <code>true</code> iff the even elements are true and
 * the odd elements are false.
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkBool"

SIDL_bool
impl_ArrayTest_ArrayOps_checkBool(
  struct SIDL_bool__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool) */
  if (a && (1 == SIDL_bool__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_bool__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_bool__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0);  ++i) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_bool__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_bool__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != ((i & 0x1) ? FALSE : TRUE))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool) */
}

/*
 * Method:  checkChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkChar"

SIDL_bool
impl_ArrayTest_ArrayOps_checkChar(
  struct SIDL_char__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar) */
  if (a && (1 == SIDL_char__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_char__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_char__array_upper(a,0))) {
    int32_t i, ind[1];
    const char *testStr = s_TestText;
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); 
        ++i, testStr = nextChar(testStr)) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_char__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_char__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != *testStr)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar) */
}

/*
 * Method:  checkInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkInt"

SIDL_bool
impl_ArrayTest_ArrayOps_checkInt(
  struct SIDL_int__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt) */
  if (a && (1 == SIDL_int__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_int__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_int__array_upper(a,0))) {
    int32_t i, ind[1];
    int32_t prime = nextPrime(0);
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); 
        ++i, prime = nextPrime(prime)) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_int__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_int__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != prime)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt) */
}

/*
 * Method:  checkLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkLong"

SIDL_bool
impl_ArrayTest_ArrayOps_checkLong(
  struct SIDL_long__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong) */
  if (a && (1 == SIDL_long__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_long__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_long__array_upper(a,0))) {
    int32_t i, ind[1];
    int64_t prime = nextPrime(0);
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); 
        ++i, prime = nextPrime(prime)) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_long__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_long__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != prime)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong) */
}

/*
 * Method:  checkString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkString"

SIDL_bool
impl_ArrayTest_ArrayOps_checkString(
  struct SIDL_string__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString) */
  if (a && (1 == SIDL_string__array_dimen(a))) {
    int32_t i, ind[1];
    const char * const *testWord = s_TestWords;
    for(i = SIDL_string__array_lower(a,0); 
        i <= SIDL_string__array_upper(a,0); 
        ++i, testWord = nextWord(testWord)) {
      char *s1, *s2;
      ind[0] = i;
      s1 = SIDL_string__array_get1(a, i);
      s2 = SIDL_string__array_get(a, ind);
      if (!(s1 && s2 && !strcmp(s1, s2) && !strcmp(s1, *testWord))) {
        free(s1);
        free(s2);
        return FALSE;
      }
      free(s1);
      free(s2);
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString) */
}

/*
 * Method:  checkDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkDouble"

SIDL_bool
impl_ArrayTest_ArrayOps_checkDouble(
  struct SIDL_double__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble) */
  if (a && (1 == SIDL_double__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_double__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_double__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_double__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_double__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble) */
}

/*
 * Method:  checkFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkFloat"

SIDL_bool
impl_ArrayTest_ArrayOps_checkFloat(
  struct SIDL_float__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat) */
  if (a && (1 == SIDL_float__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_float__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_float__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i) {
      ind[0] = i;
      if ((SIDLArrayElem1(a,i) != SIDL_float__array_get1(a, i)) ||
          (SIDLArrayElem1(a,i) != SIDL_float__array_get(a, ind)) ||
          (SIDLArrayElem1(a,i) != fpowTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat) */
}

/*
 * Method:  checkFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkFcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_checkFcomplex(
  struct SIDL_fcomplex__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex) */
  if (a && (1 == SIDL_fcomplex__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_fcomplex__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_fcomplex__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i) {
      struct SIDL_fcomplex r1 = SIDL_fcomplex__array_get1(a, i);
      struct SIDL_fcomplex r2;
      ind[0] = i;
      r2 = SIDL_fcomplex__array_get(a, ind);
      if (memcmp(&r1, &SIDLArrayElem1(a,i), 
                 sizeof(struct SIDL_fcomplex)) ||
          memcmp(&r1, &r2, sizeof(struct SIDL_fcomplex)) ||
          (SIDLArrayElem1(a,i).real != fpowTwo(i)) ||
          (SIDLArrayElem1(a,i).imaginary != fpowTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex) */
}

/*
 * Method:  checkDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkDcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_checkDcomplex(
  struct SIDL_dcomplex__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex) */
  if (a && (1 == SIDL_dcomplex__array_dimen(a)) && (1 == SIDLArrayDim(a)) &&
      (SIDLLower(a,0) == SIDL_dcomplex__array_lower(a,0)) &&
      (SIDLUpper(a,0) == SIDL_dcomplex__array_upper(a,0))) {
    int32_t i, ind[1];
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i) {
      struct SIDL_dcomplex r1 = SIDL_dcomplex__array_get1(a, i);
      struct SIDL_dcomplex r2;
      ind[0] = i;
      r2 = SIDL_dcomplex__array_get(a, ind);
      if (memcmp(&r1, &SIDLArrayElem1(a,i),
                 sizeof(struct SIDL_dcomplex)) ||
          memcmp(&r1, &r2, sizeof(struct SIDL_dcomplex)) ||
          (SIDLArrayElem1(a,i).real != powTwo(i)) ||
          (SIDLArrayElem1(a,i).imaginary != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex) */
}

/*
 * Method:  check2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Int"

SIDL_bool
impl_ArrayTest_ArrayOps_check2Int(
  struct SIDL_int__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int) */
  if (a && (2 == SIDL_int__array_dimen(a)) && (2 == SIDLArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((SIDLLower(a,i) != SIDL_int__array_lower(a,i)) ||
          (SIDLUpper(a,i) != SIDL_int__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i){
      ind[0] = i;
      for(j = SIDLLower(a,1); j <= SIDLUpper(a,1); ++j) {
        ind[1] = j;
        if ((SIDLArrayElem2(a, i, j) != 
             SIDL_int__array_get2(a, i, j)) ||
            (SIDLArrayElem2(a, i, j) !=
             SIDL_int__array_get(a, ind)) ||
            (SIDLArrayElem2(a, i, j) != powTwo(abs(i-j)))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int) */
}

/*
 * Method:  check2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Double"

SIDL_bool
impl_ArrayTest_ArrayOps_check2Double(
  struct SIDL_double__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double) */
  if (a && (2 == SIDL_double__array_dimen(a)) && (2 == SIDLArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((SIDLLower(a,i) != SIDL_double__array_lower(a,i)) ||
          (SIDLUpper(a,i) != SIDL_double__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i){
      for(j = SIDLLower(a,1); j <= SIDLUpper(a,1); ++j) {
        ind[0] = i;
        ind[1] = j;
        if ((SIDLArrayElem2(a, i, j) != 
             SIDL_double__array_get2(a, i, j)) ||
            (SIDLArrayElem2(a, i, j) !=
             SIDL_double__array_get(a, ind)) ||
            (SIDLArrayElem2(a, i, j) != powTwo(i-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double) */
}

/*
 * Method:  check2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Float"

SIDL_bool
impl_ArrayTest_ArrayOps_check2Float(
  struct SIDL_float__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float) */
  if (a && (2 == SIDL_float__array_dimen(a)) && (2 == SIDLArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((SIDLLower(a,i) != SIDL_float__array_lower(a,i)) ||
          (SIDLUpper(a,i) != SIDL_float__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i){
      for(j = SIDLLower(a,1); j <= SIDLUpper(a,1); ++j) {
        ind[0] = i;
        ind[1] = j;
        if ((SIDLArrayElem2(a, i, j) != 
             SIDL_float__array_get2(a, i, j)) ||
            (SIDLArrayElem2(a, i, j) !=
             SIDL_float__array_get(a, ind)) ||
            (SIDLArrayElem2(a, i, j) != fpowTwo(i-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float) */
}

/*
 * Method:  check2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Fcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_check2Fcomplex(
  struct SIDL_fcomplex__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex) */
  if (a && (2 == SIDL_fcomplex__array_dimen(a)) && (2 == SIDLArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((SIDLLower(a,i) != SIDL_fcomplex__array_lower(a,i)) ||
          (SIDLUpper(a,i) != SIDL_fcomplex__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i){
      for(j = SIDLLower(a,1); j <= SIDLUpper(a,1); ++j) {
        struct SIDL_fcomplex r1 = SIDL_fcomplex__array_get2(a, i, j);
        struct SIDL_fcomplex r2;
        ind[0] = i;
        ind[1] = j;
        r2 = SIDL_fcomplex__array_get(a, ind);
        if (memcmp(&r1, &SIDLArrayElem2(a, i, j),
                   sizeof(struct SIDL_fcomplex)) ||
            memcmp(&r1, &r2, sizeof(struct SIDL_fcomplex)) ||
            (SIDLArrayElem2(a, i, j).real != fpowTwo(i)) ||
            (SIDLArrayElem2(a, i, j).imaginary != fpowTwo(-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex) */
}

/*
 * Method:  check2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check2Dcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_check2Dcomplex(
  struct SIDL_dcomplex__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex) */
  if (a && (2 == SIDL_dcomplex__array_dimen(a)) && (2 == SIDLArrayDim(a))) {
    int32_t i, j, ind[2];
    for(i = 0; i < 2; ++i){
      if ((SIDLLower(a,i) != SIDL_dcomplex__array_lower(a,i)) ||
          (SIDLUpper(a,i) != SIDL_dcomplex__array_upper(a,i))) {
        return FALSE;
      }
    }
    for(i = SIDLLower(a,0); i <= SIDLUpper(a,0); ++i){
      for(j = SIDLLower(a,1); j <= SIDLUpper(a,1); ++j) {
        struct SIDL_dcomplex r1 = SIDL_dcomplex__array_get2(a, i, j);
        struct SIDL_dcomplex r2;
        ind[0] = i;
        ind[1] = j;
        r2 = SIDL_dcomplex__array_get(a, ind);
        if (memcmp(&r1, &SIDLArrayElem2(a, i, j),
                   sizeof(struct SIDL_dcomplex)) ||
            memcmp(&r1, &r2, sizeof(struct SIDL_dcomplex)) ||
            (SIDLArrayElem2(a, i, j).real != powTwo(i)) ||
            (SIDLArrayElem2(a, i, j).imaginary != powTwo(-j))) {
          return FALSE;
        }
      }
    }
    return TRUE;
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex) */
}

/*
 * Method:  check3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check3Int"

SIDL_bool
impl_ArrayTest_ArrayOps_check3Int(
  struct SIDL_int__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int) */
  int result = FALSE;
  if (a && SIDL_int__array_dimen(a) == 3) {
    result = TRUE;
    if (hasElements(3, a->d_lower, a->d_upper)) {
      int32_t ind[3], value;
      memcpy(ind, a->d_lower, sizeof(int32_t)*3);
      do {
        value = arrayValue(3, ind);
        switch(rand() % 3) {
        case 0:
          if (SIDLArrayElem3(a, ind[0], ind[1], ind[2]) != value)
            result = FALSE;
          break;
        case 1:
          if (SIDL_int__array_get3(a, ind[0], ind[1], ind[2]) != value)
            result = FALSE;
          break;
        case 2:
          if (SIDL_int__array_get(a, ind) != value)
            result = FALSE;
          break;
        }
      } while (result && nextElem(3, ind, a->d_lower, a->d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int) */
}

/*
 * Method:  check4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_check4Int"

SIDL_bool
impl_ArrayTest_ArrayOps_check4Int(
  struct SIDL_int__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int) */
  int result = FALSE;
  if (a && SIDL_int__array_dimen(a) == 4) {
    result = TRUE;
    if (hasElements(4, a->d_lower, a->d_upper)) {
      int32_t ind[4], value;
      memcpy(ind, a->d_lower, sizeof(int32_t)*4);
      do {
        value = arrayValue(4, ind);
        switch(rand() % 3) {
        case 0:
          if (SIDLArrayElem4(a, ind[0], ind[1], ind[2], ind[3]) != value)
            result = FALSE;
          break;
        case 1:
          if (SIDL_int__array_get4(a, ind[0], ind[1], ind[2], ind[3])
              != value)
            result = FALSE;
          break;
        case 2:
          if (SIDL_int__array_get(a, ind) != value) 
            result = FALSE;
          break;
        }
      } while (result && nextElem(4, ind, a->d_lower, a->d_upper));
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int) */
}

/*
 * Method:  checkObject[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_checkObject"

int32_t
impl_ArrayTest_ArrayOps_checkObject(
  struct ArrayTest_ArrayOps__array* a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject) */
  if (a && ArrayTest_ArrayOps__array_dimen(a) == 1) {
    const int32_t upper = ArrayTest_ArrayOps__array_upper(a, 0);
    int32_t i, count=0;
    for(i = ArrayTest_ArrayOps__array_lower(a, 0); i <= upper; ++i) {
      ArrayTest_ArrayOps obj = ArrayTest_ArrayOps__array_get1(a, i);
      if (ArrayTest_ArrayOps__cast(obj) != NULL) {
        ++count;
        ArrayTest_ArrayOps_deleteRef(obj);
      }
    }
    return count;
  }
  return 0;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject) */
}

/*
 * Method:  reverseBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseBool"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseBool(
  struct SIDL_bool__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_bool__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_bool__array_upper(*a,0);
    const int32_t lower = SIDL_bool__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkBool(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_bool__array
        *copy = SIDL_bool__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_bool__array_set1(copy, upper - i,
                              SIDL_bool__array_get1(*a,lower + i));
      }
      SIDL_bool__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        SIDL_bool tmp = SIDL_bool__array_get1(*a, lower + i);
        SIDL_bool__array_set1(*a, lower + i,
                              SIDL_bool__array_get1(*a, upper - i));
        SIDL_bool__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool) */
}

/*
 * Method:  reverseChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseChar"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseChar(
  struct SIDL_char__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_char__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_char__array_upper(*a,0);
    const int32_t lower = SIDL_char__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkChar(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_char__array
        *copy = SIDL_char__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_char__array_set1(copy, upper - i,
                              SIDL_char__array_get1(*a,lower + i));
      }
      SIDL_char__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        char tmp = SIDL_char__array_get1(*a, lower + i);
        SIDL_char__array_set1(*a, lower + i,
                              SIDL_char__array_get1(*a, upper - i));
        SIDL_char__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar) */
}

/*
 * Method:  reverseInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseInt"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseInt(
  struct SIDL_int__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_int__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_int__array_upper(*a,0);
    const int32_t lower = SIDL_int__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkInt(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_int__array
        *copy = SIDL_int__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_int__array_set1(copy, upper - i,
                             SIDL_int__array_get1(*a,lower + i));
      }
      SIDL_int__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        int32_t tmp = SIDL_int__array_get1(*a, lower + i);
        SIDL_int__array_set1(*a, lower + i,
                             SIDL_int__array_get1(*a, upper - i));
        SIDL_int__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt) */
}

/*
 * Method:  reverseLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseLong"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseLong(
  struct SIDL_long__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_long__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_long__array_upper(*a,0);
    const int32_t lower = SIDL_long__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkLong(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_long__array
        *copy = SIDL_long__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_long__array_set1(copy, upper - i,
                              SIDL_long__array_get1(*a,lower + i));
      }
      SIDL_long__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        int64_t tmp = SIDL_long__array_get1(*a, lower + i);
        SIDL_long__array_set1(*a, lower + i,
                              SIDL_long__array_get1(*a, upper - i));
        SIDL_long__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong) */
}

/*
 * Method:  reverseString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseString"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseString(
  struct SIDL_string__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_string__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_string__array_upper(*a,0);
    const int32_t lower = SIDL_string__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkString(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_string__array
        *copy = SIDL_string__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        char *tmp = SIDL_string__array_get1(*a,lower + i);
        SIDL_string__array_set1(copy, upper - i, tmp);
        free(tmp);
      }
      SIDL_string__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        char *tmp1 = SIDL_string__array_get1(*a, lower + i);
        char *tmp2 = SIDL_string__array_get1(*a, upper - i);
        SIDL_string__array_set1(*a, lower + i, tmp2);
        SIDL_string__array_set1(*a, upper - i, tmp1);
        free(tmp2);
        free(tmp1);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString) */
}

/*
 * Method:  reverseDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseDouble"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseDouble(
  struct SIDL_double__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_double__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_double__array_upper(*a,0);
    const int32_t lower = SIDL_double__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkDouble(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_double__array
        *copy = SIDL_double__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_double__array_set1(copy, upper - i,
                                SIDL_double__array_get1(*a,lower + i));
      }
      SIDL_double__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        double tmp = SIDL_double__array_get1(*a, lower + i);
        SIDL_double__array_set1(*a, lower + i,
                                SIDL_double__array_get1(*a, upper - i));
        SIDL_double__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble) */
}

/*
 * Method:  reverseFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseFloat"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseFloat(
  struct SIDL_float__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_float__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_float__array_upper(*a,0);
    const int32_t lower = SIDL_float__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkFloat(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_float__array
        *copy = SIDL_float__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_float__array_set1(copy, upper - i,
                               SIDL_float__array_get1(*a,lower + i));
      }
      SIDL_float__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        float tmp = SIDL_float__array_get1(*a, lower + i);
        SIDL_float__array_set1(*a, lower + i,
                               SIDL_float__array_get1(*a, upper - i));
        SIDL_float__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat) */
}

/*
 * Method:  reverseFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseFcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseFcomplex(
  struct SIDL_fcomplex__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_fcomplex__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_fcomplex__array_upper(*a,0);
    const int32_t lower = SIDL_fcomplex__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkFcomplex(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_fcomplex__array
        *copy = SIDL_fcomplex__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_fcomplex__array_set1(copy, upper - i,
                                  SIDL_fcomplex__array_get1(*a,lower + i));
      }
      SIDL_fcomplex__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        struct SIDL_fcomplex 
          tmp = SIDL_fcomplex__array_get1(*a, lower + i);
        SIDL_fcomplex__array_set1(*a, lower + i,
                                  SIDL_fcomplex__array_get1(*a, upper - i));
        SIDL_fcomplex__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex) */
}

/*
 * Method:  reverseDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_reverseDcomplex"

SIDL_bool
impl_ArrayTest_ArrayOps_reverseDcomplex(
  struct SIDL_dcomplex__array** a, SIDL_bool newArray)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex) */
  SIDL_bool result = FALSE;
  if (*a && SIDL_dcomplex__array_dimen(*a) == 1) {
    const int32_t upper = SIDL_dcomplex__array_upper(*a,0);
    const int32_t lower = SIDL_dcomplex__array_lower(*a,0);
    result = ArrayTest_ArrayOps_checkDcomplex(*a);
    if (newArray) {
      const int32_t len = upper-lower + 1;
      int32_t i;
      struct SIDL_dcomplex__array
        *copy = SIDL_dcomplex__array_createRow(1,&lower,&upper);
      for(i = 0; i < len; ++i){
        SIDL_dcomplex__array_set1(copy, upper - i,
                                  SIDL_dcomplex__array_get1(*a,lower + i));
      }
      SIDL_dcomplex__array_deleteRef(*a);
      *a = copy;
    }
    else {
      /* reverse in place */
      const int32_t len = (upper - lower + 1) >> 1;
      int32_t i;
      for(i = 0; i < len; ++i ) {
        struct SIDL_dcomplex 
          tmp = SIDL_dcomplex__array_get1(*a, lower + i);
        SIDL_dcomplex__array_set1(*a, lower + i,
                                  SIDL_dcomplex__array_get1(*a, upper - i));
        SIDL_dcomplex__array_set1(*a, upper - i, tmp);
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex) */
}

/*
 * Method:  createBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createBool"

struct SIDL_bool__array*
impl_ArrayTest_ArrayOps_createBool(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool) */
  struct SIDL_bool__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_bool__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = ((i & 0x1) ? FALSE : TRUE);
      break;
    case 1:
      SIDL_bool__array_set1(result, i, ((i & 0x1) ? FALSE : TRUE));
      break;
    case 2:
      SIDL_bool__array_set(result, lower, ((i & 0x1) ? FALSE : TRUE));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool) */
}

/*
 * Method:  createChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createChar"

struct SIDL_char__array*
impl_ArrayTest_ArrayOps_createChar(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar) */
  struct SIDL_char__array* result;
  const char *testStr = s_TestText;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_char__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, testStr = nextChar(testStr)) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = *testStr;
      break;
    case 1:
      SIDL_char__array_set1(result, i, *testStr);
      break;
    case 2:
      SIDL_char__array_set(result, lower, *testStr);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar) */
}

/*
 * Method:  createInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createInt"

struct SIDL_int__array*
impl_ArrayTest_ArrayOps_createInt(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt) */
  struct SIDL_int__array* result;
  int32_t lower[1], upper[1], i, prime = nextPrime(0);
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_int__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, prime = nextPrime(prime)) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = prime;
      break;
    case 1:
      SIDL_int__array_set1(result, i, prime);
      break;
    case 2:
      SIDL_int__array_set(result, lower, prime);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt) */
}

/*
 * Method:  createLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createLong"

struct SIDL_long__array*
impl_ArrayTest_ArrayOps_createLong(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong) */
  struct SIDL_long__array* result;
  int32_t lower[1], upper[1], i;
  int64_t prime = nextPrime(0L);
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_long__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, prime = nextPrime(prime)) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = prime;
      break;
    case 1:
      SIDL_long__array_set1(result, i, prime);
      break;
    case 2:
      SIDL_long__array_set(result, lower, prime);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong) */
}

/*
 * Method:  createString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createString"

struct SIDL_string__array*
impl_ArrayTest_ArrayOps_createString(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString) */
  struct SIDL_string__array* result;
  const char * const *testWord = s_TestWords;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_string__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i, testWord = nextWord(testWord)) {
    lower[0] = i;
    switch(rand() % 2) {
    case 0:
      SIDL_string__array_set1(result, i, *testWord);
      break;
    case 1:
      SIDL_string__array_set(result, lower, *testWord);
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString) */
}

/*
 * Method:  createDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createDouble"

struct SIDL_double__array*
impl_ArrayTest_ArrayOps_createDouble(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble) */
  struct SIDL_double__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_double__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = powTwo(-i);
      break;
    case 1:
      SIDL_double__array_set1(result, i, powTwo(-i));
      break;
    case 2:
      SIDL_double__array_set(result, lower, powTwo(-i));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble) */
}

/*
 * Method:  createFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createFloat"

struct SIDL_float__array*
impl_ArrayTest_ArrayOps_createFloat(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat) */
  struct SIDL_float__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_float__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i) = fpowTwo(-i);
      break;
    case 1:
      SIDL_float__array_set1(result, i, fpowTwo(-i));
      break;
    case 2:
      SIDL_float__array_set(result, lower, fpowTwo(-i));
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat) */
}

/*
 * Method:  createFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createFcomplex"

struct SIDL_fcomplex__array*
impl_ArrayTest_ArrayOps_createFcomplex(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex) */
  struct SIDL_fcomplex__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_fcomplex__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i).real = fpowTwo(i);
      SIDLArrayElem1(result, i).imaginary = fpowTwo(-i);
      break;
    case 1:
      {
        struct SIDL_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
        SIDL_fcomplex__array_set1(result, i, tmp);
      }
      break;
    case 2:
      {
        struct SIDL_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
        SIDL_fcomplex__array_set(result, lower, tmp);
      }
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex) */
}

/*
 * Method:  createDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createDcomplex"

struct SIDL_dcomplex__array*
impl_ArrayTest_ArrayOps_createDcomplex(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex) */
  struct SIDL_dcomplex__array* result;
  int32_t lower[1], upper[1], i;
  if (len < 0) return NULL;
  lower[0] = 0;
  upper[0] = len - 1;
  result = SIDL_dcomplex__array_createRow(1, lower, upper);
  for(i = 0; i < len; ++i) {
    lower[0] = i;
    switch(rand() % 3) {
    case 0:
      SIDLArrayElem1(result, i).real = powTwo(i);
      SIDLArrayElem1(result, i).imaginary = powTwo(-i);
      break;
    case 1:
      {
        struct SIDL_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
        SIDL_dcomplex__array_set1(result, i, tmp);
      }
      break;
    case 2:
      {
        struct SIDL_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
        SIDL_dcomplex__array_set(result, lower, tmp);
      }
      break;
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex) */
}

/*
 * Method:  createObject[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_createObject"

struct ArrayTest_ArrayOps__array*
impl_ArrayTest_ArrayOps_createObject(
  int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject) */
  struct ArrayTest_ArrayOps__array *a = NULL;
  if (len >= 0) {
    int32_t lower = 0, upper = len - 1;
    a = ArrayTest_ArrayOps__array_createRow(1, &lower, &upper);
    while (len--) {
      ArrayTest_ArrayOps obj = ArrayTest_ArrayOps__create();
      ArrayTest_ArrayOps__array_set1(a, len, obj);
      ArrayTest_ArrayOps_deleteRef(obj);
    }
  }
  return a;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject) */
}

/*
 * Method:  create2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Int"

struct SIDL_int__array*
impl_ArrayTest_ArrayOps_create2Int(
  int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int) */
  struct SIDL_int__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = SIDL_int__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result, i, j) = powTwo(abs(i-j));
        break;
      case 1:
        SIDL_int__array_set2(result, i, j, powTwo(abs(i-j)));
        break;
      case 2:
        SIDL_int__array_set(result, lower, powTwo(abs(i-j)));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int) */
}

/*
 * Method:  create2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Double"

struct SIDL_double__array*
impl_ArrayTest_ArrayOps_create2Double(
  int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double) */
  struct SIDL_double__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = SIDL_double__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result, i, j) = powTwo(i-j);
        break;
      case 1:
        SIDL_double__array_set2(result, i, j, powTwo(i-j));
        break;
      case 2:
        SIDL_double__array_set(result, lower, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double) */
}

/*
 * Method:  create2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Float"

struct SIDL_float__array*
impl_ArrayTest_ArrayOps_create2Float(
  int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float) */
  struct SIDL_float__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = SIDL_float__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result, i, j) = powTwo(i-j);
        break;
      case 1:
        SIDL_float__array_set2(result, i, j, powTwo(i-j));
        break;
      case 2:
        SIDL_float__array_set(result, lower, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float) */
}

/*
 * Method:  create2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Dcomplex"

struct SIDL_dcomplex__array*
impl_ArrayTest_ArrayOps_create2Dcomplex(
  int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex) */
  struct SIDL_dcomplex__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = SIDL_dcomplex__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      struct SIDL_dcomplex tmp;
      tmp.real = powTwo(i);
      tmp.imaginary = powTwo(-j);
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result, i, j) = tmp;
        break;
      case 1:
        SIDL_dcomplex__array_set2(result, i, j, tmp);
        break;
      case 2:
        SIDL_dcomplex__array_set(result, lower, tmp);
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex) */
}

/*
 * Method:  create2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create2Fcomplex"

struct SIDL_fcomplex__array*
impl_ArrayTest_ArrayOps_create2Fcomplex(
  int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex) */
  struct SIDL_fcomplex__array* result;
  int32_t lower[2], upper[2], i, j;
  if ((d1 < 0) || (d2 < 0)) return NULL;
  lower[0] = 0;
  upper[0] = d1 - 1;
  lower[1] = 0;
  upper[1] = d2 - 1;
  result = SIDL_fcomplex__array_createRow(2, lower, upper);
  for(i = 0; i < d1; ++i) {
    lower[0] = i;
    for(j = 0; j < d2; ++j) {
      struct SIDL_fcomplex tmp;
      tmp.real = fpowTwo(i);
      tmp.imaginary = fpowTwo(-j);
      lower[1] = j;
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result, i, j) = tmp;
        break;
      case 1:
        SIDL_fcomplex__array_set2(result, i, j, tmp);
        break;
      case 2:
        SIDL_fcomplex__array_set(result, lower, tmp);
        break;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex) */
}

/*
 * Method:  create3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create3Int"

struct SIDL_int__array*
impl_ArrayTest_ArrayOps_create3Int(
void)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int) */
  return makeIntTestMatrix(3);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int) */
}

/*
 * Method:  create4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_create4Int"

struct SIDL_int__array*
impl_ArrayTest_ArrayOps_create4Int(
void)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int) */
  return makeIntTestMatrix(4);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int) */
}

/*
 * Method:  makeBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeBool"

void
impl_ArrayTest_ArrayOps_makeBool(
  int32_t len, struct SIDL_bool__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool) */
  *a =  impl_ArrayTest_ArrayOps_createBool(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool) */
}

/*
 * Method:  makeChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeChar"

void
impl_ArrayTest_ArrayOps_makeChar(
  int32_t len, struct SIDL_char__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar) */
  *a = impl_ArrayTest_ArrayOps_createChar(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar) */
}

/*
 * Method:  makeInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInt"

void
impl_ArrayTest_ArrayOps_makeInt(
  int32_t len, struct SIDL_int__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt) */
  *a = impl_ArrayTest_ArrayOps_createInt(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt) */
}

/*
 * Method:  makeLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeLong"

void
impl_ArrayTest_ArrayOps_makeLong(
  int32_t len, struct SIDL_long__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong) */
  *a = impl_ArrayTest_ArrayOps_createLong(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong) */
}

/*
 * Method:  makeString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeString"

void
impl_ArrayTest_ArrayOps_makeString(
  int32_t len, struct SIDL_string__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString) */
  *a = impl_ArrayTest_ArrayOps_createString(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString) */
}

/*
 * Method:  makeDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeDouble"

void
impl_ArrayTest_ArrayOps_makeDouble(
  int32_t len, struct SIDL_double__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble) */
  *a = impl_ArrayTest_ArrayOps_createDouble(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble) */
}

/*
 * Method:  makeFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeFloat"

void
impl_ArrayTest_ArrayOps_makeFloat(
  int32_t len, struct SIDL_float__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat) */
  *a = impl_ArrayTest_ArrayOps_createFloat(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat) */
}

/*
 * Method:  makeFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeFcomplex"

void
impl_ArrayTest_ArrayOps_makeFcomplex(
  int32_t len, struct SIDL_fcomplex__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex) */
  *a = impl_ArrayTest_ArrayOps_createFcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex) */
}

/*
 * Method:  makeDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeDcomplex"

void
impl_ArrayTest_ArrayOps_makeDcomplex(
  int32_t len, struct SIDL_dcomplex__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex) */
  *a = impl_ArrayTest_ArrayOps_createDcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex) */
}

/*
 * Method:  makeInOutBool[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutBool"

void
impl_ArrayTest_ArrayOps_makeInOutBool(
  struct SIDL_bool__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool) */
  if (*a) SIDL_bool__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createBool(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool) */
}

/*
 * Method:  makeInOutChar[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutChar"

void
impl_ArrayTest_ArrayOps_makeInOutChar(
  struct SIDL_char__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar) */
  if (*a) SIDL_char__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createChar(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar) */
}

/*
 * Method:  makeInOutInt[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutInt"

void
impl_ArrayTest_ArrayOps_makeInOutInt(
  struct SIDL_int__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt) */
  if (*a) SIDL_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createInt(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt) */
}

/*
 * Method:  makeInOutLong[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutLong"

void
impl_ArrayTest_ArrayOps_makeInOutLong(
  struct SIDL_long__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong) */
  if (*a) SIDL_long__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createLong(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong) */
}

/*
 * Method:  makeInOutString[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutString"

void
impl_ArrayTest_ArrayOps_makeInOutString(
  struct SIDL_string__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString) */
  if (*a) SIDL_string__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createString(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString) */
}

/*
 * Method:  makeInOutDouble[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutDouble"

void
impl_ArrayTest_ArrayOps_makeInOutDouble(
  struct SIDL_double__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble) */
  if (*a) SIDL_double__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createDouble(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble) */
}

/*
 * Method:  makeInOutFloat[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutFloat"

void
impl_ArrayTest_ArrayOps_makeInOutFloat(
  struct SIDL_float__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat) */
  if (*a) SIDL_float__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createFloat(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat) */
}

/*
 * Method:  makeInOutDcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutDcomplex"

void
impl_ArrayTest_ArrayOps_makeInOutDcomplex(
  struct SIDL_dcomplex__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex) */
  if (*a) SIDL_dcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createDcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex) */
}

/*
 * Method:  makeInOutFcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOutFcomplex"

void
impl_ArrayTest_ArrayOps_makeInOutFcomplex(
  struct SIDL_fcomplex__array** a, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex) */
  if (*a) SIDL_fcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_createFcomplex(len);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex) */
}

/*
 * Method:  makeInOut2Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Int"

void
impl_ArrayTest_ArrayOps_makeInOut2Int(
  struct SIDL_int__array** a, int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int) */
  if (*a) SIDL_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Int(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int) */
}

/*
 * Method:  makeInOut2Double[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Double"

void
impl_ArrayTest_ArrayOps_makeInOut2Double(
  struct SIDL_double__array** a, int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double) */
  if (*a) SIDL_double__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Double(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double) */
}

/*
 * Method:  makeInOut2Float[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Float"

void
impl_ArrayTest_ArrayOps_makeInOut2Float(
  struct SIDL_float__array** a, int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float) */
  if (*a) SIDL_float__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Float(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float) */
}

/*
 * Method:  makeInOut2Dcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Dcomplex"

void
impl_ArrayTest_ArrayOps_makeInOut2Dcomplex(
  struct SIDL_dcomplex__array** a, int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex) */
  if (*a) SIDL_dcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Dcomplex(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex) */
}

/*
 * Method:  makeInOut2Fcomplex[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut2Fcomplex"

void
impl_ArrayTest_ArrayOps_makeInOut2Fcomplex(
  struct SIDL_fcomplex__array** a, int32_t d1, int32_t d2)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex) */
  if (*a) SIDL_fcomplex__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create2Fcomplex(d1, d2);
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex) */
}

/*
 * Method:  makeInOut3Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut3Int"

void
impl_ArrayTest_ArrayOps_makeInOut3Int(
  struct SIDL_int__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int) */
  if (*a) SIDL_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create3Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int) */
}

/*
 * Method:  makeInOut4Int[]
 */

#undef __FUNC__
#define __FUNC__ "impl_ArrayTest_ArrayOps_makeInOut4Int"

void
impl_ArrayTest_ArrayOps_makeInOut4Int(
  struct SIDL_int__array** a)
{
  /* DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int) */
  if (*a) SIDL_int__array_deleteRef(*a);
  *a = impl_ArrayTest_ArrayOps_create4Int();
  /* DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int) */
}
