// 
// File:          ArrayTest_ArrayOps_Impl.cc
// Symbol:        ArrayTest.ArrayOps-v1.2
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for ArrayTest.ArrayOps
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "ArrayTest_ArrayOps_Impl.hh"

// DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._includes)
#include "SIDLArray.h"

double powTwo(int32_t i) {
  double result = 1;
  if (i >= 0) {
    while (i--) {
      result *= 2;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5;
    }
  }
  return result;
}

float fpowTwo(int32_t i) {
  register float result = 1.0F;
  static volatile float forcestore; /* force memory storage on x86 architectures */
  if (i >= 0) {
    while (i--) {
      result *= 2.0F;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5F;
    }
  }
  forcestore = result;
  return forcestore;
}

static int isPrime(const int64_t num) {
  register int64_t i;
  for(i = 3; i*i <= num; ++i) {
    if (!(num % i)) return 0;
  }
  return 1;
}

int64_t
nextPrime(int64_t prev) {
  if (prev <= 1L) {
    return 2L;
  }
  else if (prev == 2L) {
    return 3L;
  }
  else {
    do {
      prev += 2;
    } while (!isPrime(prev));
    return prev;
  }
}

static const char s_TestText[] = "\
I'd rather write programs to write programs than write programs.";

static const char *s_TestWords[] = {
  "I'd",
  "rather",
  "write",
  "programs",
  "to",
  "write",
  "programs",
  "than",
  "write",
  "programs.",
  NULL
};

const char *nextChar(const char *str) {
  if (!*(++str)) {
    str = s_TestText;
  }
  return str;
}

const char * const* nextWord(const char *const*word) {
  if (!*(++word)){
    word = s_TestWords;
  }
  return word;
}

static bool
nextElem(const int32_t dimen,
         int32_t ind[],
         const int32_t lower[],
         const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static int32_t
arrayValue(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0; i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static bool
hasElements(const int dimen, const int32_t lower[], const int32_t upper[])
{
  int i;
  for (i = 0; i < dimen; ++i){
    if (lower[i] > upper[i]) return false;
  }
  return true;
}

static int32_t intFunc(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0;i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static bool
next(const int dimen, int32_t ind[],
     const int32_t lower[], const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static SIDL::array<int32_t>
makeIntTestMatrix(int dimen)
{
  struct SIDL::array<int32_t> result;
  static const int32_t lower[] = {0, 0, 0, 0};
  static const int32_t upper[] = {3, 3, 2, 2};
  int32_t ind[] = {0, 0, 0, 0};
  int32_t value;
  result  = SIDL::array<int32_t>::createCol(dimen, lower, upper);
  do {
    value = intFunc(dimen, ind);
    switch(rand() % 2) {
    case 0:
      if (dimen == 3) {
        result.set(ind[0], ind[1], ind[2], value);
      }
      else {
        result.set(ind[0], ind[1], ind[2], ind[3], value);
      }
      break;
    case 1:
      result.set(ind, value);
      break;
    }
  } while (next(dimen, ind, lower, upper));
  return result;
}
// DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._includes)

// user defined constructor
void ArrayTest::ArrayOps_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor)
}

// user defined destructor
void ArrayTest::ArrayOps_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor)
}

// user defined static methods:
/**
 * Return <code>true</code> iff the even elements are true and
 * the odd elements are false.
 */
bool
ArrayTest::ArrayOps_impl::checkBool (
  /*in*/ ::SIDL::array<bool> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool)
  if ( a._is_nil() ||
       ( a.dimen() != 1) ||
       (SIDLArrayDim(a._get_ior()) != 1) ||
       (a.lower(0) != SIDLLower(a._get_ior(),0)) ||
       (a.upper(0) != SIDLUpper(a._get_ior(),0)) ) {
    return false;
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i) {
    if ( ( a.get(i) != SIDL_bool__array_get1(a._get_ior(), i ) ) ||
	 ( a.get(i) != ((i & 0x1) ? FALSE : TRUE) ) ) { 
      return false;
    }    
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool)
}

/**
 * Method:  checkChar[]
 */
bool
ArrayTest::ArrayOps_impl::checkChar (
  /*in*/ ::SIDL::array<char> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar)
  if ( a._is_nil() ||
       ( a.dimen() != 1) ||
       (SIDLArrayDim(a._get_ior()) != 1) ||
       (a.lower(0) != SIDLLower(a._get_ior(),0)) ||
       (a.upper(0) != SIDLUpper(a._get_ior(),0)) ) {
    return false;
  }
  const char * testStr = s_TestText;
  for( int32_t i=a.lower(0); i<a.upper(0); ++i, testStr = nextChar(testStr) ) {
    if ( ( a.get(i) != SIDL_char__array_get1(a._get_ior(), i ) ) ||
	 ( a.get(i) != *testStr ) ) { 
      return false;
    }    
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar)
}

/**
 * Method:  checkInt[]
 */
bool
ArrayTest::ArrayOps_impl::checkInt (
  /*in*/ ::SIDL::array<int32_t> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( SIDLArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
      ( a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  int32_t prime = nextPrime(0);
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i, prime = nextPrime(prime) ) { 
    if ( ( a.get(i) != SIDLArrayElem1(a._get_ior(), i) ) ||
	   ( a.get(i) != prime ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt)
}

/**
 * Method:  checkLong[]
 */
bool
ArrayTest::ArrayOps_impl::checkLong (
  /*in*/ ::SIDL::array<int64_t> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( SIDLArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
      ( a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  int64_t prime = nextPrime(0);
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i, prime = nextPrime(prime) ) { 
    if ( ( a.get(i) != SIDLArrayElem1(a._get_ior(), i) ) ||
	 ( a.get(i) != prime ) ) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong)
}

/**
 * Method:  checkString[]
 */
bool
ArrayTest::ArrayOps_impl::checkString (
  /*in*/ ::SIDL::array< ::std::string> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const char * const * testWord = s_TestWords;
  for(int32_t i=a.lower(0); i<=a.upper(0); 
      ++i, testWord = nextWord(testWord) ) { 
    char * s1 = SIDL_string__array_get1(a._get_ior(), i);
    std::string s2 = a.get(i);
    //const char * s2c_str = s2.c_str();
    //int size = s2.size();
    //int cmp1 = strcmp(s1,s2.c_str());
    //int cmp2 = strcmp(s2.c_str(),*testWord);
    if ( !s1 || 
	 (s2.size() == 0) ||
	 strcmp(s1,s2.c_str()) ||
	 strcmp(s2.c_str(),*testWord) ) { 
      free(s1);
      return false;
    }
    free(s1);
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString)
}

/**
 * Method:  checkDouble[]
 */
bool
ArrayTest::ArrayOps_impl::checkDouble (
  /*in*/ ::SIDL::array<double> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( SIDLArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
      ( a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i ) { 
    if ( ( a.get(i) != SIDLArrayElem1(a._get_ior(), i) ) ||
	 ( a.get(i) != powTwo(-i) ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble)
}

/**
 * Method:  checkFloat[]
 */
bool
ArrayTest::ArrayOps_impl::checkFloat (
  /*in*/ ::SIDL::array<float> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( SIDLArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
      ( a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i ) { 
    if ( ( a.get(i) != SIDLArrayElem1(a._get_ior(), i) ) ||
	   ( a.get(i) != fpowTwo(-i) ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat)
}

/**
 * Method:  checkFcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::checkFcomplex (
  /*in*/ ::SIDL::array< ::SIDL::fcomplex> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex)
  if ( a._is_nil() ||
       (a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
       (a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    std::complex<double> r1 = a.get(i);
    if ( (r1.real() != SIDLArrayElem1(a._get_ior(), i).real ) ||
	 (r1.imag() != SIDLArrayElem1(a._get_ior(), i).imaginary ) ||
	 (r1.real() != fpowTwo(i)) ||
	 (r1.imag() != fpowTwo(-i))) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex)
}

/**
 * Method:  checkDcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::checkDcomplex (
  /*in*/ ::SIDL::array< ::SIDL::dcomplex> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex)
  if ( a._is_nil() ||
       (a.lower(0) != SIDLLower(a._get_ior(),0) ) ||
       (a.upper(0) != SIDLUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    std::complex<double> r1 = a.get(i);
    if ( (r1.real() != SIDLArrayElem1(a._get_ior(), i).real ) ||
	 (r1.imag() != SIDLArrayElem1(a._get_ior(), i).imaginary ) ||
	 (r1.real() != powTwo(i)) ||
	 (r1.imag() != powTwo(-i))) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex)
}

/**
 * Method:  check2Int[]
 */
bool
ArrayTest::ArrayOps_impl::check2Int (
  /*in*/ ::SIDL::array<int32_t> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( SIDLArrayDim(a._get_ior())) != 2 ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != SIDLLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != SIDLUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != SIDLArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != (int)powTwo(abs(i-j)) ) ) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int)
}

/**
 * Method:  check2Double[]
 */
bool
ArrayTest::ArrayOps_impl::check2Double (
  /*in*/ ::SIDL::array<double> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( SIDLArrayDim(a._get_ior())) != 2 ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != SIDLLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != SIDLUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != SIDLArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != powTwo(i-j) ) ) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double)
}

/**
 * Method:  check2Float[]
 */
bool
ArrayTest::ArrayOps_impl::check2Float (
  /*in*/ ::SIDL::array<float> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float)
  if ( a._is_nil() ||
       ( a.dimen() != 2 ) || 
       ( SIDLArrayDim(a._get_ior()) != 2 ) ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != SIDLLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != SIDLUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != SIDLArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != powTwo(i-j) ) ) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float)
}

/**
 * Method:  check2Fcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::check2Fcomplex (
  /*in*/ ::SIDL::array< ::SIDL::fcomplex> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex)
  if ( a._is_nil() ||
       (a.dimen() != 2) || 
       (SIDLArrayDim(a._get_ior()) != 2) ) { 
    return false;
  }
  for(int i = 0; i < 2; ++i){
    if ( ( a.lower(i) != SIDLLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != SIDLUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  } 
  for( int32_t i = a.lower(0); i<= a.upper(0); ++i ) { 
    for( int32_t j = a.lower(1); j<= a.upper(1); ++j ) { 
      std::complex<float> r1 = a.get(i,j);
      if ( (r1.real() != SIDLArrayElem2(a._get_ior(), i, j).real ) ||
	   (r1.imag() != SIDLArrayElem2(a._get_ior(), i, j).imaginary ) ||
	   (r1.real() != powTwo(i)) ||
	   (r1.imag() != powTwo(-j))) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex)
}

/**
 * Method:  check2Dcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::check2Dcomplex (
  /*in*/ ::SIDL::array< ::SIDL::dcomplex> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( SIDLArrayDim(a._get_ior()) != 2)) { 
    return false;
  }
  for(int i = 0; i < 2; ++i){
    if ( ( a.lower(i) != SIDLLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != SIDLUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  } 
  for( int32_t i = a.lower(0); i<= a.upper(0); ++i ) { 
    for( int32_t j = a.lower(1); j<= a.upper(1); ++j ) { 
      std::complex<double> r1 = a.get(i,j);
      if ( (r1.real() != SIDLArrayElem2(a._get_ior(), i, j).real ) ||
	   (r1.imag() != SIDLArrayElem2(a._get_ior(), i, j).imaginary ) ||
	   (r1.real() != powTwo(i)) ||
	   (r1.imag() != powTwo(-j))) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex)
}

/**
 * Method:  check3Int[]
 */
bool
ArrayTest::ArrayOps_impl::check3Int (
  /*in*/ ::SIDL::array<int32_t> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int)
  int i;
  int32_t ind[3], lower[3], upper[3], value;
  bool result = false;
  if (a.dimen() == 3) {
    for(i = 0; i < 3; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(3, lower, upper)) {
      do {
	value = arrayValue(3, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(3, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int)
}

/**
 * Method:  check4Int[]
 */
bool
ArrayTest::ArrayOps_impl::check4Int (
  /*in*/ ::SIDL::array<int32_t> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int)
  int i;
  int32_t ind[4], lower[4], upper[4], value;
  bool result = false;
  if (a.dimen() == 4) {
    for(i = 0; i < 4; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(4, lower, upper)) {
      do {
	value = arrayValue(4, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2], ind[3]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(4, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int)
}

/**
 * Method:  checkObject[]
 */
int32_t
ArrayTest::ArrayOps_impl::checkObject (
  /*in*/ ::SIDL::array< ::ArrayTest::ArrayOps> a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject)
  if ( a._is_nil() ||
       (a.dimen() != 1 ) ) { 
    return 0;
  }
  int32_t count=0;
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    ArrayTest::ArrayOps ops = a.get(i);
    if ( ops._is_nil() ) { 
      ;
    } else { 
      ++count;
    }
  }
  return count;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject)
}

/**
 * Method:  reverseBool[]
 */
bool
ArrayTest::ArrayOps_impl::reverseBool (
  /*inout*/ ::SIDL::array<bool>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool)
  if ( !a ||
       a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkBool(a);
  
  if (newArray) { // build a new array that is the reverse of the old one
    const int32_t len = upper - lower + 1;
    SIDL::array<bool> copy = SIDL::array<bool>::createRow(1,&lower,&upper);
    for(int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1) >> 1;
    for ( int32_t i=0; i<len; ++i ) { 
      bool temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }      
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool)
}

/**
 * Method:  reverseChar[]
 */
bool
ArrayTest::ArrayOps_impl::reverseChar (
  /*inout*/ ::SIDL::array<char>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar)
  if ( !a ||
       a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkChar(a);
  
  if (newArray) { // build a new array that is the reverse of the old one
    const int32_t len = upper - lower + 1;
    SIDL::array<char> copy = SIDL::array<char>::createRow(1,&lower,&upper);
    for(int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1) >> 1;
    for ( int32_t i=0; i<len; ++i ) { 
      char temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }      
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar)
}

/**
 * Method:  reverseInt[]
 */
bool
ArrayTest::ArrayOps_impl::reverseInt (
  /*inout*/ ::SIDL::array<int32_t>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkInt(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<int32_t> copy = SIDL::array<int32_t>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      int32_t temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt)
}

/**
 * Method:  reverseLong[]
 */
bool
ArrayTest::ArrayOps_impl::reverseLong (
  /*inout*/ ::SIDL::array<int64_t>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkLong(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<int64_t> copy = SIDL::array<int64_t>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      int64_t temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong)
}

/**
 * Method:  reverseString[]
 */
bool
ArrayTest::ArrayOps_impl::reverseString (
  /*inout*/ ::SIDL::array< ::std::string>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkString(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<std::string> copy = SIDL::array<std::string>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::string temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString)
}

/**
 * Method:  reverseDouble[]
 */
bool
ArrayTest::ArrayOps_impl::reverseDouble (
  /*inout*/ ::SIDL::array<double>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkDouble(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<double> copy = SIDL::array<double>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      double temp = a.get(lower+i);
      a.set(lower+i,a.get(upper-i));
      a.set(upper-i,temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble)
}

/**
 * Method:  reverseFloat[]
 */
bool
ArrayTest::ArrayOps_impl::reverseFloat (
  /*inout*/ ::SIDL::array<float>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkFloat(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<float> copy = SIDL::array<float>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      float temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat)
}

/**
 * Method:  reverseFcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::reverseFcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::fcomplex>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkFcomplex(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<SIDL::fcomplex> copy = SIDL::array<SIDL::fcomplex>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::complex<float> temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex)
}

/**
 * Method:  reverseDcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::reverseDcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::dcomplex>& a,
  /*in*/ bool newArray ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkDcomplex(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    SIDL::array<SIDL::dcomplex> copy = SIDL::array<SIDL::dcomplex>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::complex<double> temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex)
}

/**
 * Method:  createBool[]
 */
::SIDL::array<bool>
ArrayTest::ArrayOps_impl::createBool (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<bool> result = SIDL::array<bool>::createRow(1,lower,upper);
  
  for( int32_t i=0; i<len; ++i ) { 
    switch( rand() % 3) { 
    case 0:
      SIDLArrayElem1(result._get_ior(),i) = ((i & 0x1) ? FALSE : TRUE);
      break;
    case 1:
      SIDL_bool__array_set1(result._get_ior(), i, ((i & 0x1) ? FALSE : TRUE));
      break;
    case 2:
      result.set(i, ((i & 0x1) ? FALSE : TRUE));
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool)
}

/**
 * Method:  createChar[]
 */
::SIDL::array<char>
ArrayTest::ArrayOps_impl::createChar (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<char> result = SIDL::array<char>::createRow(1,lower,upper);
  
  const char* testStr = s_TestText;
  for( int32_t i=0; i<len; ++i, testStr=nextChar(testStr) ) { 
    switch( rand() % 3) { 
    case 0:
      SIDLArrayElem1(result._get_ior(),i) = *testStr;
      break;
    case 1:
      SIDL_char__array_set1(result._get_ior(), i, *testStr);
      break;
    case 2:
      result.set(i, *testStr);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar)
}

/**
 * Method:  createInt[]
 */
::SIDL::array<int32_t>
ArrayTest::ArrayOps_impl::createInt (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  int32_t prime = nextPrime(0);
  SIDL::array<int32_t> result = SIDL::array<int32_t>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, prime = nextPrime(prime) ) { 
    switch( rand()%3 ) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i ) = prime;
      break;
    case 1:
      SIDL_int__array_set1(result._get_ior(), i, prime );
      break;
    case 2:
      result.set(i, prime);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt)
}

/**
 * Method:  createLong[]
 */
::SIDL::array<int64_t>
ArrayTest::ArrayOps_impl::createLong (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  int64_t prime = nextPrime(0);
  SIDL::array<int64_t> result = SIDL::array<int64_t>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, prime = nextPrime(prime) ) { 
    switch( rand()%3 ) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i ) = prime;
      break;
    case 1:
      SIDL_long__array_set1(result._get_ior(), i, prime );
      break;
    case 2:
      result.set(i, prime);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong)
}

/**
 * Method:  createString[]
 */
::SIDL::array< ::std::string>
ArrayTest::ArrayOps_impl::createString (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString)
  if (len < 0) return NULL;
  const char* const * testWord = s_TestWords;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<std::string> result = SIDL::array<std::string>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, testWord = nextWord(testWord)) { 
    switch(rand()%2) { 
    case 0:
      SIDL_string__array_set1( result._get_ior(), i, *testWord );
      break;
    case 1:
      result.set(i, *testWord);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString)
}

/**
 * Method:  createDouble[]
 */
::SIDL::array<double>
ArrayTest::ArrayOps_impl::createDouble (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<double> result = SIDL::array<double>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand()%3) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i) = powTwo(-i);
      break;
    case 1:
      SIDL_double__array_set1(result._get_ior(), i, powTwo(-i) );
      break;
    case 2:
      result.set(i, powTwo(-i));
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble)
}

/**
 * Method:  createFloat[]
 */
::SIDL::array<float>
ArrayTest::ArrayOps_impl::createFloat (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<float> result = SIDL::array<float>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand()%3) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i) = powTwo(-i);
      break;
    case 1:
      SIDL_float__array_set1(result._get_ior(), i, powTwo(-i) );
      break;
    case 2:
      result.set(i, powTwo(-i) );
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat)
}

/**
 * Method:  createFcomplex[]
 */
::SIDL::array< ::SIDL::fcomplex>
ArrayTest::ArrayOps_impl::createFcomplex (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<SIDL::fcomplex> result = SIDL::array<SIDL::fcomplex>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand() % 3 ) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i).real = fpowTwo(i);
      SIDLArrayElem1(result._get_ior(), i).imaginary = fpowTwo(-i);
      break;
    case 1:
      { 
	struct SIDL_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
	SIDL_fcomplex__array_set1(result._get_ior(), i, tmp);
      }
      break;
    case 2:
      {
	std::complex<float> f( fpowTwo(i), fpowTwo(-i) );
	result.set(i,f);
      }
      break;
      
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex)
}

/**
 * Method:  createDcomplex[]
 */
::SIDL::array< ::SIDL::dcomplex>
ArrayTest::ArrayOps_impl::createDcomplex (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  SIDL::array<SIDL::dcomplex> result= SIDL::array<SIDL::dcomplex>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand() % 3 ) { 
    case 0:
      SIDLArrayElem1(result._get_ior(), i).real = powTwo(i);
      SIDLArrayElem1(result._get_ior(), i).imaginary = powTwo(-i);
      break;
    case 1:
      { 
	struct SIDL_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
	SIDL_dcomplex__array_set1(result._get_ior(), i, tmp);
      }
      break;
    case 2:
      {
	std::complex<double> d( powTwo(i), powTwo(-i) );
	result.set(i,d);
      }
      break;
      
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex)
}

/**
 * Method:  createObject[]
 */
::SIDL::array< ::ArrayTest::ArrayOps>
ArrayTest::ArrayOps_impl::createObject (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject)
  SIDL::array<ArrayTest::ArrayOps> a;
  if ( len >= 0 ) { 
    int32_t lower = 0;
    int32_t upper = len-1;
    a = SIDL::array<ArrayTest::ArrayOps>::createRow(1,&lower,&upper);
    while( len--) { 
      ArrayTest::ArrayOps obj = ArrayTest::ArrayOps::_create();
      a.set(len,obj);
    }
  }
  return a;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject)
}

/**
 * Method:  create2Int[]
 */
::SIDL::array<int32_t>
ArrayTest::ArrayOps_impl::create2Int (
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  SIDL::array<int32_t> result = SIDL::array<int32_t>::createRow(2,lower,upper);
  for( int32_t i=0; i<d1; ++i ) {
    for( int32_t j=0;  j<d2; ++j ) {
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = (int)powTwo(abs(i-j));
        break;
      case 1:
        SIDL_int__array_set2(result._get_ior(), i, j, (int)powTwo(abs(i-j)));
        break;
      case 2:
        result.set(i, j, (int)powTwo(abs(i-j)));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int)
}

/**
 * Method:  create2Double[]
 */
::SIDL::array<double>
ArrayTest::ArrayOps_impl::create2Double (
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  SIDL::array<double> result = SIDL::array<double>::createRow(2,lower,upper);
  for( int32_t i=0; i<d1; ++i ) {
    for( int32_t j=0;  j<d2; ++j ) {
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        SIDL_double__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double)
}

/**
 * Method:  create2Float[]
 */
::SIDL::array<float>
ArrayTest::ArrayOps_impl::create2Float (
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = { d1-1, d2-1};
  SIDL::array<float> result = SIDL::array<float>::createRow(2, lower, upper);
  for( int32_t i=0; i<d1; ++i) {
    for( int32_t j=0; j<d2; ++j) {
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        SIDL_float__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float)
}

/**
 * Method:  create2Dcomplex[]
 */
::SIDL::array< ::SIDL::dcomplex>
ArrayTest::ArrayOps_impl::create2Dcomplex (
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  SIDL::array<SIDL::dcomplex> result = SIDL::array<SIDL::dcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<d1; ++i) {
    for(int32_t j=0; j<d2; ++j) {
      std::complex<double> tmp( powTwo(i), powTwo(-j) );
      struct SIDL_dcomplex tmp2;
      tmp2.real = tmp.real();
      tmp2.imaginary = tmp.imag();
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = tmp2;
        break;
      case 1:
        SIDL_dcomplex__array_set2(result._get_ior(), i, j, tmp2);
        break;
      case 2:
        result.set(i, j, tmp);
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex)
}

/**
 * Method:  create2Fcomplex[]
 */
::SIDL::array< ::SIDL::fcomplex>
ArrayTest::ArrayOps_impl::create2Fcomplex (
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0,0};
  int32_t upper[2] = { d1-1, d2-1};
  SIDL::array<SIDL::fcomplex> result = SIDL::array<SIDL::fcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<d1; ++i) {
    for(int32_t j=0; j<d2; ++j) {
      std::complex<float> tmp2( fpowTwo(i), fpowTwo(-j) );
      struct SIDL_fcomplex tmp;
      tmp.real = fpowTwo(i);
      tmp.imaginary = fpowTwo(-j);
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = tmp;
        break;
      case 1:
        SIDL_fcomplex__array_set2(result._get_ior(), i, j, tmp);
        break;
      case 2:
        result.set(i, j, tmp2);
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex)
}

/**
 * Method:  create3Int[]
 */
::SIDL::array<int32_t>
ArrayTest::ArrayOps_impl::create3Int () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int)
  return makeIntTestMatrix(3);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int)
}

/**
 * Method:  create4Int[]
 */
::SIDL::array<int32_t>
ArrayTest::ArrayOps_impl::create4Int () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int)
  return makeIntTestMatrix(4);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int)
}

/**
 * Method:  makeBool[]
 */
void
ArrayTest::ArrayOps_impl::makeBool (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<bool>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool)
  a = ArrayTest::ArrayOps::createBool(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool)
}

/**
 * Method:  makeChar[]
 */
void
ArrayTest::ArrayOps_impl::makeChar (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<char>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar)
  a = ArrayTest::ArrayOps::createChar(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar)
}

/**
 * Method:  makeInt[]
 */
void
ArrayTest::ArrayOps_impl::makeInt (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<int32_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt)
  a = ArrayTest::ArrayOps::createInt(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt)
}

/**
 * Method:  makeLong[]
 */
void
ArrayTest::ArrayOps_impl::makeLong (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<int64_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong)
  a = ArrayTest::ArrayOps::createLong(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong)
}

/**
 * Method:  makeString[]
 */
void
ArrayTest::ArrayOps_impl::makeString (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array< ::std::string>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString)
  a = ArrayTest::ArrayOps::createString(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString)
}

/**
 * Method:  makeDouble[]
 */
void
ArrayTest::ArrayOps_impl::makeDouble (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<double>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble)
  a = ArrayTest::ArrayOps::createDouble(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble)
}

/**
 * Method:  makeFloat[]
 */
void
ArrayTest::ArrayOps_impl::makeFloat (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array<float>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat)
  a = ArrayTest::ArrayOps::createFloat(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat)
}

/**
 * Method:  makeFcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeFcomplex (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array< ::SIDL::fcomplex>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex)
  a = ArrayTest::ArrayOps::createFcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex)
}

/**
 * Method:  makeDcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeDcomplex (
  /*in*/ int32_t len,
  /*out*/ ::SIDL::array< ::SIDL::dcomplex>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex)
  a = ArrayTest::ArrayOps::createDcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex)
}

/**
 * Method:  makeInOutBool[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutBool (
  /*inout*/ ::SIDL::array<bool>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool)
  a = ArrayTest::ArrayOps::createBool(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool)
}

/**
 * Method:  makeInOutChar[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutChar (
  /*inout*/ ::SIDL::array<char>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar)
  a = ArrayTest::ArrayOps::createChar(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar)
}

/**
 * Method:  makeInOutInt[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutInt (
  /*inout*/ ::SIDL::array<int32_t>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt)
  a = ArrayTest::ArrayOps::createInt(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt)
}

/**
 * Method:  makeInOutLong[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutLong (
  /*inout*/ ::SIDL::array<int64_t>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong)
  a = ArrayTest::ArrayOps::createLong(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong)
}

/**
 * Method:  makeInOutString[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutString (
  /*inout*/ ::SIDL::array< ::std::string>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString)
  a = ArrayTest::ArrayOps::createString(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString)
}

/**
 * Method:  makeInOutDouble[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutDouble (
  /*inout*/ ::SIDL::array<double>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble)
  a = ArrayTest::ArrayOps::createDouble(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble)
}

/**
 * Method:  makeInOutFloat[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutFloat (
  /*inout*/ ::SIDL::array<float>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat)
  a = ArrayTest::ArrayOps::createFloat(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat)
}

/**
 * Method:  makeInOutDcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutDcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::dcomplex>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex)
  a = ArrayTest::ArrayOps::createDcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex)
}

/**
 * Method:  makeInOutFcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutFcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::fcomplex>& a,
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex)
  a = ArrayTest::ArrayOps::createFcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex)
}

/**
 * Method:  makeInOut2Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Int (
  /*inout*/ ::SIDL::array<int32_t>& a,
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int)
  a = ArrayTest::ArrayOps::create2Int(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int)
}

/**
 * Method:  makeInOut2Double[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Double (
  /*inout*/ ::SIDL::array<double>& a,
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double)
  a = ArrayTest::ArrayOps::create2Double(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double)
}

/**
 * Method:  makeInOut2Float[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Float (
  /*inout*/ ::SIDL::array<float>& a,
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float)
  a = ArrayTest::ArrayOps::create2Float(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float)
}

/**
 * Method:  makeInOut2Dcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Dcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::dcomplex>& a,
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex)
  a = ArrayTest::ArrayOps::create2Dcomplex(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex)
}

/**
 * Method:  makeInOut2Fcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Fcomplex (
  /*inout*/ ::SIDL::array< ::SIDL::fcomplex>& a,
  /*in*/ int32_t d1,
  /*in*/ int32_t d2 ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex)
  a = ArrayTest::ArrayOps::create2Fcomplex(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex)
}

/**
 * Method:  makeInOut3Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut3Int (
  /*inout*/ ::SIDL::array<int32_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int)
  a = ArrayTest::ArrayOps::create3Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int)
}

/**
 * Method:  makeInOut4Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut4Int (
  /*inout*/ ::SIDL::array<int32_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int)
  a = ArrayTest::ArrayOps::create4Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int)
}


// user defined non-static methods: (none)

// DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._misc)

