! 
! File:          ArrayTest_ArrayOps_Impl.F90
! Symbol:        ArrayTest.ArrayOps-v1.2
! Symbol Type:   class
! Babel Version: 0.8.8
! Description:   Server-side implementation for ArrayTest.ArrayOps
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.8.8
! 


! 
! Symbol "ArrayTest.ArrayOps" (version 1.2)
! 


#include "ArrayTest_ArrayOps_fAbbrev.h"
#include "SIDL_BaseInterface_fAbbrev.h"
#include "SIDL_BaseClass_fAbbrev.h"
#include "SIDL_ClassInfo_fAbbrev.h"
#include "SIDL_int_fAbbrev.h"
#include "SIDL_dcomplex_fAbbrev.h"
#include "SIDL_float_fAbbrev.h"
#include "SIDL_long_fAbbrev.h"
#include "SIDL_fcomplex_fAbbrev.h"
#include "SIDL_bool_fAbbrev.h"
#include "SIDL_char_fAbbrev.h"
#include "SIDL_double_fAbbrev.h"
#include "SIDL_string_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
#include "babel_config.h"

logical function isprime(num)
  implicit none
  integer (selected_int_kind(18)) :: num
  integer (selected_int_kind(18)) :: i
  i = 3
  do while (i*i .le. num)
     if (mod(num,i) .eq. 0) then
        isprime = .false.
        return
     endif
     i = i + 1
  enddo
  isprime = .true.
  return
end function isprime


integer (selected_int_kind(18)) function nextprime(prev)
  implicit none
  integer (selected_int_kind(18)) :: prev
  logical :: isprime
  if (prev .le. 1) then
     nextprime = 2
     return
  endif
  if (prev .eq. 2) then
     nextprime = 3
     return
  endif
  prev = prev + 2
  do while (.not. isprime(prev))
     prev = prev + 2
  enddo
  nextprime = prev
  return
end function nextprime

subroutine force_float(f)
  real(selected_real_kind(6,37)) :: f
  return
end subroutine force_float

subroutine force_fcomplex(f)
  complex(selected_real_kind(6,37)) :: f
  return
end subroutine force_fcomplex

logical function iseven(num)
  integer (selected_int_kind(9))  :: num
  iseven = (mod(num, 2) .eq. 0)
  return
end function iseven

integer (selected_int_kind(9)) function arrayValue(dim, ind)
  implicit none
  integer (selected_int_kind(9)) :: dim, result, i
  integer (selected_int_kind(9)) :: ind(dim)
  result = 1
  do i = 1, dim
     result = result * (ind(i) + i)
  enddo
  arrayValue = result
end function arrayValue

integer (selected_int_kind(9)) function intFunc(dim, ind)
  implicit none
  integer (selected_int_kind(9)) :: dim, ind(dim), i, result
  result = 1
  do i = 1, dim
    result = result * (ind(i) + i)
  enddo
  intFunc = result
  return
end

logical function hasElements(dim, low, up)
  implicit none
  integer (selected_int_kind(9)) :: dim, low(dim), up(dim)
  integer (selected_int_kind(9)) :: i
  hasElements = .true.
  do i = 1, dim
     if (low(i) .gt. up(i)) then
        hasElements = .false.
     endif
  enddo
end function hasElements

logical function nextElem(dim, ind, low, up)
  implicit none
  integer (selected_int_kind(9)) :: dim
  integer (selected_int_kind(9)) :: ind(dim), low(dim), up(dim)
  integer (selected_int_kind(9)) :: i
  i = 1
  ind(i) = ind(i) + 1
  do while ((i .le. dim) .and. (ind(i) .gt. up(i)))
     ind(i) = low(i)
     i = i + 1
     if (i .le. dim) then
        ind(i) = ind(i) + 1
     endif
  enddo
  nextElem = (i .le. dim)
end function nextElem
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine ArrayTest_ArrayOps__ctor_mi(self)
  use ArrayTest_ArrayOps
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor.use)
  implicit none
  type(ArrayTest_ArrayOps_t) :: self

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor)
end subroutine ArrayTest_ArrayOps__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine ArrayTest_ArrayOps__dtor_mi(self)
  use ArrayTest_ArrayOps
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor.use)
  implicit none
  type(ArrayTest_ArrayOps_t) :: self

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor)
end subroutine ArrayTest_ArrayOps__dtor_mi


! 
! Return <code>true</code> iff the even elements are true and
! the odd elements are false.
! 

recursive subroutine ArrayTest_ArrayOps_checkBool_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_bool_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool.use)
  implicit none
  type(SIDL_bool_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool)
  logical :: value1, value2
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  integer (selected_int_kind(9)) :: testind
  logical :: isEven
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           index(1) = low + i
           call get(a, index(1), value1)
           call get(a, index, value2)
           if ((value1 .neqv. value2) &
            .or. (value1 .neqv. isEven(low + i))) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool)
end subroutine ArrayTest_ArrayOps_checkBool_mi


! 
! Method:  checkChar[]
! 

recursive subroutine ArrayTest_ArrayOps_checkChar_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_char_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar.use)
  implicit none
  type(SIDL_char_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar)
  character (len=64) :: testtext
  character :: value1, value2
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  integer (selected_int_kind(9)) :: testind
  data testtext / 'I''d rather write programs to write programs than write programs' /
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           index(1) = low + i
           call get(a, low+i, value1)
           call get(a, index, value2)
           testind = mod(i, 64) + 1
           if ((value1 .ne. value2) &
            .or. (value1 .ne. testtext(testind:testind))) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar)
end subroutine ArrayTest_ArrayOps_checkChar_mi


! 
! Method:  checkInt[]
! 

recursive subroutine ArrayTest_ArrayOps_checkInt_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt.use)
  implicit none
  type(SIDL_int_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt)
  integer (selected_int_kind(9)) :: dim, low, up, i, index(1), prime
  integer (selected_int_kind(9)) :: refarray(1), refindex, lowa(1), upa(1), &
         astride(1)
  F90_VOLATILE refarray
  integer (selected_int_kind(9)) :: value1, value2, value3, value4
  integer (selected_int_kind(18)) :: nextprime, tmp
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        call access(a, refarray, lowa, upa, astride, refindex)
        prime = 0
        do i = low, up
           tmp = prime
           prime = nextprime(tmp)
           index(1) = i
           call get(a, i, value1)
           call get(a, index, value2)
           value3 = refarray(refindex + astride(1) * (i - lowa(1)))
           value4 = a%d_data(i)
           if ((value1 .ne. value2) &
            .or. (value2 .ne. value3) &
            .or. (value2 .ne. value4) &
            .or. (value1 .ne. prime)) then
              retval = .false.
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt)
end subroutine ArrayTest_ArrayOps_checkInt_mi


! 
! Method:  checkLong[]
! 

recursive subroutine ArrayTest_ArrayOps_checkLong_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_long_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong.use)
  implicit none
  type(SIDL_long_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong)
  integer (selected_int_kind(9)) :: dim, low, up, i, index(1)
  integer (selected_int_kind(18)) :: prime
  integer (selected_int_kind(18)) :: value1, value2, nextprime, value3
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        prime = 0
        do i = low, up
           prime = nextprime(prime)
           index(1) = i
           call get(a, i, value1)
           call get(a, index, value2)
           value3 = a%d_data(i)
           if ((value1 .ne. value2) &
                .or. (value1 .ne. value3) &
                .or. (value1 .ne. prime)) then
              retval = .false.
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong)
end subroutine ArrayTest_ArrayOps_checkLong_mi


! 
! Method:  checkString[]
! 

recursive subroutine ArrayO_checkStringqtpwhw66ji_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_string_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString.use)
  implicit none
  type(SIDL_string_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString)
  character (len=9) :: testtext(10)
  character (len=2048) :: value1
  character (len=2048) :: value2
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1), testind
  data testtext / 'I''d', 'rather', 'write', 'programs', 'to', 'write', 'programs', 'than', 'write', 'programs.'/
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           index(1) = low + i
           call get(a, low+i, value1)
           call get(a, index, value2)
           testind = mod(i, 10) + 1
           if ((value1 .ne. value2) & 
            .or. (value1 .ne. testtext(testind))) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString)
end subroutine ArrayO_checkStringqtpwhw66ji_mi


! 
! Method:  checkDouble[]
! 

recursive subroutine ArrayO_checkDoubleht03bd1cj8_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble.use)
  implicit none
  type(SIDL_double_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble)
  real(selected_real_kind(15,307)) :: value1, value2, value3, expectedvalue
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           expectedvalue = (2.0d0 ** (-i))
           index(1) = low + i
           call get(a,low+i,value1)
           call get(a,index,value2)
           value3 = a%d_data(low+i)
           if ((value1 .ne. value2) &
                .or. (value1 .ne. value3) &
                .or. (value1 .ne. expectedvalue)) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble)
end subroutine ArrayO_checkDoubleht03bd1cj8_mi


! 
! Method:  checkFloat[]
! 

recursive subroutine ArrayOp_checkFloat81idm2qyci_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat.use)
  implicit none
  type(SIDL_float_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat)
  real(selected_real_kind(6,37)) :: value1, value2, expectedvalue, value3
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           expectedvalue = (2.0 ** (-i))
           call force_float(expectedvalue)
           index(1) = low + i
           call get(a,low+i,value1)
           call get(a,index,value2)
           value3 = a%d_data(low+i)
           if ((value1 .ne. value2) &
                .or. (value1 .ne. value3) &
                .or. (value1 .ne. expectedvalue)) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat)
end subroutine ArrayOp_checkFloat81idm2qyci_mi


! 
! Method:  checkFcomplex[]
! 

recursive subroutine Arra_checkFcomplexpmjhp5xo5y_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex.use)
  implicit none
  type(SIDL_fcomplex_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex)
  complex(selected_real_kind(6,37)) :: value1, value2, expectedvalue, value3
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           call force_fcomplex(expectedvalue)
           expectedvalue = cmplx(2.0 ** i, 2.0 ** (-i))
           index(1) = low + i
           call get(a,low+i,value1)
           call get(a,index,value2)
           value3 = a%d_data(low+i)
           if ((value1 .ne. value2) &
                .or. (value1 .ne. value3) &
                .or.  (value1 .ne. expectedvalue)) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex)
end subroutine Arra_checkFcomplexpmjhp5xo5y_mi


! 
! Method:  checkDcomplex[]
! 

recursive subroutine Arra_checkDcomplexjn5f7v75je_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex.use)
  implicit none
  type(SIDL_dcomplex_1d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex)
  complex(selected_real_kind(15,307)) :: value1, value2, expectedvalue, value3
  integer (selected_int_kind(9)) :: low, up, dim, len, i, index(1)
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a, 0)
        len = (up - low) + 1
        do i = 0, len - 1
           expectedvalue = cmplx(2.0d0 ** i, 2.0d0 ** (-i))
           index(1) = low + i
           call get(a,low+i,value1)
           call get(a,index,value2)
           value3 = a%d_data(low+i)
           if ((value1 .ne. value2) &
                .or. (value1 .ne. value3) &
                .or. (value1 .ne. expectedvalue)) then
              return
           endif
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex)
end subroutine Arra_checkDcomplexjn5f7v75je_mi


! 
! Method:  check2Int[]
! 

recursive subroutine ArrayTest_ArrayOps_check2Int_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int.use)
  implicit none
  type(SIDL_int_2d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int)
  integer (selected_int_kind(9)) :: dim, low(2), up(2), ind(2), i, j
  integer (selected_int_kind(9)) :: len(2)
  integer (selected_int_kind(9)) :: value1, value2, expectedvalue, value3
  retval = .false.
  if (not_null(a)) then
     dim = dimen(a)
    if (dim .eq. 2) then
      do i = 1, dim
         low(i) = lower(a, i-1)
         up(i) = upper(a, i-1)
         len(i) = up(i) - low(i)
      enddo
      do i = 0, len(1)
        ind(1) = low(1) + i
        do j = 0, len(2)
          expectedvalue = (2.0d0 ** abs(i-j))
          ind(2) = low(2) + j
          call get(a, ind(1), ind(2), value1)
          call get(a, ind, value2)
          value3 = a%d_data(ind(1), ind(2))
          if ((value1 .ne. value2) .or. &
               (value1 .ne. value3) .or. &
               (value1 .ne. expectedvalue)) then
            return
          endif
        enddo
      enddo
      retval = .true.
    endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int)
end subroutine ArrayTest_ArrayOps_check2Int_mi


! 
! Method:  check2Double[]
! 

recursive subroutine Array_check2Double7081y8i9gp_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double.use)
  implicit none
  type(SIDL_double_2d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double)
  integer (selected_int_kind(9))   :: dim, low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))   :: len(2)
  real(selected_real_kind(15,307)) :: value1, value2, expectedvalue, value3
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 2) then
        do i = 1, 2
           low(i) = lower(a, i-1)
           up(i) = upper(a, i-1)
           len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           index(1) = low(1) + i
           do j = 0, len(2)
              expectedvalue = (2.0d0 ** (i-j))
              index(2) = low(2) + j
              call get(a, index(1), index(2), value1)
              call get(a, index, value2)
              value3 = a%d_data(index(1), index(2))
              if ((value1 .ne. value2) &
                   .or. (value1 .ne. value3) &
                   .or.  (value1 .ne. expectedvalue)) then
                 return
              endif
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double)
end subroutine Array_check2Double7081y8i9gp_mi


! 
! Method:  check2Float[]
! 

recursive subroutine ArrayO_check2Floatme7av9ys4q_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float.use)
  implicit none
  type(SIDL_float_2d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float)
  integer (selected_int_kind(9))  :: dim, low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))  :: len(2)
  real (selected_real_kind(6,37)) :: value1, value2, expectedvalue, value3
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 2) then
        do i = 1, 2
           low(i) = lower(a, i-1)
           up(i) = upper(a, i-1)
           len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           index(1) = low(1) + i
           do j = 0, len(2)
              expectedvalue = (2.0 ** (i-j))
              index(2) = low(2) + j
              call get(a, index(1), index(2), value1)
              call get(a, index, value2)
              value3 = a%d_data(index(1), index(2))
              if ((value1 .ne. value2) &
                   .or. (value1 .ne. value3) &
                   .or. (value1 .ne. expectedvalue)) then
                 return
              endif
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float)
end subroutine ArrayO_check2Floatme7av9ys4q_mi


! 
! Method:  check2Fcomplex[]
! 

recursive subroutine Arr_check2Fcomplexiayu9iwvsb_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex.use)
  implicit none
  type(SIDL_fcomplex_2d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex)
  integer (selected_int_kind(9))     :: dim, low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))     :: len(2)
  complex (selected_real_kind(6,37)) :: value1, value2, expectedvalue, value3
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 2) then
        do i = 1, 2
           low(i) = lower(a, i-1)
           up(i) = upper(a, i-1)
           len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           do j = 0, len(2)
              expectedvalue = cmplx(2.0 ** i, 2.0 ** (-j))
              index(1) = low(1) + i
              index(2) = low(2) + j
              call get(a, index(1), index(2), value1)
              call get(a, index, value2)
              value3 = a%d_data(index(1), index(2))
              if ((value1 .ne. value2) &
                   .or. (value1 .ne. value2) &
                   .or.  (value1 .ne. expectedvalue)) then
                 return
              endif
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex)
end subroutine Arr_check2Fcomplexiayu9iwvsb_mi


! 
! Method:  check2Dcomplex[]
! 

recursive subroutine Arr_check2Dcomplexvwom7ctsrx_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex.use)
  implicit none
  type(SIDL_dcomplex_2d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex)
  integer (selected_int_kind(9))       :: dim, low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))       :: len(2)
  complex (selected_real_kind(15,307)) :: value1, value2, expectedvalue, value3
  retval = .false.
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 2) then
        do i = 1, 2
           low(i) = lower(a, i-1)
           up(i) = upper(a, i-1)
           len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           do j = low(2), up(2)
              expectedvalue = cmplx(2.0d0 ** i, 2.0d0 ** (-j))
              index(1) = low(1) + i
              index(2) = low(2) + j
              call get(a, index(1), index(2), value1)
              call get(a, index, value2)
              value3 = a%d_data(index(1), index(2))
              if ((value1 .ne. value2) &
                   .or. (value1 .ne. value3) &
                   .or. (value1 .ne. expectedvalue)) then
                 return
              endif
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex)
end subroutine Arr_check2Dcomplexvwom7ctsrx_mi


! 
! Method:  check3Int[]
! 

recursive subroutine ArrayTest_ArrayOps_check3Int_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int.use)
  implicit none
  type(SIDL_int_3d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int)
  integer (selected_int_kind(9)) :: dim, len(3), ind(3), low(3), up(3)
  integer (selected_int_kind(9)) :: i, j, k
  integer (selected_int_kind(9)) :: value1, value2, expectedvalue, value3
  integer (selected_int_kind(9)) :: intFunc
  retval = .false.
  if (not_null(a)) then
     dim = dimen(a)
     if (dim .eq. 3) then
        do i = 1, dim
            low(i) = lower(a, i-1)
            up(i) = upper(a, i-1)
            len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           ind(1) = low(1) + i
           do j = 0, len(2)
              ind(2) = low(2) + j
              do k = 0, len(3)
                 ind(3) = low(3) + k
                 expectedvalue = intFunc(dim, ind)
                 call get(a, ind(1), ind(2), ind(3), value1)
                 call get(a, ind, value2)
                 value3 = a%d_data(ind(1), ind(2), ind(3))
                 if (    (value1 .ne. value2) &
                      .or. (value1 .ne. value3) &
                      .or. (value1 .ne. expectedvalue)) then
                    return
                 endif
              enddo
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int)
end subroutine ArrayTest_ArrayOps_check3Int_mi


! 
! Method:  check4Int[]
! 

recursive subroutine ArrayTest_ArrayOps_check4Int_mi(a, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int.use)
  implicit none
  type(SIDL_int_4d) :: a
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int)
  integer (selected_int_kind(9)) :: dim, len(4), ind(4), low(4), up(4)
  integer (selected_int_kind(9)) :: i, j, k, l
  integer (selected_int_kind(9)) :: value1, value2, expectedvalue, value3
  integer (selected_int_kind(9)) :: intFunc
  retval = .false.
  if (not_null(a)) then
     dim = dimen(a)
     if (dim .eq. 4) then
        do i = 1, dim
            low(i) = lower(a, i-1)
            up(i) = upper(a, i-1)
            len(i) = up(i) - low(i)
        enddo
        do i = 0, len(1)
           ind(1) = low(1) + i
           do j = 0, len(2)
              ind(2) = low(2) + j
              do k = 0, len(3)
                 ind(3) = low(3) + k
                 do l = 0, len(4)
                    ind(4) = low(4) + l
                    expectedvalue = intFunc(dim, ind)
                    call get(a, ind(1), ind(2), ind(3), ind(4), value1)
                    call get(a, ind, value2)
                    value3 = a%d_data(ind(1), ind(2), ind(3), ind(4))
                    if (    (value1 .ne. value2) &
                         .or. (value1 .ne. value3) &
                         .or. (value1 .ne. expectedvalue)) then
                       return
                    endif
                 enddo
              enddo
           enddo
        enddo
        retval = .true.
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int)
end subroutine ArrayTest_ArrayOps_check4Int_mi


! 
! Method:  checkObject[]
! 

recursive subroutine ArrayO_checkObject275yd2pmke_mi(a, retval)
  use ArrayTest_ArrayOps
  use ArrayTest_ArrayOps_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject.use)
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject.use)
  implicit none
  type(ArrayTest_ArrayOps_1d) :: a
  integer (selected_int_kind(9)) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject)
  integer (selected_int_kind(9)) :: dim, low, up, i, index(1), prime
  type(ArrayTest_ArrayOps_t) :: value1, value2
  logical isone
  retval = 0
  if (not_null(a)) then
     dim = dimen(a)
     if (dim .eq. 1) then
        low = lower(a, 0)
        up = upper(a,0)
        prime = 0
        do i = low, up
           index(1) = i
           call get(a, i, value1)
           call get(a, index, value2)
           if (value1%d_ior .ne. value2%d_ior) then
              retval = -32000
           else
              if (not_null(value1)) then
                 call isType(value1, 'ArrayTest.ArrayOps', isone)
                 if (isone) then
                    retval = retval + 1
                 endif
              endif
           endif
           if (not_null(value1)) then
              call deleteRef(value1)
           endif
           if (not_null(value2)) then
              call deleteRef(value2)
           endif
        enddo
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject)
end subroutine ArrayO_checkObject275yd2pmke_mi


! 
! Method:  reverseBool[]
! 

recursive subroutine ArrayO_reverseBoolgymo0nngeh_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_bool_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool.use)
  implicit none
  type(SIDL_bool_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_bool_1d) :: destarray
  logical buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkBool(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, &
                   up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool)
end subroutine ArrayO_reverseBoolgymo0nngeh_mi


! 
! Method:  reverseChar[]
! 

recursive subroutine ArrayO_reverseCharlkg8mhipko_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_char_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar.use)
  implicit none
  type(SIDL_char_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_char_1d) :: destarray
  character :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkChar(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray,up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar)
end subroutine ArrayO_reverseCharlkg8mhipko_mi


! 
! Method:  reverseInt[]
! 

recursive subroutine ArrayOp_reverseIntkxwfbbpb16_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt.use)
  implicit none
  type(SIDL_int_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_int_1d) :: destarray
  integer (selected_int_kind(9)) :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkInt(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt)
end subroutine ArrayOp_reverseIntkxwfbbpb16_mi


! 
! Method:  reverseLong[]
! 

recursive subroutine ArrayO_reverseLongnxvgf_63g6_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_long_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong.use)
  implicit none
  type(SIDL_long_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_long_1d) :: destarray
  integer (selected_int_kind(18)) :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkLong(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong)
end subroutine ArrayO_reverseLongnxvgf_63g6_mi


! 
! Method:  reverseString[]
! 

recursive subroutine Arra_reverseStringgoh6ljf81q_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_string_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString.use)
  implicit none
  type(SIDL_string_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_string_1d) :: destarray
  character (len=2048):: buffer
  character (len=2048) :: extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkString(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString)
end subroutine Arra_reverseStringgoh6ljf81q_mi


! 
! Method:  reverseDouble[]
! 

recursive subroutine Arra_reverseDoubletak4ebvws0_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble.use)
  implicit none
  type(SIDL_double_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_double_1d) :: destarray
  real(selected_real_kind(15,307)) :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkDouble(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble)
end subroutine Arra_reverseDoubletak4ebvws0_mi


! 
! Method:  reverseFloat[]
! 

recursive subroutine Array_reverseFloatznhcr92afl_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat.use)
  implicit none
  type(SIDL_float_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_float_1d) :: destarray
  real buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkFloat(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat)
end subroutine Array_reverseFloatznhcr92afl_mi


! 
! Method:  reverseFcomplex[]
! 

recursive subroutine Ar_reverseFcomplex3ygx3y26n0_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex.use)
  implicit none
  type(SIDL_fcomplex_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_fcomplex_1d) :: destarray
  complex(selected_real_kind(6,37)) :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkFcomplex(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex)
end subroutine Ar_reverseFcomplex3ygx3y26n0_mi


! 
! Method:  reverseDcomplex[]
! 

recursive subroutine Ar_reverseDcomplex27ddkoywyz_mi(a, newArray, retval)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex.use)
  implicit none
  type(SIDL_dcomplex_1d) :: a
  logical :: newArray
  logical :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex)
  integer (selected_int_kind(9)) :: dim, low(1), up(1), i, len
  type(SIDL_dcomplex_1d) :: destarray
  complex(selected_real_kind(15,307)) :: buffer, extra
  if (not_null(a)) then
      dim = dimen(a)
     if (dim .eq. 1) then
        low(1) = lower(a, 0)
        up(1) = upper(a, 0)
        call checkDcomplex(a, retval)
        if (newarray) then
           call createRow(low, up, destarray)
           do i = low(1), up(1)
              call get(a, i, buffer)
              call set(destarray, up(1) + low(1) - i, buffer)
           enddo
           call deleteRef(a)
           a = destarray
        else
           len = ((up(1) - low(1) + 1) / 2) - 1
           do i = 0, len
              call get(a, low(1) + i, buffer)
              call get(a, up(1) - i, extra)

              call set(a, low(1) + i, extra)
              call set(a, up(1) - i, buffer)
           enddo
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex)
end subroutine Ar_reverseDcomplex27ddkoywyz_mi


! 
! Method:  createBool[]
! 

recursive subroutine ArrayOp_createBoolqh7dzxxaoi_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_bool_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_bool_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), testind
  logical :: isEven
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        testind = mod(i, 64) + 1
        if (mod(i, 2) .eq. 0) then
           call set(retval, i, isEven(i))
        else
           index(1) = i
           call set(retval, index, isEven(i))
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool)
end subroutine ArrayOp_createBoolqh7dzxxaoi_mi


! 
! Method:  createChar[]
! 

recursive subroutine ArrayOp_createChargrqa0qqx35_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_char_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_char_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar)
  character (len=64) :: testtext
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), testind
  data testtext / 'I''d rather write programs to write programs than write programs' /
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        testind = mod(i, 64) + 1
        if (mod(i, 2) .eq. 0) then
           call set(retval, i, testtext(testind:testind))
        else
           index(1) = i
           call set(retval, index, testtext(testind:testind))
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar)
end subroutine ArrayOp_createChargrqa0qqx35_mi


! 
! Method:  createInt[]
! 

recursive subroutine ArrayTest_ArrayOps_createInt_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_int_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt)
  integer (selected_int_kind(9)) :: low(1), up(1), astride(1), i, index(1)
  integer (selected_int_kind(9)) :: value, refindex, refarray(1), modval
  F90_VOLATILE refarray
  integer (selected_int_kind(18)) :: nextprime, tmp
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     value = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     call access(retval, refarray, low, up, astride, refindex)
     do i = 0, len - 1
        tmp = value
        value = nextprime(tmp)
        modval = mod(i, 4)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              if (modval .eq. 2) then
                 refarray(refindex + astride(1)*(i - low(1))) = value
              else
                 retval%d_data(i) = value
              endif
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt)
end subroutine ArrayTest_ArrayOps_createInt_mi


! 
! Method:  createLong[]
! 

recursive subroutine ArrayOp_createLongau7gsrji_x_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_long_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_long_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), modval
  integer (selected_int_kind(18)) :: value, nextprime
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     value = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        value = nextprime(value)
        modval = mod(i, 3)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              retval%d_data(i) = value
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong)
end subroutine ArrayOp_createLongau7gsrji_x_mi


! 
! Method:  createString[]
! 

recursive subroutine Array_createStringgncdbm9unz_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_string_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_string_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString)
  character (len=9) :: testtext(10)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), testind
  data testtext / 'I''d', 'rather', 'write', 'programs', 'to', 'write', &
       'programs', 'than', 'write', 'programs.'/
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        testind = mod(i, 10) + 1
        if (mod(i, 2) .eq. 0) then
           call set(retval, i, testtext(testind))
        else
           index(1) = i
           call set(retval, index, testtext(testind))
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString)
end subroutine Array_createStringgncdbm9unz_mi


! 
! Method:  createDouble[]
! 

recursive subroutine Array_createDoubleocanws5yj__mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_double_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), modval
  real(selected_real_kind(15,307)) :: value
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        value = 2.0d0 ** (-i)
        modval = mod(i, 3)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              retval%d_data(i) = value
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble)
end subroutine Array_createDoubleocanws5yj__mi


! 
! Method:  createFloat[]
! 

recursive subroutine ArrayO_createFloatbxvfxabr56_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_float_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), modval
  real(selected_real_kind(6,37)) :: value
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        value = 2.0 ** (-i)
        modval = mod(i, 3)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              retval%d_data(i) = value
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat)
end subroutine ArrayO_createFloatbxvfxabr56_mi


! 
! Method:  createFcomplex[]
! 

recursive subroutine Arr_createFcomplex6h5qchwr1t_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_fcomplex_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1), modval
  complex(selected_real_kind(6,37)) :: value
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        value = cmplx(2.0 ** i, 2.0 ** (-i))
        modval = mod(i, 3)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              retval%d_data(i) = value
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex)
end subroutine Arr_createFcomplex6h5qchwr1t_mi


! 
! Method:  createDcomplex[]
! 

recursive subroutine Arr_createDcomplex2117rrwnvr_mi(len, retval)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_dcomplex_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex)
  integer (selected_int_kind(9))  :: low(1), up(1), i, index(1), modval
  complex(selected_real_kind(15,307)) :: value
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        value = cmplx(2.0d0 ** i, 2.0d0 ** (-i))
        modval = mod(i, 3)
        if (modval .eq. 0) then
           call set(retval, i, value)
        else
           if (modval .eq. 1) then
              index(1) = i
              call set(retval, index, value)
           else
              retval%d_data(i) = value
           endif
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex)
end subroutine Arr_createDcomplex2117rrwnvr_mi


! 
! Method:  createObject[]
! 

recursive subroutine Array_createObject4cnhf0d9y2_mi(len, retval)
  use ArrayTest_ArrayOps
  use ArrayTest_ArrayOps_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(ArrayTest_ArrayOps_1d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject)
  integer (selected_int_kind(9)) :: low(1), up(1), i, index(1)
  type(ArrayTest_ArrayOps_t) :: object
  call set_null(retval)
  if (len .ge. 0) then
     low(1) = 0
     up(1) = len - 1
     call createRow(low, up, retval)
     do i = 0, len - 1
        call new(object)
        if (mod(i, 2) .eq. 0) then
           call set(retval, i, object)
        else
           index(1) = i
           call set(retval, index, object)
        endif

        call deleteRef(object)
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject)
end subroutine Array_createObject4cnhf0d9y2_mi


! 
! Method:  create2Int[]
! 

recursive subroutine ArrayOp_create2Intmumtywacyp_mi(d1, d2, retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int.use)
  implicit none
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2
  type(SIDL_int_2d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int)
  integer (selected_int_kind(9)) :: low(2), up(2), index(2), i, j
  integer (selected_int_kind(9)) :: value, modval
  call set_null(retval)
  if ((d1 .ge. 0) .and. (d2 .ge. 0)) then
     low(1) = 0
     up(1) = d1 - 1
     low(2) = 0
     up(2) = d2 - 1
     value = 0
     call createRow(low, up, retval)
     do i = 0, up(1)
        index(1) = i
        do j = 0, up(2)
           index(2) = j
           value = (2.0d0 ** abs(i-j))
           modval = mod(i + j, 3)
           if (modval .eq. 0) then
              call set(retval, index(1), index(2), value)
           else
              if (modval .eq. 1) then
                 call set(retval, index, value)
              else
                 retval%d_data(i, j) = value
              endif
           endif
        enddo
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int)
end subroutine ArrayOp_create2Intmumtywacyp_mi


! 
! Method:  create2Double[]
! 

recursive subroutine Arra_create2Doublewgvbfvoevx_mi(d1, d2, retval)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double.use)
  implicit none
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2
  type(SIDL_double_2d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double)
  integer (selected_int_kind(9)) :: low(2), up(2), index(2), i, j
  integer (selected_int_kind(9)) :: modval
  double precision value
  call set_null(retval)
  if ((d1 .ge. 0) .and. (d2 .ge. 0)) then
     low(1) = 0
     up(1) = d1 - 1
     low(2) = 0
     up(2) = d2 - 1
     value = 0
     call createRow(low, up, retval)
     do i = 0, up(1)
        index(1) = i
        do j = 0, up(2)
           index(2) = j
           value = (2.0d0 ** (i-j))
           modval = mod(i + j, 3)
           if (modval .eq. 0) then
              call set(retval, index(1), index(2), value)
           else
              if (modval .eq. 1) then
                 call set(retval, index, value)
              else
                 retval%d_data(i, j) = value
              endif
           endif
        enddo
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double)
end subroutine Arra_create2Doublewgvbfvoevx_mi


! 
! Method:  create2Float[]
! 

recursive subroutine Array_create2Floatxtc5m3ogpa_mi(d1, d2, retval)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float.use)
  implicit none
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2
  type(SIDL_float_2d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float)
  integer (selected_int_kind(9))  :: low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))  :: modval
  real (selected_real_kind(6,37)) :: value
  call set_null(retval)
  if ((d1 .ge. 0) .and. (d2 .ge. 0)) then
     low(1) = 0
     up(1) = d1 - 1
     low(2) = 0
     up(2) = d2 - 1
     value = 0
     call createRow(low, up, retval)
     do i = 0, up(1)
        index(1) = i
        do j = 0, up(2)
           index(2) = j
           value = (2.0d0 ** (i-j))
           modval = mod(i+j, 3)
           if (modval .eq. 0) then
              call set(retval, index(1), index(2), value)
           else
              if (modval .eq. 1) then
                 call set(retval, index, value)
              else
                 retval%d_data(i, j) = value
              endif
           endif
        enddo
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float)
end subroutine Array_create2Floatxtc5m3ogpa_mi


! 
! Method:  create2Dcomplex[]
! 

recursive subroutine Ar_create2Dcomplexe22dd91s69_mi(d1, d2, retval)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2
  type(SIDL_dcomplex_2d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex)
  integer (selected_int_kind(9))       :: low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))       :: modval
  complex (selected_real_kind(15,307)) :: value
  call set_null(retval)
  if ((d1 .ge. 0) .and. (d2 .ge. 0)) then
     low(1) = 0
     up(1) = d1 - 1
     low(2) = 0
     up(2) = d2 - 1
     value = 0
     call createRow(low, up, retval)
     do i = 0, up(1)
        index(1) = i
        do j = 0, up(2)
           index(2) = j
           value = cmplx(2.0d0 ** i, 2.0d0 ** (-j))
           modval = mod(i + j, 3)
           if (modval .eq. 0) then
              call set(retval, index(1), index(2), value)
           else
              if (modval .eq. 1) then
                 call set(retval, index, value)
              else
                 retval%d_data(i, j) = value
              endif
           endif
        enddo
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex)
end subroutine Ar_create2Dcomplexe22dd91s69_mi


! 
! Method:  create2Fcomplex[]
! 

recursive subroutine Ar_create2Fcomplexb8gunt105c_mi(d1, d2, retval)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2
  type(SIDL_fcomplex_2d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex)
  integer (selected_int_kind(9))     :: low(2), up(2), index(2), i, j
  integer (selected_int_kind(9))     :: modval
  complex (selected_real_kind(6,37)) :: value
  call set_null(retval)
  if ((d1 .ge. 0) .and. (d2 .ge. 0)) then
     low(1) = 0
     up(1) = d1 - 1
     low(2) = 0
     up(2) = d2 - 1
     value = 0
     call createRow(low, up, retval)
     do i = 0, up(1)
        index(1) = i
        do j = 0, up(2)
           index(2) = j
           value = cmplx(2.0d0 ** i, 2.0d0 ** (-j))
           modval = mod(i + j, 3)
           if (modval .eq. 0) then
              call set(retval, index(1), index(2), value)
           else
              if (modval .eq. 1) then
                 call set(retval, index, value)
              else
                 retval%d_data(i,j) = value
              endif
           endif
        enddo
     enddo
  endif
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex)
end subroutine Ar_create2Fcomplexb8gunt105c_mi


! 
! Method:  create3Int[]
! 

recursive subroutine ArrayOp_create3Int4ikxjsbhe8_mi(retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int.use)
  implicit none
  type(SIDL_int_3d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int)
  integer (selected_int_kind(9))  :: dim, low(3), up(3), ind(3)
  integer (selected_int_kind(9))  :: value, modval, i, j, k, intFunc
  dim = 3
  do i = 1, dim
    low(i) = 0
    if (i .le. 2) then
      up(i) = 3
    else
      up(i) = 2
    endif
  enddo
  call createRow(low, up, retval)
  do i = 0, up(1)
    ind(1) = i
    do j = 0, up(2)
      ind(2) = j
      do k = 0, up(3)
        ind(3) = k
        value = intFunc(dim, ind)
        modval = mod(i+j+k, 3)
        if (modval .eq. 0) then
          call set(retval, ind(1), ind(2), ind(3), value)
        else
           if (modval .eq. 1) then
              call set(retval, ind, value)
           else
              retval%d_data(i,j,k) = value
           endif
        endif
      enddo
    enddo
  enddo
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int)
end subroutine ArrayOp_create3Int4ikxjsbhe8_mi


! 
! Method:  create4Int[]
! 

recursive subroutine ArrayOp_create4Inten8imvrfau_mi(retval)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int.use)
  implicit none
  type(SIDL_int_4d) :: retval

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int)
  integer (selected_int_kind(9))  :: dim, low(4), up(4), ind(4)
  integer (selected_int_kind(9))  :: value, modval, i, j, k, l, intFunc
  dim = 4
  do i = 1, dim
    low(i) = 0
    if (i .le. 2) then
      up(i) = 3
    else
      up(i) = 2
    endif
  enddo
  call createRow(low, up, retval)
  do i = 0, up(1)
    ind(1) = i
    do j = 0, up(2)
      ind(2) = j
      do k = 0, up(3)
        ind(3) = k
        do l = 0, up(4)
          ind(4) = l
          value = intFunc(dim, ind)
          modval = mod(i+j+k+l, 3)
          if (modval .eq. 0) then
            call set(retval, ind(1), ind(2), ind(3), ind(4), value)
          else
             if (modval .eq. 1) then
                call set(retval, ind, value)
             else
                retval%d_data(i,j,k,l) = value
             endif
          endif
        enddo
      enddo
    enddo
  enddo
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int)
end subroutine ArrayOp_create4Inten8imvrfau_mi


! 
! Method:  makeBool[]
! 

recursive subroutine ArrayTest_ArrayOps_makeBool_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_bool_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_bool_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool)
  call createBool(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool)
end subroutine ArrayTest_ArrayOps_makeBool_mi


! 
! Method:  makeChar[]
! 

recursive subroutine ArrayTest_ArrayOps_makeChar_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_char_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_char_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar)
  call createChar(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar)
end subroutine ArrayTest_ArrayOps_makeChar_mi


! 
! Method:  makeInt[]
! 

recursive subroutine ArrayTest_ArrayOps_makeInt_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_int_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt)
  call createInt(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt)
end subroutine ArrayTest_ArrayOps_makeInt_mi


! 
! Method:  makeLong[]
! 

recursive subroutine ArrayTest_ArrayOps_makeLong_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_long_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_long_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong)
  call createLong(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong)
end subroutine ArrayTest_ArrayOps_makeLong_mi


! 
! Method:  makeString[]
! 

recursive subroutine ArrayOp_makeStringucptewb9ad_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_string_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_string_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString)
  call createString(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString)
end subroutine ArrayOp_makeStringucptewb9ad_mi


! 
! Method:  makeDouble[]
! 

recursive subroutine ArrayOp_makeDouble7j4r5nh156_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_double_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble)
  call createDouble(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble)
end subroutine ArrayOp_makeDouble7j4r5nh156_mi


! 
! Method:  makeFloat[]
! 

recursive subroutine ArrayTest_ArrayOps_makeFloat_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_float_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat)
  call createFloat(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat)
end subroutine ArrayTest_ArrayOps_makeFloat_mi


! 
! Method:  makeFcomplex[]
! 

recursive subroutine Array_makeFcomplexv0425q5_2o_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_fcomplex_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex)
  call createFcomplex(len,a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex)
end subroutine Array_makeFcomplexv0425q5_2o_mi


! 
! Method:  makeDcomplex[]
! 

recursive subroutine Array_makeDcomplexp093yr7xy7_mi(len, a)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex.use)
  implicit none
  integer (selected_int_kind(9)) :: len
  type(SIDL_dcomplex_1d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex)
  call createDcomplex(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex)
end subroutine Array_makeDcomplexp093yr7xy7_mi


! 
! Method:  makeInOutBool[]
! 

recursive subroutine Arra_makeInOutBool5jfcbo_ube_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_bool_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool.use)
  implicit none
  type(SIDL_bool_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createBool(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool)
end subroutine Arra_makeInOutBool5jfcbo_ube_mi


! 
! Method:  makeInOutChar[]
! 

recursive subroutine Arra_makeInOutChartpjt62yvqd_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_char_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar.use)
  implicit none
  type(SIDL_char_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createChar(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar)
end subroutine Arra_makeInOutChartpjt62yvqd_mi


! 
! Method:  makeInOutInt[]
! 

recursive subroutine Array_makeInOutIntyo69yq7z9p_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt.use)
  implicit none
  type(SIDL_int_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createInt(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt)
end subroutine Array_makeInOutIntyo69yq7z9p_mi


! 
! Method:  makeInOutLong[]
! 

recursive subroutine Arra_makeInOutLonghy687ifd8__mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_long_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong.use)
  implicit none
  type(SIDL_long_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createLong(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong)
end subroutine Arra_makeInOutLonghy687ifd8__mi


! 
! Method:  makeInOutString[]
! 

recursive subroutine Ar_makeInOutString_uzdlcqlye_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_string_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString.use)
  implicit none
  type(SIDL_string_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createString(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString)
end subroutine Ar_makeInOutString_uzdlcqlye_mi


! 
! Method:  makeInOutDouble[]
! 

recursive subroutine Ar_makeInOutDouble045y36r_il_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble.use)
  implicit none
  type(SIDL_double_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createDouble(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble)
end subroutine Ar_makeInOutDouble045y36r_il_mi


! 
! Method:  makeInOutFloat[]
! 

recursive subroutine Arr_makeInOutFloati3hp8_tmhu_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat.use)
  implicit none
  type(SIDL_float_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createFloat(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat)
end subroutine Arr_makeInOutFloati3hp8_tmhu_mi


! 
! Method:  makeInOutDcomplex[]
! 

recursive subroutine makeInOutDcomplexuq8uzvc62wd_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex.use)
  implicit none
  type(SIDL_dcomplex_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createDcomplex(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex)
end subroutine makeInOutDcomplexuq8uzvc62wd_mi


! 
! Method:  makeInOutFcomplex[]
! 

recursive subroutine makeInOutFcomplexnnmei919ckr_mi(a, len)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex.use)
  implicit none
  type(SIDL_fcomplex_1d) :: a
  integer (selected_int_kind(9)) :: len

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call createFcomplex(len, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex)
end subroutine makeInOutFcomplexnnmei919ckr_mi


! 
! Method:  makeInOut2Int[]
! 

recursive subroutine Arra_makeInOut2Intar5f7eylp9_mi(a, d1, d2)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int.use)
  implicit none
  type(SIDL_int_2d) :: a
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create2Int(d1, d2, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int)
end subroutine Arra_makeInOut2Intar5f7eylp9_mi


! 
! Method:  makeInOut2Double[]
! 

recursive subroutine A_makeInOut2Doublebgpvhq3prh_mi(a, d1, d2)
  use ArrayTest_ArrayOps
  use SIDL_double_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double.use)
  implicit none
  type(SIDL_double_2d) :: a
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create2Double(d1, d2, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double)
end subroutine A_makeInOut2Doublebgpvhq3prh_mi


! 
! Method:  makeInOut2Float[]
! 

recursive subroutine Ar_makeInOut2Floatq670n4ukao_mi(a, d1, d2)
  use ArrayTest_ArrayOps
  use SIDL_float_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float.use)
  implicit none
  type(SIDL_float_2d) :: a
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create2Float(d1, d2, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float)
end subroutine Ar_makeInOut2Floatq670n4ukao_mi


! 
! Method:  makeInOut2Dcomplex[]
! 

recursive subroutine makeInOut2Dcomplexckhu3osbep_mi(a, d1, d2)
  use ArrayTest_ArrayOps
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex.use)
  implicit none
  type(SIDL_dcomplex_2d) :: a
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create2Dcomplex(d1, d2, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex)
end subroutine makeInOut2Dcomplexckhu3osbep_mi


! 
! Method:  makeInOut2Fcomplex[]
! 

recursive subroutine makeInOut2Fcomplexxh7zrwg3ge_mi(a, d1, d2)
  use ArrayTest_ArrayOps
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex.use)
  implicit none
  type(SIDL_fcomplex_2d) :: a
  integer (selected_int_kind(9)) :: d1
  integer (selected_int_kind(9)) :: d2

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create2Fcomplex(d1, d2, a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex)
end subroutine makeInOut2Fcomplexxh7zrwg3ge_mi


! 
! Method:  makeInOut3Int[]
! 

recursive subroutine Arra_makeInOut3Intxzlzgrsum3_mi(a)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int.use)
  implicit none
  type(SIDL_int_3d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create3Int(a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int)
end subroutine Arra_makeInOut3Intxzlzgrsum3_mi


! 
! Method:  makeInOut4Int[]
! 

recursive subroutine Arra_makeInOut4Intiw_x5vq0ti_mi(a)
  use ArrayTest_ArrayOps
  use SIDL_int_array
  use ArrayTest_ArrayOps_impl
  ! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int.use)
  implicit none
  type(SIDL_int_4d) :: a

! DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int)
  if (not_null(a)) then
     call deleteRef(a)
  endif
  call create4Int(a)
! DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int)
end subroutine Arra_makeInOut4Intiw_x5vq0ti_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
