// 
// File:          ExceptionTest_Fib_Impl.hh
// Symbol:        ExceptionTest.Fib-v1.0
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for ExceptionTest.Fib
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 

#ifndef included_ExceptionTest_Fib_Impl_hh
#define included_ExceptionTest_Fib_Impl_hh

#ifndef included_SIDL_cxx_hh
#include "SIDL_cxx.hh"
#endif
#ifndef included_ExceptionTest_Fib_IOR_h
#include "ExceptionTest_Fib_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_ExceptionTest_Fib_hh
#include "ExceptionTest_Fib.hh"
#endif
#ifndef included_ExceptionTest_FibException_hh
#include "ExceptionTest_FibException.hh"
#endif
#ifndef included_ExceptionTest_NegativeValueException_hh
#include "ExceptionTest_NegativeValueException.hh"
#endif
#ifndef included_SIDL_BaseInterface_hh
#include "SIDL_BaseInterface.hh"
#endif
#ifndef included_SIDL_ClassInfo_hh
#include "SIDL_ClassInfo.hh"
#endif


// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes)
// Put additional includes or other arbitrary code here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes)

namespace ExceptionTest { 

  /**
   * Symbol "ExceptionTest.Fib" (version 1.0)
   * 
   * This class holds the method <code>getFib</code> that generates the
   * requested Fibonacci numbers.
   */
  class Fib_impl
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._inherits)
  {

  private:
    // Pointer back to IOR.
    // Use this to dispatch back through IOR vtable.
    Fib self;

    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._implementation)
    // Put additional implementation details here...
    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._implementation)

  private:
    // private default constructor (required)
    Fib_impl() {} 

  public:
    // SIDL constructor (required)
    // Note: alternate Skel constructor doesn't call addref()
    // (fixes bug #275)
    Fib_impl( struct ExceptionTest_Fib__object * s ) : self(s,true) { _ctor(); }

    // user defined construction
    void _ctor();

    // virtual destructor (required)
    virtual ~Fib_impl() { _dtor(); }

    // user defined destruction
    void _dtor();

  public:


    /**
     * <p>
     * Generate the requested Fibonacci number or generate exceptions if
     * the input Fibonacci number is invalid or if any of the maximum depth
     * or maximum value parameters are exceeded.  The last argument of the
     * method should be zero.
     * </p>
     * <p>
     * The logic method should be similar to the following <code>Java</code>:
     * </p>
     * <pre>
     * public int getFib(int n, int max_depth, int max_value, int depth)
     *     throws NegativeValueException, FibException {
     * 
     *   if (n < 0) {
     *     throw new NegativeValueException("n negative");
     * 
     *   } else if (depth > max_depth) {
     *     throw new TooDeepException("too deep");
     * 
     *   } else if (n == 0) {
     *     return 1;
     * 
     *   } else if (n == 1) {
     *     return 1;
     * 
     *   } else {
     *     int a = getFib(n-1, max_depth, max_value, depth+1);
     *     int b = getFib(n-2, max_depth, max_value, depth+1);
     *     if (a + b > max_value) {
     *       throw new TooBigException("too big");
     *     }
     *     return a + b;
     *   }
     * } 
     * </pre>
     */
    int32_t
    getFib (
      /*in*/ int32_t n,
      /*in*/ int32_t max_depth,
      /*in*/ int32_t max_value,
      /*in*/ int32_t depth
    )
    throw ( 
      ::ExceptionTest::FibException, 
      ::ExceptionTest::NegativeValueException
    );

  };  // end class Fib_impl

} // end namespace ExceptionTest

// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)

#endif
