C       
C       File:          ExceptionTest_Fib_Impl.f
C       Symbol:        ExceptionTest.Fib-v1.0
C       Symbol Type:   class
C       Babel Version: 0.8.8
C       Description:   Server-side implementation for ExceptionTest.Fib
C       
C       WARNING: Automatically generated; only changes within splicers preserved
C       
C       babel-version = 0.8.8
C       


C       
C       Symbol "ExceptionTest.Fib" (version 1.0)
C       
C       This class holds the method <code>getFib</code> that generates the
C       requested Fibonacci numbers.
C       


C       DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
C       Nothing needed here...
C       DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




C       
C       Class constructor called when the class is created.
C       

        subroutine ExceptionTest_Fib__ctor_fi(self)
        implicit none
        integer*8 self

C       DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor)
C       Nothing needed here...
C       DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor)
        end


C       
C       Class destructor called when the class is deleted.
C       

        subroutine ExceptionTest_Fib__dtor_fi(self)
        implicit none
        integer*8 self

C       DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor)
C       Nothing needed here...
C       DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor)
        end


C       
C       <p>
C       Generate the requested Fibonacci number or generate exceptions if
C       the input Fibonacci number is invalid or if any of the maximum depth
C       or maximum value parameters are exceeded.  The last argument of the
C       method should be zero.
C       </p>
C       <p>
C       The logic method should be similar to the following <code>Java</code>:
C       </p>
C       <pre>
C       public int getFib(int n, int max_depth, int max_value, int depth)
C           throws NegativeValueException, FibException {
C       
C         if (n < 0) {
C           throw new NegativeValueException("n negative");
C       
C         } else if (depth > max_depth) {
C           throw new TooDeepException("too deep");
C       
C         } else if (n == 0) {
C           return 1;
C       
C         } else if (n == 1) {
C           return 1;
C       
C         } else {
C           int a = getFib(n-1, max_depth, max_value, depth+1);
C           int b = getFib(n-2, max_depth, max_value, depth+1);
C           if (a + b > max_value) {
C             throw new TooBigException("too big");
C           }
C           return a + b;
C         }
C       } 
C       </pre>
C       

        subroutine ExceptionTest_Fib_getFib_fi(self, n, max_depth,
     &     max_value, depth, retval, exception)
        implicit none
        integer*8 self
        integer*4 n
        integer*4 max_depth
        integer*4 max_value
        integer*4 depth
        integer*4 retval
        integer*8 exception

C       DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib)
        character*(*) myfilename 
        parameter(myfilename='ExceptionTest_Fib_Impl.f')
        integer*4 a, b
        retval = 0
        if (n .lt. 0) then
          call ExceptionTest_NegativeValueException__create_f(exception)
          if (exception .ne. 0) then
            call ExceptionTest_NegativeValueException_setNote_f(
     $             exception, 
     $             'called with negative n')
            call ExceptionTest_NegativeValueException_add_f(
     $             exception, 
     $             myfilename,
     $             57, 
     $             'ExceptionTest_Fib_getFib_impl')
            return
          endif
        else if (depth .gt. max_depth) then
          call ExceptionTest_TooDeepException__create_f(exception)
          if (exception .ne. 0) then
            call ExceptionTest_TooDeepException_setNote_f(
     $             exception, 
     $             'exceeded specified recursion depth')
            call ExceptionTest_TooDeepException_add_f(
     $             exception, 
     $             myfilename,
     $             70, 
     $             'ExceptionTest_Fib_getFib_impl')
            return
          endif
        else if (n .eq. 0) then
          retval = 1
        else if (n .eq. 1) then
          retval = 1
        else 
C       
C       Note that we must call the stub version of this method
C       because g77 does not (currently) support recursion.
C       
          call ExceptionTest_Fib_getFib_f(self, 
     $                                    n-1, 
     $                                    max_depth, 
     $                                    max_value,
     $                                    depth+1, 
     $                                    a, 
     $                                    exception)
          if (exception .ne. 0) then
            call SIDL_BaseException_add_f(
     $             exception, 
     $             myfilename,
     $             90, 
     $             'ExceptionTest_Fib_getFib_impl')
            return
          endif
C       
C       Note that we must call the stub version of this method
C       because g77 does not (currently) support recursion.
C       
          call ExceptionTest_Fib_getFib_f(self, 
     $                                    n-2, 
     $                                    max_depth, 
     $                                    max_value,
     $                                    depth+1, 
     $                                    b, 
     $                                    exception)
          if (exception .ne. 0) then
            call SIDL_BaseException_add_f(
     $             exception, 
     $             myfilename,
     $             105, 
     $             'ExceptionTest_Fib_getFib_impl')
            return
          endif
          retval = a+b
          if (retval .gt. max_value) then
            retval = 0
            call ExceptionTest_TooBigException__create_f(exception)
            if (exception .ne. 0) then
              call ExceptionTest_TooBigException_setNote_f(
     $               exception, 
     $               'result exceeds specified maximum value')
              call ExceptionTest_TooBigException_add_f(
     $               exception, 
     $               myfilename,
     $               103, 
     $               'ExceptionTest_Fib_getFib_impl')
              return
            endif
          endif
        endif
C       DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib)
        end


C       DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
C       Nothing needed here...
C       DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
