#
# File:          Fib_Impl.py
# Symbol:        ExceptionTest.Fib-v1.0
# Symbol Type:   class
# Babel Version: 0.8.8
# Description:   Implementation of SIDL class ExceptionTest.Fib in Python.
# 
# WARNING: Automatically generated; changes will be lost
# 
# babel-version = 0.8.8
#


"""This class holds the method <code>getFib</code> that generates the
requested Fibonacci numbers.
"""

# DO-NOT-DELETE splicer.begin(_initial)
# Put your code here...
# DO-NOT-DELETE splicer.end(_initial)

import ExceptionTest.FibException
import SIDL.BaseInterface
import SIDL.BaseClass
import SIDL.ClassInfo
import ExceptionTest.Fib
import ExceptionTest.NegativeValueException

# DO-NOT-DELETE splicer.begin(_before_type)
import ExceptionTest.TooDeepException
import ExceptionTest.TooBigException
# DO-NOT-DELETE splicer.end(_before_type)

class Fib:
  """\
This class holds the method <code>getFib</code> that generates the
requested Fibonacci numbers.
"""

  # All calls to SIDL methods should use __IORself

  def __init__(self, IORself):
    self.__IORself = IORself
    # DO-NOT-DELETE splicer.begin(__init__)
    # Put your code here...
    # DO-NOT-DELETE splicer.end(__init__)

  def getFib(self, n, max_depth, max_value, depth):
    #
    # SIDL EXPECTED INCOMING TYPES
    # ============================
    # int n
    # int max_depth
    # int max_value
    # int depth
    #

    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # int _return
    #

    """\
<p>
Generate the requested Fibonacci number or generate exceptions if
the input Fibonacci number is invalid or if any of the maximum depth
or maximum value parameters are exceeded.  The last argument of the
method should be zero.
</p>
<p>
The logic method should be similar to the following <code>Java</code>:
</p>
<pre>
public int getFib(int n, int max_depth, int max_value, int depth)
    throws NegativeValueException, FibException {

  if (n < 0) {
    throw new NegativeValueException(\"n negative\");

  } else if (depth > max_depth) {
    throw new TooDeepException(\"too deep\");

  } else if (n == 0) {
    return 1;

  } else if (n == 1) {
    return 1;

  } else {
    int a = getFib(n-1, max_depth, max_value, depth+1);
    int b = getFib(n-2, max_depth, max_value, depth+1);
    if (a + b > max_value) {
      throw new TooBigException(\"too big\");
    }
    return a + b;
  }
} 
</pre>
"""
    # DO-NOT-DELETE splicer.begin(getFib)
    if (n < 0):
      ex = ExceptionTest.NegativeValueException.NegativeValueException()
      ex.setNote("n negative")
      ex.add(__name__, 0, "ExceptionTest.Fib.getFib")
      raise ExceptionTest.NegativeValueException.Exception, ex
    if (depth > max_depth):
      ex =  ExceptionTest.TooDeepException.TooDeepException()
      ex.setNote("too deep")
      ex.add(__name__, 0, "ExceptionTest.Fib.getFib")
      raise ExceptionTest.FibException.Exception, ex
    if (n == 0):
      return 1
    if (n == 1):
      return 1
    try:
      a = self.__IORself.getFib(n - 1, max_depth, max_value, depth + 1)
      b = self.__IORself.getFib(n - 2, max_depth, max_value, depth + 1)
      if (a + b > max_value):
        ex = ExceptionTest.TooBigException.TooBigException()
        ex.setNote("too big")
        ex.add(__name__, 0, "ExceptionTest.Fib.getFib")
        raise ExceptionTest.FibException.Exception, ex
      return a + b
    except ExceptionTest.FibException.Exception, exc:
      exc.add(__name__, 0, "ExceptionTest.Fib.getFib")
      raise ExceptionTest.FibException.Exception, exc
    # DO-NOT-DELETE splicer.end(getFib)

# DO-NOT-DELETE splicer.begin(_final)
# Put your code here...
# DO-NOT-DELETE splicer.end(_final)
