c
c     File:       exceptionclient.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Release:    $Name: release-0-8-8 $
c     Revision:   @(#) $Revision: 1.6 $
c     Date:       $Date: 2003/02/05 17:28:34 $
c     Description:Simple F77 exception test client
c
c

      subroutine starttest(number)
      implicit none
      integer number
      write (6, 100) number
 100  format ('PART ', I4)
      end

      subroutine reporttest(test, number, pass, fail)
      implicit none
      integer number, pass, fail
      logical test
      if (test) then
         write (6, 100) number, 'PASS'
         pass = pass + 1
      else
         write (6, 100) number, 'FAIL'
         fail = fail + 1
      endif
 100  format ('RESULT', 1x, i2, 1x, A4)
      number = number + 1
      end

      subroutine reportexc(exc)
      implicit none
      integer*8 exc
      character*(100) msg
      character*(1024) trace

      call SIDL_BaseException_getNote_f(exc, msg)
      write (6, 100) msg
      call SIDL_BaseException_getTrace_f(exc, trace)
      write (6, 110) trace
 100  format (1x, a100)
 110  format (1x, a1024)
      end

      subroutine testnone(fib, test, pass, fail)
      implicit none
      integer*8 fib
      integer test, pass, fail
      integer*8 retval
      integer*8 exc

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 25, 200, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.true., test, pass, fail)
        write (6, 100) retval
      else
        call reporttest(.false., test, pass, fail)
        call reportexc(exc)
        call SIDL_BaseException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testneg(fib, test, pass, fail)
      implicit none
      integer*8 fib
      integer test, pass, fail
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, -1, 10, 10, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test, pass, fail)
        write (6, 100) retval
      else
        call SIDL_BaseException_isType_f (exc, 
     $          'ExceptionTest.NegativeValueException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test, pass, fail)
        else
          call reporttest(.false., test, pass, fail)
        endif
        call reportexc(exc)
        call SIDL_BaseException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testdeep(fib, test, pass, fail)
      implicit none
      integer*8 fib
      integer test, pass, fail
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 1, 100, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test, pass, fail)
        write (6, 100) retval
      else
        call SIDL_BaseException_isType_f (exc, 
     $          'ExceptionTest.TooDeepException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test, pass, fail)
        else
          call reporttest(.false., test, pass, fail)
        endif
        call reportexc(exc)
        call SIDL_BaseException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testbig(fib, test, pass, fail)
      implicit none
      integer*8 fib
      integer test, pass, fail
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 100, 1, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test, pass, fail)
        write (6, 100) retval
      else
        call SIDL_BaseException_isType_f (exc, 
     $          'ExceptionTest.TooBigException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test, pass, fail)
        else
          call reporttest(.false., test, pass, fail)
        endif
        call reportexc(exc)
        call SIDL_BaseException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end


      program exceptionclient
      implicit none
      integer test, pass, fail
      integer*8 fib
      integer*8 retval

      call ExceptionTest_Fib__create_f (fib)

      test = 1
      pass = 0
      fail = 0

      write(6,130) 4
      write(6,110)
      write(6,120) 'No Exception test            '
      call testnone(fib, test, pass, fail)
      write(6,110)
      write(6,120) 'Negative Value Exception test'
      call testneg(fib, test, pass, fail)
      write(6,110)
      write(6,120) 'Too Deep Exception test      '
      call testdeep(fib, test, pass, fail)
      write(6,110)
      write(6,120) 'Too Big Exception test       '
      call testbig(fib, test, pass, fail)

      call ExceptionTest_Fib_deleteRef_f (fib)

      write(6, 110) 
      if ((fail .eq. 0) .and. (pass .eq. 4)) then
         write(6, 100) 'PASS'
      else
         write(6, 100) 'FAIL'
      endif
 100  format ('TEST_RESULT', 1x, a4)
 110  format (' ')
 120  format ('COMMENT:', 1x, a30)
 130  format ('NPARTS', 1x, i4)
      end
