!     
! File:        inherittest.F90
! Copyright:   (c) 2002 The Regents of the University of California
! Release:     $Name: release-0-8-8 $
! Revision:    $Revision: 1.6 $
! Date:        $Date: 2003/02/25 19:32:53 $
! Description: Regression test to test FORTRAN calls to BABEL
!

subroutine castcheck(partno, numpassed, sourcename, destname, not_null)
  implicit none
  integer (selected_int_kind(9))  :: partno, numpassed
  character (len=*)                  :: sourcename, destname
  logical                         :: not_null
  partno = partno + 1
  write (*,100) 'PART', partno
  write (*,110) 'COMMENT: Casting ', sourcename, ' to ', destname
  if (not_null) then
     write (*, 120) 'RESULT ', partno, ' PASS'
     numpassed = numpassed + 1
  else
     write (*, 120) 'RESULT ', partno, ' FAIL'
  endif
100 format (a, i3)
110 format (a, a, a, a)
120 format (a, i3, a)
end subroutine castcheck


subroutine reporttest(partno, numpassed, methodname, expectedresult, result)
  implicit none
  integer (selected_int_kind(9)) :: partno, numpassed
  character (len=*)                 :: methodname, expectedresult, result
  partno = partno + 1
  write (*, 100) 'PART ', partno
  write (*, 110) 'COMMENT: Method Inherit_', methodname, ' should return ', &
       expectedresult
  write (*, 110) 'COMMENT: Method Inherit_', methodname, ' returned ', result
  if (result .eq. expectedresult) then
     numpassed = numpassed + 1
     write (*, 120) 'RESULT ', partno, ' PASS'
  else
     write (*, 120) 'RESULT ', partno, ' FAIL'
  endif
100 format (a, i3)
110 format (a, a, a, a)
120 format (a, i3, a)
end subroutine reporttest

program inherittest
  use Inherit_A
  use Inherit_B
  use Inherit_C
  use Inherit_D
  use Inherit_E
  use Inherit_E2
  use Inherit_F
  use Inherit_F2
  use Inherit_G
  use Inherit_G2
  use Inherit_H
  use Inherit_I
  implicit none
  integer (selected_int_kind(9))  :: partno, numpassed
  character (len=32)              :: strresult
  type(Inherit_A_t)  :: A_object
  type(Inherit_B_t)  :: B_object
  type(Inherit_C_t)  :: C_object
  type(Inherit_D_t)  :: D_object
  type(Inherit_E_t)  :: E_object
  type(Inherit_E2_t) :: E2_object
  type(Inherit_F_t)  :: F_object
  type(Inherit_F2_t) :: F2_object
  type(Inherit_G_t)  :: G_object
  type(Inherit_G2_t) :: G2_object
  type(Inherit_H_t)  :: H_object
  type(Inherit_I_t)  :: I_object
  partno = 0
  numpassed = 0

  write (*, 110) 'NPARTS -1'
  call new(C_object)
  write (*,110) ' '
  write (*,110) 'Class C:'
  write (*,110) ' '
  call c(C_object,strresult)
  call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
  call deleteRef(C_object)

  call new(D_object)
  write (*,110) ' '
  write (*,110) 'Class D: inheritance of interface A'
  write (*,110) ' '
  call a(D_object,strresult)
  call reporttest(partno, numpassed, 'D_a', 'D.a', strresult)
  write (*,110) ' '
  call d(D_object,strresult)
  call reporttest(partno, numpassed, 'D_d', 'D.d', strresult)

  write (*,110) ' '
  write (*,110) 'Class D: via interface A'
  write (*,110) ' '
  call cast(D_object, A_object)
  call castcheck(partno, numpassed, 'Class D', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, numpassed, 'A_a', 'D.a', strresult)
     call set_null(A_object)
  endif
  call deleteRef(D_object)

  call new(E_object)
  write (*,110) ' '
  write (*,110) 'Class E: inheritance of class C'
  write (*,110) ' '
  call c(E_object,strresult)
  call reporttest(partno, numpassed, 'E_c', 'C.c', strresult)
  write (*,110) ' '
  call e(E_object,strresult)
  call reporttest(partno, numpassed, 'E_e', 'E.e', strresult)

  write (*,110) ' '
  write (*,110) 'Class E: via class C (C.c not overridden)'
  write (*,110) ' '
  call cast(E_object, C_object)
  call castcheck(partno, numpassed, 'Class E', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
     call set_null(C_object)
  endif
  call deleteRef(E_object)

  call new(E2_object)
  write (*,110) ' '
  write (*,110) 'Class E2: inheritance of class C'
  write (*,110) ' '
  call c(E2_object,strresult)
  call reporttest(partno, numpassed, 'E2_c', 'E2.c', strresult)
  write (*,110) ' '
  call e(E2_object,strresult)
  call reporttest(partno, numpassed, 'E2_e', 'E2.e', strresult)

  write (*, 110) ' '
  write (*, 110) 'Class E2: via class C (C.c overridden)'
  write (*, 110) ' '
  call cast(E2_object, C_object)
  call castcheck(partno, numpassed, 'Class E2', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, numpassed, 'C_c', 'E2.c', strresult)
     call set_null(C_object)
  endif
  call deleteRef(E2_object)

  call new(F_object)
  write (*,110) ' '
  write (*,110) 'Class F: Multiple inheritance (no overriding)'
  write (*,110) ' '
  call a(F_object,strresult)
  call reporttest(partno, numpassed, 'F_a', 'F.a', strresult)
  write (*,110) ' '
  call b(F_object,strresult)
  call reporttest(partno, numpassed, 'F_b', 'F.b', strresult)
  write (*,110) ' '
  call c(F_object,strresult)
  call reporttest(partno, numpassed, 'F_c', 'C.c', strresult)
  write (*,110) ' '
  call f(F_object,strresult)
  call reporttest(partno, numpassed, 'F_f', 'F.f', strresult)
  write (*,110) ' '
  write (*,110) 'Class F: via interface A'
  write (*,110) ' '
  call cast(F_object, A_object)
  call castcheck(partno, numpassed, 'Class F', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, numpassed, 'A_a', 'F.a', strresult)
     call set_null(A_object)
  endif


  write (*,110) ' '
  write (*,110) 'Class F: via interface B'
  write (*,110) ' '
  call cast(F_object, B_object)
  call castcheck(partno, numpassed, 'Class F', 'Interface B', &
       not_null(B_object))
  if (not_null(B_object)) then
     call b(B_object,strresult)
     call reporttest(partno, numpassed, 'B_b', 'F.b', strresult)
     call set_null(B_object)
  endif

  write (*,110) ' '
  write (*,110) 'Class F: via class C (no overloading of C.c)'
  write (*,110) ' '
  call cast(F_object, C_object)
  call castcheck(partno, numpassed, 'Class F', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
     call set_null(C_object)
  endif
  write (*,110) ' '

  call deleteRef(F_object)

  call new(F2_object)
  write (*,110) ' '
  write (*,110) 'Class F2: Multiple inheritance (overrides C.c)'
  write (*,110) ' '
  call a(F2_object,strresult)
  call reporttest(partno, numpassed, 'F2_a', 'F2.a', strresult)
  write (*,110) ' '
  call b(F2_object,strresult)
  call reporttest(partno, numpassed, 'F2_b', 'F2.b', strresult)
  write (*,110) ' '
  call c(F2_object,strresult)
  call reporttest(partno, numpassed, 'F2_c', 'F2.c', strresult)
  write (*,110) ' '
  call f(F2_object,strresult)
  call reporttest(partno, numpassed, 'F2_f', 'F2.f', strresult)
  write (*,110) ' '

  write (*,110) ' '
  write (*,110) 'Class F2: via interface A'
  write (*,110) ' '
  call cast(F2_object, A_object)
  call castcheck(partno, numpassed, 'Class F2', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, numpassed, 'A_a', 'F2.a', strresult)
     call set_null(A_object)
  endif

  write (*,110) ' '
  write (*,110) 'Class F2: via interface B'
  write (*,110) ' '
  call cast(F2_object, B_object)
  call castcheck(partno, numpassed, 'Class F2', 'Interface B', &
       not_null(B_object))
  if (not_null(B_object)) then
     call b(B_object,strresult)
     call reporttest(partno, numpassed, 'B_b', 'F2.b', strresult)
     call set_null(B_object)
  endif

  write (*,110) ' '
  write (*,110) 'Class F2: via class C (overloads C.c)'
  write (*,110) ' '
  call cast(F2_object, C_object)
  call castcheck(partno, numpassed, 'Class F2', 'Class C', &
       not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, numpassed, 'C_c', 'F2.c', strresult)
     call set_null(C_object)
  endif
  write (*,110) ' '

  call deleteRef(F2_object)

  write (*,110) ' '
  write (*,110) 'Class G: indirect multiple inheritance (no overloads)'
  write (*,110) ' '
  call new(G_object)
  call a(G_object,strresult)
  call reporttest(partno, numpassed, 'G_a', 'D.a', strresult)
  write (*,110) ' '
  call d(G_object,strresult)
  call reporttest(partno, numpassed, 'G_d', 'D.d', strresult)
  write (*,110) ' '
  call g(G_object,strresult)
  call reporttest(partno, numpassed, 'G_g', 'G.g', strresult)
  write (*,110) ' '

  write (*,110) 'Class G: via interface A'
  write (*,110) ' '
  call cast(G_object, A_object)
  call castcheck(partno, numpassed, 'Class G', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, numpassed, 'A_a', 'D.a', strresult)
     call set_null(A_object)
  endif
  write (*,110) ' '
  write (*,110) 'Class G: via class D'
  write (*,110) ' '
  call cast(G_object, D_object)
  call castcheck(partno, numpassed, 'Class G', 'Class D', &
       not_null(D_object))
  if (not_null(D_object)) then
     call a(D_object,strresult)
     call reporttest(partno, numpassed, 'D_a', 'D.a', strresult)
     write (*,110) ' '
     write (*,110) ' '
     call d(D_object,strresult)
     call reporttest(partno, numpassed, 'D_d', 'D.d', strresult)
     call set_null(D_object)
  endif
  write (*,110) ' '

  call deleteRef(G_object)

  write (*,110) ' '
  write (*,110) 'Class G2: indirect multiple inheritance (overloads)'
  write (*,110) ' '
  call new(G2_object)
  call a(G2_object,strresult)
  call reporttest(partno, numpassed, 'G2_a', 'G2.a', strresult)
  write (*,110) ' '
  call d(G2_object,strresult)
  call reporttest(partno, numpassed, 'G2_d', 'G2.d', strresult)
  write (*,110) ' '
  call g(G2_object,strresult)
  call reporttest(partno, numpassed, 'G2_g', 'G2.g', strresult)
  write (*,110) ' '

  write (*,110) 'Class G2: via interface A'
  write (*,110) ' '
  call cast(G2_object, A_object)
  call castcheck(partno, numpassed, 'Class G2', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, numpassed, 'A_a', 'G2.a', strresult)
     call set_null(A_object)
  endif

  write (*,110) ' '
  write (*,110) 'Class G2: via class D'
  write (*,110) ' '
  call cast(G2_object, D_object)
  call castcheck(partno, numpassed, 'Class G2', 'Class D', &
       not_null(D_object))
  if (not_null(D_object)) then
     call a(D_object,strresult)
     call reporttest(partno, numpassed, 'D_a', 'G2.a', strresult)
     write (*,110) ' '
     write (*,110) ' '
     call d(D_object,strresult)
     call reporttest(partno, numpassed, 'D_d', 'G2.d', strresult)
     call set_null(D_object)
  endif
  write (*,110) ' '
  call deleteRef(G2_object)

  call new(I_object)
  write (*,110) ' '
  write (*,110) 'Class I:'
  write (*,110) ' '
  call a(I_object,strresult)
  call reporttest(partno, numpassed, 'I_a', 'I.a', strresult)
  write (*,110) ' '
  write (*,110) ' '
  call h(I_object,strresult)
  call reporttest(partno, numpassed, 'I_h', 'I.h', strresult)

  write (*,110) ' '
  write (*,110) 'Class I: via class H'
  write (*,110) ' '
  call cast(I_object, H_object)
  call castcheck(partno, numpassed, 'Class I', 'Class H', &
       not_null(H_object))
  
  if (not_null(H_object)) then
     call a(H_object,strresult)
     call reporttest(partno, numpassed, 'H_a', 'I.a', strresult)
     write (*,110) ' '
     write (*,110) ' '
     call h(H_object,strresult)
     call reporttest(partno, numpassed, 'H_h', 'I.h', strresult)
     call set_null(H_object)
  endif

  call deleteRef(I_object)

  if (partno .eq. numpassed) then
     write (*, 110) 'TEST_RESULT PASS'
  else
     write (*, 110) 'TEST_RESULT FAIL'
  endif

110 format (a)
end program inherittest
