/*
 * File:        orderingtests.c
 * Copyright:   (c) 2002 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.4 $
 * Date:        $Date: 2002/09/30 23:01:00 $
 * Description: Regression test for array ordering code
 *
 */

#include "Ordering_IntOrderTest.h"
#include <stdio.h>
#include <stdlib.h>

static const char * result_string[] = { "FAIL", "XFAIL", "PASS" };

const int pass = 2;
const int xfail = 1;
const int fail = 0;

static void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

static void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result < *final_result ) { 
    *final_result = result;
  }
}

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );


static const int arraySize = 7;

static struct SIDL_int__array*
make1DIMatrix(const int32_t size)
{
  struct SIDL_int__array *result=NULL;
  int32_t i;
  result = SIDL_int__array_create1d(size);
  for(i = 0; i < size; ++i ){
    SIDLArrayElem1(result, i) = i;
  }
  return result;
}

int main(int argc, char **argv)
{
  int magicNumber = 1;
  int result = pass;
  int final_result = pass;
  int part_no = 0;
  
  struct SIDL_int__array *A = NULL;
  printf("NPARTS 32\n");
  A = Ordering_IntOrderTest_makeColumnIMatrix(arraySize, TRUE);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixTwo(A));
  Ordering_IntOrderTest_ensureRow(&A);
  MYASSERT(A && SIDL_int__array_isRowOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureColumn(&A);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureRow(&A);
  MYASSERT(A && SIDL_int__array_isRowOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureColumn(&A);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeColumnIMatrix(arraySize, FALSE);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeRowIMatrix(arraySize, TRUE);
  MYASSERT(A && SIDL_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeRowIMatrix(arraySize, FALSE);
  MYASSERT(A && SIDL_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createColumnIMatrix(arraySize, TRUE, &A);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createColumnIMatrix(arraySize, FALSE, &A);
  MYASSERT(A && SIDL_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createRowIMatrix(arraySize, TRUE, &A);
  MYASSERT(A && SIDL_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createRowIMatrix(arraySize, FALSE, &A);
  MYASSERT(A && SIDL_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeIMatrix(arraySize, TRUE);
  MYASSERT(A && Ordering_IntOrderTest_isIMatrixFour(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixFour(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixFour(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  A = make1DIMatrix(arraySize);
  MYASSERT(A && Ordering_IntOrderTest_isIMatrixOne(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixOne(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixOne(A));
  SIDL_int__array_deleteRef(A); A = NULL;

  MYASSERT(Ordering_IntOrderTest_isSliceWorking(TRUE));
  MYASSERT(Ordering_IntOrderTest_isSliceWorking(FALSE));

  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}
