/*
 * File:        orderingtests.c
 * Copyright:   (c) 2002 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.5 $
 * Date:        $Date: 2003/04/04 18:38:16 $
 * Description: Regression test for array ordering code
 *
 */

#include "Ordering_IntOrderTest.hh"

#include <iostream>
using namespace std;

const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

static const int TEST_SIZE = 345; /* size of one dimensional arrays */
static const int TEST_DIM1 = 17; /* first dimension of 2-d arrays */
static const int TEST_DIM2 = 13; /* second dimension of 2-d arrays */

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  cout << "COMMENT: (" <<  __LINE__ << ") " << #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );


/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}


static const int arraySize = 7;

static SIDL::array<int32_t> 
make1DIMatrix(const int32_t size)
{
  SIDL::array<int32_t> result= SIDL::array<int32_t>::create1d(size);
  int32_t i;
  for(i = 0; i < size; ++i ){
    result.set(i,i);
  }
  return result;
}

int main(int argc, char **argv)
{
  int magicNumber = 1;
  int result = pass;
  int final_result = pass;
  int part_no = 0;
  
  SIDL::array<int32_t> A = NULL;
  
  cout << "NPARTS 32" << endl;
  
  A = Ordering::IntOrderTest::makeColumnIMatrix(arraySize, true);
  MYASSERT(A._not_nil() && A.isColumnOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  MYASSERT(Ordering::IntOrderTest::isColumnIMatrixTwo(A));
  MYASSERT(Ordering::IntOrderTest::isRowIMatrixTwo(A));
  Ordering::IntOrderTest::ensureRow(A);
  MYASSERT(A._not_nil() && A.isRowOrder() &&
           Ordering::IntOrderTest::isIMatrixTwo(A));
  Ordering::IntOrderTest::ensureColumn(A);
  MYASSERT(A._not_nil() && A.isColumnOrder() &&
           Ordering::IntOrderTest::isIMatrixTwo(A));
  Ordering::IntOrderTest::ensureRow(A);
  MYASSERT(A._not_nil() && A.isRowOrder() &&
           Ordering::IntOrderTest::isIMatrixTwo(A));
  Ordering::IntOrderTest::ensureColumn(A);
  MYASSERT(A._not_nil() && A.isColumnOrder() &&
           Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  A = Ordering::IntOrderTest::makeColumnIMatrix(arraySize, false);
  MYASSERT(A._not_nil() && A.isColumnOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  A = Ordering::IntOrderTest::makeRowIMatrix(arraySize, true);
  MYASSERT(A._not_nil() && A.isRowOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  MYASSERT(Ordering::IntOrderTest::isColumnIMatrixTwo(A));
  MYASSERT(Ordering::IntOrderTest::isRowIMatrixTwo(A));
  //  A.deleteRef();

  A = Ordering::IntOrderTest::makeRowIMatrix(arraySize, false);
  MYASSERT(A._not_nil() && A.isRowOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  Ordering::IntOrderTest::createColumnIMatrix(arraySize, true, A);
  MYASSERT(A._not_nil() && A.isColumnOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  Ordering::IntOrderTest::createColumnIMatrix(arraySize, false, A);
  MYASSERT(A._not_nil() && A.isColumnOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  Ordering::IntOrderTest::createRowIMatrix(arraySize, true, A);
  MYASSERT(A._not_nil() && A.isRowOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  Ordering::IntOrderTest::createRowIMatrix(arraySize, false, A);
  MYASSERT(A._not_nil() && A.isRowOrder());
  MYASSERT(Ordering::IntOrderTest::isIMatrixTwo(A));
  //  A.deleteRef();

  A = Ordering::IntOrderTest::makeIMatrix(arraySize, true);
  MYASSERT(A._not_nil() && Ordering::IntOrderTest::isIMatrixFour(A));
  MYASSERT(Ordering::IntOrderTest::isColumnIMatrixFour(A));
  MYASSERT(Ordering::IntOrderTest::isRowIMatrixFour(A));
  //  A.deleteRef();

  A = make1DIMatrix(arraySize);
  MYASSERT(A._not_nil() && Ordering::IntOrderTest::isIMatrixOne(A));
  MYASSERT(Ordering::IntOrderTest::isColumnIMatrixOne(A));
  MYASSERT(Ordering::IntOrderTest::isRowIMatrixOne(A));
  //  A.deleteRef();

  MYASSERT(Ordering::IntOrderTest::isSliceWorking(true));
  MYASSERT(Ordering::IntOrderTest::isSliceWorking(false));

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

