// overloadtest.cc

#include <iostream>
#include <string>
using namespace std;
#include "Overload.hh"
using namespace Overload;

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );

const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass       = 3;
const int pass        = 2;
const int xfail       = 1;
const int fail        = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail; \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );

int main() { 
  int part_no      = 0;
  int final_result = pass;
  int result       = pass;

  bool   b1        = true;
  double d1        = 1.0;
  float  f1        = 1.0F;
  int    i1        = 1;
  double did       = 2.0;
  double difd      = 3.0;
  string s1        = "aString";

  complex<double> cd1 (1.1, 1.1);
  complex<double> cdret;
  complex<float>  cf1 (1.1F, 1.1F);
  complex<float>  cfret;

  Overload::Test        t  = Overload::Test::_create();
  Overload::AnException ae = Overload::AnException::_create();
  Overload::AClass      ac = Overload::AClass::_create();
  Overload::BClass      bc = Overload::BClass::_create();

  cout << "NPARTS 19" << endl;
  MYASSERT( t.getValue() == 1 );

  MYASSERT( t.getValue(b1) == b1 );
  MYASSERT( t.getValue(d1) == d1 );
  cdret = t.getValue(cd1);
  MYASSERT( cdret.real() == cd1.real() && cdret.imag() == cd1.imag() );
  MYASSERT( t.getValue(f1) == f1 );
  cfret = t.getValue(cf1);
  MYASSERT( cfret.real() == cf1.real() && cfret.imag() == cf1.imag() );
  MYASSERT( t.getValue(i1) == i1 );
  MYASSERT( t.getValue(s1) == s1 );

  MYASSERT( t.getValue(d1, i1) == did );
  MYASSERT( t.getValue(i1, d1) == did );

  MYASSERT( t.getValue(d1, i1, f1) == difd );
  MYASSERT( t.getValue(i1, d1, f1) == difd );

  MYASSERT( t.getValue(d1, f1, i1) == difd );
  MYASSERT( t.getValue(i1, f1, d1) == difd );

  MYASSERT( t.getValue(f1, d1, i1) == difd );
  MYASSERT( t.getValue(f1, i1, d1) == difd );

  MYASSERT( t.getValue(ae) == "AnException" );
  MYASSERT( t.getValue(ac) == 2 );
  MYASSERT( t.getValue(bc) == 2 );

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}
