c
c     File:       overloadtest.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Release:    $Name: release-0-8-8 $
c     Revision:   @(#) $Revision: 1.6 $
c     Date:       $Date: 2003/04/09 18:39:21 $
c     Description:Simple F77 overload test client
c
c

      subroutine starttest(number)
      implicit none
      integer number
      write (6, 100) number
 100  format ('PART ', I4)
      end

      subroutine reporttest(test, number, pass, fail)
      implicit none
      integer number, pass, fail
      logical test
      if (test) then
         write (6, 100) number, 'PASS'
         pass = pass + 1
      else
         write (6, 100) number, 'FAIL'
         fail = fail + 1
      endif
 100  format ('RESULT', 1x, i2, 1x, A4)
      number = number + 1
      end

      subroutine testnone(t, test, pass, fail)
      implicit none
      integer test, pass, fail
      integer*8 t
      integer*4 retval

      retval = 0

      call starttest(test)
      call Overload_Test_getValue_f (t, retval)
      call reporttest(retval .eq. 1, test, pass, fail)
      end

      subroutine testone(t, test, pass, fail)
      implicit none
      character*80 s1, sretval
      integer test, pass, fail
      integer*8 t, ae, ac, bc
      integer*4 i1, iretval
      double precision d1, dretval
      real f1, fretval
      logical b1, bretval
      complex fc, fcretval
      double complex dc, dcretval

      b1 = .true.
      d1 = 1.0d0
      f1 = 1.0
      i1 = 1
      fc = (1.1, 1.1)
      dc = (2.2d0, 2.2d0)
      s1 = 'AnException'

      call starttest(test)
      call Overload_Test_getValueBool_f (t, b1, bretval)
      call reporttest(bretval .eqv. b1, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueDouble_f (t, d1, dretval)
      call reporttest(dretval .eq. d1, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueDcomplex_f (t, dc, dcretval)
      call reporttest(dcretval .eq. dc, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueFloat_f (t, f1, fretval)
      call reporttest(fretval .eq. f1, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueFcomplex_f (t, fc, fcretval)
      call reporttest(fcretval .eq. fc, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueInt_f (t, i1, iretval)
      call reporttest(iretval .eq. i1, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueString_f (t, s1, sretval)
      call reporttest(sretval .eq. s1, test, pass, fail)

      call Overload_AnException__create_f(ae)
      call starttest(test)
      call Overload_Test_getValueException_f (t, ae, sretval)
      call reporttest(sretval .eq. s1, test, pass, fail)
      call Overload_AnException_deleteRef_f(ae)
      call Overload_AClass__create_f(ac)
      call starttest(test)
      call Overload_Test_getValueAClass_f (t, ac, iretval)
      call reporttest(iretval .eq. 2, test, pass, fail)
      call Overload_AClass_deleteRef_f(ac)
      call Overload_BClass__create_f(bc)
      call starttest(test)
      call Overload_Test_getValueBClass_f (t, bc, iretval)
      call reporttest(iretval .eq. 2, test, pass, fail)
      call Overload_BClass_deleteRef_f(bc)
      end

      subroutine testtwo(t, test, pass, fail)
      implicit none
      integer test, pass, fail
      integer*8 t
      integer*4 i1, iretval
      double precision d1, dretval, did
      real f1

      d1 = 1.0d0
      i1 = 1
      did =2.0d0

      call starttest(test)
      call Overload_Test_getValueDoubleInt_f (t, d1, i1, dretval)
      call reporttest(dretval .eq. did, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueIntDouble_f (t, i1, d1, dretval)
      call reporttest(dretval .eq. did, test, pass, fail)
      end

      subroutine testthree(t, test, pass, fail)
      implicit none
      integer*8 t
      integer*4 i1
      integer test, pass, fail
      double precision d1, difd, dretval
      real f1

      d1 = 1.0d0
      f1 = 1.0
      i1 = 1
      difd = 3.0d0

      call starttest(test)
      call Overload_Test_getValueDoubleIntFloat_f (t, d1, i1, f1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueIntDoubleFloat_f (t, i1, d1, f1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueDoubleFloatInt_f (t, d1, f1, i1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueIntFloatDouble_f (t, i1, f1, d1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueFloatDoubleInt_f (t, f1, d1, i1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      call starttest(test)
      call Overload_Test_getValueFloatIntDouble_f (t, f1, i1, d1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test, pass, fail)
      end


      program overloadtest
      implicit none
      integer test, pass, fail, total
      integer*8 t

      call Overload_Test__create_f (t)

      test = 1
      pass = 0
      fail = 0
      total = 19

      write(6,130) total
      write(6,110)
      write(6,120) 'No Argument test             '
      call testnone(t, test, pass, fail)
      write(6,110)
      write(6,120) 'Single Argument tests        '
      call testone(t, test, pass, fail)
      write(6,110)
      write(6,120) 'Double Argument tests        '
      call testtwo(t, test, pass, fail)
      write(6,110)
      write(6,120) 'Triple Argument tests        '
      call testthree(t, test, pass, fail)

      call Overload_Test_deleteRef_f (t)

      write(6, 110) 
      if ((fail .eq. 0) .and. (pass .eq. total)) then
         write(6, 100) 'PASS'
      else
         write(6, 100) 'FAIL'
      endif
      write(6,110)
 100  format ('TEST_RESULT', 1x, a4)
 110  format (' ')
 120  format ('COMMENT:', 1x, a30)
 130  format ('NPARTS', 1x, i4)
      end
