/*
 * File:          sort_QuickSort_Impl.c
 * Symbol:        sort.QuickSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.QuickSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.QuickSort" (version 0.1)
 * 
 * Quick sort
 */

#include "sort_QuickSort_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.QuickSort._includes) */
#include "sort_Container.h"
#include "sort_Counter.h"
#include "sort_Comparator.h"
#include "SIDL_String.h"
#include <stdio.h>

/**
 * Choose the middle of the first, middle and last element of the
 * list.  For small lists, return the middle without checking.
 */
static int32_t
choosePivot(sort_Container  elems,
            sort_Comparator comp,
            sort_Counter    cmp,
            int32_t         start,
            int32_t         end)
{
  int32_t pivot = (start + end) >> 1;
  if ((end - start) > 4) {
    int32_t mid = pivot;
    sort_Counter_inc(cmp);
    if (sort_Container_compare(elems, start, mid, comp) <= 0) {
      sort_Counter_inc(cmp);
      if (sort_Container_compare(elems, mid, end - 1, comp) > 0) {
        sort_Counter_inc(cmp);
        if (sort_Container_compare(elems, start, end - 1, comp) < 0) {
          pivot = end - 1;
        }
        else {
          pivot = start;
        }
      }
    }
    else {
      sort_Counter_inc(cmp);
      if (sort_Container_compare(elems, mid, end - 1, comp) < 0) {
        sort_Counter_inc(cmp);
        if (sort_Container_compare(elems, start, end - 1, comp) > 0) {
          pivot = end - 1;
        }
        else {
          pivot = start;
        }
      }
    }
  }
  return pivot;
}

static void 
quickSort(sort_Container  elems,
          sort_Comparator comp,
          sort_Counter    cmp,
          sort_Counter    swp,
          int32_t         start,
          int32_t         end)
{
  if ((end - start) > 1) {
    int32_t pivot = choosePivot(elems, comp, cmp, start, end);
    int32_t i = start;
    int32_t j = end;
    if (pivot != start) {
      sort_Counter_inc(swp);
      sort_Container_swap(elems, start, pivot);
    }
    for(;;) {
      do {
        --j;
        sort_Counter_inc(cmp);
      } while (sort_Container_compare(elems, start, j, comp) < 0);
      while (++i < j) {
        sort_Counter_inc(cmp);
        if (sort_Container_compare(elems, start, i, comp) < 0) break;
      }
      if (i >= j) break;
      sort_Counter_inc(swp);
      sort_Container_swap(elems, i, j);
    }
    if (j != start) {
      sort_Counter_inc(swp);
      sort_Container_swap(elems, start, j);
    }
    quickSort(elems, comp, cmp, swp, start, j);
    quickSort(elems, comp, cmp, swp, j + 1, end);
  }
}
/* DO-NOT-DELETE splicer.end(sort.QuickSort._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_QuickSort__ctor"

void
impl_sort_QuickSort__ctor(
  sort_QuickSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.QuickSort._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.QuickSort._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_QuickSort__dtor"

void
impl_sort_QuickSort__dtor(
  sort_QuickSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.QuickSort._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.QuickSort._dtor) */
}

/*
 * Sort elements using Quick Sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_QuickSort_sort"

void
impl_sort_QuickSort_sort(
  sort_QuickSort self, sort_Container elems, sort_Comparator comp)
{
  /* DO-NOT-DELETE splicer.begin(sort.QuickSort.sort) */
  const int32_t num = sort_Container_getLength(elems);
  sort_Counter cmp = sort_QuickSort_getCompareCounter(self);
  sort_Counter swp = sort_QuickSort_getSwapCounter(self);
  quickSort(elems, comp, cmp, swp, 0, num);
  sort_Counter_deleteRef(cmp);
  sort_Counter_deleteRef(swp);
  /* DO-NOT-DELETE splicer.end(sort.QuickSort.sort) */
}

/*
 * Return quick sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_QuickSort_getName"

char*
impl_sort_QuickSort_getName(
  sort_QuickSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.QuickSort.getName) */
  return SIDL_String_strdup("Quick sort");
  /* DO-NOT-DELETE splicer.end(sort.QuickSort.getName) */
}
