/*
 * File:        sorttest.c
 * Copyright:   (c) 2002 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.4 $
 * Date:        $Date: 2002/09/30 23:01:01 $
 * Description: Simple C driver for the sort regression test
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "sort_SortTest.h"
#include "sort_MergeSort.h"
#include "sort_QuickSort.h"
#include "sort_HeapSort.h"
#include "sort_SortingAlgorithm.h"

char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = xpass; \
  else result = xfail;  \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  printf("COMMENT: %s\n", #AAA ); \
  end_part( part_no, unsupported, &final_result );

void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

int
main(int argc, char **argv)
{
  int result = pass;
  int final_result =pass;
  int magicNumber = 1;
  int part_no = 0;
  sort_MergeSort merge = sort_MergeSort__create();
  sort_QuickSort quick = sort_QuickSort__create();
  sort_HeapSort  heap = sort_HeapSort__create();
  struct sort_SortingAlgorithm__array* 
    algs = sort_SortingAlgorithm__array_create1d(3);
  srandom(time(NULL));
  printf("NPARTS 4\n");
  MYASSERT(merge != NULL);
  MYASSERT(quick != NULL);
  MYASSERT(heap != NULL);
  sort_SortingAlgorithm__array_set1
    (algs, 0, sort_SortingAlgorithm__cast(merge));
  sort_SortingAlgorithm__array_set1
    (algs, 1, sort_SortingAlgorithm__cast(quick));
  sort_SortingAlgorithm__array_set1
    (algs, 2, sort_SortingAlgorithm__cast(heap));
  /* remove extraneous references */
  sort_MergeSort_deleteRef(merge); merge = NULL;
  sort_QuickSort_deleteRef(quick); quick = NULL;
  sort_HeapSort_deleteRef(heap); heap = NULL;
  /* call test */
  MYASSERT(sort_SortTest_stressTest(algs) == TRUE);
  sort_SortingAlgorithm__array_deleteRef(algs);
  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}

