c
c     File:       sorttest.f
c     Copyright:  (c) 2002 The Regents of the University of California
c     Release:    $Name: release-0-8-8 $
c     Revision:   @(#) $Revision: 1.4 $
c     Date:       $Date: 2003/04/09 19:19:35 $
c     Description:Exercise the FORTRAN interface for sorting
c
c
      subroutine starttest(number)
      implicit none
      integer number
      write (6, 100) number
 100  format ('PART ', I4)
      end

      subroutine reporttest(test, number, pass, fail)
      implicit none
      integer number, pass, fail
      logical test
      if (test) then
         write (6, 100) number, 'PASS'
         pass = pass + 1
      else
         write (6, 100) number, 'FAIL'
         fail = fail + 1
      endif
 100  format ('RESULT', 1x, i2, 1x, A4)
      number = number + 1
      end

      subroutine testsort(test, pass, fail)
      implicit none
      integer*8 algs, merge, quick, heap, alg
      integer test, pass, fail
      logical retval

      call sort_SortingAlgorithm__array_create1d_f(3, algs)
      call starttest(test)
      call sort_MergeSort__create_f(merge)
      call reporttest(merge .ne. 0, test, pass, fail)
      call starttest(test)
      call sort_QuickSort__create_f(quick)
      call reporttest(quick .ne. 0, test, pass, fail)
      call starttest(test)
      call sort_HeapSort__create_f(heap)
      call reporttest(heap .ne. 0, test, pass, fail)

      call sort_SortingAlgorithm__cast_f(merge, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 0, alg)
      call sort_SortingAlgorithm__cast_f(heap, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 1, alg)
      call sort_SortingAlgorithm__cast_f(quick, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 2, alg)
c     remove extraneous references
      call sort_MergeSort_deleteRef_f(merge)
      call sort_QuickSort_deleteRef_f(quick)
      call sort_HeapSort_deleteRef_f(heap)

      call starttest(test)
      call sort_SortTest_stressTest_f(algs, retval)
      call reporttest(retval, test, pass, fail)
      call sort_SortingAlgorithm__array_deleteRef_f(algs)

      end

      program sorttest
      implicit none
      integer test, pass, fail
      test = 1
      pass = 0
      fail = 0
      write(6,120) 4
      write(6,110) 'Sort tests'
      call testsort(test, pass, fail)
      if ((fail .eq. 0) .and. (pass .eq. 4)) then
         write(6, 100) 'PASS'
      else
         write(6, 100) 'FAIL'
      endif
 100  format ('TEST_RESULT', 1x, a4)
 110  format ('COMMENT:', 1x, a20)
 120  format ('NPARTS', 1x, i4)
      end
