/*
 * File:          Strings_Cstring_Impl.c
 * Symbol:        Strings.Cstring-v1.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for Strings.Cstring
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "Strings.Cstring" (version 1.1)
 * 
 * Class to allow testing of string passing using every possible mode.
 */

#include "Strings_Cstring_Impl.h"

/* DO-NOT-DELETE splicer.begin(Strings.Cstring._includes) */
#include <string.h>
#include "SIDL_String.h"
/* DO-NOT-DELETE splicer.end(Strings.Cstring._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring__ctor"

void
impl_Strings_Cstring__ctor(
  Strings_Cstring self)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Strings.Cstring._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring__dtor"

void
impl_Strings_Cstring__dtor(
  Strings_Cstring self)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring._dtor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Strings.Cstring._dtor) */
}

/*
 * If <code>nonNull</code> is <code>true</code>, this will
 * return "Three"; otherwise, it will return a NULL or empty string.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_returnback"

char*
impl_Strings_Cstring_returnback(
  Strings_Cstring self, SIDL_bool nonNull)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.returnback) */
  return nonNull ? SIDL_String_strdup("Three") : NULL;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.returnback) */
}

/*
 * This will return <code>true</code> iff <code>c</code> equals "Three".
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passin"

SIDL_bool
impl_Strings_Cstring_passin(
  Strings_Cstring self, const char* c)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passin) */
  return (c && !strcmp(c,"Three")) ? TRUE : FALSE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passin) */
}

/*
 * If <code>nonNull</code> is <code>true</code>, this will return
 * "Three" in <code>c</code>; otherwise, it will return a null or
 * empty string. The return value is <code>false</code> iff 
 * the outgoing value of <code>c</code> is <code>null</code>.
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passout"

SIDL_bool
impl_Strings_Cstring_passout(
  Strings_Cstring self, SIDL_bool nonNull, char** c)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passout) */
  *c = nonNull ? SIDL_String_strdup("Three") : NULL;
  return (*c == NULL) ? FALSE : TRUE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passout) */
}

/*
 * Method:  passinout[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passinout"

SIDL_bool
impl_Strings_Cstring_passinout(
  Strings_Cstring self, char** c)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passinout) */
  char * s = "s";
  char * temp;
  if ( *c == NULL ) { 
    return FALSE;
  }
  if ((temp=(char*)malloc( (strlen(*c) + 2) * sizeof(char) )) == NULL ) { 
    return FALSE;
  }
  strcpy( temp, *c );
  strcat( temp, s );
  free(*c);
  *c = NULL;
  if ( temp[0] >= 'a' && temp[0] <= 'z' ) { 
    temp[0] += 'A' - 'a';
  } else if ( temp[0] >= 'A' && temp[0] <= 'Z' ) { 
    temp[0] += 'a' - 'A';
  }
  *c = temp;
  return TRUE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passinout) */
}

/*
 * Method:  passeverywhere[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_passeverywhere"

char*
impl_Strings_Cstring_passeverywhere(
  Strings_Cstring self, const char* c1, char** c2, char** c3)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.passeverywhere) */
  char * temp;  
  *c2 = NULL;
  if ( *c3 == NULL ) {
    return NULL;
  }
  temp = *c3;
  temp[ strlen( temp ) - 1 ] = '\0'; /* remove last character */
  if ( temp[0] >= 'a' && temp[0] <= 'z' ) { 
    temp[0] += 'A' - 'a';
  } else if ( temp[0] >= 'A' && temp[0] <= 'Z' ) { 
    temp[0] += 'a' - 'A';
  }
  *c3 = temp;
  *c2 = SIDL_String_strdup("Three");
  return (c1 && !(strcmp(c1,"Three")) ) ? SIDL_String_strdup("Three") : NULL;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.passeverywhere) */
}

/*
 * Method:  mixedarguments[]
 */

#undef __FUNC__
#define __FUNC__ "impl_Strings_Cstring_mixedarguments"

SIDL_bool
impl_Strings_Cstring_mixedarguments(
  Strings_Cstring self, const char* s1, char c1, const char* s2, char c2)
{
  /* DO-NOT-DELETE splicer.begin(Strings.Cstring.mixedarguments) */
  return (s1 && s2 && (c1 == c2) && !strcmp(s1, s2)) ? TRUE : FALSE;
  /* DO-NOT-DELETE splicer.end(Strings.Cstring.mixedarguments) */
}
