/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Batik" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation. For more  information on the
 Apache Software Foundation, please see <http://www.apache.org/>.

*/

package org.apache.batik.swing.svg;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.batik.util.gui.JErrorPane;

/**
 * One line Class Desc
 *
 * Methods users may want to implement:
 *    displayMessage
 *
 * @author <a href="mailto:deweese@apache.org>deweese</a>
 * @version $Id: SVGUserAgentGUIAdapter.java,v 1.1 2003/09/25 00:45:11 deweese Exp $
 */
public class SVGUserAgentGUIAdapter extends SVGUserAgentAdapter{
    public Component parentComponent;
    public SVGUserAgentGUIAdapter(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    /**
     * Displays an error message.
     */
    public void displayError(String message) {
        JOptionPane pane = new JOptionPane(message, JOptionPane.ERROR_MESSAGE);
        JDialog dialog = pane.createDialog(parentComponent, "ERROR");
        dialog.setModal(false);
        dialog.show();
    }

    /**
     * Displays an error resulting from the specified Exception.
     */
    public void displayError(Exception ex) {
        JErrorPane pane = new JErrorPane(ex, JOptionPane.ERROR_MESSAGE);
        JDialog dialog = pane.createDialog(parentComponent, "ERROR");
        dialog.setModal(false);
        dialog.show();
    }

    /**
     * Displays a message in the User Agent interface.
     * The given message is typically displayed in a status bar.
     */
    public void displayMessage(String message) {
        // Can't do anything don't have a status bar...
    }

    /**
     * Shows an alert dialog box.
     */
    public void showAlert(String message) {
        String str = "Script alert:\n" + message;
        JOptionPane.showMessageDialog(parentComponent, str);
    }

    /**
     * Shows a prompt dialog box.
     */
    public String showPrompt(String message) {
        String str = "Script prompt:\n" + message;
        return JOptionPane.showInputDialog(parentComponent, str);
    }
    
    /**
     * Shows a prompt dialog box.
     */
    public String showPrompt(String message, String defaultValue) {
        String str = "Script prompt:\n" + message;
        return (String)JOptionPane.showInputDialog
            (parentComponent, str, null,
             JOptionPane.PLAIN_MESSAGE,
             null, null, defaultValue);
    }

    /**
     * Shows a confirm dialog box.
     */
    public boolean showConfirm(String message) {
        String str = "Script confirm:\n" + message;
        return JOptionPane.showConfirmDialog
            (parentComponent, str, 
             "Confirm", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION;
    }
};
