package org.biojava.utils.bytecode;

/**
 * Instructions which load int constants
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class IntConstantInstruction implements Instruction {
  private final int i;
  
  IntConstantInstruction(int i) {
    this.i = i;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    int i_indx = ctx.getConstants().resolveInt(i);
    if (i_indx < 256) {
      ctx.writeByte(ByteCode.op_ldc);
      ctx.writeByte((byte) i_indx);
    } else {
      ctx.writeByte(ByteCode.op_ldc_w);
      ctx.writeShort(i_indx);
    }
  }
  
  public int stackDepth() {
    return stackDelta();
  }
  
  public int stackDelta() {
    return 1;
  }
}
