(* \chaptertitle{Pdftest}{Test on a document} *)

(* Summary: \texttt{pdftest in.pdf out.pdf} reads, lexes, parses a document
\texttt{in.pdf} and its graphics streams, then writes it to \texttt{out.pdf}.
*)
open Utility

let _ =
  let in_name, out_name =
    match tl (Array.to_list Sys.argv) with
    | [i; o] -> i, o
    | _ -> print_string "Syntax: pdftest <input> <output>\n\n"; exit 1
  in
    try
      let pdf = Pdfread.pdf_of_file None in_name in
        let pages = Pdfdoc.pages_of_pagetree pdf in
          let pages' = 
            (*i map 
              (fun page ->
                 let graphic = Pdfgraphics.graphic_of_page pdf page in
                     flprint (Pdfgraphics.string_of_graphic graphic);
                     Pdfgraphics.page_of_graphic pdf (Pdf.parse_rectangle page.Pdfdoc.mediabox) graphic) i*)
              pages
          in
            let pdf = Pdfdoc.change_pages true pdf pages' in
              Pdf.remove_unreferenced pdf;
              Pdfwrite.pdf_to_file pdf out_name
    with
      err ->
        Printf.printf "Test failed:\n%s\n\n" (Printexc.to_string err);
        exit 1

