/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef CVSDIRECTORY_H
#define CVSDIRECTORY_H

#include "directory.h"
#include "FileListViewItem.h"
#include "CCvsEntries.h"

class CvsDirectory : public Directory {

 public:

   CvsDirectory( QStringList, const QString& fileName);
   
   CvsDirectory( QListViewItem * parent,
	 const QString& fileName,
	 bool virtualDir);

   virtual ~CvsDirectory();
   virtual int rtti() const;
   CvsDirectory * firstChild();
   CvsDirectory * nextSibling();
   CvsDirectory * dyncast_cvsdir(QListViewItem *);

   
 protected:

 private:

   //inherited virtual methods
   Directory * createChild( const QString&, bool=false);
   int getType() {return Cvs;}
   bool loginOk(CCvsOutput*,bool = false);
   void removeLogin(CCvsOutput*);
   bool isModified();
   bool isControlledTree();
   bool checkDirForControl();
   void recCheckForModifications(bool);
   bool postCallCheck(int=Controled|NonControled|Ignored);
   void validateControlledFilesStatus(bool=false, bool=false, bool=false);
   void checkAndShowStatus(FileListViewItem * =0, bool=false, int=Controled|NonControled|Ignored, bool=false);
   void checkAndUpdateFileCache(QString&);
   void removeTmpEntries(QString=QString::null);
   void recRemoveTmpEntries(bool);
   bool recCopyTree(QString,QString,bool=false);
   bool parseCallResult(CvsBuffer*, int, QStringList * =0);
   bool isControlled(QString);
   bool isBinary(QString);
   bool analyzeDirs();
   Entries * getEntries(bool=false);
   const QString getHomeFilesToIgnore(QDateTime&, bool&);
   const QString getDirFilesToIgnore(const QString, bool&);
   void getNameAndRevOfFirstSelectedFile(QString *, QString *);
   QString getRev(QString *);
   bool backupFiles(QStringList);
   bool restoreFiles(QStringList);
   QStringList getControledSubdirs();
   DirBase * searchDirOfPath (QString, bool = false);
   DirBase * searchLastValidDirOfPath (QString);
   
   //local methods
   void init(const QString& fileName);
   void fillFileListWithEntries(QStringList& fileList);
   void fillFileListWithFullNameEntries(QStringList& fileList);
   QString rcsToFileName (QString, bool = true);
   void removeFileNameInconsistencies(QString &);
   
   CvsEntries * getCvsEntries(bool=false);
   EntryStates alignWithEntries(QString name, EntryStates stateId);
   bool setAndAppendTmpEntryQueryUpdate(QString); //special case for query-update files missing and not in CVS/Entries
   inline FileListViewItem * setStatusInFileListView(FileListViewItem *,Entry *,bool=false);
   inline QString getState(const EntryStates &);
   inline char * getPix(const EntryStates &,const int &);
   
   bool isFilesModified();
   bool entriesFileModified();
   bool entriesLogFileModified();

   //local variables
   CvsEntries m_CvsEntries;
   QStringList m_tmpEntries;
   
   bool m_entriesCached;
   bool m_checkedForIgnoresFile;
   
   QDateTime m_lastTimeHomeIgnoresChanged;
   QDateTime m_lastTimeDirIgnoresChanged;
   QString m_pDirIgnores;
   
};

#endif

