// -*-c++-*-

#ifndef __INTERFACE_H
#define __INTERFACE_H

#include "CoreOption.h"
#include "keymap.h"

//
// The user interface
//
class InterfaceElement {
public:
    const char * str;

    virtual const char * text(int) { return str; }
    virtual int doKey(int key) { return 1; }

    InterfaceElement(const char * t): str(t) {}
};

class InterfaceElementOption : public InterfaceElement {
public:
    Option * opt;
    int inc1, inc2, inc3;
    static Keymap keymap;

    virtual const char * text(int selected);
    virtual int doKey(int key);

    InterfaceElementOption(const char * t, Option * opt, int i1=1, int i2=1, int i3=1);
};
extern Option * currentOption;
extern CoreOption * currentCoreOption;
extern InterfaceElementOption * currentOptionInterfaceElement;

class InterfaceElementCoreOption : public InterfaceElementOption {
public:
    CoreOption * coreOpt;
    static Keymap coreKeymap;

    virtual int doKey(int key);

    InterfaceElementCoreOption(const char * t, CoreOption * opt, int i1=1, int i2=1, int i3=1);
};



class Interface {
public:
    static Interface * interfaces[];
    static Interface * current;

protected:
    const char * name;

    const char * title;
    const char * text;
    InterfaceElement ** elements;
    int nElements;

    int sel;

    Interface * next;
    static Interface * head;

    char * silenceMsg;
    double silenceLine;

public:
    Interface(const char * name, 
	      const char * title, const char * text);
    Interface(const char * name, 
	      const char * title, const char * text,
	      InterfaceElement * el[], int nEl);

    void setElements(InterfaceElement ** el, int nEl);

    virtual void preRun() {}
    virtual void doKey(int key);
    void run();
    

    virtual void display();

    void msg(char *);			// a silence message

    static void set(const char * name);		// set a new interface by name

    friend int main(int argc, char *argv[]);	// for server
    friend int init_mixer();

    friend class upAction;		// actins for cursor movement
    friend class downAction;
    friend class homeAction;
    friend class endAction;

    friend class activateAction;
    friend class nextInterfaceAction;
    friend class prevInterfaceAction;

    static int saveToHot;
    static int showStatus;
};

void inc1Action(const char *, double);
void inc2Action(const char *, double);
void inc3Action(const char *, double);
void dec1Action(const char *, double);
void dec2Action(const char *, double);
void dec3Action(const char *, double);
void lockElementAction(const char *, double);

void initInterfaceLists();

extern Interface interfaceMixer;



//
// an error message
//
class ErrorMessages {
    char msgs[128][128];
    int on_screen[128];
    int nMsgs;
public:
    ErrorMessages() : nMsgs(0) {}

    void addMessage(const char * text);
    void display();
};


extern ErrorMessages errors;


#endif








