/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "lnslang.h"

#include "lns.h"
#include "frag.h"
#include "xstack.h"

static XStack< LnsFrag > hFrag;
static XStack< LnsFrag > vFrag;

Bool Frag_HAlloc( int nitems )
{
   if (!hFrag.Create( nitems, nitems ))
      return FALSE;
   hFrag.MemSet(0);
   return TRUE;
}

LnsFrag* Frag_HGet( int nfrag )
{
   if (!hFrag)
      return NULL;
   return &(hFrag[nfrag]);
}

int      Frag_HCount(void)
{
   return hFrag.GetCurCnt();
}

void Frag_HFree(void)
{
   hFrag.Destroy();
}

Bool Frag_VAlloc( int nitems )
{
   if (!vFrag.Create( nitems, nitems ))
      return FALSE;
   vFrag.MemSet(0);
   return TRUE;
}

LnsFrag* Frag_VGet( int nfrag )
{
   if (!vFrag)
      return NULL;
   return &(vFrag[nfrag]);
}

int      Frag_VCount(void)
{
   return vFrag.GetCurCnt();
}

void Frag_VFree(void)
{
   vFrag.Destroy();
}

