#!/bin/bash
#
# dm-start-mx.sh
#
#	 Start Multi X.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"

PATH=$PATH:/usr/X11R6/bin/

MAX_X_START_TIME=120
MIN_X_START_TIME=5

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi

# Update userful.Mxorg.conf for input devices not required.
# For now, check TouchScreen and update config file.
update_mx_config()
{
	NUM_OF_HEADS=`cat /etc/X11/stations`

	if ! grep "tch" /etc/usbinput > /dev/null 2>&1 ; then
		# No touchscreen device in the /etc/usbinput.
		# Remove Touch from ServerLayout in the userful.Mxorg.conf
		for ((i = 0; i < $NUM_OF_HEADS; i++))
		do
			TEST=`grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch$i"`

			if [ ! -z "$TEST" ]; then
				sed -i -e "/$TEST/d" /etc/X11/userful.Mxorg.conf
			fi
		done
	elif ! grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch" > /dev/null 2>&1 ; then
		# Touchscreen exist in the /etc/usbinput, but no Touch entry in the ServerLayout section
		# Recreate userful.Mxorg.conf
		echo "(II) Touchscreen detected. Create userful.Mxorg.conf with touchscreen infomation" >>  $logfile
		if [ -f /root/xorg.conf.new ]; then
			/opt/userful/bin/dm-gen-xconfig.sh -1box
		else
			/opt/userful/bin/mx-config-gen.sh -1box
		fi
	fi
}

# Start Multi X
start_mx()
{
	# load nvidia module if nvidia driver exist
	if $LSPCI -n | grep "0300:" | tr "a-z" "A-Z" | grep "10DE" > /dev/null 2>&1 ; then
		if [ -e /usr/lib/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/lib64/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/X11R6/lib64/modules/drivers/nvidia_drv.o -o \
		 	-e /usr/X11R6/lib/modules/drivers/nvidia_drv.o ]; then
			modprobe -q nvidia
		fi
	fi

	#reset PS/2 device if needed
	/opt/userful/bin/checkPS2

	# create usbinput config file
	echo "(II) create /etc/usbinput and symbolic link in /etc/X11/Xinput/ directory" >>  $logfile
	/opt/userful/bin/make-config-file

	# update userful.Mxorg.conf before X starts
	update_mx_config

	if which date > /dev/null 2>&1; then
		date +%s > /tmp/X-start
	else
		rm -f /tmp/X-start
	fi

	# start Multi X
	echo "(II) Start Multi X with userful.Mxorg.conf at `date`" >>  $logfile
	xinit /opt/userful/bin/mx.xinitrc  -- /opt/MX11R6/bin/X :0 \
		-br -logfile /var/log/1box-server.log -nolisten tcp -xf86config userful.Mxorg.conf &	
	sleep 1
}

# check if MX starts well within certain time
check_mx_start()
{
	if which date > /dev/null 2>&1; then
		START_TIME=`cat /tmp/X-start`
		TIME_TAKEN=0
	else
		sleep 5
	fi

	while [ -f /tmp/X-start ]; do
		NOW=`date +%s`
		TIME_TAKEN=$(( $NOW - $START_TIME ))
		if [ $TIME_TAKEN -gt $MIN_X_START_TIME ] ; then
			# check Multi-X still alive or not.
			pgrep X
			if [ "$?" != "0" ]; then # MXserver doesn't exist.
				echo "(EE) Multi X fails to start. See the /var/log/1box-server.log" >>  $logfile
				break
			fi
		fi

		# IF MX has been stuck somewhere, reboot system. -- problem in initialization..
		if [ $TIME_TAKEN -gt $MAX_X_START_TIME ] ; then
			pkill -9 X 2> /dev/null
			sleep 5
			echo "(EE) Starting multi X has been taken more than $MAX_X_START_TIME seconds. See the /var/log/1box-server.log" >>  $logfile
			break
		fi
		# wait 1 second for next checking
		sleep 1
	done
}

# Start MX and check if it starts well
start_1box_server()
{
	# start MX
	start_mx

	# check MX starting 
	check_mx_start

	###
	# /etc/userful/start-mx : specify the success of starting Multi-X
	###
	# 0: Starting Multi-X has been succeeded once before.
	# 1: Starting Multi-X has been failed, or this is first boot.
	# 2: Starting Multi-X has been failed more than two time in a row.
	if [ ! -e /etc/userful/start-mx ]; then
		START_MX=1
	else
		START_MX=`cat /etc/userful/start-mx`
	fi

	if [ -f /tmp/X-start ] || [ -f /tmp/mx-config-error ]; then
		# fails to start X or fails to create config file
		rm -f /tmp/X-start
		sleep 2
		clear
		
		START_MX=$(( $START_MX + 1 ))

		if [ $START_MX -gt 2 ]; then
			echo "(EE) Multi X fails to start three times in a row. Reconfigure userful.Mxorg.conf with single head configuration" >>  $logfile
			# fails to start MX more than two time
			while read VIDEOCARD; do
				BUSID=`echo $VIDEOCARD | awk -F'^' '{print $1}'`
				VENDORNAME=`echo $VIDEOCARD | awk -F'^' '{print $2}'`
				BOARDNAME=`echo $VIDEOCARD | awk -F'^' '{print $3}'`
				DRIVER=`echo $VIDEOCARD | awk -F'^' '{print $4}'`
				DEVID=`echo $VIDEOCARD | awk -F'^' '{print $6}'`

				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^1^$DEVID" >> /etc/mvgainfo.new
			done < /etc/mvgainfo

			mv -f /etc/mvgainfo /etc/mvgainfo.fail
			mv -f /etc/mvgainfo.new /etc/mvgainfo

			rm -f /etc/usbinput
			rm -f /etc/X11/xdm/Xservers

			if [ -f /root/xorg.conf.new ]; then
				/opt/userful/bin/dm-gen-xconfig.sh -1box
			else
   				pushd /opt/userful/bin > /dev/null
					/opt/userful/bin/mx-config-gen.sh -1box
   				popd /dev/null
			fi
			echo 0 > /etc/userful/start-mx
		else
			echo $START_MX > /etc/userful/start-mx
		fi

		echo "(EE) Fail to start multi X server. Reboot system.." >>  $logfile
		sync;sync;reboot;reboot
		exit 1

	else 
		echo "(II) Multi X started." >>  $logfile
		# start MX successfully
		echo 0 > /etc/userful/start-mx
	fi
}

#--------------------
# Start from here..
#--------------------

# Check if MX is running already
if [ -e /var/run/x.pid ]; then
   	if [ -e /proc/`cat /var/run/x.pid` ]; then
		# MX is running
   		echo "" >> /var/log/usbinput.log
       	echo "(WW) Multi X is already running ..." >>  $logfile
		rm -f /tmp/mx-trial
		usleep 100000
   	else
		# Start MX and check if it starts well
		start_1box_server
   	fi
else
	# Start MX and check if it starts well
	start_1box_server
fi
