#!/bin/sh
#
# Copyright (c) 2004-2006 by Userful Corporation
#
# Name: unlink-kbd.sh
# Author: Jason Kim
# Description:
#   This script runs GUI for kbd-assignment in respond to Ctrl-Alt-Break.
# $1: screenNumber
############################################

logfile="/var/log/usbinput.log"
UNLINK=0
DISPLAYNUM=
SCREENNUM=
CURRENTDM=

if [ -f /opt/userful/bin/xkeepalive ]; then
    KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [ -f /opt/userful/bin/keepalive ]; then
    KEEPALIVE="/opt/userful/bin/keepalive"
fi

usage()
{
    echo
    echo "Usage: $0 <Screen Number>"
    echo
    exit 1
}

#
# Start here...
#

# receive only one argument(screenNum).  
if [ $# -ne 1 ]; then
    usage
fi
#echo "unlink-kbd.sh  argument: $1" >> $logfile

# avoid multiple executions of unlink-kbd.sh at the same time
if [ -e /etc/usbinput.tmp ]; then
	exit 1
fi
touch /etc/usbinput.tmp

# We need to set environment variables for language translation.
# This could be different for each distro.
# FC4
[ -f /etc/profile.d/lang.sh ] && . /etc/profile.d/lang.sh
echo "LANG=$LANG" >> $logfile

SCREENNUM=$1
if [ $1 -lt 10 ]; then
    DISPLAYNUM="0$1"
else
    DISPLAYNUM=$1
fi

if [ -e /etc/usbinput ]; then
	while read USBINPUT; do
		# find devices which have same screen number, then unconfigure them
    	if echo $USBINPUT | grep "Srn#=$DISPLAYNUM" > /dev/null; then
			if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	    		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
			fi
    	fi
    	echo $USBINPUT >> /etc/usbinput.tmp
	done < /etc/usbinput

	# update /etc/usbinput
	rm -f /etc/usbinput
	cp -f /etc/usbinput.tmp /etc/usbinput

	# update /etc/X11/Xinput/configstat
	/opt/userful/bin/make-config-file -r
else
	/opt/userful/bin/make-config-file -r
fi

# find current display manager
if [ -e /etc/userful/currentdm ]; then
   	source /etc/userful/currentdm
	if [ -z "$CURRENTDM" ]; then
		CURRENTDM=gdm
	fi
fi

echo "Unlink keyboard on display :$SCREENNUM" >> $logfile

# check if GUI for kbd-assignment exists on the $SCREENNUM display. 
if [ ! -e /var/run/pid.kbdlink$SCREENNUM -o \
	 ! -d /proc/`cat /var/run/pid.kbdlink$SCREENNUM` ]; then

	if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
		/opt/userful/bin/checkGrabKeyboard -display :$SCREENNUM
		RET=$?

		if [ $RET -eq $TRUE ]; then
			#echo "unlink-kbd.sh  kill login-server" >> $logfile
			kill `cat /var/run/pid.login-server$SCREENNUM`
		else
			#echo "unlink-kbd.sh  start GUI" >> $logfile
			/opt/userful/bin/userful-usbinput-config -display :$SCREENNUM -r &
		fi
	else
		#echo "unlink-kbd.sh  start GUI" >> $logfile
		/opt/userful/bin/userful-usbinput-config -display :$SCREENNUM -r &
	fi
	usleep 500000
else
	#echo "unlink-kbd.sh  GUI is exist already.." >> $logfile
	:
fi

# re-initialize USBConfigDaemon
if pgrep USBConfigDaemon > /dev/null 2>&1; then
    #pkill USBConfigDaemon
	:
else
	if [ -z "$CURRENTDM" ]; then
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon &
	else
		$KEEPALIVE /opt/userful/bin/USBConfigDaemon -dm $CURRENTDM &
	fi
fi

# re-initialize kbd-daemon
if pgrep kbd-daemon > /dev/null 2>&1; then
  	pkill kbd-daemon
else
    $KEEPALIVE /opt/userful/bin/kbd-daemon 2>>/var/log/kbd-daemon.log &
fi

# re-initialize mse-daemon
if pgrep mse-daemon > /dev/null 2>&1; then
   	pkill mse-daemon
else
    $KEEPALIVE /opt/userful/bin/mse-daemon 2>>/var/log/mse-daemon.log &
fi

# send signal to userful-usbinput-config
#echo "unlink-kbd.sh  send signal HUP to GUI " >> $logfile
/usr/bin/killall -s HUP userful-usbinput-config

rm -f /etc/usbinput.tmp
